# System.Text.Json

``` diff
 namespace System.Text.Json {
     public enum JsonCommentHandling : byte {
-        Allow = (byte)1,
+        Allow = (byte)2,
-        Skip = (byte)2,
+        Skip = (byte)1,
     }
     public sealed class JsonDocument : IDisposable {
+        public static JsonDocument Parse(ReadOnlySequence<byte> utf8Json, JsonDocumentOptions options = default(JsonDocumentOptions));
-        public static JsonDocument Parse(ReadOnlySequence<byte> utf8Json, JsonReaderOptions readerOptions = default(JsonReaderOptions));

+        public static JsonDocument Parse(Stream utf8Json, JsonDocumentOptions options = default(JsonDocumentOptions));
-        public static JsonDocument Parse(Stream utf8Json, JsonReaderOptions readerOptions = default(JsonReaderOptions));

+        public static JsonDocument Parse(ReadOnlyMemory<byte> utf8Json, JsonDocumentOptions options = default(JsonDocumentOptions));
-        public static JsonDocument Parse(ReadOnlyMemory<byte> utf8Json, JsonReaderOptions readerOptions = default(JsonReaderOptions));

+        public static JsonDocument Parse(ReadOnlyMemory<char> json, JsonDocumentOptions options = default(JsonDocumentOptions));
-        public static JsonDocument Parse(ReadOnlyMemory<char> json, JsonReaderOptions readerOptions = default(JsonReaderOptions));

+        public static JsonDocument Parse(string json, JsonDocumentOptions options = default(JsonDocumentOptions));
-        public static JsonDocument Parse(string json, JsonReaderOptions readerOptions = default(JsonReaderOptions));

+        public static Task<JsonDocument> ParseAsync(Stream utf8Json, JsonDocumentOptions options = default(JsonDocumentOptions), CancellationToken cancellationToken = default(CancellationToken));
-        public static Task<JsonDocument> ParseAsync(Stream utf8Json, JsonReaderOptions readerOptions = default(JsonReaderOptions), CancellationToken cancellationToken = default(CancellationToken));

     }
+    public struct JsonDocumentOptions {
+        public bool AllowTrailingCommas { get; set; }
+        public JsonCommentHandling CommentHandling { get; set; }
+        public int MaxDepth { get; set; }
+    }
     public readonly struct JsonElement {
-        public JsonValueType Type { get; }

+        public JsonValueKind ValueKind { get; }
+        public byte GetByte();
+        public short GetInt16();
+        public sbyte GetSByte();
+        public ushort GetUInt16();
+        public bool TryGetByte(out byte value);
+        public bool TryGetInt16(out short value);
+        public bool TryGetSByte(out sbyte value);
+        public bool TryGetUInt16(out ushort value);
+        public bool ValueEquals(ReadOnlySpan<byte> utf8Text);
+        public bool ValueEquals(ReadOnlySpan<char> text);
+        public bool ValueEquals(string text);
-        public void WriteAsProperty(ReadOnlySpan<byte> utf8PropertyName, Utf8JsonWriter writer);

-        public void WriteAsProperty(ReadOnlySpan<char> propertyName, Utf8JsonWriter writer);

-        public void WriteAsProperty(string propertyName, Utf8JsonWriter writer);

-        public void WriteAsValue(Utf8JsonWriter writer);

+        public void WriteProperty(ReadOnlySpan<byte> utf8PropertyName, Utf8JsonWriter writer);
+        public void WriteProperty(ReadOnlySpan<char> propertyName, Utf8JsonWriter writer);
+        public void WriteProperty(string propertyName, Utf8JsonWriter writer);
+        public void WriteProperty(JsonEncodedText propertyName, Utf8JsonWriter writer);
+        public void WriteValue(Utf8JsonWriter writer);
     }
     public class JsonException : Exception {
+        public JsonException();
+        public JsonException(string message);
+        public JsonException(string message, Exception innerException);
+        public override string Message { get; }
     }
+    public abstract class JsonNamingPolicy {
+        protected JsonNamingPolicy();
+        public static JsonNamingPolicy CamelCase { get; }
+        public abstract string ConvertName(string name);
+    }
     public readonly struct JsonProperty {
+        public bool NameEquals(ReadOnlySpan<byte> utf8Text);
+        public bool NameEquals(ReadOnlySpan<char> text);
+        public bool NameEquals(string text);
     }
     public struct JsonReaderState {
-        public long BytesConsumed { get; }

-        public SequencePosition Position { get; }

     }
+    public static class JsonSerializer {
+        public static object Deserialize(ReadOnlySpan<byte> utf8Json, Type returnType, JsonSerializerOptions options = null);
+        public static object Deserialize(string json, Type returnType, JsonSerializerOptions options = null);
+        public static object Deserialize(ref Utf8JsonReader reader, Type returnType, JsonSerializerOptions options = null);
+        public static TValue Deserialize<TValue>(ReadOnlySpan<byte> utf8Json, JsonSerializerOptions options = null);
+        public static TValue Deserialize<TValue>(string json, JsonSerializerOptions options = null);
+        public static TValue Deserialize<TValue>(ref Utf8JsonReader reader, JsonSerializerOptions options = null);
+        public static ValueTask<object> DeserializeAsync(Stream utf8Json, Type returnType, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue> DeserializeAsync<TValue>(Stream utf8Json, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static string Serialize(object value, Type inputType, JsonSerializerOptions options = null);
+        public static void Serialize(Utf8JsonWriter writer, object value, Type inputType, JsonSerializerOptions options = null);
+        public static void Serialize<TValue>(Utf8JsonWriter writer, TValue value, JsonSerializerOptions options = null);
+        public static string Serialize<TValue>(TValue value, JsonSerializerOptions options = null);
+        public static Task SerializeAsync(Stream utf8Json, object value, Type inputType, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task SerializeAsync<TValue>(Stream utf8Json, TValue value, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static byte[] SerializeToUtf8Bytes(object value, Type inputType, JsonSerializerOptions options = null);
+        public static byte[] SerializeToUtf8Bytes<TValue>(TValue value, JsonSerializerOptions options = null);
+    }
+    public sealed class JsonSerializerOptions {
+        public JsonSerializerOptions();
+        public bool AllowTrailingCommas { get; set; }
+        public IList<JsonConverter> Converters { get; }
+        public int DefaultBufferSize { get; set; }
+        public JsonNamingPolicy DictionaryKeyPolicy { get; set; }
+        public bool IgnoreNullValues { get; set; }
+        public bool IgnoreReadOnlyProperties { get; set; }
+        public int MaxDepth { get; set; }
+        public bool PropertyNameCaseInsensitive { get; set; }
+        public JsonNamingPolicy PropertyNamingPolicy { get; set; }
+        public JsonCommentHandling ReadCommentHandling { get; set; }
+        public bool WriteIndented { get; set; }
+        public JsonConverter GetConverter(Type typeToConvert);
+    }
     public enum JsonTokenType : byte {
-        Comment = (byte)11,
+        Comment = (byte)6,
-        False = (byte)9,
+        False = (byte)10,
-        Null = (byte)10,
+        Null = (byte)11,
-        Number = (byte)7,
+        Number = (byte)8,
-        String = (byte)6,
+        String = (byte)7,
-        True = (byte)8,
+        True = (byte)9,
     }
+    public enum JsonValueKind : byte {
+        Array = (byte)2,
+        False = (byte)6,
+        Null = (byte)7,
+        Number = (byte)4,
+        Object = (byte)1,
+        String = (byte)3,
+        True = (byte)5,
+        Undefined = (byte)0,
+    }
-    public enum JsonValueType : byte {
 {
-        Array = (byte)2,

-        False = (byte)6,

-        Null = (byte)7,

-        Number = (byte)4,

-        Object = (byte)1,

-        String = (byte)3,

-        True = (byte)5,

-        Undefined = (byte)0,

-    }
     public ref struct Utf8JsonReader {
-        public Utf8JsonReader(in ReadOnlySequence<byte> jsonData, bool isFinalBlock, JsonReaderState state);
+        public Utf8JsonReader(ReadOnlySequence<byte> jsonData, bool isFinalBlock, JsonReaderState state);
+        public Utf8JsonReader(ReadOnlySequence<byte> jsonData, JsonReaderOptions options = default(JsonReaderOptions));
+        public Utf8JsonReader(ReadOnlySpan<byte> jsonData, JsonReaderOptions options = default(JsonReaderOptions));
+        public byte GetByte();
+        public short GetInt16();
+        public sbyte GetSByte();
+        public ushort GetUInt16();
-        public bool TextEquals(ReadOnlySpan<byte> otherUtf8Text);

-        public bool TextEquals(ReadOnlySpan<char> otherText);

+        public bool TryGetByte(out byte value);
+        public bool TryGetInt16(out short value);
+        public bool TryGetSByte(out sbyte value);
+        public bool TryGetUInt16(out ushort value);
+        public bool ValueTextEquals(ReadOnlySpan<byte> utf8Text);
+        public bool ValueTextEquals(ReadOnlySpan<char> text);
+        public bool ValueTextEquals(string text);
     }
     public sealed class Utf8JsonWriter : IAsyncDisposable, IDisposable {
+        public void WritePropertyName(ReadOnlySpan<byte> utf8PropertyName);
+        public void WritePropertyName(ReadOnlySpan<char> propertyName);
+        public void WritePropertyName(string propertyName);
+        public void WritePropertyName(JsonEncodedText propertyName);
     }
 }
```

