# Microsoft.AspNetCore.Components.Forms

``` diff
 namespace Microsoft.AspNetCore.Components.Forms {
     public sealed class EditContext {
+        public IEnumerable<string> GetValidationMessages(Expression<Func<object>> accessor);
+        public bool IsModified(Expression<Func<object>> accessor);
     }
-    public static class EditContextExpressionExtensions {
 {
-        public static IEnumerable<string> GetValidationMessages(this EditContext editContext, Expression<Func<object>> accessor);

-        public static bool IsModified(this EditContext editContext, Expression<Func<object>> accessor);

-    }
     public static class EditContextFieldClassExtensions {
-        public static string FieldClass(this EditContext editContext, in FieldIdentifier fieldIdentifier);

-        public static string FieldClass<TField>(this EditContext editContext, Expression<Func<TField>> accessor);

+        public static string FieldCssClass(this EditContext editContext, in FieldIdentifier fieldIdentifier);
+        public static string FieldCssClass<TField>(this EditContext editContext, Expression<Func<TField>> accessor);
     }
     public class EditForm : ComponentBase {
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
-        protected override void BuildRenderTree(RenderTreeBuilder builder);

     }
-    public sealed class FieldChangedEventArgs {
+    public sealed class FieldChangedEventArgs : EventArgs {
+        public FieldChangedEventArgs(in FieldIdentifier fieldIdentifier);
     }
-    public readonly struct FieldIdentifier {
+    public readonly struct FieldIdentifier : IEquatable<FieldIdentifier> {
-        public static FieldIdentifier Create<T>(Expression<Func<T>> accessor);

+        public static FieldIdentifier Create<TField>(Expression<Func<TField>> accessor);
+        public bool Equals(FieldIdentifier otherIdentifier);
     }
-    public abstract class InputBase<T> : ComponentBase {
 {
-        protected InputBase();

-        public IReadOnlyDictionary<string, object> AdditionalAttributes { get; set; }

-        protected string CssClass { get; }

-        protected T CurrentValue { get; set; }

-        protected string CurrentValueAsString { get; set; }

-        protected EditContext EditContext { get; set; }

-        protected string FieldClass { get; }

-        protected FieldIdentifier FieldIdentifier { get; set; }

-        public T Value { get; set; }

-        public EventCallback<T> ValueChanged { get; set; }

-        public Expression<Func<T>> ValueExpression { get; set; }

-        protected virtual string FormatValueAsString(T value);

-        public override Task SetParametersAsync(ParameterView parameters);

-        protected abstract bool TryParseValueFromString(string value, out T result, out string validationErrorMessage);

-    }
+    public abstract class InputBase<TValue> : ComponentBase {
+        protected InputBase();
+        public IReadOnlyDictionary<string, object> AdditionalAttributes { get; set; }
+        protected string CssClass { get; }
+        protected TValue CurrentValue { get; set; }
+        protected string CurrentValueAsString { get; set; }
+        protected EditContext EditContext { get; set; }
+        protected FieldIdentifier FieldIdentifier { get; set; }
+        public TValue Value { get; set; }
+        public EventCallback<TValue> ValueChanged { get; set; }
+        public Expression<Func<TValue>> ValueExpression { get; set; }
+        protected virtual string FormatValueAsString(TValue value);
+        public override Task SetParametersAsync(ParameterView parameters);
+        protected abstract bool TryParseValueFromString(string value, out TValue result, out string validationErrorMessage);
+    }
     public class InputCheckbox : InputBase<bool> {
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
-        protected override void BuildRenderTree(RenderTreeBuilder builder);

     }
-    public class InputDate<T> : InputBase<T> {
 {
-        public InputDate();

-        public string ParsingErrorMessage { get; set; }

-        protected override void BuildRenderTree(RenderTreeBuilder builder);

-        protected override string FormatValueAsString(T value);

-        protected override bool TryParseValueFromString(string value, out T result, out string validationErrorMessage);

-    }
+    public class InputDate<TValue> : InputBase<TValue> {
+        public InputDate();
+        public string ParsingErrorMessage { get; set; }
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
+        protected override string FormatValueAsString(TValue value);
+        protected override bool TryParseValueFromString(string value, out TValue result, out string validationErrorMessage);
+    }
-    public class InputNumber<T> : InputBase<T> {
 {
-        public InputNumber();

-        public string ParsingErrorMessage { get; set; }

-        protected override void BuildRenderTree(RenderTreeBuilder builder);

-        protected override string FormatValueAsString(T value);

-        protected override bool TryParseValueFromString(string value, out T result, out string validationErrorMessage);

-    }
+    public class InputNumber<TValue> : InputBase<TValue> {
+        public InputNumber();
+        public string ParsingErrorMessage { get; set; }
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
+        protected override string FormatValueAsString(TValue value);
+        protected override bool TryParseValueFromString(string value, out TValue result, out string validationErrorMessage);
+    }
-    public class InputSelect<T> : InputBase<T> {
 {
-        public InputSelect();

-        public RenderFragment ChildContent { get; set; }

-        protected override void BuildRenderTree(RenderTreeBuilder builder);

-        protected override bool TryParseValueFromString(string value, out T result, out string validationErrorMessage);

-    }
+    public class InputSelect<TValue> : InputBase<TValue> {
+        public InputSelect();
+        public RenderFragment ChildContent { get; set; }
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
+        protected override bool TryParseValueFromString(string value, out TValue result, out string validationErrorMessage);
+    }
     public class InputText : InputBase<string> {
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
-        protected override void BuildRenderTree(RenderTreeBuilder builder);

     }
     public class InputTextArea : InputBase<string> {
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
-        protected override void BuildRenderTree(RenderTreeBuilder builder);

     }
-    public class ValidationMessage<T> : ComponentBase, IDisposable {
 {
-        public ValidationMessage();

-        public IReadOnlyDictionary<string, object> AdditionalAttributes { get; set; }

-        public Expression<Func<T>> For { get; set; }

-        protected override void BuildRenderTree(RenderTreeBuilder builder);

-        protected override void OnParametersSet();

-        void System.IDisposable.Dispose();

-    }
+    public class ValidationMessage<TValue> : ComponentBase, IDisposable {
+        public ValidationMessage();
+        public IReadOnlyDictionary<string, object> AdditionalAttributes { get; set; }
+        public Expression<Func<TValue>> For { get; set; }
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
+        protected virtual void Dispose(bool disposing);
+        protected override void OnParametersSet();
+        void System.IDisposable.Dispose();
+    }
     public sealed class ValidationMessageStore {
+        public void Add(in FieldIdentifier fieldIdentifier, IEnumerable<string> messages);
+        public void Add(Expression<Func<object>> accessor, IEnumerable<string> messages);
+        public void Add(Expression<Func<object>> accessor, string message);
-        public void AddRange(in FieldIdentifier fieldIdentifier, IEnumerable<string> messages);

+        public void Clear(Expression<Func<object>> accessor);
     }
-    public static class ValidationMessageStoreExpressionExtensions {
 {
-        public static void Add(this ValidationMessageStore store, Expression<Func<object>> accessor, string message);

-        public static void AddRange(this ValidationMessageStore store, Expression<Func<object>> accessor, IEnumerable<string> messages);

-        public static void Clear(this ValidationMessageStore store, Expression<Func<object>> accessor);

-    }
-    public sealed class ValidationRequestedEventArgs {
+    public sealed class ValidationRequestedEventArgs : EventArgs {
+        public static readonly ValidationRequestedEventArgs Empty;
+        public ValidationRequestedEventArgs();
     }
-    public sealed class ValidationStateChangedEventArgs {
+    public sealed class ValidationStateChangedEventArgs : EventArgs {
+        public static readonly ValidationStateChangedEventArgs Empty;
+        public ValidationStateChangedEventArgs();
     }
     public class ValidationSummary : ComponentBase, IDisposable {
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
-        protected override void BuildRenderTree(RenderTreeBuilder builder);

+        protected virtual void Dispose(bool disposing);
     }
 }
```

