# Microsoft.AspNetCore.Components.RenderTree

``` diff
 namespace Microsoft.AspNetCore.Components.RenderTree {
+    public class EventFieldInfo {
+        public EventFieldInfo();
+        public int ComponentId { get; set; }
+        public object FieldValue { get; set; }
+    }
+    public readonly struct RenderBatch {
+        public ArrayRange<int> DisposedComponentIDs { get; }
+        public ArrayRange<ulong> DisposedEventHandlerIDs { get; }
+        public ArrayRange<RenderTreeFrame> ReferenceFrames { get; }
+        public ArrayRange<RenderTreeDiff> UpdatedComponents { get; }
+    }
+    public abstract class Renderer : IDisposable {
+        public Renderer(IServiceProvider serviceProvider, ILoggerFactory loggerFactory);
+        public abstract Dispatcher Dispatcher { get; }
+        public event UnhandledExceptionEventHandler UnhandledSynchronizationException;
+        protected internal int AssignRootComponentId(IComponent component);
+        public virtual Task DispatchEventAsync(ulong eventHandlerId, EventFieldInfo fieldInfo, EventArgs eventArgs);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        protected ArrayRange<RenderTreeFrame> GetCurrentRenderTreeFrames(int componentId);
+        protected abstract void HandleException(Exception exception);
+        protected IComponent InstantiateComponent(Type componentType);
+        protected virtual void ProcessPendingRender();
+        protected Task RenderRootComponentAsync(int componentId);
+        protected Task RenderRootComponentAsync(int componentId, ParameterView initialParameters);
+        protected abstract Task UpdateDisplayAsync(in RenderBatch renderBatch);
+    }
-    public sealed class RenderTreeBuilder : IDisposable {
 {
-        public RenderTreeBuilder();

-        public void AddAttribute(int sequence, in RenderTreeFrame frame);

-        public void AddAttribute(int sequence, string name, EventCallback value);

-        public void AddAttribute(int sequence, string name, bool value);

-        public void AddAttribute(int sequence, string name, MulticastDelegate value);

-        public void AddAttribute(int sequence, string name, object value);

-        public void AddAttribute(int sequence, string name, string value);

-        public void AddAttribute<T>(int sequence, string name, EventCallback<T> value);

-        public void AddComponentReferenceCapture(int sequence, Action<object> componentReferenceCaptureAction);

-        public void AddContent(int sequence, MarkupString markupContent);

-        public void AddContent(int sequence, RenderFragment fragment);

-        public void AddContent(int sequence, object textContent);

-        public void AddContent(int sequence, string textContent);

-        public void AddContent<T>(int sequence, RenderFragment<T> fragment, T value);

-        public void AddElementReferenceCapture(int sequence, Action<ElementReference> elementReferenceCaptureAction);

-        public void AddMarkupContent(int sequence, string markupContent);

-        public void AddMultipleAttributes(int sequence, IEnumerable<KeyValuePair<string, object>> attributes);

-        public void Clear();

-        public void CloseComponent();

-        public void CloseElement();

-        public void CloseRegion();

-        public ArrayRange<RenderTreeFrame> GetFrames();

-        public void OpenComponent(int sequence, Type componentType);

-        public void OpenComponent<TComponent>(int sequence) where TComponent : IComponent;

-        public void OpenElement(int sequence, string elementName);

-        public void OpenRegion(int sequence);

-        public void SetKey(object value);

-        public void SetUpdatesAttributeName(string updatesAttributeName);

-        void System.IDisposable.Dispose();

-    }
+    public sealed class WebEventDescriptor {
+        public WebEventDescriptor();
+        public int BrowserRendererId { get; set; }
+        public string EventArgsType { get; set; }
+        public EventFieldInfo EventFieldInfo { get; set; }
+        public ulong EventHandlerId { get; set; }
+    }
 }
```

