# Microsoft.AspNetCore.Components.Rendering

``` diff
 namespace Microsoft.AspNetCore.Components.Rendering {
-    public readonly struct ComponentRenderedText {
 {
-        public int ComponentId { get; }

-        public IEnumerable<string> Tokens { get; }

-    }
-    public class EventFieldInfo {
 {
-        public EventFieldInfo();

-        public int ComponentId { get; set; }

-        public object FieldValue { get; set; }

-    }
-    public class HtmlRenderer : Renderer {
 {
-        public HtmlRenderer(IServiceProvider serviceProvider, ILoggerFactory loggerFactory, Func<string, string> htmlEncoder);

-        public override Dispatcher Dispatcher { get; }

-        protected override void HandleException(Exception exception);

-        public Task<ComponentRenderedText> RenderComponentAsync(Type componentType, ParameterView initialParameters);

-        public Task<ComponentRenderedText> RenderComponentAsync<TComponent>(ParameterView initialParameters) where TComponent : IComponent;

-        protected override Task UpdateDisplayAsync(in RenderBatch renderBatch);

-    }
-    public readonly struct RenderBatch {
 {
-        public ArrayRange<int> DisposedComponentIDs { get; }

-        public ArrayRange<ulong> DisposedEventHandlerIDs { get; }

-        public ArrayRange<RenderTreeFrame> ReferenceFrames { get; }

-        public ArrayRange<RenderTreeDiff> UpdatedComponents { get; }

-    }
-    public abstract class Renderer : IDisposable {
 {
-        public Renderer(IServiceProvider serviceProvider, ILoggerFactory loggerFactory);

-        public abstract Dispatcher Dispatcher { get; }

-        public event UnhandledExceptionEventHandler UnhandledSynchronizationException;

-        protected internal virtual void AddToRenderQueue(int componentId, RenderFragment renderFragment);

-        protected internal int AssignRootComponentId(IComponent component);

-        public virtual Task DispatchEventAsync(ulong eventHandlerId, EventFieldInfo fieldInfo, UIEventArgs eventArgs);

-        public void Dispose();

-        protected virtual void Dispose(bool disposing);

-        protected abstract void HandleException(Exception exception);

-        protected IComponent InstantiateComponent(Type componentType);

-        protected Task RenderRootComponentAsync(int componentId);

-        protected Task RenderRootComponentAsync(int componentId, ParameterView initialParameters);

-        protected abstract Task UpdateDisplayAsync(in RenderBatch renderBatch);

-    }
+    public sealed class RenderTreeBuilder : IDisposable {
+        public RenderTreeBuilder();
+        public void AddAttribute(int sequence, in RenderTreeFrame frame);
+        public void AddAttribute(int sequence, string name, EventCallback value);
+        public void AddAttribute(int sequence, string name, bool value);
+        public void AddAttribute(int sequence, string name, MulticastDelegate value);
+        public void AddAttribute(int sequence, string name, object value);
+        public void AddAttribute(int sequence, string name, string value);
+        public void AddAttribute<TArgument>(int sequence, string name, EventCallback<TArgument> value);
+        public void AddComponentReferenceCapture(int sequence, Action<object> componentReferenceCaptureAction);
+        public void AddContent(int sequence, MarkupString markupContent);
+        public void AddContent(int sequence, RenderFragment fragment);
+        public void AddContent(int sequence, object textContent);
+        public void AddContent(int sequence, string textContent);
+        public void AddContent<TValue>(int sequence, RenderFragment<TValue> fragment, TValue value);
+        public void AddElementReferenceCapture(int sequence, Action<ElementReference> elementReferenceCaptureAction);
+        public void AddMarkupContent(int sequence, string markupContent);
+        public void AddMultipleAttributes(int sequence, IEnumerable<KeyValuePair<string, object>> attributes);
+        public void Clear();
+        public void CloseComponent();
+        public void CloseElement();
+        public void CloseRegion();
+        public ArrayRange<RenderTreeFrame> GetFrames();
+        public void OpenComponent(int sequence, Type componentType);
+        public void OpenComponent<TComponent>(int sequence) where TComponent : IComponent;
+        public void OpenElement(int sequence, string elementName);
+        public void OpenRegion(int sequence);
+        public void SetKey(object value);
+        public void SetUpdatesAttributeName(string updatesAttributeName);
+        void System.IDisposable.Dispose();
+    }
 }
```

