# Microsoft.JSInterop

``` diff
 namespace Microsoft.JSInterop {
-    public static class DotNetDispatcher {
 {
-        public static void BeginInvoke(string callId, string assemblyName, string methodIdentifier, long dotNetObjectId, string argsJson);

-        public static void EndInvoke(string arguments);

-        public static string Invoke(string assemblyName, string methodIdentifier, long dotNetObjectId, string argsJson);

-        public static void ReleaseDotNetObject(long dotNetObjectId);

-    }
-    public static class DotNetObjectRef {
 {
-        public static DotNetObjectRef<TValue> Create<TValue>(TValue value) where TValue : class;

-    }
-    public sealed class DotNetObjectRef<TValue> : IDisposable where TValue : class {
 {
-        public TValue Value { get; }

-        public void Dispose();

-    }
+    public static class DotNetObjectReference {
+        public static DotNetObjectReference<TValue> Create<TValue>(TValue value) where TValue : class;
+    }
+    public sealed class DotNetObjectReference<TValue> : IDisposable where TValue : class {
+        public TValue Value { get; }
+        public void Dispose();
+    }
     public interface IJSRuntime {
-        Task<TValue> InvokeAsync<TValue>(string identifier, IEnumerable<object> args, CancellationToken cancellationToken = default(CancellationToken));

-        Task<TValue> InvokeAsync<TValue>(string identifier, params object[] args);

+        ValueTask<TValue> InvokeAsync<TValue>(string identifier, object[] args);
+        ValueTask<TValue> InvokeAsync<TValue>(string identifier, CancellationToken cancellationToken, object[] args);
     }
+    public abstract class JSInProcessRuntime : JSRuntime, IJSInProcessRuntime, IJSRuntime {
+        protected JSInProcessRuntime();
+        public TValue Invoke<TValue>(string identifier, params object[] args);
+        protected abstract string InvokeJS(string identifier, string argsJson);
+    }
-    public abstract class JSInProcessRuntimeBase : JSRuntimeBase, IJSInProcessRuntime, IJSRuntime {
 {
-        protected JSInProcessRuntimeBase();

-        public TValue Invoke<TValue>(string identifier, params object[] args);

-        protected abstract string InvokeJS(string identifier, string argsJson);

-    }
+    public static class JSInProcessRuntimeExtensions {
+        public static void InvokeVoid(this IJSInProcessRuntime jsRuntime, string identifier, params object[] args);
+    }
-    public class JSInvokableAttribute : Attribute
+    public sealed class JSInvokableAttribute : Attribute
-    public static class JSRuntime {
+    public abstract class JSRuntime : IJSRuntime {
+        protected JSRuntime();
+        protected Nullable<TimeSpan> DefaultAsyncTimeout { get; set; }
+        protected internal JsonSerializerOptions JsonSerializerOptions { get; }
+        protected abstract void BeginInvokeJS(long taskId, string identifier, string argsJson);
+        protected internal abstract void EndInvokeDotNet(DotNetInvocationInfo invocationInfo, in DotNetInvocationResult invocationResult);
+        public ValueTask<TValue> InvokeAsync<TValue>(string identifier, object[] args);
+        public ValueTask<TValue> InvokeAsync<TValue>(string identifier, CancellationToken cancellationToken, object[] args);
-        public static void SetCurrentJSRuntime(IJSRuntime instance);

     }
-    public abstract class JSRuntimeBase : IJSRuntime {
 {
-        protected JSRuntimeBase();

-        protected Nullable<TimeSpan> DefaultAsyncTimeout { get; set; }

-        protected abstract void BeginInvokeJS(long taskId, string identifier, string argsJson);

-        protected internal abstract void EndInvokeDotNet(string callId, bool success, object resultOrError, string assemblyName, string methodIdentifier, long dotNetObjectId);

-        public Task<T> InvokeAsync<T>(string identifier, IEnumerable<object> args, CancellationToken cancellationToken = default(CancellationToken));

-        public Task<T> InvokeAsync<T>(string identifier, params object[] args);

-    }
+    public static class JSRuntimeExtensions {
+        public static ValueTask<TValue> InvokeAsync<TValue>(this IJSRuntime jsRuntime, string identifier, params object[] args);
+        public static ValueTask<TValue> InvokeAsync<TValue>(this IJSRuntime jsRuntime, string identifier, CancellationToken cancellationToken, params object[] args);
+        public static ValueTask<TValue> InvokeAsync<TValue>(this IJSRuntime jsRuntime, string identifier, TimeSpan timeout, params object[] args);
+        public static ValueTask InvokeVoidAsync(this IJSRuntime jsRuntime, string identifier, params object[] args);
+        public static ValueTask InvokeVoidAsync(this IJSRuntime jsRuntime, string identifier, CancellationToken cancellationToken, params object[] args);
+        public static ValueTask InvokeVoidAsync(this IJSRuntime jsRuntime, string identifier, TimeSpan timeout, params object[] args);
+    }
 }
```

