# .NET Core 3.1 - Supported OS versions

[.NET Core 3.1](README.md) [is supported](../../support.md) on multiple operating systems per their [lifecycle policy](../../os-lifecycle-policy.md).

For issues with .NET on operating systems not listed here, please open a GitHub issue in the appropriate .NET repository or contact the OS maintainer community . Please see [.NET Repos](../../Documentation/core-repos.md) for the repository list.

## Keys used in the tables

* **Bold numbers** indicate additions to this release.
* A '+' indicates the minimum supported version.
* Where possible, links to Distribution-owned lifecycle documentation is provided.

## Windows

OS                            | Version                       | Architectures  | Notes
------------------------------|-------------------------------|----------------|-----
Windows Client                | 7 SP1(**\***), 8.1            | x64, x86       |
Windows 10 Client             | Version 1607+                 | x64, x86       | 1607 is the minimum version for support. See [Out of support OS versions](#out-of-support-os-versions) below for Windows 10 releases that are no longer supported.
Windows 11 Client   | Version 22000+           | x64, x86, Arm64 |
Nano Server                   | Version 1803+                 | x64, ARM32     |
Windows Server                | 2012+                  | x64, x86       |

* Windows 7 SP1 is supported with [Extended Security Updates](https://learn.microsoft.com/troubleshoot/windows-client/windows-7-eos-faq/windows-7-extended-security-updates-faq) installed.

* See the [Windows Lifecycle Fact Sheet](https://support.microsoft.com/help/13853/windows-lifecycle-fact-sheet) for details regarding each Windows release lifecycle.

## macOS

OS                            | Version                       | Architectures  | Notes
------------------------------|-------------------------------|----------------|-----
Mac OS X                      | 10.15+                        | x64            | [Apple Support Sitemap](https://support.apple.com/sitemap) <br/> [Apple Security Updates](https://support.apple.com/HT201222)

## Linux

Alpine 3.14 and Debian 11 are now supported with the .NET 5.0.10 and .NET Core 3.1.19. The operating system support pages for [.NET 5.0](../5.0/5.0-supported-os.md) and [.NET Core 3.1](3.1-supported-os.md) have been updated to reflect that.

OS                            | Version                       | Architectures  | Notes
------------------------------|-------------------------------|----------------|-----
Red Hat Enterprise Linux      | 7+                            | x64            | [Microsoft support policy](https://dotnet.microsoft.com/platform/support/policy/)
Red Hat Enterprise Linux <br/> CentOS <br/> Oracle Linux | 7+    | x64            | [Red Hat support policy](https://access.redhat.com/support/policy/updates/errata/) <br/> [CentOS lifecycle](https://wiki.centos.org/FAQ/General#head-fe8a0be91ee3e7dea812e8694491e1dde5b75e6d) <br/> [Oracle Linux lifecycle](https://www.oracle.com/a/ocom/docs/elsp-lifetime-069338.pdf)
Fedora                        | 33+                    | x64            | [Fedora lifecycle](https://fedoraproject.org/wiki/End_of_life)
Debian                        | 9+                       | x64, ARM32, ARM64     | [Debian lifecycle](https://wiki.debian.org/DebianReleases)
Ubuntu                        | 21.04, 20.04, 18.04                  | x64, ARM32, ARM64   | [Ubuntu lifecycle](https://wiki.ubuntu.com/Releases)
Linux Mint                    | 18+                          | x64            | [Linux Mint end of life announcements](https://forums.linuxmint.com/search.php?keywords=%22end+of+life%22&terms=all&author=&sc=1&sf=titleonly&sr=posts&sk=t&sd=d&st=0&ch=300&t=0&submit=Search)
openSUSE                      | 15+                         | x64            | [OpenSUSE lifecycle](https://en.opensuse.org/Lifetime)
SUSE Enterprise Linux (SLES)  | 12 SP2+                       | x64            | [SUSE lifecycle](https://www.suse.com/lifecycle/)
Alpine Linux                  | 3.13+                          | x64, ARM64            | [Alpine lifecycle](https://wiki.alpinelinux.org/wiki/Alpine_Linux:Releases)

* **Bold numbers** indicate additions in this release.
* '+' indicates the minimum supported version.

Note: .NET Core 3.1 requires OpenSSL 1.x. Newer distro versions such as Ubuntu 22.04 use OpenSSL 3 and not OpenSSL 1.x. You need to use .NET 6+ if you want a newer distro that only offers OpenSSL 3.

## Out of support OS versions

Support for the following versions was ended by the distribution owners and are [no longer supported by .NET Core 3.1](../../os-lifecycle-policy.md).

|OS         | Version  | End of Life | Supported Version|
|-----------|----------|-------------|------------------|
| Windows 10| 1703     | [10/08/2019](https://support.microsoft.com/help/13853/windows-lifecycle-fact-sheet) |
| Fedora    | 30       | [05/26/2020](https://lists.fedoraproject.org/archives/list/devel@lists.fedoraproject.org/message/7UTUFY7WEL6RTFRXJB75XAFH44Y6RPUC/)   |
| Fedora    | 31       | [11/24/2020](https://lists.fedoraproject.org/archives/list/announce@lists.fedoraproject.org/thread/NU5AENRUFG4XK5D34SJN5FZPLYMZF6ZQ/)   |
| Fedora    | 32       | [05/25/2021](https://lists.fedoraproject.org/archives/list/announce@lists.fedoraproject.org/thread/RPZQXPEV3L45YQV2HRBIQ5DQZ7GMP4X3/)   |
| Fedora    | 33       | [11/30/2021](https://lists.fedoraproject.org/archives/list/announce@lists.fedoraproject.org/thread/RGP5K5OZGVUCF2H62T5ZT4CWUZAGS6OY/)   |
| Fedora    | 34       | [06/07/2022](https://lists.fedoraproject.org/archives/list/announce@lists.fedoraproject.org/thread/WBORO72RN3RZBVWMVHQ4O2YZCFEQGNZA/)   |
| Alpine    | 3.8      | [05/01/2020](https://alpinelinux.org/releases/)   |
| Ubuntu    | 19.04    | [01/23/2020](https://wiki.ubuntu.com/Releases)   |
| Ubuntu    | 19.10    | [07/17/2020](https://wiki.ubuntu.com/Releases)   |
| Ubuntu    | 20.10    | [07/22/2021](https://wiki.ubuntu.com/Releases)   |
| RHEL      | 6    | [11/30/2020](https://access.redhat.com/support/policy/updates/errata)   |
| Alpine    | 3.12     | [05/22/2022](https://wiki.ubuntu.com/Releases)    |
