# .NET Core 3.1.12 - February 09, 2021

The .NET 3.1.12 and .NET SDK 3.1.112 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.112
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

### Azure App Services

* .NET Core 3.1.12 is being deployed to Azure App Services and the deployment is expected to complete later in January 2021.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.406](3.1.406-download.md) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.112](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |



## Notable Changes

.NET Core 3.1.12 release carries both security and non-security fixes.

### [CVE-2021-1721 | .NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-1721)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core and ASP.NET 5. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial-of-service vulnerability exists when creating HTTPS web request during X509 certificate chain building.

### [CVE-2021-24112 | .NET 5 and .NET Core Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-24112)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1, and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A remote code execution vulnerability exists when parsing certain types of graphics files. This vulnerability only exists on systems running on MacOS or Linux.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

### Additional fixes in this release

* [Runtime](https://github.com/dotnet/runtime/pulls?q=is%3Apr+is%3Aclosed+3.1.12+label%3Aservicing-approved)
* [CoreCLR](https://github.com/dotnet/coreclr/pulls?q=milestone%3A3.1.12+is%3Aclosed+label%3Aservicing-approved)
* [Winforms](https://github.com/dotnet/winforms/pulls?q=milestone%3A3.1.12+is%3Aclosed+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/dotnet/aspnetcore/pulls?q=milestone%3A3.1.12+is%3Aclosed+label%3Aservicing-approved)

## Adding a switch to enable sending ISO-8859-1 headers with SocketsHttpHandler

Since the introduction of `SocketsHttpHandler` in .NET Core 2.1, an attempt to send non-ASCII characters in HTTP headers throws an `HttpRequestException`. This (RFC-conform) behavior turned out to be a blocker for some users trying to migrate from .NET Framework. In .NET 5 we are addressing this by the introduction of [`SocketsHttpHandler.RequestHeaderEncodingSelector`](https://learn.microsoft.com/dotnet/api/system.net.http.socketshttphandler.requestheaderencodingselector?view=net-5.0). To unblock users who are not (yet) able to migrate to .NET 5.0, we also added a runtime-configuration switch as part of .NET Core 3.1 servicing. This switch allows relaxing the HTTP header validation, enabling `SocketsHttpHandler` to send ISO-8859-1 (Latin-1) encoded characters in headers.

- `AppContext` switch: `System.Net.Http.SocketsHttpHandler.AllowLatin1Headers`. `false` - disabled, `true` - enabled
- Environment variable: `DOTNET_SYSTEM_NET_HTTP_SOCKETSHTTPHANDLER_ALLOWLATIN1HEADERS`. `0` - disabled, `1` - enabled

**Note:**

This switch is specific to .NET Core 3.1 since service release 3.1.12, and not available in later versions.



## macOS Notarization Change
  Running "dotnet build" will generate a dll instead of a dylib on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://learn.microsoft.com/dotnet/core/install/macos-notarization-issues). If you want to opt into using the AppHost, add the following to your project file:
```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5932](https://github.com/dotnet/core/issues/5932) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.12.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.12.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.12.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.12.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.12.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.12.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.12.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.12.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.12.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.12.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.12.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.12.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.12.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.12.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.12.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.12.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.12.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.12.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.12.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.12.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.12.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.12.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.12.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.12.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.12.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.12.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.12.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.12.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.12.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.12.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.12.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.12.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.12.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.12.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.12.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.12.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.12.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.12.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.12.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.12.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.12.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.12.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.12.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.12.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.12.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.12.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.12.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.12.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.12.nupkg
Microsoft.NETCore.DotNetHost | 3.1.12.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.12.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.12.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.12.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.12.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.12.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.12.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.12.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.12.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.12.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.12.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.12.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.12.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.12.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.12.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.12.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.12.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.12.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.12.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.12.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.12.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.12.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.12.nupkg
System.Drawing.Common | 4.7.2.nupkg
Microsoft.NETCore.Platforms | 3.1.4.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.12.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.12.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.12.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.12.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.12.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.12.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.12.nupkg
dotnet-sql-cache | 3.1.12.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.12.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.12.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.12.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.12.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.12.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.12.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.12.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.12.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.12.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.12.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.12.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.12.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.12.nupkg
Microsoft.dotnet-openapi | 3.1.12.nupkg
Microsoft.AspNetCore.TestHost | 3.1.12.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.12.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.12.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.12.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.12.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.12.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.12.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.12.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.12.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.12.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.12.nupkg
Microsoft.AspNetCore.Owin | 3.1.12.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.12.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.12.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.12.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.12.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.12.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.12.nupkg
Microsoft.AspNetCore.Components | 3.1.12.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.12.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.12.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.12.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.12.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.12.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.12.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.12.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.12.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.12.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.12.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.12.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.12.nupkg
Microsoft.AspNetCore.Metadata | 3.1.12.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.12.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.12.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.12.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.12.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.12.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.12.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.12.nupkg
Microsoft.Extensions.Identity.Core | 3.1.12.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.12.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.12.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.12.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.12.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.12.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.12.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.12.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.12.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.12.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.12.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.12.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.12.nupkg
Microsoft.AspNetCore.Authorization | 3.1.12.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.12.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.12.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.12.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.12.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.12.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.12.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.12.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.12.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.12.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.12.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.12.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.12.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.12.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.12.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.12.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.12.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.12.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.12.nupkg
Microsoft.NET.Sdk.Razor | 3.1.12.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.12.nupkg
dotnet-ef | 3.1.12.nupkg
Microsoft.Data.Sqlite | 3.1.12.nupkg
Microsoft.Data.Sqlite.Core | 3.1.12.nupkg
Microsoft.EntityFrameworkCore | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.12.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.12.nupkg
Microsoft.JSInterop | 3.1.12.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.12.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.12.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.12.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.12.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.12.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.12.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.12.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.12.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.12.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.12.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.12.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.12.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.12.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.12.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.12.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.12.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.12.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.12.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.12.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.12.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.12.nupkg
Microsoft.Extensions.Configuration | 3.1.12.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.12.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.12.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.12.nupkg
Microsoft.Extensions.WebEncoders | 3.1.12.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.12.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.12.nupkg
Microsoft.Extensions.Primitives | 3.1.12.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.12.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.12.nupkg
Microsoft.Extensions.Options | 3.1.12.nupkg
Microsoft.Extensions.ObjectPool | 3.1.12.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.12.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.12.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.12.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.12.nupkg
Microsoft.Extensions.Logging.Console | 3.1.12.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.12.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.12.nupkg
Microsoft.Extensions.Hosting | 3.1.12.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.12.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.12.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.12.nupkg
Microsoft.Extensions.Http | 3.1.12.nupkg
Microsoft.Extensions.Http.Polly | 3.1.12.nupkg
Microsoft.Extensions.Localization | 3.1.12.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.12.nupkg
Microsoft.Extensions.Logging | 3.1.12.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.12.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.12.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.12.md
[snap-install]: 3.1.12-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.12-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.12-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-february-2021/



[//]: # ( Runtime 3.1.12)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06a5020e-0419-44e4-a0f7-8626c3395745/6cfef3a75663a3c27ea57fe6db7386bb/dotnet-runtime-3.1.12-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/11d0843e-a5b1-43b8-986b-09e905bcf7de/bf52a70e500ce41e42481094fe91d2c2/dotnet-runtime-3.1.12-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d97b783e-6ff2-4176-8283-3dcb23e44835/c14433b32ae7a43376f49edf6320a4cb/dotnet-runtime-3.1.12-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cf082400-3337-4e72-b461-363bcb930d5f/49f83d32b1b3dc2a0e5c834aa53225ba/dotnet-runtime-3.1.12-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f54a9098-69e6-4914-8fa8-42cb4ed05e65/9daae40d4a0ea4ad7aa2fc014b5f20db/dotnet-runtime-3.1.12-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4a3a3806-4c2b-4932-bec8-15596fd726ca/ba3c16e01b63b2b1b650929dae619c06/dotnet-runtime-3.1.12-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43113f2a-8305-4ac5-b5b2-a42cadbc0d1e/c29746d07de1a7a9fa83e9cefbadd8ac/dotnet-runtime-3.1.12-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/002e274a-61c2-4600-b4a3-28fa3b556b4c/3cc523c9999cbef4d12620b8ae1ec6bf/dotnet-runtime-3.1.12-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/115f47c2-7875-4987-80a7-18fffc37c95f/a3978378181f771d9d6b3e58385c1e1c/dotnet-runtime-3.1.12-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2fdc3009-cf5c-4cf6-8f3b-a61e83200cbb/2c71ee04b48103a7464f4e28a8bf339b/dotnet-runtime-3.1.12-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/49a53002-9157-498a-b3bf-11a0616b0348/4b5c31f6cae31c967f4138d8389cb8b5/dotnet-runtime-3.1.12-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cbdd1603-7fa9-4957-8869-94e24963ba6c/ca0b7d1be494882d5a7433accfa3c94c/dotnet-runtime-3.1.12-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e83ec32c-fc33-4ffa-9fc3-9f9c842d48d5/7805ff449700e2915d442e8d018c54dd/dotnet-runtime-3.1.12-win-x86.zip

[//]: # ( WindowsDesktop 3.1.12)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/076a47e9-c65b-4b78-95a7-93eb988891a4/3574764590cfa650e0aa87c44d3fe384/windowsdesktop-runtime-3.1.12-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5d89a010-88bf-4e4e-ac12-a07258ddbf5f/1ff5dfe312c5bd9760f3b500b1b37597/windowsdesktop-runtime-3.1.12-win-x86.exe

[//]: # ( ASP 3.1.12)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e9ef750d-af2f-4b89-a6d4-881a0a79bf67/6bb54316198f3a027649b027eca0c745/aspnetcore-runtime-3.1.12-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bb0d3897-cc8e-4929-bc5a-910e0f99df2f/4f654c997f921f2b7985e0ee879879ff/aspnetcore-runtime-3.1.12-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/528d1b40-494e-4fdf-a110-8a5c4c4fae79/5d34373c46fc4435fe0f0b013bfce329/aspnetcore-runtime-3.1.12-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d2846cf6-d1bd-4624-9018-a2de7707d83e/8e1118905610e8531bf6c5d6af8418b0/aspnetcore-runtime-3.1.12-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5d69db1-7735-4473-973c-220b56c32e3d/8b907777706429063b0ed646a5445cdf/aspnetcore-runtime-3.1.12-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/147cf098-ea0e-4ec2-945c-dd0f0e25f68a/c18e79204173cdefebdfeed43a5d3ee4/aspnetcore-runtime-3.1.12-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/9b1662f3-f0d2-4901-85e1-9c3e1fad1148/2d5e3bf582cf7f253410e60b91725bf0/aspnetcore-runtime-3.1.12-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/20cf277c-2ccf-449f-a0b8-925ba0c175e7/aa50b052ceb8a8d36a5b4f9b8d0bd91c/aspnetcore-runtime-3.1.12-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/78e8f825-af52-4586-84c6-59f49c6d9f59/e5cd0846317d3afff9e695e33bb1408c/aspnetcore-runtime-3.1.12-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/55d6ff56-2725-4657-bffd-fdf35d6816fd/7431d1d3533f0b1ac97df734c45c33f2/aspnetcore-runtime-3.1.12-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c5927c8a-2b42-4049-bdb4-27e20ee48478/8fcad15200d3393a685aabec8e6378ac/aspnetcore-runtime-3.1.12-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/19a5a3cc-b297-4a10-9b22-1184a0aeb990/5af443d748d2c5fb444477f202a11470/dotnet-hosting-3.1.12-win.exe

[//]: # ( SDK 3.1.112 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d720b6ef-d5c3-4403-a87e-e371c33fbc08/3cbf4e48b65cb9f9dc9f8db0959eed1c/dotnet-sdk-3.1.112-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9b242a62-b203-44fe-9fb8-964f705b0c6d/ba9802acf2096e4832cb0aecfdc1519c/dotnet-sdk-3.1.112-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/23f3b412-ac1d-4cd4-bda3-619ab07ad6e3/0db4e754350c9b1ea1ddf3e6d6d7303d/dotnet-sdk-3.1.112-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/551a1eae-c8f0-4c7c-9b49-f1cdbb8d454f/f75654333d11a15bfed06a5a8f7a858f/dotnet-sdk-3.1.112-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/cf02abb0-e4b5-4b0c-809f-138dfa956252/35a945b6e93703e7a424a177539c094d/dotnet-sdk-3.1.112-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4098ca7d-4adf-4ef7-871e-862df750feb2/2ddbc29b1713946940b7fc5f91d1eea1/dotnet-sdk-3.1.112-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/1ac26b1d-0b90-401a-92db-637f216c07d0/f962e3145444789af37d8e7f1bdf9656/dotnet-sdk-3.1.112-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/55d9a0a2-862c-4a13-9cbe-94f2c73b250f/71966b0ef5cc59d3dc426cf41c0aa529/dotnet-sdk-3.1.112-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7e02ba74-7428-4810-a835-6b68b5485776/81e29e936ac6784ed10fc12ca0ba6515/dotnet-sdk-3.1.112-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cc367e9c-adee-4de5-a8fd-8623379902e2/3773331072b2b76f839eb6be6d7084f0/dotnet-sdk-3.1.112-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6ee3c956-881f-4f89-96be-6df4acba4dce/50a97327af0d8337374f14778b8c231b/dotnet-sdk-3.1.112-win-x86.zip

