# .NET Core 3.1.14 - April 13, 2021

The .NET 3.1.14 and .NET SDK 3.1.114 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.114
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

### Azure App Services

* .NET Core 3.1.14 is being deployed to Azure App Services and the deployment is expected to complete later in April 2021.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.408](3.1.408-download.md) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.114](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

## Notable Changes

.NET Core 3.1.14 release carries only non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/pulls?q=milestone%3A3.1.14+is%3Aclosed+label%3Aservicing-approved)
* [Setup](https://github.com/dotnet/core-setup/pulls?q=milestone%3A3.1.14+is%3Aclosed+label%3Aservicing-approved)

## macOS Notarization Change

  Running "dotnet build" will generate a dll instead of a dylib on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://learn.microsoft.com/dotnet/core/install/macos-notarization-issues). If you want to opt into using the AppHost, add the following to your project file:

```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6129](https://github.com/dotnet/core/issues/6129) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.14.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.14.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.14.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.14.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.14.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.14.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.14.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.14.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.14.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.14.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.14.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.14.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.14.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.14.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.14.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.14.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.14.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.14.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.14.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.14.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.14.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.14.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.14.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.14.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.14.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.14.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.14.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.14.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.14.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.14.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.14.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.14.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.14.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.14.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.14.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.14.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.14.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.14.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.14.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.14.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.14.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.14.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.14.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.14.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.14.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.14.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.14.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.14.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.14.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.14.nupkg
Microsoft.NETCore.DotNetHost | 3.1.14.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.14.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.14.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.14.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.14.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.14.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.14.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.14.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.14.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.14.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.14.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.14.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.14.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.14.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.14.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.14.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.14.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.14.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.14.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.14.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.14.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.14.nupkg
Microsoft.NETCore.Platforms | 3.1.6.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.14.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.14.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.14.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.14.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.14.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.14.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.14.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.14.nupkg
dotnet-sql-cache | 3.1.14.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.14.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.14.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.14.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.14.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.14.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.14.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.14.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.14.nupkg
Microsoft.AspNetCore.TestHost | 3.1.14.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.14.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.14.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.14.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.14.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.14.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.14.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.14.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.14.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.14.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.14.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.14.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.14.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.14.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.14.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.14.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.14.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.14.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.14.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.14.nupkg
Microsoft.dotnet-openapi | 3.1.14.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.14.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.14.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.14.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.14.nupkg
Microsoft.AspNetCore.Metadata | 3.1.14.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.14.nupkg
Microsoft.AspNetCore.Owin | 3.1.14.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.14.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.14.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.14.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.14.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.14.nupkg
Microsoft.Extensions.Identity.Core | 3.1.14.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.14.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.14.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.14.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.14.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.14.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.14.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.14.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.14.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.14.nupkg
Microsoft.AspNetCore.Authorization | 3.1.14.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.14.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.14.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.14.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.14.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.14.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.14.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.14.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.14.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.14.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.14.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.14.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.14.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.14.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.14.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.14.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.14.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.14.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.14.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.14.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.14.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.14.nupkg
Microsoft.AspNetCore.Components | 3.1.14.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.14.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.14.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.14.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.14.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.14.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.14.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.14.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.14.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.14.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.14.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.14.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.14.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.14.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.14.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.14.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.14.nupkg
Microsoft.NET.Sdk.Razor | 3.1.14.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.14.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.14.nupkg
Microsoft.EntityFrameworkCore | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.14.nupkg
dotnet-ef | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.14.nupkg
Microsoft.Data.Sqlite.Core | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.14.nupkg
Microsoft.Data.Sqlite | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.14.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.14.nupkg
Microsoft.JSInterop | 3.1.14.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.14.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.14.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.14.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.14.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.14.nupkg
Microsoft.Extensions.Primitives | 3.1.14.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.14.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.14.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.14.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.14.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.14.nupkg
Microsoft.Extensions.Options | 3.1.14.nupkg
Microsoft.Extensions.Http | 3.1.14.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.14.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.14.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.14.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.14.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.14.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.14.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.14.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.14.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.14.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.14.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.14.nupkg
Microsoft.Extensions.Http.Polly | 3.1.14.nupkg
Microsoft.Extensions.Configuration | 3.1.14.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.14.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.14.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.14.nupkg
Microsoft.Extensions.Logging | 3.1.14.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.14.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.14.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.14.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.14.nupkg
Microsoft.Extensions.ObjectPool | 3.1.14.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.14.nupkg
Microsoft.Extensions.Logging.Console | 3.1.14.nupkg
Microsoft.Extensions.Localization | 3.1.14.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.14.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.14.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.14.nupkg
Microsoft.Extensions.WebEncoders | 3.1.14.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.14.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.14.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.14.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.14.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.14.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.14.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.14.nupkg
Microsoft.Extensions.Hosting | 3.1.14.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.14.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.14.md
[snap-install]: 3.1.14-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.14-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.14-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-april-2021-updates/

[//]: # ( Runtime 3.1.14)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b094bab3-c504-404b-9524-b191f7deaad3/42eb57c4ed80bf99336cb8ea99105c7b/dotnet-runtime-3.1.14-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c6c4000d-5156-4526-b39e-e8fc67594e1b/dc652a3170cab422a1860b63ee83a25b/dotnet-runtime-3.1.14-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7ea5a67d-c13f-4da6-8615-81033db8c143/6ce1efafbe3859a9e9863795a30fe7a2/dotnet-runtime-3.1.14-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e7f88aae-a10e-4b49-8ccd-31f2df82cf3f/35fb27716a3b7543ef2889f0e4c19949/dotnet-runtime-3.1.14-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4e5f17fa-fa56-40bc-bf3d-fd6abc91d0ad/08bd80f3751c0ac602dd41dc2534265e/dotnet-runtime-3.1.14-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/61df6a9d-3026-41f9-88e3-8bc9eded713d/6a46352bc4a98d208350d65e0a02bd3a/dotnet-runtime-3.1.14-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3423c7df-2daa-4188-8a13-646ae39f9d3f/86ed48857b28ce85cdc9a8699489aa71/dotnet-runtime-3.1.14-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/b05ae762-0720-4d51-80d5-76d6e1c3d212/c00f5949dcb80ba6b923d3b318960d3a/dotnet-runtime-3.1.14-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/56c3a951-9e5c-437d-a8da-80d263a62cc0/9681c2ff2f0e98f93976289e5ee7f53f/dotnet-runtime-3.1.14-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d88fda36-5e76-447e-8ed4-c3bd4151663c/c2d1485326cdeaab2168ee1d0ced1e0a/dotnet-runtime-3.1.14-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/56faca83-d1b3-4e1e-b203-3799c9166e84/707d7503ef4e4254f83f4030c60e8501/dotnet-runtime-3.1.14-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7859793b-fc78-474a-8e50-cf037ead0fec/d5cf5dbe06bb0f078f9329d4ee63ad91/dotnet-runtime-3.1.14-win-x86.zip

[//]: # ( WindowsDesktop 3.1.14)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/88437980-f813-4a01-865c-f992ad4909bb/9a936984781f6ce3526ffc946267e0ea/windowsdesktop-runtime-3.1.14-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f449f435-25d3-4d5c-ad14-0c84f5131dea/a597530464689595a430407e440787c4/windowsdesktop-runtime-3.1.14-win-x86.exe

[//]: # ( ASP 3.1.14)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a2439002-1f01-40d3-bc03-93612f2a25b5/2bd289060d44b428baa027ba0e8be762/aspnetcore-runtime-3.1.14-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/af1dcdff-acfe-4cbe-8a5b-aae0d6e63381/d3bd67c6fd14cd1187c268834189d5cc/aspnetcore-runtime-3.1.14-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/afd4ecd1-5473-495e-9441-28790eecedd0/687a17a0534e548c5a9ab6f953eff1a1/aspnetcore-runtime-3.1.14-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/16f982a4-68a1-4655-bb82-79862198d441/2fcb7b40ff0f3c2f786390817ef469f1/aspnetcore-runtime-3.1.14-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/516b337a-83f9-4946-b2a6-b2f686e09a76/d0e82549e890c5d852c461319ffd5b31/aspnetcore-runtime-3.1.14-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4e37dd8f-af29-4b27-b495-e7a2fdd1ccb1/50219323ab8d29de6a7fef040646d8b9/aspnetcore-runtime-3.1.14-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/b5f5103a-6605-4757-81d7-dcc83d6d025a/d50274294e23cf9d1226680029191972/aspnetcore-runtime-3.1.14-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c060cd8b-e7b8-4e20-8195-b102053f515b/fc88cd9ee072881bde14fa29badb8884/aspnetcore-runtime-3.1.14-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e4c43b9d-847a-4f92-aff3-ccae21822e43/cea2ed10f2fa8247a0cec513f6cc5e47/aspnetcore-runtime-3.1.14-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/871c3c8b-0fa3-4d95-bfb2-87e81000d975/e46edc7df65a9c88f354110b6c8a0ce8/aspnetcore-runtime-3.1.14-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/496f9fa7-1761-47f3-811b-18e546a0934c/05cc06e6d506ad92e61a1f638dd97774/aspnetcore-runtime-3.1.14-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/bdc70151-74f7-427c-a368-716d5f1840c5/6186889f6c784bae224eb15fb94c45fe/dotnet-hosting-3.1.14-win.exe

[//]: # ( SDK 3.1.114 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09c1545d-dd80-4629-ad2d-90a69723cb0b/06fd6210be9220099d4a506c0323c7c1/dotnet-sdk-3.1.114-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/99d10374-6d9f-4f7d-b79c-c7de5530a082/17105b38223a2bdb340775162dc96e65/dotnet-sdk-3.1.114-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/126ebec4-f57b-4f50-b359-471e74b4f948/92d88be97072597785268ed552858738/dotnet-sdk-3.1.114-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/79c30043-e62b-49e5-ba42-0aea2af1499a/f853a4f12fb4376532826272cdbbdd66/dotnet-sdk-3.1.114-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/181bacde-297f-4d45-97a4-4d8929779e4e/6a20a4e8a2911322399b56f1695bbdc6/dotnet-sdk-3.1.114-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ccca972-2444-4a2d-b978-3ba5a6a92ca0/8d6f121bebded1c2cf67e73f3552092a/dotnet-sdk-3.1.114-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/9ebeb16a-027b-441f-adfb-bce11ce5e66d/81ea90c02a162bec28cb09bb677de78e/dotnet-sdk-3.1.114-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/262179ed-c1a9-4336-9012-5a0624a939f5/696cf25414663da0aa5d2bb1f7960ae9/dotnet-sdk-3.1.114-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/de16b12a-5595-4d29-bc05-0781a10c75ed/d6115eb55cedf6f34c6d374cdbdfd860/dotnet-sdk-3.1.114-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ecb4ff96-9283-4df5-9bf0-39b93d0b9377/7d207e4e57d258f4dff4aac4410c7d6c/dotnet-sdk-3.1.114-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/87fed692-05b3-4b00-bd10-17a97678ba87/ff89f6e7a353f96ad37d30e81b3cd46a/dotnet-sdk-3.1.114-win-x86.zip
