# .NET Core 3.1.409 - May 11, 2021

This .NET Core SDK release includes the following released .NET Core and ASP.NET Core Runtimes.

* .NET Core SDK 3.1.409
* .NET Core Runtime 3.1.15
* ASP.NET Core 3.1.15

See the [Release Notes](3.1.15.md) for details about what is included in this update.


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.6 | [3.1.409](#downloads) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.115](3.1.15.md) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |


## Docker

The [.NET Core Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distributions which are not directly supported by .NET Core can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel 3.1/stable –-classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [.NET for Linux Distributions](../../../linux.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically include package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

Note: .NET 3.1 is available in the default Fedora 33+ packages feeds. Before using the default Fedora package feed, please make sure to remove any packages.microsoft.com registration first.

## Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-3.1
```

## Run applications

If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-3.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](../linux-packages.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-3.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-3.1` will install both the ASP.NET Core Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-3.1.15-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.409-download.md
[snap-install]: 3.1.15-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.15-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.15-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux


[//]: # ( Runtime 3.1.15)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8e22adf9-3d0c-4d05-98c2-418af9f75b07/92ae7cb0014cdafd6e6bb1ba30344d0f/dotnet-runtime-3.1.15-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/63d88492-c14a-48ac-bc16-0e8a20adcb81/56cdb7f10b6c4340a16565867b37056d/dotnet-runtime-3.1.15-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/12202a39-ed36-47e1-b5a0-109eb1151748/626c0e183181e2595be8fb923c8b18ba/dotnet-runtime-3.1.15-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e4bb6c66-f43c-4781-8ef2-4fa23e2d9d0d/23186bed817e4debd8f5ed264cb1c9dc/dotnet-runtime-3.1.15-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/692284f9-e1e7-4b31-9191-cd8043441024/ac45c17d4327b1f992b7fe3956a99129/dotnet-runtime-3.1.15-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7b0beb64-e40c-4eb2-83d1-86478e9e2f41/032098e50fe0b81d2f981c5acc4409cf/dotnet-runtime-3.1.15-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33e0367d-172f-46c6-9c52-139ede48154b/4abf68360d00e3301a51fa6a54a4af0e/dotnet-runtime-3.1.15-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/032e0c68-61b2-4b0f-a36b-7920f3005184/e2edb1fa69ec1128d4ef2e55a6949b0f/dotnet-runtime-3.1.15-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/175dbe99-a914-4654-90b3-a80a2d2f03c8/f1609ae26bce5fbff4ac08e0476d1a7e/dotnet-runtime-3.1.15-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9ced34cb-7ed9-44a1-9dd4-c8f83b56259d/0ab010ea8056e5c8e7c653efea456fc8/dotnet-runtime-3.1.15-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/35b3d0cb-0c1c-44c2-8134-bfae32e9aa2a/0754bccd12a07e746bce755f58a0e74d/dotnet-runtime-3.1.15-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/280a4546-1afc-4576-85c5-11605fef4bac/0f1556ac537ca7d183a2aa19f504b0f8/dotnet-runtime-3.1.15-win-x86.zip

[//]: # ( WindowsDesktop 3.1.15)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d30352fe-d4f3-4203-91b9-01a3b66a802e/bb416e6573fa278fec92113abefc58b3/windowsdesktop-runtime-3.1.15-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8b11972e-ded9-4d3c-9714-7c7ef047cca6/76dbe20bc03e69f5c0d005452ba88a9d/windowsdesktop-runtime-3.1.15-win-x86.exe

[//]: # ( ASP 3.1.15)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/000183b9-3d77-4e03-902e-7debe460497d/dcd6400fe1f28baba8624d3242f820a7/aspnetcore-runtime-3.1.15-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dccfa850-fe07-4444-8af1-5ec25cf177f2/e2625f76e9fc4748e956a4e7d449d34c/aspnetcore-runtime-3.1.15-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/72ff135f-2b46-4625-8777-e2135d59c4b4/c21ac6916d562771a8a3f14d4ccdd9b8/aspnetcore-runtime-3.1.15-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/27e4b0cc-5088-4a73-a436-cb5538ba2a0d/e04a0568631f3eb4c3311cf35b42c544/aspnetcore-runtime-3.1.15-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8aaf94dc-ce57-4d00-9d2d-70e8b760619e/2979ffe47a37c1aa5d931ee1953613f3/aspnetcore-runtime-3.1.15-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/45be4b5b-1ce2-480c-953c-6c7f0b836f09/ffbfcbc419a50d9a846de69bed41a6ce/aspnetcore-runtime-3.1.15-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/45a8a347-4263-432c-a29c-9a91a005ae74/0f4fadfabe18ad290022393636367750/aspnetcore-runtime-3.1.15-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ae6e6b5b-5e7c-45f9-a668-cb1899f22e46/9c917acfab934ddd64340ba46490264e/aspnetcore-runtime-3.1.15-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/268da69e-87a0-47bd-a353-f66d0a1bfb69/867b54adc61b71e7b38ab2091836dae9/aspnetcore-runtime-3.1.15-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/223a50e4-a4e1-42dc-8f97-f38a8f7518c3/642dab7b5177097ee223156ce70a6c3c/aspnetcore-runtime-3.1.15-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4e362d0f-853b-4fb3-b733-75d6c13b8f01/daef6e0e8a0e6e34b18d93026501b08a/aspnetcore-runtime-3.1.15-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c8eabe25-bb2b-4089-992e-48198ff72ad8/a55a5313bfb65ac9bd2e5069dd4de5bc/dotnet-hosting-3.1.15-win.exe

[//]: # ( SDK 3.1.409 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58d0ebb7-c06d-4d9a-a69f-22dac06fb278/0ae7881b7007c13a8e325d54a8f87657/dotnet-sdk-3.1.409-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/df1fe0a4-487f-4803-b541-4abb2f08ef2d/c905bb3ccc7f584963a45e32d7361d74/dotnet-sdk-3.1.409-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/10758180-a55d-444d-9b9b-0497d6fce4c0/c8941291391ec67f5a07634048905881/dotnet-sdk-3.1.409-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dfbc47b7-4c2c-4e00-989e-a18f6f2e8fe8/5f42a60705fd9122837c68dcbdbbe278/dotnet-sdk-3.1.409-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e77f6426-f98a-420d-8e47-f863ed50da53/d850329d205d17903149277985c453ec/dotnet-sdk-3.1.409-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/964ae449-a8b8-46d1-b944-c54f6e1bf8fc/f0cbcb2df3409d865b62f0c02a9ebbb9/dotnet-sdk-3.1.409-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8b25f371-643c-4250-b178-c97d37e05887/b508345f18902133c6d4daec35ac3cf1/dotnet-sdk-3.1.409-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/18b91030-c7a1-43be-9085-b14e96b828c0/23aef40e87463574c483ff3479c3cef6/dotnet-sdk-3.1.409-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d144f312-0922-4c92-a13f-9ffdf946525e/f5fd0de3cc3a88ba6bdb515e6e4dc41a/dotnet-sdk-3.1.409-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/72fdb191-1d41-4c5e-a5a4-0d6f10ba9af2/5cc37d0a751c96513aeb5f907b8c560d/dotnet-sdk-3.1.409-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/43d2148c-72a9-4658-9bb4-0d759203f20e/3837b775171032f0c2214c99ea56f7f5/dotnet-sdk-3.1.409-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8976e579-d782-4074-b1c5-33d7281e9d88/c95edf4f4e7725a6dbc2130205e1c102/dotnet-sdk-3.1.409-win-x86.zip
