# .NET Core 3.1.17 - July 13, 2021

The .NET 3.1.17 and .NET SDK 3.1.117 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.117
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

### Azure App Services

* .NET Core 3.1.17 is being deployed to Azure App Services and the deployment is expected to complete later in July 2021.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.411](3.1.411-download.md) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.117](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |



## Notable Changes

.NET Core 3.1.17 release carries non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/pulls?q=milestone%3A3.1.17+is%3Aclosed+label%3Aservicing-approved)
* [CoreFx](https://github.com/dotnet/corefx/pulls?q=milestone%3A3.1.17+is%3Aclosed+label%3Aservicing-approved)
* [Core-setup](https://github.com/dotnet/core-setup/pulls?q=milestone%3A3.1.17+is%3Aclosed+label%3Aservicing-approved)
* [Extensions](https://github.com/dotnet/extensions/pulls?q=milestone%3A3.1.17+is%3Aclosed+label%3Aservicing-approved)


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6459](https://github.com/dotnet/core/issues/6459) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.17.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.17.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.17.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.17.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.17.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.17.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.17.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.17.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.17.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.17.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.17.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.17.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.17.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.17.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.17.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.17.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.17.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.17.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.17.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.17.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.17.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.17.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.17.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.17.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.17.nupkg
Microsoft.NETCore.DotNetHost | 3.1.17.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.17.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.17.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.17.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.17.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.17.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.17.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.17.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.17.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.17.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.17.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.17.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.17.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.17.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.17.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.17.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.17.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.17.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.17.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.17.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.17.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.17.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.17.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.17.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.17.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.17.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.17.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.17.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.17.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.17.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.17.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.17.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.17.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.17.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.17.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.17.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.17.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.17.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.17.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.17.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.17.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.17.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.17.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.17.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.17.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.17.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.17.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.17.nupkg
Microsoft.AspNetCore.TestHost | 3.1.17.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.17.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.17.nupkg
dotnet-sql-cache | 3.1.17.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.17.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.17.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.17.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.17.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.17.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.17.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.17.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.17.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.17.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.17.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.17.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.17.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.17.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.17.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.17.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.17.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.17.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.17.nupkg
Microsoft.dotnet-openapi | 3.1.17.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.17.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.17.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.17.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.17.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.17.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.17.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.17.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.17.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.17.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.17.nupkg
Microsoft.AspNetCore.Authorization | 3.1.17.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.17.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.17.nupkg
Microsoft.AspNetCore.Metadata | 3.1.17.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.17.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.17.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.17.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.17.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.17.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.17.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.17.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.17.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.17.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.17.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.17.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.17.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.17.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.17.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.17.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.17.nupkg
Microsoft.AspNetCore.Owin | 3.1.17.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.17.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.17.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.17.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.17.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.17.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.17.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.17.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.17.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.17.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.17.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.17.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.17.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.17.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.17.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.17.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.17.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.17.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.17.nupkg
Microsoft.AspNetCore.Components | 3.1.17.nupkg
Microsoft.Extensions.Identity.Core | 3.1.17.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.17.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.17.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.17.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.17.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.17.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.17.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.17.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.17.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.17.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.17.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.17.nupkg
Microsoft.NET.Sdk.Razor | 3.1.17.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.17.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.17.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.17.nupkg
dotnet-ef | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.17.nupkg
Microsoft.Data.Sqlite.Core | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.17.nupkg
Microsoft.Data.Sqlite | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.17.nupkg
Microsoft.EntityFrameworkCore | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.17.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.17.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.17.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.17.nupkg
Microsoft.Extensions.WebEncoders | 3.1.17.nupkg
Microsoft.Extensions.Primitives | 3.1.17.nupkg
Microsoft.Extensions.Options | 3.1.17.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.17.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.17.nupkg
Microsoft.Extensions.Hosting | 3.1.17.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.17.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.17.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.17.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.17.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.17.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.17.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.17.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.17.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.17.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.17.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.17.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.17.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.17.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.17.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.17.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.17.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.17.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.17.nupkg
Microsoft.Extensions.Configuration | 3.1.17.nupkg
Microsoft.Extensions.Logging | 3.1.17.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.17.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.17.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.17.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.17.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.17.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.17.nupkg
Microsoft.Extensions.Http.Polly | 3.1.17.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.17.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.17.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.17.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.17.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.17.nupkg
Microsoft.Extensions.Http | 3.1.17.nupkg
Microsoft.Extensions.Localization | 3.1.17.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.17.nupkg
Microsoft.JSInterop | 3.1.17.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.17.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.17.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.17.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.17.nupkg
Microsoft.Extensions.ObjectPool | 3.1.17.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.17.nupkg
Microsoft.Extensions.Logging.Console | 3.1.17.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.17.nupkg

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.17.md
[snap-install]: 3.1.17-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.17-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.17-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-july-2021/


[//]: # ( Runtime 3.1.17)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/38a94860-f13c-4d7f-8089-4aaf6e34a4e0/d5dceff2f680b8ae9999de0028d64725/dotnet-runtime-3.1.17-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b079f97-5847-46fa-a3bb-d4aa5d674d7e/fd4c48ac7d03c00ca06aee63a1834074/dotnet-runtime-3.1.17-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1a65d1f3-37aa-4bc7-8f32-c89e91cc596c/b8a076c32f5fefdbecc40bce15024ceb/dotnet-runtime-3.1.17-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f0598531-ecfc-482f-9d38-bba14ebc4639/0612755e988b5e6d5d602aaeff68d7f6/dotnet-runtime-3.1.17-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7a4bfa73-e500-45aa-8e10-04dc4910d8ae/f8b74c973752d3ea095fe06aa625f7f7/dotnet-runtime-3.1.17-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d9016e1d-ac43-48d8-9928-f3822721f029/b417c4d50ba854ecae176566aa95a53c/dotnet-runtime-3.1.17-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/090c2104-7c36-440c-b40b-9a37315ad7f5/f006ce33af9674cfa24dbcde986e7e49/dotnet-runtime-3.1.17-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/9d81a06e-2532-4901-a6c8-035bc6ed19af/3d67a506153ad00a149a77be13937101/dotnet-runtime-3.1.17-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5bc28007-3bd9-458d-8a63-0918c27eb2fe/0d0d7d6600f7932f0d5b0a7b949be126/dotnet-runtime-3.1.17-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f7aa9c9b-a854-4307-84a5-1d7aaa126a7e/b828394c4b68d27b87a8c7293681135e/dotnet-runtime-3.1.17-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8b0f817c-0bda-49d4-b587-74d2bc2eeae3/96c6b670e096f268ea71ed6905a98478/dotnet-runtime-3.1.17-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/27b86f2b-a7c3-4f8c-8f62-6c593a332e4c/f13a19300cdc936f999eb48456f67a24/dotnet-runtime-3.1.17-win-x86.zip

[//]: # ( WindowsDesktop 3.1.17)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/444b48db-df03-4c14-b98d-09fec51b34d7/5bf38b8cde40d1e6e92c2495a89a4793/windowsdesktop-runtime-3.1.17-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7849e6b4-8ba7-4287-85e5-a76cd764ce6f/e4a25251dcff1af2af15868d7d9f3950/windowsdesktop-runtime-3.1.17-win-x86.exe

[//]: # ( ASP 3.1.17)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b90c0096-d58b-42cb-b71c-ca631ffe892f/781c09adab634c3ad0c462ecd144757d/aspnetcore-runtime-3.1.17-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f746eefd-6ae5-407b-8013-539e28ef60bf/80a42dda7bac89fda1867c1ed2002a13/aspnetcore-runtime-3.1.17-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/812b91da-fd52-44f8-a864-acaf5fbca418/82a1f7fd5b3c2e933a88de18387c6b33/aspnetcore-runtime-3.1.17-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e5c99cca-582a-444f-a142-2ff15aba13aa/117da93cae7e0dc12a3b86d861d0960d/aspnetcore-runtime-3.1.17-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5f9e644f-4555-4a62-8f92-af1ee9634008/778036941916d560bef6da8899ac88f5/aspnetcore-runtime-3.1.17-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7beea08-c477-4934-ae0d-99e6372e1ebd/7e6792efb84cc7542a2d2a0b2078d751/aspnetcore-runtime-3.1.17-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/acdba8c7-f8af-4bbd-a6a2-f60ca8cdc68f/bd390283bfdfb6ab3d38237107e83cce/aspnetcore-runtime-3.1.17-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d16eeeef-4faa-4b6f-bd79-28e3625ebd2a/3d8e10a0bca0431457acaa7e48ee9fc0/aspnetcore-runtime-3.1.17-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6921ff25-e160-48bd-84dd-e05bc4d092c6/b13376d46fae89dc6208eec8aa11521c/aspnetcore-runtime-3.1.17-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/38bb586f-0eed-492c-bf99-8a0f2a34abe6/b928889ade68319a6b565e27717f8612/aspnetcore-runtime-3.1.17-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/073fe341-2015-4857-b5aa-2e3f8afecb7b/6995dd615309ece22b5b824eda8c65e2/aspnetcore-runtime-3.1.17-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/db4f9e1d-7ef3-4409-8c37-1c57a66c1232/97f890c7af1f3e2049992299f2c7a54c/dotnet-hosting-3.1.17-win.exe


[//]: # ( SDK 3.1.117 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/56bbadc1-12ad-4885-95e6-a52760aa4786/d5bc16bac8471d8c8a978c9dc6154bb0/dotnet-sdk-3.1.117-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/af36f11d-46b3-4adf-8d39-bd8607c58edb/2d2fe413f311e55cb729b86c49a214c2/dotnet-sdk-3.1.117-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bc799706-0ab6-4f2e-ab40-c691a39494fe/04ed181b172eade1dfce2f1ccc03bd03/dotnet-sdk-3.1.117-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/589132a9-950c-4c01-9db7-ef06b902ce7e/8c1e51167731a0c05552fead69fa19f7/dotnet-sdk-3.1.117-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4168ee74-3a5c-4741-b4ef-cb0cd751d64c/d784ca94c3372690c250b9783e2c2630/dotnet-sdk-3.1.117-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/298924b2-2598-4cc0-b0a3-e30189b82e31/e2cf7067074dab9043c7a2d4ad9fdd01/dotnet-sdk-3.1.117-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1ac8dbb-87cb-424b-95dd-16ca34fe1138/275b1bf647dba78638a5e3917e981624/dotnet-sdk-3.1.117-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/29215376-bd13-4236-80e3-e9bd38cac735/f1a7ee60a6e084004a0cb1752104aa4e/dotnet-sdk-3.1.117-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/842e20e5-8cd4-4fe1-bdc5-5d27a45552dd/5660663ac2e8747101d040c7764a79c2/dotnet-sdk-3.1.117-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0adb3693-fe0b-41a9-968a-a888165eefad/b7e168596a258f57ff191eb17c9d2782/dotnet-sdk-3.1.117-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b68e10d3-0da2-4b36-917d-1d6e40adf776/2a4ac0b3290bb060839708aacf76802a/dotnet-sdk-3.1.117-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/215af70f-10ca-483b-8b12-d8e68ca56bac/4a13d04785885b295f49e1250f21cc6f/dotnet-sdk-3.1.117-win-x86.zip
