# .NET Core 3.1.411 - July 13, 2021

This .NET Core SDK release includes the following released .NET Core and ASP.NET Core Runtimes.

* .NET Core SDK 3.1.411
* .NET Core Runtime 3.1.17
* ASP.NET Core 3.1.17

See the [Release Notes](3.1.17.md) for details about what is included in this update.


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.6 | [3.1.411](#downloads) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.117](3.1.17.md) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |


## Docker

The [.NET Core Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distributions which are not directly supported by .NET Core can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel 3.1/stable –-classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [.NET for Linux Distributions](../../../linux.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically include package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

Note: .NET 3.1 is available in the default Fedora 33+ packages feeds. Before using the default Fedora package feed, please make sure to remove any packages.microsoft.com registration first.

## Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-3.1
```

## Run applications

If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-3.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](../linux-packages.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-3.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-3.1` will install both the ASP.NET Core Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-3.1.17-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.411-download.md
[snap-install]: 3.1.17-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.17-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.17-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux


[//]: # ( Runtime 3.1.17)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/38a94860-f13c-4d7f-8089-4aaf6e34a4e0/d5dceff2f680b8ae9999de0028d64725/dotnet-runtime-3.1.17-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b079f97-5847-46fa-a3bb-d4aa5d674d7e/fd4c48ac7d03c00ca06aee63a1834074/dotnet-runtime-3.1.17-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1a65d1f3-37aa-4bc7-8f32-c89e91cc596c/b8a076c32f5fefdbecc40bce15024ceb/dotnet-runtime-3.1.17-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f0598531-ecfc-482f-9d38-bba14ebc4639/0612755e988b5e6d5d602aaeff68d7f6/dotnet-runtime-3.1.17-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7a4bfa73-e500-45aa-8e10-04dc4910d8ae/f8b74c973752d3ea095fe06aa625f7f7/dotnet-runtime-3.1.17-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d9016e1d-ac43-48d8-9928-f3822721f029/b417c4d50ba854ecae176566aa95a53c/dotnet-runtime-3.1.17-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/090c2104-7c36-440c-b40b-9a37315ad7f5/f006ce33af9674cfa24dbcde986e7e49/dotnet-runtime-3.1.17-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/9d81a06e-2532-4901-a6c8-035bc6ed19af/3d67a506153ad00a149a77be13937101/dotnet-runtime-3.1.17-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5bc28007-3bd9-458d-8a63-0918c27eb2fe/0d0d7d6600f7932f0d5b0a7b949be126/dotnet-runtime-3.1.17-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f7aa9c9b-a854-4307-84a5-1d7aaa126a7e/b828394c4b68d27b87a8c7293681135e/dotnet-runtime-3.1.17-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8b0f817c-0bda-49d4-b587-74d2bc2eeae3/96c6b670e096f268ea71ed6905a98478/dotnet-runtime-3.1.17-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/27b86f2b-a7c3-4f8c-8f62-6c593a332e4c/f13a19300cdc936f999eb48456f67a24/dotnet-runtime-3.1.17-win-x86.zip

[//]: # ( WindowsDesktop 3.1.17)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/444b48db-df03-4c14-b98d-09fec51b34d7/5bf38b8cde40d1e6e92c2495a89a4793/windowsdesktop-runtime-3.1.17-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7849e6b4-8ba7-4287-85e5-a76cd764ce6f/e4a25251dcff1af2af15868d7d9f3950/windowsdesktop-runtime-3.1.17-win-x86.exe

[//]: # ( ASP 3.1.17)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b90c0096-d58b-42cb-b71c-ca631ffe892f/781c09adab634c3ad0c462ecd144757d/aspnetcore-runtime-3.1.17-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f746eefd-6ae5-407b-8013-539e28ef60bf/80a42dda7bac89fda1867c1ed2002a13/aspnetcore-runtime-3.1.17-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/812b91da-fd52-44f8-a864-acaf5fbca418/82a1f7fd5b3c2e933a88de18387c6b33/aspnetcore-runtime-3.1.17-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e5c99cca-582a-444f-a142-2ff15aba13aa/117da93cae7e0dc12a3b86d861d0960d/aspnetcore-runtime-3.1.17-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5f9e644f-4555-4a62-8f92-af1ee9634008/778036941916d560bef6da8899ac88f5/aspnetcore-runtime-3.1.17-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7beea08-c477-4934-ae0d-99e6372e1ebd/7e6792efb84cc7542a2d2a0b2078d751/aspnetcore-runtime-3.1.17-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/acdba8c7-f8af-4bbd-a6a2-f60ca8cdc68f/bd390283bfdfb6ab3d38237107e83cce/aspnetcore-runtime-3.1.17-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d16eeeef-4faa-4b6f-bd79-28e3625ebd2a/3d8e10a0bca0431457acaa7e48ee9fc0/aspnetcore-runtime-3.1.17-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6921ff25-e160-48bd-84dd-e05bc4d092c6/b13376d46fae89dc6208eec8aa11521c/aspnetcore-runtime-3.1.17-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/38bb586f-0eed-492c-bf99-8a0f2a34abe6/b928889ade68319a6b565e27717f8612/aspnetcore-runtime-3.1.17-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/073fe341-2015-4857-b5aa-2e3f8afecb7b/6995dd615309ece22b5b824eda8c65e2/aspnetcore-runtime-3.1.17-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/db4f9e1d-7ef3-4409-8c37-1c57a66c1232/97f890c7af1f3e2049992299f2c7a54c/dotnet-hosting-3.1.17-win.exe

[//]: # ( SDK 3.1.411 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c36515e8-b5eb-4501-bfda-555c16938673/4faa9e8f1e1f84f020e85ab3dbd4c306/dotnet-sdk-3.1.411-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3dc91205-b4b2-4b90-bd5d-899b85c79454/6831ad89fe379c5ed01dbd362cbd4cac/dotnet-sdk-3.1.411-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39d1095f-2100-4802-87db-624dab2c7650/2c79efc252b0a3894a85f453367f25f1/dotnet-sdk-3.1.411-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7afc344-acf0-4a6c-8e53-4455f2bcfc85/321418f6300e475f6c5d52849efa2e2e/dotnet-sdk-3.1.411-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0d2f3ad5-4921-4bd3-b977-ec5337fc7127/04d487944308530db535de00fe6dc6ab/dotnet-sdk-3.1.411-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5579eb11-0f40-46ad-9d87-274584ca8231/04c7e06cce0102990290e23fb6f1f139/dotnet-sdk-3.1.411-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1a495e39-09cb-4e95-b9b3-b1c6bac490c1/1bc8bd5c49a36aab6825bdeb6e6c854d/dotnet-sdk-3.1.411-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/887a1760-ea02-4baa-b22d-da6e9e861d80/58f826e2d828c11b2809298be53aa785/dotnet-sdk-3.1.411-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/17d4e08f-c93a-4e2c-83e6-1e7010b5c7ad/53fc30104eb36c45f6ef5930e4c88c01/dotnet-sdk-3.1.411-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/be4d4d21-3d7c-4f11-a077-2f78191ecba8/891edb15f0e1cc4fdcd9cf5d1bfc76f5/dotnet-sdk-3.1.411-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6e841eb8-1330-4f18-b0b0-89694f7f88c1/135a47cf13838a49b275c336c0b697fb/dotnet-sdk-3.1.411-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7e4e5bc9-eae0-427b-8055-70c41a21090a/fdaccaee52940b58880f0796f4201fc7/dotnet-sdk-3.1.411-win-x86.zip

[//]: # ( SDK 3.1.117 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/56bbadc1-12ad-4885-95e6-a52760aa4786/d5bc16bac8471d8c8a978c9dc6154bb0/dotnet-sdk-3.1.117-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/af36f11d-46b3-4adf-8d39-bd8607c58edb/2d2fe413f311e55cb729b86c49a214c2/dotnet-sdk-3.1.117-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bc799706-0ab6-4f2e-ab40-c691a39494fe/04ed181b172eade1dfce2f1ccc03bd03/dotnet-sdk-3.1.117-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/589132a9-950c-4c01-9db7-ef06b902ce7e/8c1e51167731a0c05552fead69fa19f7/dotnet-sdk-3.1.117-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4168ee74-3a5c-4741-b4ef-cb0cd751d64c/d784ca94c3372690c250b9783e2c2630/dotnet-sdk-3.1.117-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/298924b2-2598-4cc0-b0a3-e30189b82e31/e2cf7067074dab9043c7a2d4ad9fdd01/dotnet-sdk-3.1.117-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1ac8dbb-87cb-424b-95dd-16ca34fe1138/275b1bf647dba78638a5e3917e981624/dotnet-sdk-3.1.117-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/29215376-bd13-4236-80e3-e9bd38cac735/f1a7ee60a6e084004a0cb1752104aa4e/dotnet-sdk-3.1.117-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/842e20e5-8cd4-4fe1-bdc5-5d27a45552dd/5660663ac2e8747101d040c7764a79c2/dotnet-sdk-3.1.117-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0adb3693-fe0b-41a9-968a-a888165eefad/b7e168596a258f57ff191eb17c9d2782/dotnet-sdk-3.1.117-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b68e10d3-0da2-4b36-917d-1d6e40adf776/2a4ac0b3290bb060839708aacf76802a/dotnet-sdk-3.1.117-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/215af70f-10ca-483b-8b12-d8e68ca56bac/4a13d04785885b295f49e1250f21cc6f/dotnet-sdk-3.1.117-win-x86.zip
