# .NET Core 3.1.18 - August 10, 2021

The .NET Core Runtime 3.1.18, .NET Core SDK 3.1.412 and [.NET Core SDK 3.1.118](3.1.118.md) releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.412
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

### Azure App Services

* .NET Core 3.1.18 is being deployed to Azure App Services and the deployment is expected to complete later in August 2021.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.412](#downloads) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.118](3.1.118.md) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |



## Notable Changes

.NET Core 3.1.18 release carries both security and non-security fixes.

# Microsoft Security Advisory CVE-2021-34485 | .NET Core Information Disclosure Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1 and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

An information disclosure vulnerability exists in .NET 5.0, .NET Core 3.1 and .NET Core 2.1 when dumps created by the tool to collect crash dumps and dumps on demand are created with global read permissions on Linux and macOS.

# Microsoft Security Advisory CVE-2021-26423 | .NET Core Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1 and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists in .NET 5.0, .NET Core 3.1 and .NET Core 2.1 where .NET (Core) server applications providing WebSocket endpoints could be tricked into endlessly looping while trying to read a single WebSocket frame.

# Microsoft Security Advisory CVE-2021-34532 | ASP.NET Core Information Disclosure Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1 and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

An information disclosure vulnerability exists in .NET 5.0, .NET Core 3.1 and .NET Core 2.1 where an JWT token is logged if it cannot be parsed.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

### Additional fixes in this release

* [CoreFx](https://github.com/dotnet/corefx/pulls?q=milestone%3A3.1.18+is%3Aclosed+label%3Aservicing-approved)
* [Winforms](https://github.com/dotnet/winforms/pulls?q=milestone%3A3.1.18+is%3Aclosed+label%3Aservicing-approved)


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6553](https://github.com/dotnet/core/issues/6553) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.18.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.18.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.18.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.18.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.18.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.18.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.18.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.18.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.18.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.18.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.18.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.18.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.18.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.18.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.18.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.18.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.18.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.18.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.18.nupkg
Microsoft.NETCore.DotNetHost | 3.1.18.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.18.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.18.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.18.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.18.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.18.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.18.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.18.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.18.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.18.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.18.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.18.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.18.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.18.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.18.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.18.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.18.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.18.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.18.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.18.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.18.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.18.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.18.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.18.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.18.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.18.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.18.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.18.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.18.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.18.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.18.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.18.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.18.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.18.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.18.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.18.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.18.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.18.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.18.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.18.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.18.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.18.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.18.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.18.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.18.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.18.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.18.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.18.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.18.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.18.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.18.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.18.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.18.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.18.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.18.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.18.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.18.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.18.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.18.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.18.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.18.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.18.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.18.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.18.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.18.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.18.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.18.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.18.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.18.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.18.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.18.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.18.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.18.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.18.nupkg
Microsoft.dotnet-openapi | 3.1.18.nupkg
dotnet-sql-cache | 3.1.18.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.18.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.18.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.18.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.18.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.18.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.18.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.18.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.18.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.18.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.18.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.18.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.18.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.18.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.18.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.18.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.18.nupkg
Microsoft.AspNetCore.Owin | 3.1.18.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.18.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.18.nupkg
Microsoft.AspNetCore.Authorization | 3.1.18.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.18.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.18.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.18.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.18.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.18.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.18.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.18.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.18.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.18.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.18.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.18.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.18.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.18.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.18.nupkg
Microsoft.Extensions.Identity.Core | 3.1.18.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.18.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.18.nupkg
Microsoft.AspNetCore.TestHost | 3.1.18.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.18.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.18.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.18.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.18.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.18.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.18.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.18.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.18.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.18.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.18.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.18.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.18.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.18.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.18.nupkg
Microsoft.AspNetCore.Metadata | 3.1.18.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.18.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.18.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.18.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.18.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.18.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.18.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.18.nupkg
Microsoft.AspNetCore.Components | 3.1.18.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.18.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.18.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.18.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.18.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.18.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.18.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.18.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.18.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.18.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.18.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.18.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.18.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.18.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.18.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.18.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.18.nupkg
Microsoft.NET.Sdk.Razor | 3.1.18.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.18.nupkg
Microsoft.EntityFrameworkCore | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.18.nupkg
dotnet-ef | 3.1.18.nupkg
Microsoft.Data.Sqlite.Core | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.18.nupkg
Microsoft.Data.Sqlite | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.18.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.18.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.18.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.18.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.18.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.18.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.18.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.18.nupkg
Microsoft.Extensions.WebEncoders | 3.1.18.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.18.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.18.nupkg
Microsoft.Extensions.ObjectPool | 3.1.18.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.18.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.18.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.18.nupkg
Microsoft.Extensions.Http.Polly | 3.1.18.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.18.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.18.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.18.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.18.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.18.nupkg
Microsoft.Extensions.Http | 3.1.18.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.18.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.18.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.18.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.18.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.18.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.18.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.18.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.18.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.18.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.18.nupkg
Microsoft.Extensions.Logging.Console | 3.1.18.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.18.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.18.nupkg
Microsoft.Extensions.Logging | 3.1.18.nupkg
Microsoft.JSInterop | 3.1.18.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.18.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.18.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.18.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.18.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.18.nupkg
Microsoft.Extensions.Configuration | 3.1.18.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.18.nupkg
Microsoft.Extensions.Primitives | 3.1.18.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.18.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.18.nupkg
Microsoft.Extensions.Hosting | 3.1.18.nupkg
Microsoft.Extensions.Localization | 3.1.18.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.18.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.18.nupkg
Microsoft.Extensions.Options | 3.1.18.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.18.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.18.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.18.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.18-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.18-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-august-2021/


[//]: # ( Runtime 3.1.18)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/553523d6-f78f-4897-bbf5-13e4720d9a2e/e48e3eea5d133197fcc191a673ec4a22/dotnet-runtime-3.1.18-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/276e189e-9535-4bfd-b84d-b60c043b582b/89729cf37b76f7eca3b8cb8176e9dbf2/dotnet-runtime-3.1.18-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1e8dc450-5e64-498a-ad2b-fb33543b2d42/17a4cac10a7ee3c6aa0b59e4f92b6c0f/dotnet-runtime-3.1.18-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/87fb522b-ee8d-4d26-8f45-82d3b2187293/ae2aa08059ac12deca00adc0cd196cca/dotnet-runtime-3.1.18-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/13a14c60-b4c7-4d48-bef5-8553bb28980d/7b8eb9f74577383064bfb3b02a5964f5/dotnet-runtime-3.1.18-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/18d16d77-9172-46ac-9cd2-72ea0fa6b366/13103fc2200fd16b83e6ededbc0d510f/dotnet-runtime-3.1.18-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6135fd1-df82-4cf9-bcba-34b8104d5782/fc4bc57a4ecf1ed68c3d47734956d0e9/dotnet-runtime-3.1.18-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/7e1c876a-45f6-4e8b-8bb5-1cdaf0800c59/25b36e0b06873c5605bc8618a0712338/dotnet-runtime-3.1.18-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7d09d7c0-8902-4467-9268-d7f584923cde/eddcb12257e68b030bc1b4baf9a68681/dotnet-runtime-3.1.18-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/37c67f99-f227-47c3-ab1b-ee474a5576a1/aa0d14a14e98f995825d712936f0716e/dotnet-runtime-3.1.18-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c6a860af-a0ec-44d9-95bb-27213e6ae584/f042477c51e9e274bc2df2b3936cc75d/dotnet-runtime-3.1.18-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/774fe66a-0709-425f-b73d-b2b478a7c842/95b9323ca5f69acf25e86ae15aea17ac/dotnet-runtime-3.1.18-win-x86.zip

[//]: # ( WindowsDesktop 3.1.18)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/aa240732-82d7-4bd1-9701-e4014d7dc735/41a460f5e9c343f7b9207f64ab0e4c90/windowsdesktop-runtime-3.1.18-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1a1efc0c-f28c-4d60-8a52-6d62da05444c/0d192b81749b9374342b64150c9442a0/windowsdesktop-runtime-3.1.18-win-x86.exe

[//]: # ( ASP 3.1.18)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/56d6e6bb-34e4-4e8e-8d6f-ce11be174182/6a3daf4d44793478df8f5f291cc8b029/aspnetcore-runtime-3.1.18-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6feb0bc9-ed1e-40b0-bb06-5ea0826bac35/b12cb170ec2c406c8ec4fd8bf90cfc52/aspnetcore-runtime-3.1.18-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/317a80a7-d16b-4fdd-9f4d-bda5f8485c7c/fd6ec4f8a875b436e1266d0a8cb1baed/aspnetcore-runtime-3.1.18-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/027367d0-0577-489b-8474-0f02253aa3f0/b82fdb9ee04ec8da8e82b7e9f4128f0e/aspnetcore-runtime-3.1.18-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/67843ba3-26f9-4746-bdfe-0f8074c00767/d51340f4f5cf8a361414650f510fe202/aspnetcore-runtime-3.1.18-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1ef6d2e-e8eb-4522-8c3f-c8f4b1a5d832/e6bc77b95881cf1614a1047cae819af6/aspnetcore-runtime-3.1.18-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/5e5a334f-f38b-4660-8960-8414f6fdae94/85d65b69b7471d8f466a5893dcdd1f6f/aspnetcore-runtime-3.1.18-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c37ece76-1305-4042-a9e6-58e7cb1b0bf6/75c20ff59335e370985b4f03fa637fcb/aspnetcore-runtime-3.1.18-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d5e5fe63-7e9e-4817-822a-bbb83f088715/02201bb196ede826363a0037563b097e/aspnetcore-runtime-3.1.18-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e9290580-1545-415c-864b-578d9469364f/4593126fe99a07fc0b52a7328597b865/aspnetcore-runtime-3.1.18-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9e64a4e0-6d4f-4c1e-a557-e1a0898eeea1/17b3ed31cf779978f1537dae5f9d7bc6/aspnetcore-runtime-3.1.18-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/a363a491-56ab-4451-a901-e5886dea2fc6/40595416f34ad49d8a83c2bf83f03487/dotnet-hosting-3.1.18-win.exe

[//]: # ( SDK 3.1.412)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5aef7e5d-2112-4868-8d7c-4c82f04363c5/e4fe30dc136634001cf357f26c825506/dotnet-sdk-3.1.412-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f9f54199-f0b3-43ac-badd-f9ef6867641c/50bd985f26c59f5d63f29f571f7f89e5/dotnet-sdk-3.1.412-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ad0d810a-37d7-4b8d-a818-7cf7e23eaf2e/617ee35bf77b9c0a1aadeb4e09f83fa6/dotnet-sdk-3.1.412-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/90e2064f-8786-4e12-95cd-8185fc71f1cb/1a3279320411c489f37142ec656ef0b8/dotnet-sdk-3.1.412-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b79a9bde-c846-49d8-b9b4-ed3ab95f839e/01af43fe9c3fd1831fa1db9a502473b7/dotnet-sdk-3.1.412-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/46981fb5-7b16-4c5b-bedb-68a479939a41/b0295f7dda05c6ec038fc023168259dd/dotnet-sdk-3.1.412-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6b5c79a-077b-4c6d-acb2-c8be3ef527c7/fb1fd46305b3deaf9e4ace607b5a8d00/dotnet-sdk-3.1.412-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/f689de95-ba3c-406c-ad52-0d88e4d9cc24/5b02567e62649059119dfe53d199b0bb/dotnet-sdk-3.1.412-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/046165a4-10d4-4156-8e65-1d7b2cbd304e/a4c7b01f6bf7199669a45ab6a03803ac/dotnet-sdk-3.1.412-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/44476be2-ac39-4378-889e-37e71285c5fd/d8e7bc8809999cd5d56622993ee06c63/dotnet-sdk-3.1.412-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4ac11493-ccf2-4e3f-943e-f6aef9208853/ac20ce2a8178cc65f8f5c570ccdc29bd/dotnet-sdk-3.1.412-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0041e593-2191-400c-8692-3d769dd28f18/b00dff7aa2c609eb05a9a29d589c697b/dotnet-sdk-3.1.412-win-x86.zip
