# .NET Core 3.1.22 - December 14 , 2021

.NET Core 3.1.22 and .NET Core SDK 3.1.416 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.416
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

### Azure App Services

* .NET Core 3.1.22 is being deployed to Azure App Services and the deployment is expected to complete later in December 2021.

## Deployment Update

Customers that have opted to receive .NET Core updates via the Microsoft Update channel will be offered updates to the Hosting Bundle starting with the December 2021 update. Updates for other .NET Core bundles (.NET Core Runtime, ASP.NET Core Runtime, Windows Desktop Runtime, and SDK) have been offered via Microsoft Update to customers that opt in since December 2020. See this [blog post](https://devblogs.microsoft.com/dotnet/net-core-updates-coming-to-microsoft-update) for more information.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.416](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |



## Notable Changes

# Microsoft Security Advisory CVE-2021-43877 | ASP.NET Core Elevation of privilege Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET and .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

An elevation of privilege vulnerability exists in ASP.NET Core Module (ANCM) that could allow elevation of privilege when .NET Core, .NET 5 and .NET 6 applications are hosted within IIS.

.NET Core 3.1.22 release carries security and non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

### Additional fixes in this release
* [ASP.NET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A3.1.22++is%3Aclosed+label%3Aservicing-approved+)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7036](https://github.com/dotnet/core/issues/7036) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.22.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.22.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.22.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.22.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.22.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.22.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.22.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.22.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.22.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.22.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.22.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.22.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.22.nupkg
Microsoft.NETCore.DotNetHost | 3.1.22.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.22.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.22.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.22.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.22.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.22.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.22.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.22.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.22.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.22.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.22.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.22.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.22.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.22.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.22.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.22.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.22.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.22.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.22.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.22.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.22.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.22.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.22.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.22.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.22.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.22.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.22.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.22.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.22.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.22.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.22.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.22.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.22.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.22.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.22.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.22.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.22.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.22.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.22.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.22.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.22.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.22.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.22.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.22.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.22.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.22.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.22.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.22.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.22.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.22.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.22.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.22.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.22.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.22.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.22.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.22.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.22.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.22.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.22.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.22.nupkg
Microsoft.AspNetCore.Authorization | 3.1.22.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.22.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.22.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.22.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.22.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.22.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.22.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.22.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.22.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.22.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.22.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.22.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.22.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.22.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.22.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.22.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.22.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.22.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.22.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.22.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.22.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.22.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.22.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.22.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.22.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.22.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.22.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.22.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.22.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.22.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.22.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.22.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.22.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.22.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.22.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.22.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.22.nupkg
Microsoft.AspNetCore.TestHost | 3.1.22.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.22.nupkg
Microsoft.dotnet-openapi | 3.1.22.nupkg
dotnet-sql-cache | 3.1.22.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.22.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.22.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.22.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.22.nupkg
Microsoft.AspNetCore.Owin | 3.1.22.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.22.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.22.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.22.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.22.nupkg
Microsoft.AspNetCore.Components | 3.1.22.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.22.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.22.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.22.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.22.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.22.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.22.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.22.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.22.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.22.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.22.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.22.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.22.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.22.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.22.nupkg
Microsoft.Extensions.Identity.Core | 3.1.22.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.22.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.22.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.22.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.22.nupkg
Microsoft.AspNetCore.Metadata | 3.1.22.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.22.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.22.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.22.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.22.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.22.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.22.nupkg
Microsoft.Data.Sqlite.Core | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.22.nupkg
dotnet-ef | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.22.nupkg
Microsoft.Data.Sqlite | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.22.nupkg
Microsoft.EntityFrameworkCore | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.22.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.22.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.22.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.22.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.22.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.22.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.22.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.22.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.22.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.22.nupkg
Microsoft.Extensions.Configuration | 3.1.22.nupkg
Microsoft.Extensions.Options | 3.1.22.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.22.nupkg
Microsoft.Extensions.Hosting | 3.1.22.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.22.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.22.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.22.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.22.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.22.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.22.nupkg
Microsoft.Extensions.Primitives | 3.1.22.nupkg
Microsoft.Extensions.ObjectPool | 3.1.22.nupkg
Microsoft.Extensions.Logging.Console | 3.1.22.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.22.nupkg
Microsoft.Extensions.Http.Polly | 3.1.22.nupkg
Microsoft.JSInterop | 3.1.22.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.22.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.22.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.22.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.22.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.22.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.22.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.22.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.22.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.22.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.22.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.22.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.22.nupkg
Microsoft.Extensions.Http | 3.1.22.nupkg
Microsoft.Extensions.Logging | 3.1.22.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.22.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.22.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.22.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.22.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.22.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.22.nupkg
Microsoft.Extensions.WebEncoders | 3.1.22.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.22.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.22.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.22.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.22.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.22.nupkg
Microsoft.Extensions.Localization | 3.1.22.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.22.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.22.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.22-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.22-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/december-2021-updates/


[//]: # ( Runtime 3.1.22)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/59ac1b86-7d1b-4321-9880-9d7c11dadaf5/5e4019b066cd8a78b33f567bb8a1a5d0/dotnet-runtime-3.1.22-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2da60b58-b342-4edf-86e5-e343984c2697/76c4e4cb37c0950a9d73aaf314e109dd/dotnet-runtime-3.1.22-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d28fca28-a016-44c1-be19-d38acc2d113d/5927097ee507edcc9a7d7f168c4978fd/dotnet-runtime-3.1.22-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/787e6ae7-03a1-44c3-849f-ed85b25ff620/c6f4cfe60b5dc12cb2032a580c8e4c58/dotnet-runtime-3.1.22-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a11a2ba-d599-486f-ba61-9e420bc4a2bb/db9d61f28e0a688adc83687b611702ff/dotnet-runtime-3.1.22-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2b0556cd-006a-4772-a1f6-f28dbd042509/ca7a1486eddf277fd5b419198d4c8289/dotnet-runtime-3.1.22-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39f94fea-8181-4fea-a8f1-5e99189e17f3/1a98e370e9bae6b79a7975e1e4740310/dotnet-runtime-3.1.22-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/7a534765-4849-4724-8d8d-38f7af5dcc94/d7b5b114f604f1b15d5ff927749670ff/dotnet-runtime-3.1.22-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4e95705e-1bb6-4764-b899-1b97eb70ea1d/dd311e073bd3e25b2efe2dcf02727e81/dotnet-runtime-3.1.22-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b072b0b7-42cc-41c5-91b1-e6ec3b83581a/65d7f42b6df4370a81ec270cd07dde30/dotnet-runtime-3.1.22-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c2437aed-8cc4-41d0-a239-d6c7cf7bddae/062c37e8b06df740301c0bca1b0b7b9a/dotnet-runtime-3.1.22-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/07bde014-b680-4526-a7d4-a0b56174ab38/4afd0fa162c4c9d02ac6786d5273f2f7/dotnet-runtime-3.1.22-win-x86.zip

[//]: # ( WindowsDesktop 3.1.22)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1c14e24b-7f31-42dc-ba3c-83295a2d6f7e/41b93591162dfe556cc160ae44fbe75e/windowsdesktop-runtime-3.1.22-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e4fcd574-4487-4b4b-8ca8-c23177c6f59f/c6d67a04956169dc21895cdcb42bf344/windowsdesktop-runtime-3.1.22-win-x86.exe

[//]: # ( ASP 3.1.22)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aa937189-01d4-4656-b202-493c9947d29a/9de1a87d125e4d158c357d35fa81737c/aspnetcore-runtime-3.1.22-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4f1a224b-f1b8-4e00-9f87-989beab1aa0d/5ba796b5a886ea16503d336ea389fae2/aspnetcore-runtime-3.1.22-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a5bdf73f-4a49-41d4-a401-faf92dda842c/c8b17243ecf466c9124bb5fa46d10354/aspnetcore-runtime-3.1.22-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c9b43283-e42a-41f2-9274-711411298d34/d2ed427503879e7f0741447208991531/aspnetcore-runtime-3.1.22-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ded261a4-ec9a-46be-8359-3055e73ff388/9ab54349df5185d4f548abdca3dd523d/aspnetcore-runtime-3.1.22-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b27749db-5b42-47da-b16f-153ba95bbf22/64654baca62faf5796335bea216c6853/aspnetcore-runtime-3.1.22-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/0b588723-482e-4bd2-8c7a-14c71659acf9/12168ab4300f2649e149c4d8da922f86/aspnetcore-runtime-3.1.22-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/80e52143-31e8-450e-aa94-b3f8484aaba9/4b69e5c77d50e7b367960a0079c90a99/aspnetcore-runtime-3.1.22-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b7448c2d-fb97-4244-8f90-6e72669daee6/19c66bda300ce1c44c918e40fb30a32b/aspnetcore-runtime-3.1.22-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0a1a2ee5-b8ed-4f0d-a4af-a7bce9a9ac2b/d452039b49d79e8897f272c3ab34b875/aspnetcore-runtime-3.1.22-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c6fedc18-54d7-4b4f-bfc2-726fc46f5f58/64a913d424a005ff33ff265776cd05e0/aspnetcore-runtime-3.1.22-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/5b681079-0068-4c70-be77-af30f1154a83/cd5d074d8328fbc0b3bebf87c88ae082/dotnet-hosting-3.1.22-win.exe

[//]: # ( SDK 3.1.416)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b2a2fb1-b04b-485b-8a25-caed97ebe601/0c6024a3814f664558dc39fc85b34192/dotnet-sdk-3.1.416-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3aaa7cc-a603-4693-871b-53b1537a4319/5981099ca17a113b3ce1c080462c50ef/dotnet-sdk-3.1.416-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1da779d5-0177-4a0c-a439-34f38e1d4761/56649104a169e490e09b5cfc6e4ba26e/dotnet-sdk-3.1.416-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3c98126b-50f5-4497-8ffd-18d17a3f6b95/044d0f20256fd9bf2971f8da9a0364e4/dotnet-sdk-3.1.416-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a5c96d86-8ba2-4ca7-b920-2b74c3e264ff/e13bb06f8ddd4779d2bd2b8e05db161e/dotnet-sdk-3.1.416-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2dc016eb-cb93-4bdf-98c0-ee8c84ad26c0/d1a7eb02814ac9e164cb0e23c24d5973/dotnet-sdk-3.1.416-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/895b7e35-b1c2-4d1d-8d7f-f82f4ae70eb7/9470e66ca28443328cbaa36963ff83f8/dotnet-sdk-3.1.416-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/fc2630fe-f2e1-455c-9007-af42ca572999/0e9ed656908438563185ad292c8a8933/dotnet-sdk-3.1.416-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c3cf05a0-3011-46ac-9d03-38a2e25d77c8/2ce9c7449a222d423ae6fe41e7f9f867/dotnet-sdk-3.1.416-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1842d490-55d8-4b96-82a8-468cfd4cd127/6925df11c7c31c7b51018779f76626dc/dotnet-sdk-3.1.416-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/52ab1b11-b2ff-4a81-aca3-fcace67ff84d/b8f1f8eab48d423b5b42c1a1af35d57b/dotnet-sdk-3.1.416-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/bfc0d931-ad63-4afc-9f68-8824f14325c4/9be2542d43ffc549b39f8ca554ff8844/dotnet-sdk-3.1.416-win-x86.zip
