# .NET Core 3.1.23 - March 8, 2022

.NET Core 3.1.23 and .NET Core SDK 3.1.417 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.417
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.417](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |



## Notable Changes
.NET Core 3.1.23 release carries security fixes.

# Microsoft Security Advisory CVE-2022-24464 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0, and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a Denial of Service vulnerability, which exists in .NET 6.0, .NET 5.0, and .NET Core 3.1 when parsing certain types of http form requests.

# Microsoft Security Advisory CVE-2022-24512 | .NET Remote Code Execution Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0, and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Remote Code Execution vulnerability exists in .NET 6.0, .NET 5.0, and .NET Core 3.1 where a stack buffer overrun occurs in .NET Double Parse routine.

# Microsoft Security Advisory CVE-2020-8927 | .NET Remote Code Execution Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 5.0 and .NET Core 3.1 where a buffer overflow exists in the Brotli library versions prior to 1.0.8.


* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7259](https://github.com/dotnet/core/issues/7259) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.23.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.23-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.23-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/march-2022-updates/

## Packages updated in this release:

Package name | Version
:----------- | :------------------
  runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.23.nupkg
 runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.23.nupkg
 runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.23.nupkg
 runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.23.nupkg
 runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.23.nupkg
 runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.23.nupkg
 runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.23.nupkg
 runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.23.nupkg
 runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.23.nupkg
 runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.23.nupkg
 runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.23.nupkg
 runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.23.nupkg
 runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.23.nupkg
 runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.23.nupkg
 runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.23.nupkg
 runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.23.nupkg
 runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.23.nupkg
 runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.23.nupkg
 runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.23.nupkg
 runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.23.nupkg
 runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.23.nupkg
 runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.23.nupkg
 runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.23.nupkg
 runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.23.nupkg
 runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.23.nupkg
 runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.23.nupkg
 Microsoft.NETCore.App.Host.linux-arm | 3.1.23.nupkg
 Microsoft.NETCore.App.Host.linux-arm64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Host.linux-x64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Host.osx-x64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Host.win-arm | 3.1.23.nupkg
 Microsoft.NETCore.App.Host.win-arm64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Host.win-x64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Host.win-x86 | 3.1.23.nupkg
 Microsoft.NETCore.App.Runtime.linux-arm | 3.1.23.nupkg
 Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Runtime.win-arm | 3.1.23.nupkg
 Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Runtime.win-x64 | 3.1.23.nupkg
 Microsoft.NETCore.App.Runtime.win-x86 | 3.1.23.nupkg
 Microsoft.NETCore.DotNetAppHost | 3.1.23.nupkg
 Microsoft.NETCore.DotNetHost | 3.1.23.nupkg
 Microsoft.NETCore.DotNetHostPolicy | 3.1.23.nupkg
 Microsoft.NETCore.DotNetHostResolver | 3.1.23.nupkg
 Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.23.nupkg
 Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.23.nupkg
 runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.23.nupkg
 runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.23.nupkg
 runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.23.nupkg
 runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.23.nupkg
 runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.23.nupkg
 runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.23.nupkg
 runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.23.nupkg
 runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.23.nupkg
 runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.23.nupkg
 runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.23.nupkg
 runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.23.nupkg
 runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.23.nupkg
 runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.23.nupkg
 runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.23.nupkg
 Microsoft.Extensions.Identity.Stores | 3.1.23.nupkg
 Microsoft.Extensions.Identity.Core | 3.1.23.nupkg
 Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.23.nupkg
 Microsoft.Extensions.ApiDescription.Server | 3.1.23.nupkg
 Microsoft.Extensions.ApiDescription.Client | 3.1.23.nupkg
 Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.23.nupkg
 Microsoft.DotNet.Web.ItemTemplates | 3.1.23.nupkg
 Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.23.nupkg
 Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.23.nupkg
 Microsoft.AspNetCore.TestHost | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.23.nupkg
 Microsoft.dotnet-openapi | 3.1.23.nupkg
 dotnet-sql-cache | 3.1.23.nupkg
 AspNetCoreRuntime.3.1.x86 | 3.1.23.nupkg
 AspNetCoreRuntime.3.1.x64 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.23.nupkg
 Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.23.nupkg
 Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.23.nupkg
 Microsoft.AspNetCore.Metadata | 3.1.23.nupkg
 Microsoft.AspNetCore.JsonPatch | 3.1.23.nupkg
 Microsoft.AspNetCore.Identity.UI | 3.1.23.nupkg
 Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.23.nupkg
 Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.23.nupkg
 Microsoft.AspNetCore.Http.Features | 3.1.23.nupkg
 Microsoft.AspNetCore.Http.Connections.Common | 3.1.23.nupkg
 Microsoft.AspNetCore.Http.Connections.Client | 3.1.23.nupkg
 Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.23.nupkg
 Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.23.nupkg
 Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.23.nupkg
 Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.23.nupkg
 Microsoft.AspNetCore.NodeServices | 3.1.23.nupkg
 Microsoft.AspNetCore.SpaServices.Extensions | 3.1.23.nupkg
 Microsoft.AspNetCore.SpaServices | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.23.nupkg
 Microsoft.AspNetCore.Mvc.Testing | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Client.Core | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Client | 3.1.23.nupkg
 Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.23.nupkg
 Microsoft.AspNetCore.Owin | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Common | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.23.nupkg
 Microsoft.AspNetCore.HeaderPropagation | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.23.nupkg
 Microsoft.AspNetCore.Authorization | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection.Extensions | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.Twitter | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.Negotiate | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.23.nupkg
 Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.Facebook | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.Certificate | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.Google | 3.1.23.nupkg
 Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.WsFederation | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection | 3.1.23.nupkg
 Microsoft.AspNetCore.Cryptography.Internal | 3.1.23.nupkg
 Microsoft.AspNetCore.Connections.Abstractions | 3.1.23.nupkg
 Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.23.nupkg
 Microsoft.AspNetCore.Components.Web | 3.1.23.nupkg
 Microsoft.AspNetCore.Components.Forms | 3.1.23.nupkg
 Microsoft.AspNetCore.Components.Authorization | 3.1.23.nupkg
 Microsoft.AspNetCore.Components.Analyzers | 3.1.23.nupkg
 Microsoft.AspNetCore.Components | 3.1.23.nupkg
 Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.23.nupkg
 Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.23.nupkg
 Microsoft.Extensions.Identity.Stores | 3.1.23.nupkg
 Microsoft.Extensions.Identity.Core | 3.1.23.nupkg
 Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.23.nupkg
 Microsoft.Extensions.ApiDescription.Server | 3.1.23.nupkg
 Microsoft.Extensions.ApiDescription.Client | 3.1.23.nupkg
 Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.23.nupkg
 Microsoft.DotNet.Web.ItemTemplates | 3.1.23.nupkg
 Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.23.nupkg
 Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.23.nupkg
 Microsoft.AspNetCore.TestHost | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.23.nupkg
 Microsoft.dotnet-openapi | 3.1.23.nupkg
 dotnet-sql-cache | 3.1.23.nupkg
 AspNetCoreRuntime.3.1.x86 | 3.1.23.nupkg
 AspNetCoreRuntime.3.1.x64 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.23.nupkg
 Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.23.nupkg
 Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.23.nupkg
 Microsoft.AspNetCore.Metadata | 3.1.23.nupkg
 Microsoft.AspNetCore.JsonPatch | 3.1.23.nupkg
 Microsoft.AspNetCore.Identity.UI | 3.1.23.nupkg
 Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.23.nupkg
 Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.23.nupkg
 Microsoft.AspNetCore.Http.Features | 3.1.23.nupkg
 Microsoft.AspNetCore.Http.Connections.Common | 3.1.23.nupkg
 Microsoft.AspNetCore.Http.Connections.Client | 3.1.23.nupkg
 Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.23.nupkg
 Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.23.nupkg
 Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.23.nupkg
 Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.23.nupkg
 Microsoft.AspNetCore.NodeServices | 3.1.23.nupkg
 Microsoft.AspNetCore.SpaServices.Extensions | 3.1.23.nupkg
 Microsoft.AspNetCore.SpaServices | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.23.nupkg
 Microsoft.AspNetCore.Mvc.Testing | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Client.Core | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Client | 3.1.23.nupkg
 Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.23.nupkg
 Microsoft.AspNetCore.Owin | 3.1.23.nupkg
 Microsoft.AspNetCore.SignalR.Common | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.23.nupkg
 Microsoft.AspNetCore.HeaderPropagation | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.23.nupkg
 Microsoft.AspNetCore.Authorization | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection.Extensions | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.Twitter | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.Negotiate | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.23.nupkg
 Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.Facebook | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.Certificate | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.23.nupkg
 Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.Google | 3.1.23.nupkg
 Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.23.nupkg
 Microsoft.AspNetCore.Authentication.WsFederation | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.23.nupkg
 Microsoft.AspNetCore.DataProtection | 3.1.23.nupkg
 Microsoft.AspNetCore.Cryptography.Internal | 3.1.23.nupkg
 Microsoft.AspNetCore.Connections.Abstractions | 3.1.23.nupkg
 Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.23.nupkg
 Microsoft.AspNetCore.Components.Web | 3.1.23.nupkg
 Microsoft.AspNetCore.Components.Forms | 3.1.23.nupkg
 Microsoft.AspNetCore.Components.Authorization | 3.1.23.nupkg
 Microsoft.AspNetCore.Components.Analyzers | 3.1.23.nupkg
 Microsoft.AspNetCore.Components | 3.1.23.nupkg
 Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.23.nupkg
 Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.23.nupkg
 Microsoft.DotNet.Common.ItemTemplates | 3.1.23.nupkg
 Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.23.nupkg
 Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.23.nupkg
 Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.23.nupkg
 Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.23.nupkg
 Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.23.nupkg
 Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.23.nupkg
 System.IO.Pipelines | 4.7.5.nupkg
 Microsoft.AspNetCore.Razor.Language | 3.1.23.nupkg
 Microsoft.CodeAnalysis.Razor | 3.1.23.nupkg
 Microsoft.NET.Sdk.Razor | 3.1.23.nupkg
 Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.Tools | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.SqlServer | 3.1.23.nupkg
 dotnet-ef | 3.1.23.nupkg
 Microsoft.Data.Sqlite | 3.1.23.nupkg
 Microsoft.Data.Sqlite.Core | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.Abstractions | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.Analyzers | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.Cosmos | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.InMemory | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.Design | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.Relational | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.Sqlite | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.23.nupkg
 Microsoft.EntityFrameworkCore.Proxies | 3.1.23.nupkg
 Microsoft.JSInterop | 3.1.23.nupkg
 Microsoft.Extensions.FileProviders.Abstractions | 3.1.23.nupkg
 Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.23.nupkg
 Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.23.nupkg
 Microsoft.Extensions.DiagnosticAdapter | 3.1.23.nupkg
 Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.23.nupkg
 Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.23.nupkg
 Microsoft.Extensions.DependencyInjection | 3.1.23.nupkg
 Microsoft.Extensions.Configuration.Xml | 3.1.23.nupkg
 Microsoft.Extensions.Configuration.UserSecrets | 3.1.23.nupkg
 Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.23.nupkg
 Microsoft.Extensions.Configuration.KeyPerFile | 3.1.23.nupkg
 Microsoft.Extensions.Configuration.Json | 3.1.23.nupkg
 Microsoft.Extensions.Configuration.Ini | 3.1.23.nupkg
 Microsoft.Extensions.Configuration.FileExtensions | 3.1.23.nupkg
 Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.23.nupkg
 Microsoft.Extensions.Configuration.CommandLine | 3.1.23.nupkg
 Microsoft.Extensions.Configuration.Binder | 3.1.23.nupkg
 Microsoft.Extensions.FileProviders.Composite | 3.1.23.nupkg
 Microsoft.Extensions.Caching.Abstractions | 3.1.23.nupkg
 Microsoft.Extensions.Caching.SqlServer | 3.1.23.nupkg
 Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.23.nupkg
 Microsoft.Extensions.Configuration | 3.1.23.nupkg
 Microsoft.Extensions.Configuration.Abstractions | 3.1.23.nupkg
 Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.23.nupkg
 Microsoft.Extensions.Caching.Memory | 3.1.23.nupkg
 Microsoft.Extensions.WebEncoders | 3.1.23.nupkg
 Microsoft.Extensions.FileProviders.Embedded | 3.1.23.nupkg
 Microsoft.Extensions.FileSystemGlobbing | 3.1.23.nupkg
 Microsoft.Extensions.Primitives | 3.1.23.nupkg
 Microsoft.Extensions.Options.DataAnnotations | 3.1.23.nupkg
 Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.23.nupkg
 Microsoft.Extensions.Options | 3.1.23.nupkg
 Microsoft.Extensions.ObjectPool | 3.1.23.nupkg
 Microsoft.Extensions.Logging.TraceSource | 3.1.23.nupkg
 Microsoft.Extensions.Logging.EventSource | 3.1.23.nupkg
 Microsoft.Extensions.Logging.EventLog | 3.1.23.nupkg
 Microsoft.Extensions.FileProviders.Physical | 3.1.23.nupkg
 Microsoft.Extensions.Logging.Console | 3.1.23.nupkg
 Microsoft.Extensions.Logging.Configuration | 3.1.23.nupkg
 Microsoft.Extensions.Logging.Debug | 3.1.23.nupkg
 Microsoft.Extensions.Hosting | 3.1.23.nupkg
 Microsoft.Extensions.Hosting.Abstractions | 3.1.23.nupkg
 Microsoft.Extensions.Logging.AzureAppServices | 3.1.23.nupkg
 Microsoft.Extensions.Hosting.Systemd | 3.1.23.nupkg
 Microsoft.Extensions.Http | 3.1.23.nupkg
 Microsoft.Extensions.Http.Polly | 3.1.23.nupkg
 Microsoft.Extensions.Localization | 3.1.23.nupkg
 Microsoft.Extensions.Localization.Abstractions | 3.1.23.nupkg
 Microsoft.Extensions.Logging | 3.1.23.nupkg
 Microsoft.Extensions.Logging.Abstractions | 3.1.23.nupkg
 Microsoft.Extensions.Hosting.WindowsServices | 3.1.23.nupkg


[//]: # ( Runtime 3.1.23)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97d3b167-5605-4de4-a735-04c540f274f3/99dd9fd5195f8725254b4f8d5897bf97/dotnet-runtime-3.1.23-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f7cb69c-db30-4174-8b1d-aa6cdb50a324/2483784c6707a569d92ce72199d31998/dotnet-runtime-3.1.23-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ed2e763c-9ff0-402f-a01d-625a3317435a/47360747cbd63a52b10abe56b139a827/dotnet-runtime-3.1.23-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3318317d-26f6-4547-b41b-6e5f1dbe3dbb/a2e60e4a5412e2579b86e3870fc80742/dotnet-runtime-3.1.23-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4022ad95-d68e-46de-a849-f66d482d6b45/f67e642ff95d838d03a0548cc4ea0ba1/dotnet-runtime-3.1.23-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/cb11b14e-09f4-48cf-9bc9-ed785ea2e3f3/f1b9d6ac94db6151422eb273520a05aa/dotnet-runtime-3.1.23-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1a4e929e-335f-4377-b3c9-fba2cadca9e8/7c24cacb065eee7770cadea99a0cfea5/dotnet-runtime-3.1.23-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/23cf26b3-64ea-4b49-a9ee-c2a59285941d/71db62dd056e30158cee9beceec2254a/dotnet-runtime-3.1.23-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9fa03f97-6c46-4aa1-8193-00a5b66dfae8/1638ae61aeb362ecf63ce4142a188d89/dotnet-runtime-3.1.23-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d39730cf-7304-4710-bc6b-3efa34a7ccb2/f4b1c4cbf216894faf13a1ff2437acd8/dotnet-runtime-3.1.23-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/03939b9f-0fad-4399-b43f-fd1960d798a4/0384ba55a4dfd6d94d6ca86b0c897e09/dotnet-runtime-3.1.23-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4617b5bc-eed2-453f-bb00-fcf7009376f1/5dce02fc1491121aa9fe3571f3734795/dotnet-runtime-3.1.23-win-x86.zip

[//]: # ( WindowsDesktop 3.1.23)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0bc6a80a-3f07-411d-8ce3-17aaeb7388ac/ed1000a04fc9c8dca5af35b53263d9ae/windowsdesktop-runtime-3.1.23-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c5fa66c0-fe4f-471e-81ac-8f6574518709/b729e0728b756672758ec3927b34c1bb/windowsdesktop-runtime-3.1.23-win-x86.exe

[//]: # ( ASP 3.1.23)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1807fe27-9fc6-4ca0-a186-f9a5a941d7a6/ee1662ca2a603618bc8f0e93f05c770c/aspnetcore-runtime-3.1.23-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/677b9c58-362a-463b-8e42-c2812d23d782/d6a7a814daf37f40355e5e4e098e1d13/aspnetcore-runtime-3.1.23-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97923244-0aae-4754-a02f-0a3dca73568d/799b9050426e25da52c1df1bdc492596/aspnetcore-runtime-3.1.23-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/36eac931-1dd0-4819-90e3-5f26fefabf1c/5ff29243646cbf1169d064d344351bf3/aspnetcore-runtime-3.1.23-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/437c96ef-4100-41a2-8c3a-17e01d078e53/d62482387d9ff71f009c3b7794a80212/aspnetcore-runtime-3.1.23-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c8720c0e-58ee-462c-9ba1-b92a6f599f71/87a66c8d78fff8f6263cbcb71778e1f4/aspnetcore-runtime-3.1.23-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/87678784-0bd6-4a9c-9019-c3d5a5dc9e49/e7bb9fc9e1e9ea902c992bb605bf0706/aspnetcore-runtime-3.1.23-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0de950c1-b385-438a-b1be-9f4fc0c35be5/4aa21f95334bf59d842cd899763ff6e1/aspnetcore-runtime-3.1.23-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/60c1fe64-3c9d-4a13-bffa-65aff86d039c/28bd30b0f5adaf8c99c5df019cfe826e/aspnetcore-runtime-3.1.23-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7a4a195c-37df-48c5-9cba-a9d38b6fd86a/64e11509f0597562b917efb065c8334f/aspnetcore-runtime-3.1.23-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0fe86008-a578-4cca-810a-743e8238e0e0/96fa8304d9437e05f437b4cc545a1d71/aspnetcore-runtime-3.1.23-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/8c089b35-4e8d-4eda-b1e9-1267d2240818/4f60c233e5c968a236e853576548f6ae/dotnet-hosting-3.1.23-win.exe

[//]: # ( SDK 3.1.417)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/36a601f0-b88e-41ea-910b-4dde7b083e73/61ec8564d50fb391f9e3a10b226fdd0d/dotnet-sdk-3.1.417-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5da6dffe-5c27-4d62-87c7-a3fca48be9bd/967bd7ddc7bbcaef20671175f7b26ee3/dotnet-sdk-3.1.417-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a861d3d3-cac7-43ab-8f53-f2b79776bb22/9b89428d982c24615c32210b2c2c84e4/dotnet-sdk-3.1.417-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d8cdb908-9a61-45e9-8cac-1899af7b49b4/0f815fae130481a31fed4d9d1ad5b217/dotnet-sdk-3.1.417-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9473795a-3cd6-45ef-b6c0-724029369bb9/06c809557b30ffcdce59d5d4c978b4d8/dotnet-sdk-3.1.417-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/95c7c3fe-7036-4724-8730-4631603d3b6b/8bc1f5d475ec827f5d8defe984a21a83/dotnet-sdk-3.1.417-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d1accbe-6ed2-4fc8-b8d9-5e98919947da/55d7f3f3521f519e92318ec6178eddcb/dotnet-sdk-3.1.417-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/00ed1520-f35b-4e76-91ff-b295a7519a87/a43769908eff201c57b872de93147bdf/dotnet-sdk-3.1.417-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/962fa33f-e57c-4e8a-abc9-01882ff74e3d/23e11ee6c3da863fa1489f951aa7e75e/dotnet-sdk-3.1.417-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7c6cd67f-61d2-4b4e-bf19-556043769544/cfa8364fb2b22b4602ee14b60b8c8ca1/dotnet-sdk-3.1.417-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/acf5cfff-ddb5-437e-a7f1-59b66cd9d29f/7a63487c13fd4164aa3209992fb09810/dotnet-sdk-3.1.417-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8c6d3e38-51a2-4041-a78e-2557a978ca15/ad85bfde0935be10c8266256f616a462/dotnet-sdk-3.1.417-win-x86.zip
