# .NET Core 3.1.26 - June 14, 2022

.NET Core 3.1.26 and .NET Core SDK 3.1.420 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.420
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.9 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.9 | [3.1.420](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |


## Notable Changes
.NET Core 3.1.26 release carries security fixes.

# Microsoft Security Advisory CVE-2022-30184 | .NET Information Disclosure Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0 and .NET Core 3.1 within Nuget where a credential leak can occur.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7536](https://github.com/dotnet/core/issues/7536) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.26.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.26-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.26-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/june-2022-updates/

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.NETCore.App.Host.linux-musl-arm64| 3.1.26.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64| 3.1.26.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.26.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.26.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 3.1.26.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.26.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.26.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 3.1.26.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 3.1.26.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64| 3.1.26.nupkg
Microsoft.NETCore.App.Host.win-arm| 3.1.26.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 3.1.26.nupkg
Microsoft.NETCore.App.Runtime.linux-x64| 3.1.26.nupkg
Microsoft.NETCore.App.Runtime.win-arm| 3.1.26.nupkg
Microsoft.NETCore.App.Runtime.win-x64| 3.1.26.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64| 3.1.26.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86| 3.1.26.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 3.1.26.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.26.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 3.1.26.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 3.1.26.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost| 3.1.26.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.26.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.26.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 3.1.26.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.26.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.26.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 3.1.26.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.26.nupkg
Microsoft.NETCore.App.Host.win-arm64| 3.1.26.nupkg
Microsoft.NETCore.App.Runtime.win-arm64| 3.1.26.nupkg
Microsoft.NETCore.DotNetAppHost| 3.1.26.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 3.1.26.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.26.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.26.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 3.1.26.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 3.1.26.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.26.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.26.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 3.1.26.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 3.1.26.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.26.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.26.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.26.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.26.nupkg
Microsoft.NETCore.App.Host.linux-arm| 3.1.26.nupkg
Microsoft.NETCore.App.Host.linux-arm64| 3.1.26.nupkg
Microsoft.NETCore.App.Host.osx-x64| 3.1.26.nupkg
Microsoft.NETCore.App.Host.win-x64| 3.1.26.nupkg
Microsoft.NETCore.App.Host.win-x86| 3.1.26.nupkg
Microsoft.NETCore.App.Runtime.osx-x64| 3.1.26.nupkg
Microsoft.NETCore.App.Runtime.win-x86| 3.1.26.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 3.1.26.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 3.1.26.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.26.nupkg
Microsoft.NETCore.App.Runtime.linux-arm| 3.1.26.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost| 3.1.26.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 3.1.26.nupkg
Microsoft.NETCore.App.Host.linux-x64| 3.1.26.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64| 3.1.26.nupkg
Microsoft.NETCore.DotNetHost| 3.1.26.nupkg
Microsoft.NETCore.DotNetHostPolicy| 3.1.26.nupkg
Microsoft.NETCore.DotNetHostResolver| 3.1.26.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost| 3.1.26.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.26.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.26.nupkg
Microsoft.Extensions.Identity.Stores| 3.1.26.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 3.1.26.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64| 3.1.26.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64| 3.1.26.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 3.1.26.nupkg
Microsoft.AspNetCore.Http.Connections.Client| 3.1.26.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 3.1.26.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 3.1.26.nupkg
Microsoft.AspNetCore.SignalR.Client.Core| 3.1.26.nupkg
Microsoft.AspNetCore.SignalR.Client| 3.1.26.nupkg
Microsoft.AspNetCore.Authentication.Facebook| 3.1.26.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI| 3.1.26.nupkg
Microsoft.AspNetCore.Authentication.Google| 3.1.26.nupkg
Microsoft.AspNetCore.DataProtection| 3.1.26.nupkg
Microsoft.Extensions.Identity.Core| 3.1.26.nupkg
Microsoft.Extensions.ApiDescription.Client| 3.1.26.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1| 3.1.26.nupkg
dotnet-sql-cache| 3.1.26.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm| 3.1.26.nupkg
Microsoft.AspNetCore.JsonPatch| 3.1.26.nupkg
Microsoft.AspNetCore.Http.Connections.Common| 3.1.26.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 3.1.26.nupkg
Microsoft.AspNetCore.SpaServices| 3.1.26.nupkg
Microsoft.AspNetCore.SignalR.Common| 3.1.26.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64| 3.1.26.nupkg
Microsoft.AspNetCore.Authentication.WsFederation| 3.1.26.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation| 3.1.26.nupkg
Microsoft.AspNetCore.Components.Web| 3.1.26.nupkg
Microsoft.DotNet.Web.ItemTemplates| 3.1.26.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates| 3.1.26.nupkg
AspNetCoreRuntime.3.1.x86| 3.1.26.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm| 3.1.26.nupkg
Microsoft.dotnet-openapi| 3.1.26.nupkg
Microsoft.AspNetCore.Identity.UI| 3.1.26.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests| 3.1.26.nupkg
Microsoft.AspNetCore.NodeServices| 3.1.26.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 3.1.26.nupkg
Microsoft.AspNetCore.Owin| 3.1.26.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 3.1.26.nupkg
Microsoft.AspNetCore.DataProtection.Extensions| 3.1.26.nupkg
Microsoft.AspNetCore.Authentication.Negotiate| 3.1.26.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 3.1.26.nupkg
Microsoft.AspNetCore.Cryptography.Internal| 3.1.26.nupkg
Microsoft.AspNetCore.Components| 3.1.26.nupkg
Microsoft.Extensions.ApiDescription.Server| 3.1.26.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 3.1.26.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis| 3.1.26.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 3.1.26.nupkg
Microsoft.AspNetCore.SpaServices.Extensions| 3.1.26.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86| 3.1.26.nupkg
Microsoft.AspNetCore.Authentication.Twitter| 3.1.26.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 3.1.26.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer| 3.1.26.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 3.1.26.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions| 3.1.26.nupkg
Microsoft.AspNetCore.Components.Authorization| 3.1.26.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter| 3.1.26.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 3.1.26.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices| 3.1.26.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 3.1.26.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests| 3.1.26.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json| 3.1.26.nupkg
Microsoft.AspNetCore.Authorization| 3.1.26.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect| 3.1.26.nupkg
Microsoft.AspNetCore.Authentication.Certificate| 3.1.26.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 3.1.26.nupkg
Microsoft.AspNetCore.Connections.Abstractions| 3.1.26.nupkg
Microsoft.AspNetCore.Components.Analyzers| 3.1.26.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1| 3.1.26.nupkg
Microsoft.AspNetCore.TestHost| 3.1.26.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64| 3.1.26.nupkg
AspNetCoreRuntime.3.1.x64| 3.1.26.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64| 3.1.26.nupkg
Microsoft.AspNetCore.Metadata| 3.1.26.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 3.1.26.nupkg
Microsoft.AspNetCore.Http.Features| 3.1.26.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 3.1.26.nupkg
Microsoft.AspNetCore.Mvc.Testing| 3.1.26.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 3.1.26.nupkg
Microsoft.AspNetCore.HeaderPropagation| 3.1.26.nupkg
Microsoft.AspNetCore.Components.Forms| 3.1.26.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration| 3.1.26.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0| 3.1.26.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1| 3.1.26.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x| 3.1.26.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0| 3.1.26.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2| 3.1.26.nupkg
Microsoft.DotNet.Common.ItemTemplates| 3.1.26.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1| 3.1.26.nupkg
Microsoft.CodeAnalysis.Razor| 3.1.26.nupkg
Microsoft.AspNetCore.Razor.Language| 3.1.26.nupkg
Microsoft.NET.Sdk.Razor| 3.1.26.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.Tools| 3.1.26.nupkg
dotnet-ef| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.Design| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.SqlServer| 3.1.26.nupkg
Microsoft.EntityFrameworkCore| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.Sqlite| 3.1.26.nupkg
Microsoft.Data.Sqlite| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.Abstractions| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.Cosmos| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.InMemory| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 3.1.26.nupkg
Microsoft.Data.Sqlite.Core| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.Analyzers| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.Relational| 3.1.26.nupkg
Microsoft.EntityFrameworkCore.Proxies| 3.1.26.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 3.1.26.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests| 3.1.26.nupkg
Microsoft.Extensions.Caching.SqlServer| 3.1.26.nupkg
Microsoft.Extensions.FileProviders.Embedded| 3.1.26.nupkg
Microsoft.Extensions.Primitives| 3.1.26.nupkg
Microsoft.Extensions.DiagnosticAdapter| 3.1.26.nupkg
Microsoft.Extensions.Configuration.Xml| 3.1.26.nupkg
Microsoft.Extensions.Configuration.KeyPerFile| 3.1.26.nupkg
Microsoft.Extensions.Caching.Abstractions| 3.1.26.nupkg
Microsoft.Extensions.FileSystemGlobbing| 3.1.26.nupkg
Microsoft.Extensions.Options.DataAnnotations| 3.1.26.nupkg
Microsoft.Extensions.FileProviders.Physical| 3.1.26.nupkg
Microsoft.Extensions.Configuration| 3.1.26.nupkg
Microsoft.Extensions.ObjectPool| 3.1.26.nupkg
Microsoft.Extensions.Logging.EventSource| 3.1.26.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions| 3.1.26.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson| 3.1.26.nupkg
Microsoft.Extensions.Configuration.CommandLine| 3.1.26.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis| 3.1.26.nupkg
Microsoft.Extensions.Logging.Debug| 3.1.26.nupkg
Microsoft.Extensions.Http| 3.1.26.nupkg
Microsoft.JSInterop| 3.1.26.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks| 3.1.26.nupkg
Microsoft.Extensions.DependencyInjection| 3.1.26.nupkg
Microsoft.Extensions.Configuration.Json| 3.1.26.nupkg
Microsoft.Extensions.Configuration.FileExtensions| 3.1.26.nupkg
Microsoft.Extensions.Configuration.Abstractions| 3.1.26.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions| 3.1.26.nupkg
Microsoft.Extensions.Logging.TraceSource| 3.1.26.nupkg
Microsoft.Extensions.Logging.EventLog| 3.1.26.nupkg
Microsoft.Extensions.Logging.Configuration| 3.1.26.nupkg
Microsoft.Extensions.Localization.Abstractions| 3.1.26.nupkg
Microsoft.Extensions.Configuration.Ini| 3.1.26.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables| 3.1.26.nupkg
Microsoft.Extensions.WebEncoders| 3.1.26.nupkg
Microsoft.Extensions.Caching.Memory| 3.1.26.nupkg
Microsoft.Extensions.FileProviders.Composite| 3.1.26.nupkg
Microsoft.Extensions.Options| 3.1.26.nupkg
Microsoft.Extensions.Logging.Console| 3.1.26.nupkg
Microsoft.Extensions.Hosting.Systemd| 3.1.26.nupkg
Microsoft.Extensions.Localization| 3.1.26.nupkg
Microsoft.Extensions.Logging.Abstractions| 3.1.26.nupkg
Microsoft.Extensions.Hosting| 3.1.26.nupkg
Microsoft.Extensions.Hosting.Abstractions| 3.1.26.nupkg
Microsoft.Extensions.Http.Polly| 3.1.26.nupkg
Microsoft.Extensions.Logging| 3.1.26.nupkg
Microsoft.Extensions.FileProviders.Abstractions| 3.1.26.nupkg
Microsoft.Extensions.Configuration.UserSecrets| 3.1.26.nupkg
Microsoft.Extensions.Configuration.Binder| 3.1.26.nupkg
Microsoft.Extensions.Logging.AzureAppServices| 3.1.26.nupkg
Microsoft.Extensions.Hosting.WindowsServices| 3.1.26.nupkg


[//]: # ( Runtime 3.1.26)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e6e33223-7d66-4527-a136-4cf975353bfa/1b50d103dd24165c4bb87011c4bb41d6/dotnet-runtime-3.1.26-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cb0e8b4b-7b2b-40cc-b7a6-30f0d4fabe6c/f5cb06cbb1b1b5d198792333b3db235a/dotnet-runtime-3.1.26-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c61c0112-2123-47be-8ce4-4eb7886ad6c8/bfeda09472a742f5550f38196e2c6704/dotnet-runtime-3.1.26-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2f7eb774-ccda-4b50-8661-2b363ea93562/2d41b51ff8a978b7b8c12e0ed8fae74b/dotnet-runtime-3.1.26-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a14c8e4d-a22b-47f8-953c-bb4337634513/58017d103d432f7106c44b0891936aba/dotnet-runtime-3.1.26-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e14e6b1e-b27d-4f8c-90e7-9def21d250a1/1602ff3b9598157d42a541069882a30a/dotnet-runtime-3.1.26-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6bedea65-b104-45b8-abe9-36cefbeedadf/05f4e472ec2395dad7103fda9ed278b2/dotnet-runtime-3.1.26-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/1e59be28-53a4-43c8-991a-885180fc8877/13aee0a20e2d9009c74b0a687f75de81/dotnet-runtime-3.1.26-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d68744b6-7bb2-43c3-80f2-b1c2e7108a4d/8d13e9eabef35592e79f2eb608ce63e6/dotnet-runtime-3.1.26-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/bcf63452-4708-4ea3-94c9-71297e0fba13/f7ba23ab26ea03c7437621c5577f9a00/dotnet-runtime-3.1.26-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bdcac76d-0597-49d3-9c9f-739fa824a397/efc7d60c312bdf9c3f7168d8b8b73954/dotnet-runtime-3.1.26-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8efa8cad-0c3d-4744-86d5-7ab46b859afc/0e2ceddf73199c45d3885ad96dd0dfa2/dotnet-runtime-3.1.26-win-x86.zip

[//]: # ( WindowsDesktop 3.1.26)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a40ed796-b721-455e-bf17-574d905fd8d7/b5ce5020abaf4317855697cb5d085695/windowsdesktop-runtime-3.1.26-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a4ddd21c-0c40-49a2-bea4-a9209e214953/6381be0ed116cf2ee2cc72c9b4ad35ce/windowsdesktop-runtime-3.1.26-win-x86.exe

[//]: # ( ASP 3.1.26)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d05cb243-5392-478b-ab85-a7123c1d304e/94833632c0e5f80691258283f889af34/aspnetcore-runtime-3.1.26-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6b68a14a-b4dd-4a75-bb32-26c08d19190f/1d6b637e290775f668701f8f6092ab35/aspnetcore-runtime-3.1.26-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95ad0d56-e0db-4d19-8c33-921ec5da3b2d/3ab9ca19c1ba8f26aeec1d237c36f962/aspnetcore-runtime-3.1.26-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68598153-d1c9-4413-9c4e-127e5f944469/ec7429af0782056161659ab6405bb678/aspnetcore-runtime-3.1.26-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f72adf7-0e78-48ea-85ef-e72a39a1f8a1/1ec0238c236c3757e5628563a329fdc4/aspnetcore-runtime-3.1.26-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33e8be5c-5e6a-4dc2-9aa8-846aaffa6897/fe9d96af1d75f8d5f4cba4bff95f2fae/aspnetcore-runtime-3.1.26-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/03168212-59d7-4a24-93c4-03f00c52ec92/9b0bd15549a50d32558a553aa8ad1a99/aspnetcore-runtime-3.1.26-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6b84271b-7981-491e-bd9c-bb80173191a0/245c0523fbdc56322c6c8f08bc2e6960/aspnetcore-runtime-3.1.26-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1b357655-c440-4012-8a19-b2c4b7a54d8f/88f533e711186b120d8fba5a3a306566/aspnetcore-runtime-3.1.26-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c77f2fdf-905d-4886-bbcd-98be61e34d48/f7499d8dc547d6df28a673df1cbdaf5f/aspnetcore-runtime-3.1.26-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9b3535b4-9c65-49ec-87dc-d32b0076ed1a/57de9e642bab2d2335d4798837f79c10/aspnetcore-runtime-3.1.26-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/3f4a4c4f-f969-41b3-b9d5-0b889261646b/0c24d7226927c10847b5efecc3528ee0/dotnet-hosting-3.1.26-win.exe

[//]: # ( SDK 3.1.420)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/78abce54-388a-418f-85e0-cf3c6a0e7d35/98d1ee575a0369c97c3d14ee0e1085a8/dotnet-sdk-3.1.420-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a84bf296-ee6e-4e66-9694-90d3da7af2b4/b00b2efe2432938e5a19c45d3759d80f/dotnet-sdk-3.1.420-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/be39cbdb-38b9-45f3-a8c2-fe7029954327/e0c2ca91909db1a9dc5522faf73ff576/dotnet-sdk-3.1.420-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5424da8c-ce12-46de-a51a-8fa61aefdde6/52a9d6b5718ea40863db96901c780d4b/dotnet-sdk-3.1.420-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c3e1c0ca-42fa-421c-a58e-507a9e046d55/5cb3a4564df9e86cf729163474b658df/dotnet-sdk-3.1.420-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ed7270b9-903b-4cc7-8a85-6cea3f954720/29603443e7d51971b04b6ed3a6911eac/dotnet-sdk-3.1.420-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bb0efe58-450c-4e28-81c1-4081acd6ffa4/1d0eaf8b624dff000c8b10ea0497e731/dotnet-sdk-3.1.420-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/158d3a67-86f6-45e0-a1a8-ba82b98298eb/99045bfd32d5b58edb9db0cfa46fe19a/dotnet-sdk-3.1.420-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b0cd1e2f-13da-4573-803b-68b31618d35b/7b485cb16a59e6f2ddab0d45821ca43a/dotnet-sdk-3.1.420-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8c820993-e5cd-4b0a-81ff-43c74222a11b/e181b62887f08be3560a4cc6c842c725/dotnet-sdk-3.1.420-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8286a41b-c787-4912-a5c9-50c40eba07d0/a48056f55cb8efb2eaf2fd2e5dd5f8c6/dotnet-sdk-3.1.420-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/58ff2760-cec9-4f3e-abfd-f5f47d04a99c/486ea04c54d1c64c2f95410a5a2eddef/dotnet-sdk-3.1.420-win-x86.zip
