# .NET Core 3.1.28 - August 9, 2022

.NET Core 3.1.28 and .NET Core SDK 3.1.422 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.422
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.9 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.9 | [3.1.422](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |


## Notable Changes
.NET Core 3.1.28 release carries security and non-security fixes.

# Microsoft Security Advisory CVE-2022-34716 | .NET Information Disclosure Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

An information disclosure vulnerability exists in .NET 6.0 and .NET Core 3.1 that could lead to unauthorized access of privileged information.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7682](https://github.com/dotnet/core/issues/7682) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.28.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.28-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.28-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/august-2022-updates/

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.NETCore.App.Host.linux-musl-arm64| 3.1.28
Microsoft.NETCore.App.Host.linux-x64| 3.1.28
Microsoft.NETCore.App.Host.osx-x64| 3.1.28
Microsoft.NETCore.App.Host.win-arm64| 3.1.28
Microsoft.NETCore.App.Runtime.win-x64| 3.1.28
Microsoft.WindowsDesktop.App.Runtime.win-x86| 3.1.28
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.28
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.28
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.28
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.28
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.28
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.28
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 3.1.28
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 3.1.28
Microsoft.NETCore.App.Host.linux-arm| 3.1.28
Microsoft.NETCore.App.Runtime.linux-arm| 3.1.28
Microsoft.NETCore.App.Host.win-x86| 3.1.28
Microsoft.NETCore.App.Runtime.win-arm| 3.1.28
Microsoft.WindowsDesktop.App.Runtime.win-x64| 3.1.28
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 3.1.28
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 3.1.28
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 3.1.28
runtime.win-arm.Microsoft.NETCore.DotNetHost| 3.1.28
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.28
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 3.1.28
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 3.1.28
Microsoft.NETCore.App.Host.linux-arm64| 3.1.28
Microsoft.NETCore.App.Host.linux-musl-x64| 3.1.28
Microsoft.NETCore.App.Host.win-arm| 3.1.28
Microsoft.NETCore.App.Host.win-x64| 3.1.28
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 3.1.28
Microsoft.NETCore.App.Runtime.win-x86| 3.1.28
Microsoft.NETCore.DotNetAppHost| 3.1.28
Microsoft.NETCore.DotNetHostPolicy| 3.1.28
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.28
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.28
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 3.1.28
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.28
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 3.1.28
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.28
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.28
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 3.1.28
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 3.1.28
runtime.win-x86.Microsoft.NETCore.DotNetHost| 3.1.28
Microsoft.NETCore.App.Runtime.linux-musl-x64| 3.1.28
Microsoft.NETCore.App.Runtime.osx-x64| 3.1.28
Microsoft.NETCore.DotNetHost| 3.1.28
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 3.1.28
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 3.1.28
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.28
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.28
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.28
Microsoft.NETCore.App.Runtime.linux-arm64| 3.1.28
Microsoft.NETCore.App.Runtime.linux-x64| 3.1.28
Microsoft.NETCore.App.Runtime.win-arm64| 3.1.28
Microsoft.NETCore.DotNetHostResolver| 3.1.28
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 3.1.28
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.28
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.28
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 3.1.28
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.28
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 3.1.28
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.28
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.28
runtime.win-x64.Microsoft.NETCore.DotNetHost| 3.1.28
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.28
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 3.1.28
Microsoft.AspNetCore.App.Runtime.win-arm64| 3.1.28
AspNetCoreRuntime.3.1.x86| 3.1.28
Microsoft.AspNetCore.Authentication.AzureAD.UI| 3.1.28
Microsoft.AspNetCore.DataProtection.Abstractions| 3.1.28
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 3.1.28
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 3.1.28
Microsoft.AspNetCore.Components.Forms| 3.1.28
Microsoft.AspNetCore.Cryptography.KeyDerivation| 3.1.28
Microsoft.AspNetCore.Http.Connections.Client| 3.1.28
Microsoft.AspNetCore.Identity.UI| 3.1.28
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 3.1.28
Microsoft.AspNetCore.TestHost| 3.1.28
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1| 3.1.28
Microsoft.Extensions.ApiDescription.Server| 3.1.28
Microsoft.Extensions.Identity.Stores| 3.1.28
Microsoft.AspNetCore.Hosting.WindowsServices| 3.1.28
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 3.1.28
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 3.1.28
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 3.1.28
Microsoft.Extensions.ApiDescription.Client| 3.1.28
Microsoft.AspNetCore.App.Runtime.win-arm| 3.1.28
Microsoft.AspNetCore.Components| 3.1.28
Microsoft.AspNetCore.Components.Web| 3.1.28
Microsoft.AspNetCore.Connections.Abstractions| 3.1.28
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 3.1.28
Microsoft.AspNetCore.Http.Features| 3.1.28
Microsoft.AspNetCore.MiddlewareAnalysis| 3.1.28
Microsoft.AspNetCore.SignalR.Client| 3.1.28
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 3.1.28
Microsoft.AspNetCore.SpaServices.Extensions| 3.1.28
Microsoft.DotNet.Web.Client.ItemTemplates| 3.1.28
Microsoft.DotNet.Web.ItemTemplates| 3.1.28
Microsoft.AspNetCore.App.Runtime.linux-arm64| 3.1.28
AspNetCoreRuntime.3.1.x64| 3.1.28
Microsoft.AspNetCore.AzureAppServicesIntegration| 3.1.28
Microsoft.AspNetCore.NodeServices| 3.1.28
Microsoft.AspNetCore.SignalR.Common| 3.1.28
Microsoft.AspNetCore.SpaServices| 3.1.28
Microsoft.dotnet-openapi| 3.1.28
Microsoft.Extensions.Identity.Core| 3.1.28
Microsoft.AspNetCore.Authentication.Facebook| 3.1.28
Microsoft.AspNetCore.Authentication.JwtBearer| 3.1.28
Microsoft.AspNetCore.Authentication.Negotiate| 3.1.28
Microsoft.AspNetCore.Authorization| 3.1.28
Microsoft.AspNetCore.Cryptography.Internal| 3.1.28
Microsoft.AspNetCore.JsonPatch| 3.1.28
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 3.1.28
Microsoft.AspNetCore.Mvc.Testing| 3.1.28
Microsoft.AspNetCore.App.Runtime.linux-arm| 3.1.28
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 3.1.28
Microsoft.AspNetCore.App.Runtime.linux-x64| 3.1.28
Microsoft.AspNetCore.App.Runtime.osx-x64| 3.1.28
Microsoft.AspNetCore.App.Runtime.win-x86| 3.1.28
Microsoft.AspNetCore.Authentication.OpenIdConnect| 3.1.28
Microsoft.AspNetCore.Authentication.Twitter| 3.1.28
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 3.1.28
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 3.1.28
Microsoft.AspNetCore.Authentication.Google| 3.1.28
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 3.1.28
Microsoft.AspNetCore.Authentication.WsFederation| 3.1.28
Microsoft.AspNetCore.Components.Authorization| 3.1.28
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 3.1.28
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 3.1.28
Microsoft.AspNetCore.Identity.Specification.Tests| 3.1.28
Microsoft.AspNetCore.Owin| 3.1.28
Microsoft.AspNetCore.SignalR.Client.Core| 3.1.28
Microsoft.AspNetCore.SignalR.Specification.Tests| 3.1.28
Microsoft.AspNetCore.App.Runtime.win-x64| 3.1.28
dotnet-sql-cache| 3.1.28
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 3.1.28
Microsoft.AspNetCore.Authentication.Certificate| 3.1.28
Microsoft.AspNetCore.Components.Analyzers| 3.1.28
Microsoft.AspNetCore.ConcurrencyLimiter| 3.1.28
Microsoft.AspNetCore.DataProtection| 3.1.28
Microsoft.AspNetCore.DataProtection.Extensions| 3.1.28
Microsoft.AspNetCore.HeaderPropagation| 3.1.28
Microsoft.AspNetCore.Http.Connections.Common| 3.1.28
Microsoft.AspNetCore.Metadata| 3.1.28
Microsoft.AspNetCore.SignalR.Protocols.Json| 3.1.28
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 3.1.28
Microsoft.DotNet.Web.ProjectTemplates.3.1| 3.1.28
Microsoft.DotNet.Common.ProjectTemplates.1.x| 3.1.28
Microsoft.DotNet.Common.ProjectTemplates.3.1| 3.1.28
Microsoft.DotNet.Common.ItemTemplates| 3.1.28
Microsoft.DotNet.Common.ProjectTemplates.2.1| 3.1.28
Microsoft.DotNet.Common.ProjectTemplates.3.0| 3.1.28
Microsoft.DotNet.Common.ProjectTemplates.2.0| 3.1.28
Microsoft.DotNet.Common.ProjectTemplates.2.2| 3.1.28
System.Security.Cryptography.Xml| 4.7.1
Microsoft.AspNetCore.Mvc.Razor.Extensions| 3.1.28
Microsoft.NET.Sdk.Razor| 3.1.28
Microsoft.CodeAnalysis.Razor| 3.1.28
Microsoft.AspNetCore.Razor.Language| 3.1.28
Microsoft.EntityFrameworkCore.SqlServer| 3.1.28
Microsoft.Data.Sqlite.Core| 3.1.28
Microsoft.EntityFrameworkCore.InMemory| 3.1.28
Microsoft.EntityFrameworkCore.Proxies| 3.1.28
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 3.1.28
Microsoft.EntityFrameworkCore.Abstractions| 3.1.28
Microsoft.EntityFrameworkCore.Specification.Tests| 3.1.28
Microsoft.EntityFrameworkCore.Sqlite| 3.1.28
Microsoft.EntityFrameworkCore| 3.1.28
Microsoft.EntityFrameworkCore.Design| 3.1.28
Microsoft.EntityFrameworkCore.Sqlite.Core| 3.1.28
Microsoft.EntityFrameworkCore.Tools| 3.1.28
dotnet-ef| 3.1.28
Microsoft.EntityFrameworkCore.Cosmos| 3.1.28
Microsoft.EntityFrameworkCore.Relational| 3.1.28
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 3.1.28
Microsoft.Data.Sqlite| 3.1.28
Microsoft.EntityFrameworkCore.Analyzers| 3.1.28
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 3.1.28
Microsoft.Extensions.Configuration| 3.1.28
Microsoft.Extensions.Configuration.FileExtensions| 3.1.28
Microsoft.Extensions.Configuration.Json| 3.1.28
Microsoft.Extensions.Diagnostics.HealthChecks| 3.1.28
Microsoft.Extensions.Configuration.Ini| 3.1.28
Microsoft.Extensions.Configuration.NewtonsoftJson| 3.1.28
Microsoft.Extensions.FileProviders.Embedded| 3.1.28
Microsoft.Extensions.FileSystemGlobbing| 3.1.28
Microsoft.Extensions.Configuration.CommandLine| 3.1.28
Microsoft.Extensions.FileProviders.Physical| 3.1.28
Microsoft.Extensions.Hosting| 3.1.28
Microsoft.Extensions.Http| 3.1.28
Microsoft.Extensions.Logging.AzureAppServices| 3.1.28
Microsoft.Extensions.Options| 3.1.28
Microsoft.Extensions.Caching.SqlServer| 3.1.28
Microsoft.Extensions.DependencyInjection| 3.1.28
Microsoft.Extensions.DependencyInjection.Abstractions| 3.1.28
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 3.1.28
Microsoft.Extensions.Http.Polly| 3.1.28
Microsoft.Extensions.Localization| 3.1.28
Microsoft.Extensions.Logging.EventSource| 3.1.28
Microsoft.Extensions.Primitives| 3.1.28
Microsoft.Extensions.Logging| 3.1.28
Microsoft.Extensions.ObjectPool| 3.1.28
Microsoft.JSInterop| 3.1.28
Microsoft.Extensions.Caching.StackExchangeRedis| 3.1.28
Microsoft.Extensions.Hosting.Abstractions| 3.1.28
Microsoft.Extensions.Logging.Console| 3.1.28
Microsoft.Extensions.Logging.EventLog| 3.1.28
Microsoft.Extensions.Caching.Memory| 3.1.28
Microsoft.Extensions.Configuration.EnvironmentVariables| 3.1.28
Microsoft.Extensions.Configuration.KeyPerFile| 3.1.28
Microsoft.Extensions.Configuration.Xml| 3.1.28
Microsoft.Extensions.DiagnosticAdapter| 3.1.28
Microsoft.Extensions.FileProviders.Composite| 3.1.28
Microsoft.Extensions.Hosting.WindowsServices| 3.1.28
Microsoft.Extensions.Localization.Abstractions| 3.1.28
Microsoft.Extensions.Logging.Debug| 3.1.28
Microsoft.Extensions.Logging.TraceSource| 3.1.28
Microsoft.Extensions.Options.DataAnnotations| 3.1.28
Microsoft.Extensions.Caching.Abstractions| 3.1.28
Microsoft.Extensions.Configuration.Abstractions| 3.1.28
Microsoft.Extensions.Configuration.Binder| 3.1.28
Microsoft.Extensions.Configuration.UserSecrets| 3.1.28
Microsoft.Extensions.DependencyInjection.Specification.Tests| 3.1.28
Microsoft.Extensions.FileProviders.Abstractions| 3.1.28
Microsoft.Extensions.Hosting.Systemd| 3.1.28
Microsoft.Extensions.Logging.Abstractions| 3.1.28
Microsoft.Extensions.Logging.Configuration| 3.1.28
Microsoft.Extensions.Options.ConfigurationExtensions| 3.1.28
Microsoft.Extensions.WebEncoders| 3.1.28

[//]: # ( Runtime 3.1.28)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/70405685-0adb-4e7e-92a3-da9f22041538/cc88879e8aa05ac1d8c555142fd83ae7/dotnet-runtime-3.1.28-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d71449b4-4504-410b-a805-48b3a6af5182/06abb8b35645e76dbe8cc4d17fdcbf89/dotnet-runtime-3.1.28-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1ce32b24-5879-428f-b678-2c19c68c520b/668e8cb120eefdcf5d99acee3aec78fe/dotnet-runtime-3.1.28-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6db0e343-d3d2-4380-b5ef-e715bd8b2fb1/9c84383ce1453118d819721fb6d6b17e/dotnet-runtime-3.1.28-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9a0b8ff8-d3da-4e77-9b5b-2fb3202afbbe/94dbcaacd4ebf59106a141c8e9e84167/dotnet-runtime-3.1.28-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c70ad1ab-8041-48dc-880f-b7a5f2d44f1e/4bbd20781e643916b8bcf6a422237e28/dotnet-runtime-3.1.28-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ff22de78-4644-4395-a187-3910c27222d6/95c5a5334aa3c861238518a66696efa2/dotnet-runtime-3.1.28-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/f9e65be4-18f7-48da-8950-a2667e562046/2cd5e0ff0e939c7c4880ae53b1b5c284/dotnet-runtime-3.1.28-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/83149576-180d-49ab-be17-83110eb2379b/9dfe3f504f0bd38d2d8d4bd1c544f6ce/dotnet-runtime-3.1.28-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/721259f9-2e4c-413e-be54-3b8eecbb9cd5/021d978c4be389e07cbdcaeb80ab6c64/dotnet-runtime-3.1.28-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/31628805-a966-4391-8982-8c1434daf966/74ae6a781e7c7b1fbc28645791e988b1/dotnet-runtime-3.1.28-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/fe5385c8-4eb8-4ad1-b79e-07e6fa2f0b0e/1cb1e3983999d00ef8e90c7a328599cd/dotnet-runtime-3.1.28-win-x86.zip

[//]: # ( WindowsDesktop 3.1.28)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5c74593e-f156-44c8-9957-f11996de72bc/d3e0e26c64a5a2d860c5c0deca975d78/windowsdesktop-runtime-3.1.28-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d2ec7ca2-017d-4d06-a6da-3707daa3c3b1/1f2e108653e3d8316e1657105ef24b93/windowsdesktop-runtime-3.1.28-win-x86.exe

[//]: # ( ASP 3.1.28)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9bb6a9e7-2d61-4eea-ba71-a45bd59d6b58/cdff91baabbbdde94852fea2d1ff3b3b/aspnetcore-runtime-3.1.28-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/75b4f8b5-8aeb-4ba1-956d-bfc17ba5d6b3/bb3744801157ebc769808a92eabeee5c/aspnetcore-runtime-3.1.28-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e1b40437-08dc-446c-800c-fd287d0fda66/9f3bc472356417f3a341e8034197b722/aspnetcore-runtime-3.1.28-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b0e6dd66-02f4-497d-b2d8-ccf0726d4c22/517de52ae05d7829e9be58b6b0308472/aspnetcore-runtime-3.1.28-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/effaa5bf-0fa7-4e5a-9ce8-9ac04ee86669/5afb2b1c2ad68550cec914d8fb303d20/aspnetcore-runtime-3.1.28-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9ad2468-f18b-4d35-9b9d-f2bccc681bdc/b3100ca07ee0e8dc4ef958921d4adbfa/aspnetcore-runtime-3.1.28-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/8730fed0-a01c-4736-bc37-93997e3cdf32/2722ceaa4a2b4e9b7618b15b104b221d/aspnetcore-runtime-3.1.28-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/85d0ae35-c88e-400d-94ce-d79398ae6193/a5a4a60340087f27a609f302218d144c/aspnetcore-runtime-3.1.28-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f84e3cc7-b062-40ad-b9b7-d6e0309dbe05/094dd898c861ffaa926137946b799b5b/aspnetcore-runtime-3.1.28-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b2e74c89-a241-4f3f-b908-f20a56dd79f2/5e97b30708c856f71ab763c159b671a4/aspnetcore-runtime-3.1.28-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c785a65d-a997-46e8-9196-761fe227f1e5/0abd96045ca30395b3eb39168eeed98f/aspnetcore-runtime-3.1.28-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/6deb2f82-9fe4-4453-a30a-ef4b780ad3d6/9f90355e0576949a5d605aae01376f65/dotnet-hosting-3.1.28-win.exe

[//]: # ( SDK 3.1.422)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e5ec7845-008a-4b7d-a247-c314f2407b8d/9117e05fa19f0217a030666df6b6eb9d/dotnet-sdk-3.1.422-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fdf76122-e9d5-4f66-b96f-4dd0c64e5bea/d756ca70357442de960db145f9b4234d/dotnet-sdk-3.1.422-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7457ed8-e07e-4f71-978f-74ea53aaa5f9/a1130e139ddc995f0c955fc85ed14399/dotnet-sdk-3.1.422-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4fd83694-c9ad-487f-bf26-ef80f3cbfd9e/6ca93b498019311e6f7732717c350811/dotnet-sdk-3.1.422-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c4b07ed0-d02c-42c8-b82c-c05d45083000/069d2956ca5e71b670cf801ebc789716/dotnet-sdk-3.1.422-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f0d8ea7f-2a12-46ee-9808-c018aa78e8b6/2757f0e395ac71eb09453c52fd8e1841/dotnet-sdk-3.1.422-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/515fcb39-1e67-4cf5-908e-0e00f3cd76b2/6478e6b98726db240cb6b572f9eab97e/dotnet-sdk-3.1.422-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/82a875b5-760f-4910-babd-8ece54f5f383/5fbc5f051209b88b5dfba2ad2298b8bf/dotnet-sdk-3.1.422-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6414fa6d-dc70-4e1a-ba00-c08bc18a1a2a/0223996d225593798019681f0a1e5946/dotnet-sdk-3.1.422-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/629565ad-0b61-41aa-9c4b-78f856890a2d/4ed9571f53049d57ea3f58b813264a1e/dotnet-sdk-3.1.422-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/19629d8e-df1c-4e84-862b-bb9e41672731/c8b1cf3ae7d9f2651068bc1cdb72c754/dotnet-sdk-3.1.422-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/14c07735-f781-4589-a2c8-33952e6bbd95/8cba09869cb4a10a19a48333efa7902f/dotnet-sdk-3.1.422-win-x86.zip
