# .NET Core 3.1.29 - September 13, 2022

.NET Core 3.1.29 and .NET Core SDK 3.1.423 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.423
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.9 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.9 | [3.1.423](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |


## Notable Changes
.NET Core 3.1.29 release carries security and non-security fixes.

# Microsoft Security Advisory CVE-2022-38013 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists in ASP.NET Core 3.1 and .NET 6.0 where a malicious client could cause a stack overflow which may result in a denial of service attack when an attacker sends a customized payload that is parsed during model binding.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7791](https://github.com/dotnet/core/issues/7791) for your questions and comments.



[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.29.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.29-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.29-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/september-2022-updates/

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.NETCore.App.Host.linux-arm| 3.1.29
Microsoft.NETCore.App.Host.linux-arm64| 3.1.29
Microsoft.NETCore.App.Host.linux-musl-arm64| 3.1.29
Microsoft.NETCore.App.Host.linux-musl-x64| 3.1.29
Microsoft.NETCore.App.Host.linux-x64| 3.1.29
Microsoft.NETCore.App.Host.osx-x64| 3.1.29
Microsoft.NETCore.App.Host.win-arm| 3.1.29
Microsoft.NETCore.App.Host.win-arm64| 3.1.29
Microsoft.NETCore.App.Host.win-x64| 3.1.29
Microsoft.NETCore.App.Host.win-x86| 3.1.29
Microsoft.NETCore.App.Runtime.linux-arm| 3.1.29
Microsoft.NETCore.App.Runtime.linux-arm64| 3.1.29
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 3.1.29
Microsoft.NETCore.App.Runtime.linux-musl-x64| 3.1.29
Microsoft.NETCore.App.Runtime.linux-x64| 3.1.29
Microsoft.NETCore.App.Runtime.osx-x64| 3.1.29
Microsoft.NETCore.App.Runtime.win-arm| 3.1.29
Microsoft.NETCore.App.Runtime.win-arm64| 3.1.29
Microsoft.NETCore.App.Runtime.win-x64| 3.1.29
Microsoft.NETCore.App.Runtime.win-x86| 3.1.29
Microsoft.NETCore.DotNetAppHost| 3.1.29
Microsoft.NETCore.DotNetHost| 3.1.29
Microsoft.NETCore.DotNetHostPolicy| 3.1.29
Microsoft.NETCore.DotNetHostResolver| 3.1.29
Microsoft.WindowsDesktop.App.Runtime.win-x64| 3.1.29
Microsoft.WindowsDesktop.App.Runtime.win-x86| 3.1.29
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 3.1.29
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 3.1.29
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.29
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.29
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.29
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 3.1.29
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.29
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.29
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.29
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 3.1.29
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.29
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.29
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 3.1.29
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 3.1.29
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.29
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.29
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 3.1.29
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 3.1.29
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.29
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.29
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 3.1.29
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 3.1.29
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.29
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.29
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 3.1.29
runtime.win-arm.Microsoft.NETCore.DotNetHost| 3.1.29
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.29
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.29
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.29
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 3.1.29
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.29
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.29
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 3.1.29
runtime.win-x64.Microsoft.NETCore.DotNetHost| 3.1.29
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.29
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.29
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 3.1.29
runtime.win-x86.Microsoft.NETCore.DotNetHost| 3.1.29
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 3.1.29
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 3.1.29
Microsoft.AspNetCore.App.Runtime.linux-arm| 3.1.29
Microsoft.AspNetCore.App.Runtime.linux-arm64| 3.1.29
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 3.1.29
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 3.1.29
Microsoft.AspNetCore.App.Runtime.linux-x64| 3.1.29
Microsoft.AspNetCore.App.Runtime.osx-x64| 3.1.29
Microsoft.AspNetCore.App.Runtime.win-arm| 3.1.29
Microsoft.AspNetCore.App.Runtime.win-arm64| 3.1.29
AspNetCoreRuntime.3.1.x64| 3.1.29
AspNetCoreRuntime.3.1.x86| 3.1.29
dotnet-sql-cache| 3.1.29
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 3.1.29
Microsoft.AspNetCore.App.Runtime.win-x64| 3.1.29
Microsoft.AspNetCore.App.Runtime.win-x86| 3.1.29
Microsoft.AspNetCore.Authentication.AzureAD.UI| 3.1.29
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 3.1.29
Microsoft.AspNetCore.Authentication.Certificate| 3.1.29
Microsoft.AspNetCore.Authentication.Facebook| 3.1.29
Microsoft.AspNetCore.Authentication.Google| 3.1.29
Microsoft.AspNetCore.Authentication.JwtBearer| 3.1.29
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 3.1.29
Microsoft.AspNetCore.Authentication.Negotiate| 3.1.29
Microsoft.AspNetCore.Authentication.OpenIdConnect| 3.1.29
Microsoft.AspNetCore.Authentication.Twitter| 3.1.29
Microsoft.AspNetCore.Authentication.WsFederation| 3.1.29
Microsoft.AspNetCore.Authorization| 3.1.29
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 3.1.29
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 3.1.29
Microsoft.AspNetCore.AzureAppServicesIntegration| 3.1.29
Microsoft.AspNetCore.Components| 3.1.29
Microsoft.AspNetCore.Components.Analyzers| 3.1.29
Microsoft.AspNetCore.Components.Authorization| 3.1.29
Microsoft.AspNetCore.Components.Forms| 3.1.29
Microsoft.AspNetCore.Components.Web| 3.1.29
Microsoft.AspNetCore.ConcurrencyLimiter| 3.1.29
Microsoft.AspNetCore.Connections.Abstractions| 3.1.29
Microsoft.AspNetCore.Cryptography.Internal| 3.1.29
Microsoft.AspNetCore.Cryptography.KeyDerivation| 3.1.29
Microsoft.AspNetCore.DataProtection| 3.1.29
Microsoft.AspNetCore.DataProtection.Abstractions| 3.1.29
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 3.1.29
Microsoft.AspNetCore.DataProtection.Extensions| 3.1.29
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 3.1.29
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 3.1.29
Microsoft.AspNetCore.HeaderPropagation| 3.1.29
Microsoft.AspNetCore.Hosting.WindowsServices| 3.1.29
Microsoft.AspNetCore.Http.Connections.Client| 3.1.29
Microsoft.AspNetCore.Http.Connections.Common| 3.1.29
Microsoft.AspNetCore.Http.Features| 3.1.29
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 3.1.29
Microsoft.AspNetCore.Identity.Specification.Tests| 3.1.29
Microsoft.AspNetCore.Identity.UI| 3.1.29
Microsoft.AspNetCore.JsonPatch| 3.1.29
Microsoft.AspNetCore.Metadata| 3.1.29
Microsoft.AspNetCore.MiddlewareAnalysis| 3.1.29
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 3.1.29
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 3.1.29
Microsoft.AspNetCore.Mvc.Testing| 3.1.29
Microsoft.AspNetCore.NodeServices| 3.1.29
Microsoft.AspNetCore.Owin| 3.1.29
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 3.1.29
Microsoft.AspNetCore.SignalR.Client| 3.1.29
Microsoft.AspNetCore.SignalR.Client.Core| 3.1.29
Microsoft.AspNetCore.SignalR.Common| 3.1.29
Microsoft.AspNetCore.SignalR.Protocols.Json| 3.1.29
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 3.1.29
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 3.1.29
Microsoft.AspNetCore.SignalR.Specification.Tests| 3.1.29
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 3.1.29
Microsoft.AspNetCore.SpaServices| 3.1.29
Microsoft.AspNetCore.SpaServices.Extensions| 3.1.29
Microsoft.AspNetCore.TestHost| 3.1.29
Microsoft.dotnet-openapi| 3.1.29
Microsoft.DotNet.Web.Client.ItemTemplates| 3.1.29
Microsoft.DotNet.Web.ItemTemplates| 3.1.29
Microsoft.DotNet.Web.ProjectTemplates.3.1| 3.1.29
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1| 3.1.29
Microsoft.Extensions.ApiDescription.Client| 3.1.29
Microsoft.Extensions.ApiDescription.Server| 3.1.29
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 3.1.29
Microsoft.Extensions.Identity.Core| 3.1.29
Microsoft.Extensions.Identity.Stores| 3.1.29
Microsoft.DotNet.Common.ItemTemplates| 3.1.29
Microsoft.DotNet.Common.ProjectTemplates.1.x| 3.1.29
Microsoft.DotNet.Common.ProjectTemplates.2.0| 3.1.29
Microsoft.DotNet.Common.ProjectTemplates.2.1| 3.1.29
Microsoft.DotNet.Common.ProjectTemplates.2.2| 3.1.29
Microsoft.DotNet.Common.ProjectTemplates.3.0| 3.1.29
Microsoft.DotNet.Common.ProjectTemplates.3.1| 3.1.29
Microsoft.AspNetCore.Mvc.Razor.Extensions| 3.1.29
nMicrosoft.AspNetCore.Razor.Language| 3.1.29
Microsoft.CodeAnalysis.Razor| 3.1.29
Microsoft.NET.Sdk.Razor| 3.1.29
dotnet-ef| 3.1.29
Microsoft.Data.Sqlite| 3.1.29
Microsoft.Data.Sqlite.Core| 3.1.29
Microsoft.EntityFrameworkCore| 3.1.29
Microsoft.EntityFrameworkCore.Abstractions| 3.1.29
Microsoft.EntityFrameworkCore.Analyzers| 3.1.29
Microsoft.EntityFrameworkCore.Cosmos| 3.1.29
Microsoft.EntityFrameworkCore.Design| 3.1.29
Microsoft.EntityFrameworkCore.InMemory| 3.1.29
Microsoft.EntityFrameworkCore.Proxies| 3.1.29
Microsoft.EntityFrameworkCore.Relational| 3.1.29
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 3.1.29
Microsoft.EntityFrameworkCore.Specification.Tests| 3.1.29
Microsoft.EntityFrameworkCore.Sqlite| 3.1.29
Microsoft.EntityFrameworkCore.Sqlite.Core| 3.1.29
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 3.1.29
Microsoft.EntityFrameworkCore.SqlServer| 3.1.29
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 3.1.29
Microsoft.EntityFrameworkCore.Tools| 3.1.29
Microsoft.Extensions.Caching.Abstractions| 3.1.29
Microsoft.Extensions.Caching.Memory| 3.1.29
Microsoft.Extensions.Caching.SqlServer| 3.1.29
Microsoft.Extensions.Caching.StackExchangeRedis| 3.1.29
Microsoft.Extensions.Configuration| 3.1.29
Microsoft.Extensions.Configuration.Abstractions| 3.1.29
Microsoft.Extensions.Configuration.Binder| 3.1.29
Microsoft.Extensions.Configuration.CommandLine| 3.1.29
Microsoft.Extensions.Configuration.EnvironmentVariables| 3.1.29
Microsoft.Extensions.Configuration.FileExtensions| 3.1.29
Microsoft.Extensions.Configuration.Ini| 3.1.29
Microsoft.Extensions.Configuration.Json| 3.1.29
Microsoft.Extensions.Configuration.KeyPerFile| 3.1.29
Microsoft.Extensions.Configuration.NewtonsoftJson| 3.1.29
Microsoft.Extensions.Configuration.UserSecrets| 3.1.29
Microsoft.Extensions.Configuration.Xml| 3.1.29
Microsoft.Extensions.DependencyInjection| 3.1.29
Microsoft.Extensions.DependencyInjection.Abstractions| 3.1.29
Microsoft.Extensions.DependencyInjection.Specification.Tests| 3.1.29
Microsoft.Extensions.DiagnosticAdapter| 3.1.29
Microsoft.Extensions.Diagnostics.HealthChecks| 3.1.29
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 3.1.29
Microsoft.Extensions.FileProviders.Abstractions| 3.1.29
Microsoft.Extensions.FileProviders.Composite| 3.1.29
Microsoft.Extensions.FileProviders.Embedded| 3.1.29
Microsoft.Extensions.FileProviders.Physical| 3.1.29
Microsoft.Extensions.FileSystemGlobbing| 3.1.29
Microsoft.Extensions.Hosting| 3.1.29
Microsoft.Extensions.Hosting.Abstractions| 3.1.29
Microsoft.Extensions.Hosting.Systemd| 3.1.29
Microsoft.Extensions.Hosting.WindowsServices| 3.1.29
Microsoft.Extensions.Http| 3.1.29
Microsoft.Extensions.Http.Polly| 3.1.29
Microsoft.Extensions.Localization| 3.1.29
Microsoft.Extensions.Localization.Abstractions| 3.1.29
Microsoft.Extensions.Logging| 3.1.29
Microsoft.Extensions.Logging.Abstractions| 3.1.29
Microsoft.Extensions.Logging.AzureAppServices| 3.1.29
Microsoft.Extensions.Logging.Configuration| 3.1.29
Microsoft.Extensions.Logging.Console| 3.1.29
Microsoft.Extensions.Logging.Debug| 3.1.29
Microsoft.Extensions.Logging.EventLog| 3.1.29
Microsoft.Extensions.Logging.EventSource| 3.1.29
Microsoft.Extensions.Logging.TraceSource| 3.1.29
Microsoft.Extensions.ObjectPool| 3.1.29
Microsoft.Extensions.Options| 3.1.29
Microsoft.Extensions.Options.ConfigurationExtensions| 3.1.29
Microsoft.Extensions.Options.DataAnnotations| 3.1.29
Microsoft.Extensions.Primitives| 3.1.29
Microsoft.Extensions.WebEncoders| 3.1.29
Microsoft.JSInterop| 3.1.29


[//]: # ( Runtime 3.1.29)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95e6a096-b2bd-4eb8-8cb4-69ca86f8183e/3a9932b042bd575f831cff60be32ae04/dotnet-runtime-3.1.29-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d859c2b0-4af9-441f-8c13-35e119224624/357a1322f8612211c336c63f25553f46/dotnet-runtime-3.1.29-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58d0a866-2361-425b-8527-f4084d962ec1/b0bb712a75d5697674e711f12d281a28/dotnet-runtime-3.1.29-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/db825385-f42d-4c25-b397-64ade09a2235/e8ef771e27615b7da9d7f4495950af1d/dotnet-runtime-3.1.29-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a8cff44-0a23-413a-8643-2a0fa3b4da3c/c937fe6ed4d60efb1ef2929d983398cd/dotnet-runtime-3.1.29-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0d3052c2-3fc2-4494-a7de-4858032e8a02/60f4a0069c106242be443c6d054c1f3e/dotnet-runtime-3.1.29-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aaea7c1a-5c9d-44b3-8c9f-1968962010dc/0fc4b5693c319c46bf8911ec5c6e7a6a/dotnet-runtime-3.1.29-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/66871d2b-c469-40da-9f04-54692c4e7e9f/e5d175a71c22ffa8514b7fdbde12e1c4/dotnet-runtime-3.1.29-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6fd5d472-74ea-43f2-8d85-bf942b9faa2d/5f7e7161389843833675b884c20d4157/dotnet-runtime-3.1.29-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4d2c80ad-8cc4-4957-8fc3-33a093011039/836857fcd54cd753e3f6a10fb987c90c/dotnet-runtime-3.1.29-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bb2ff940-1763-457b-9b65-aef6b9226727/f48a275a098e530d1cd38d3cc7026840/dotnet-runtime-3.1.29-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/cb9c5846-4ae4-422f-a678-22401cbd4ca1/9cc147f03ef26e887c2ce1dd03662f1e/dotnet-runtime-3.1.29-win-x86.zip

[//]: # ( WindowsDesktop 3.1.29)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6a9318dd-fec5-4df3-84df-ffd917b382ea/d3391ca5a4e14a8a96e04bbfa5c4c2dc/windowsdesktop-runtime-3.1.29-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b5a2058e-d1a7-48f6-a615-353973a1f960/9a2efe2b3d299f1e276106da8cea1c1d/windowsdesktop-runtime-3.1.29-win-x86.exe

[//]: # ( ASP 3.1.29)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/56dad134-e304-4c43-8886-7eabfb28316f/ea431fb3e96044e8d8a9c06ef8c01bb4/aspnetcore-runtime-3.1.29-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/35d465aa-769b-4b28-aded-0043dae97ef6/685bea2c3c4c7e0071e93c6263299fb3/aspnetcore-runtime-3.1.29-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ca3c2dfe-0be1-4640-9cdd-08b933ed2d8a/bb7152169e7333cdbdb2b50ff7123230/aspnetcore-runtime-3.1.29-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7eef05a-73c2-4c01-b025-4a2bdd677f49/3e1182c754744a4308b13132b07f02bb/aspnetcore-runtime-3.1.29-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d35c543b-44be-46ab-abf0-de8af9c5b3cb/4a17a6aaabe3f2f0e49de31f2f809713/aspnetcore-runtime-3.1.29-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09fc8ad1-3cbe-495c-b34e-0db458c81668/271a1c1b56be2c36057fabf005d15f4e/aspnetcore-runtime-3.1.29-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/141ca3b6-7163-420b-aafc-c5ad60c29959/60aad0a556aa26e40f829406e0563f17/aspnetcore-runtime-3.1.29-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ad97751d-b5b0-4646-91db-74705aceac64/c89bcdeb4a10db4768fae62fec33fb42/aspnetcore-runtime-3.1.29-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1ffc4a80-1dfa-481f-87a0-2abbcd14cab3/680debd7440d2baf05ea06ebc0b9641e/aspnetcore-runtime-3.1.29-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a741db5a-4219-4d0e-8302-1531b0f2d241/4b16361c0a70fdf5f7ceacd08e034dae/aspnetcore-runtime-3.1.29-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/fc44840c-f820-4558-8410-3f9adcd3d1db/cafe0775482608d8b5380039b187f5e6/aspnetcore-runtime-3.1.29-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/d7924d3c-977f-4130-bcf3-5851881e90c4/9f8715d4e5824730da1d78ace9baeb9e/dotnet-hosting-3.1.29-win.exe

[//]: # ( SDK 3.1.423)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8f81b133-220b-4831-abe6-e8be161fd9a2/1af75b5e2ca89af2a31cf9981a976832/dotnet-sdk-3.1.423-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/11abab07-d7a2-46b0-9ab5-19d5db67212f/783196073ecbd9fd64378fec412affbe/dotnet-sdk-3.1.423-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8ebf1e17-c387-47c2-9f5d-88f5e6b3a0f2/3b4d89833b4e2990f4b5e1ef31cf50ae/dotnet-sdk-3.1.423-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e137cdac-0e15-46ec-bd60-14fe6ad50c41/30c102677cc4bd0f117cc026781ec5e8/dotnet-sdk-3.1.423-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7052bcb3-764a-4c76-9d5f-e55acc3f6f70/64ae3ba8baf4f683ec3ad4c480a4f7d4/dotnet-sdk-3.1.423-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/dd9e2eb6-adf9-4da5-a058-c69118fca0f9/392150c11bf427c05560690db0572193/dotnet-sdk-3.1.423-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68bf0fe2-c2e9-4a57-b6fc-fcee862d6a92/6d13392c3596710426f91c6b46c6ff40/dotnet-sdk-3.1.423-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/3472bec6-e0e0-47bb-91e6-278dfb8b540b/7938330ff4a52b8a75392bc0f129b86f/dotnet-sdk-3.1.423-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c6eac4d8-45f2-442d-a43d-79b30249cef8/35ffdb7ea4dc51f11705732a3a1d1d4c/dotnet-sdk-3.1.423-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c05b1416-c23b-4223-8925-9e07b2a1f9a8/3d919fad7f64ca91bcf8801152882b53/dotnet-sdk-3.1.423-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c6ea7fa7-8fb2-4430-84dd-a096476168ff/2d982333aaba7eb119c6cd51e7a9835a/dotnet-sdk-3.1.423-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/da1d1257-12d7-4d2c-a55f-458fa62e5762/713e0097759fa67d64cbab5f1631cf13/dotnet-sdk-3.1.423-win-x86.zip

