# .NET Core 3.1.30 - October 11, 2022

.NET Core 3.1.30 and .NET Core SDK 3.1.424 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.424
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.9 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.9 | [3.1.424](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |


## Notable Changes
.NET Core 3.1.30 release carries security and non-security fixes.

# Microsoft Security Advisory CVE-2022-41032 | .NET Elevation of Privilege Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET Core 3.1, and NuGet (NuGet.exe, NuGet.Commands, NuGet.CommandLine, NuGet.Protocol). This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0, .NET Core 3.1, and NuGet clients (NuGet.exe, NuGet.Commands, NuGet.CommandLine, NuGet.Protocol) where a malicious actor could cause a user to execute arbitrary code.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7864](https://github.com/dotnet/core/issues/7864) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.30.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.30-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.30-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/october-2022-updates/

## Packages updated in this release

Package name | Version
:----------- | :------------------
Microsoft.NETCore.App.Host.linux-arm64| 3.1.30
Microsoft.NETCore.App.Runtime.linux-x64| 3.1.30
Microsoft.NETCore.App.Runtime.win-arm64| 3.1.30
Microsoft.WindowsDesktop.App.Runtime.win-x64| 3.1.30
Microsoft.NETCore.DotNetHostPolicy| 3.1.30
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 3.1.30
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 3.1.30
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.30
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.30
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 3.1.30
runtime.win-arm.Microsoft.NETCore.DotNetHost| 3.1.30
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.30
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.30
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.30
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.30
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.30
Microsoft.NETCore.App.Host.linux-arm| 3.1.30
Microsoft.NETCore.App.Host.linux-musl-x64| 3.1.30
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 3.1.30
Microsoft.NETCore.DotNetAppHost| 3.1.30
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 3.1.30
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.30
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.30
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 3.1.30
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 3.1.30
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.30
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 3.1.30
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.30
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 3.1.30
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 3.1.30
runtime.win-x86.Microsoft.NETCore.DotNetHost| 3.1.30
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 3.1.30
Microsoft.NETCore.App.Host.osx-x64| 3.1.30
Microsoft.NETCore.App.Host.win-arm64| 3.1.30
Microsoft.NETCore.App.Host.win-x64| 3.1.30
Microsoft.NETCore.App.Runtime.osx-x64| 3.1.30
Microsoft.NETCore.App.Runtime.win-x64| 3.1.30
Microsoft.NETCore.DotNetHostResolver| 3.1.30
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.30
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.30
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 3.1.30
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.30
runtime.win-x64.Microsoft.NETCore.DotNetHost| 3.1.30
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 3.1.30
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 3.1.30
Microsoft.NETCore.App.Runtime.linux-arm| 3.1.30
Microsoft.NETCore.App.Host.linux-x64| 3.1.30
Microsoft.NETCore.DotNetHost| 3.1.30
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.30
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.30
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.30
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.30
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 3.1.30
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 3.1.30
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.30
Microsoft.NETCore.App.Runtime.linux-arm64| 3.1.30
Microsoft.NETCore.App.Host.linux-musl-arm64| 3.1.30
Microsoft.NETCore.App.Host.win-arm| 3.1.30
Microsoft.NETCore.App.Host.win-x86| 3.1.30
Microsoft.NETCore.App.Runtime.linux-musl-x64| 3.1.30
Microsoft.NETCore.App.Runtime.win-arm| 3.1.30
Microsoft.NETCore.App.Runtime.win-x86| 3.1.30
Microsoft.WindowsDesktop.App.Runtime.win-x86| 3.1.30
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.30
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 3.1.30
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.30
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 3.1.30
Microsoft.AspNetCore.App.Runtime.win-arm64| 3.1.30
Microsoft.AspNetCore.App.Runtime.win-x86| 3.1.30
Microsoft.AspNetCore.Authentication.Certificate| 3.1.30
Microsoft.AspNetCore.Authentication.JwtBearer| 3.1.30
Microsoft.AspNetCore.Authentication.Negotiate| 3.1.30
Microsoft.AspNetCore.Authorization| 3.1.30
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 3.1.30
Microsoft.AspNetCore.Components.Analyzers| 3.1.30
Microsoft.AspNetCore.Connections.Abstractions| 3.1.30
Microsoft.AspNetCore.Cryptography.Internal| 3.1.30
Microsoft.AspNetCore.Http.Connections.Client| 3.1.30
Microsoft.AspNetCore.Http.Connections.Common| 3.1.30
Microsoft.AspNetCore.Http.Features| 3.1.30
Microsoft.AspNetCore.MiddlewareAnalysis| 3.1.30
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 3.1.30
Microsoft.AspNetCore.SignalR.Client| 3.1.30
Microsoft.AspNetCore.SignalR.Common| 3.1.30
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 3.1.30
Microsoft.AspNetCore.TestHost| 3.1.30
Microsoft.DotNet.Web.Client.ItemTemplates| 3.1.30
Microsoft.AspNetCore.App.Runtime.linux-arm64| 3.1.30
AspNetCoreRuntime.3.1.x64| 3.1.30
Microsoft.AspNetCore.Authentication.AzureAD.UI| 3.1.30
Microsoft.AspNetCore.Authentication.Facebook| 3.1.30
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 3.1.30
Microsoft.AspNetCore.Authentication.Twitter| 3.1.30
Microsoft.AspNetCore.Authentication.WsFederation| 3.1.30
Microsoft.AspNetCore.AzureAppServicesIntegration| 3.1.30
Microsoft.AspNetCore.ConcurrencyLimiter| 3.1.30
Microsoft.AspNetCore.Cryptography.KeyDerivation| 3.1.30
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 3.1.30
Microsoft.AspNetCore.HeaderPropagation| 3.1.30
Microsoft.AspNetCore.Identity.Specification.Tests| 3.1.30
Microsoft.AspNetCore.Metadata| 3.1.30
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 3.1.30
Microsoft.AspNetCore.NodeServices| 3.1.30
Microsoft.AspNetCore.SignalR.Protocols.Json| 3.1.30
Microsoft.AspNetCore.SignalR.Specification.Tests| 3.1.30
Microsoft.AspNetCore.SpaServices| 3.1.30
Microsoft.Extensions.Identity.Stores| 3.1.30
Microsoft.AspNetCore.App.Runtime.linux-arm| 3.1.30
Microsoft.AspNetCore.App.Runtime.osx-x64| 3.1.30
Microsoft.AspNetCore.App.Runtime.win-x64| 3.1.30
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 3.1.30
Microsoft.AspNetCore.Hosting.WindowsServices| 3.1.30
Microsoft.AspNetCore.SignalR.Client.Core| 3.1.30
Microsoft.DotNet.Web.ProjectTemplates.3.1| 3.1.30
Microsoft.dotnet-openapi| 3.1.30
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1| 3.1.30
Microsoft.Extensions.ApiDescription.Server| 3.1.30
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 3.1.30
Microsoft.Extensions.Identity.Core| 3.1.30
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 3.1.30
AspNetCoreRuntime.3.1.x86| 3.1.30
dotnet-sql-cache| 3.1.30
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 3.1.30
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 3.1.30
Microsoft.AspNetCore.Authentication.Google| 3.1.30
Microsoft.AspNetCore.Authentication.OpenIdConnect| 3.1.30
Microsoft.AspNetCore.Components.Authorization| 3.1.30
Microsoft.AspNetCore.Components.Forms| 3.1.30
Microsoft.AspNetCore.DataProtection| 3.1.30
Microsoft.AspNetCore.DataProtection.Extensions| 3.1.30
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 3.1.30
Microsoft.AspNetCore.Identity.UI| 3.1.30
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 3.1.30
Microsoft.AspNetCore.JsonPatch| 3.1.30
Microsoft.AspNetCore.Mvc.Testing| 3.1.30
Microsoft.AspNetCore.Owin| 3.1.30
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 3.1.30
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 3.1.30
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 3.1.30
Microsoft.Extensions.ApiDescription.Client| 3.1.30
Microsoft.AspNetCore.App.Runtime.linux-x64| 3.1.30
Microsoft.AspNetCore.App.Runtime.win-arm| 3.1.30
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 3.1.30
Microsoft.AspNetCore.Components| 3.1.30
Microsoft.AspNetCore.Components.Web| 3.1.30
Microsoft.AspNetCore.DataProtection.Abstractions| 3.1.30
Microsoft.AspNetCore.SpaServices.Extensions| 3.1.30
Microsoft.DotNet.Web.ItemTemplates| 3.1.30
Microsoft.DotNet.Common.ProjectTemplates.2.1| 3.1.30
Microsoft.DotNet.Common.ProjectTemplates.3.0| 3.1.30
Microsoft.DotNet.Common.ItemTemplates| 3.1.30
Microsoft.DotNet.Common.ProjectTemplates.1.x| 3.1.30
Microsoft.DotNet.Common.ProjectTemplates.2.2| 3.1.30
Microsoft.DotNet.Common.ProjectTemplates.2.0| 3.1.30
Microsoft.DotNet.Common.ProjectTemplates.3.1| 3.1.30
Microsoft.AspNetCore.Mvc.Razor.Extensions| 3.1.30
Microsoft.NET.Sdk.Razor| 3.1.30
Microsoft.AspNetCore.Razor.Language| 3.1.30
Microsoft.CodeAnalysis.Razor| 3.1.30
dotnet-ef| 3.1.30
Microsoft.EntityFrameworkCore.Cosmos| 3.1.30
Microsoft.EntityFrameworkCore.Specification.Tests| 3.1.30
Microsoft.EntityFrameworkCore.Sqlite.Core| 3.1.30
Microsoft.EntityFrameworkCore.SqlServer| 3.1.30
Microsoft.Data.Sqlite.Core| 3.1.30
Microsoft.EntityFrameworkCore.Analyzers| 3.1.30
Microsoft.EntityFrameworkCore.InMemory| 3.1.30
Microsoft.EntityFrameworkCore.Proxies| 3.1.30
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 3.1.30
Microsoft.EntityFrameworkCore| 3.1.30
Microsoft.Data.Sqlite| 3.1.30
Microsoft.EntityFrameworkCore.Relational| 3.1.30
Microsoft.EntityFrameworkCore.Tools| 3.1.30
Microsoft.EntityFrameworkCore.Abstractions| 3.1.30
Microsoft.EntityFrameworkCore.Design| 3.1.30
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 3.1.30
Microsoft.EntityFrameworkCore.Sqlite| 3.1.30
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 3.1.30
Microsoft.Extensions.Hosting| 3.1.30
Microsoft.Extensions.Hosting.Systemd| 3.1.30
Microsoft.Extensions.Logging.Configuration| 3.1.30
Microsoft.Extensions.Logging.EventLog| 3.1.30
Microsoft.Extensions.ObjectPool| 3.1.30
Microsoft.JSInterop| 3.1.30
Microsoft.Extensions.Caching.Abstractions| 3.1.30
Microsoft.Extensions.Caching.StackExchangeRedis| 3.1.30
Microsoft.Extensions.Configuration.CommandLine| 3.1.30
Microsoft.Extensions.Configuration.Ini| 3.1.30
Microsoft.Extensions.DependencyInjection.Abstractions| 3.1.30
Microsoft.Extensions.FileProviders.Composite| 3.1.30
Microsoft.Extensions.Http.Polly| 3.1.30
Microsoft.Extensions.Logging| 3.1.30
Microsoft.Extensions.Logging.AzureAppServices| 3.1.30
Microsoft.Extensions.Configuration.Abstractions| 3.1.30
Microsoft.Extensions.Configuration.Binder| 3.1.30
Microsoft.Extensions.Configuration.FileExtensions| 3.1.30
Microsoft.Extensions.Configuration.KeyPerFile| 3.1.30
Microsoft.Extensions.Configuration.Xml| 3.1.30
Microsoft.Extensions.DependencyInjection.Specification.Tests| 3.1.30
Microsoft.Extensions.Diagnostics.HealthChecks| 3.1.30
Microsoft.Extensions.FileProviders.Embedded| 3.1.30
Microsoft.Extensions.Hosting.WindowsServices| 3.1.30
Microsoft.Extensions.Logging.Abstractions| 3.1.30
Microsoft.Extensions.Logging.TraceSource| 3.1.30
Microsoft.Extensions.Options.ConfigurationExtensions| 3.1.30
Microsoft.Extensions.Primitives| 3.1.30
Microsoft.Extensions.WebEncoders| 3.1.30
Microsoft.Extensions.Caching.SqlServer| 3.1.30
Microsoft.Extensions.Configuration.EnvironmentVariables| 3.1.30
Microsoft.Extensions.Configuration.UserSecrets| 3.1.30
Microsoft.Extensions.DependencyInjection| 3.1.30
Microsoft.Extensions.DiagnosticAdapter| 3.1.30
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 3.1.30
Microsoft.Extensions.FileSystemGlobbing| 3.1.30
Microsoft.Extensions.Hosting.Abstractions| 3.1.30
Microsoft.Extensions.Http| 3.1.30
Microsoft.Extensions.Localization| 3.1.30
Microsoft.Extensions.Localization.Abstractions| 3.1.30
Microsoft.Extensions.Logging.Console| 3.1.30
Microsoft.Extensions.Logging.EventSource| 3.1.30
Microsoft.Extensions.Caching.Memory| 3.1.30
Microsoft.Extensions.Configuration| 3.1.30
Microsoft.Extensions.Configuration.Json| 3.1.30
Microsoft.Extensions.Configuration.NewtonsoftJson| 3.1.30
Microsoft.Extensions.FileProviders.Abstractions| 3.1.30
Microsoft.Extensions.FileProviders.Physical| 3.1.30
Microsoft.Extensions.Logging.Debug| 3.1.30
Microsoft.Extensions.Options| 3.1.30
Microsoft.Extensions.Options.DataAnnotations| 3.1.30


[//]: # ( Runtime 3.1.30)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/172aff79-d2e8-4215-9e18-1f4bf2b50fd1/7d06e75a61a7c8dbc87beb73c76e6921/dotnet-runtime-3.1.30-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5400dc4c-6b15-4cab-b8cd-7ed7ea6f87bf/a409c6dbf2c866217cfc1ef4c449e30b/dotnet-runtime-3.1.30-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/616b7954-610a-45a8-83cd-556ca6d3213f/673b4fdb8fc1898a31b3bca33be9d1c7/dotnet-runtime-3.1.30-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6821e7f2-70d8-4ca5-9694-b93702667455/a762ba04e874323af647bd0e3c16cb9f/dotnet-runtime-3.1.30-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9f6128a8-3962-4018-b9b0-9608b9aecec8/f46a672e0117d9128acdbc82cc314e20/dotnet-runtime-3.1.30-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5736812a-0652-452c-afd1-cd74984caf30/ac72b63bd6856c5c095cdf8189c33294/dotnet-runtime-3.1.30-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9e891fa6-2faf-42ef-8331-dbffe526de7f/7b4b639d7bd08587ce0d0a2b90b6196e/dotnet-runtime-3.1.30-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/d4c82170-cad2-4b7e-8a17-97aaabd617fd/4553dde6c5136c3ef152287ced70426a/dotnet-runtime-3.1.30-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c64ca8a4-3257-4395-b4ab-72ea51aeeb20/ce7a8b72d965f9f9bb95a94fc334bfdb/dotnet-runtime-3.1.30-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/736806da-ce3e-44ae-bc7a-e556894af4a9/819a5e95dd16eb9ba065fc658b9d48c7/dotnet-runtime-3.1.30-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7b4d4b46-bcba-4072-81ef-91020a5c2128/372cfd7f3b87d96999161aad8cd61469/dotnet-runtime-3.1.30-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8a9ed0f8-b628-48b9-8c50-53b556ea63e8/6d24ef6dd7e33c2b5f1eaffc535d949b/dotnet-runtime-3.1.30-win-x86.zip

[//]: # ( WindowsDesktop 3.1.30)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d8cdebe3-76ae-47a8-9461-e0b588f52fdd/58f4ac35bb7eff0192987ce902c9b051/windowsdesktop-runtime-3.1.30-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/81f9b887-49cf-43a1-83b7-3d6db15e8f3f/79f20278e76d07333b98524f69f62a9a/windowsdesktop-runtime-3.1.30-win-x86.exe

[//]: # ( ASP 3.1.30)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2cb5afcb-d69c-418a-9be9-661a87aeeed5/bbdf5386457ebac78b97294c74de694e/aspnetcore-runtime-3.1.30-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4e1115da-a8e7-41b3-a5e7-54d8d0bf516f/e81152a855fa9ba69fa59c741fb4ef77/aspnetcore-runtime-3.1.30-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd1289a2-6dda-4039-93df-221c394907df/09908748a59202860b910742b09a7923/aspnetcore-runtime-3.1.30-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/99fcecdf-ac60-4de8-9676-65233a4ae636/b355f80081b9208c22869c04f549a641/aspnetcore-runtime-3.1.30-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/12f61df9-e5d2-4cc2-b992-80d30ee3fc43/0087f4e0b8b3a94effa890ee3ebba0b1/aspnetcore-runtime-3.1.30-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/095f69b9-439e-4d3c-9927-c0bac5924730/f1d0b61643ae84745cf23de375eed37b/aspnetcore-runtime-3.1.30-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/59ba923c-63e6-4208-90f8-da625f9379a0/04f6d3b223a7c7fde15121e2954855b5/aspnetcore-runtime-3.1.30-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b5ad046f-3fdf-404b-80ed-d540c7e4b894/1fd4aceeb1a04637f9820f32a4baccbb/aspnetcore-runtime-3.1.30-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/36b8c9bc-7768-4ca6-8c43-6e1b590111f0/d734c542d79298b96e1fc71b2585de36/aspnetcore-runtime-3.1.30-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/12788621-4b44-4f9b-acfc-64fd5a907322/90ef036d9105a12cc9b3f25e89679f7c/aspnetcore-runtime-3.1.30-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dcd76037-8802-490a-b4ea-b6d23d3c61f4/83771424a900c00f6c0bc3a82de39591/aspnetcore-runtime-3.1.30-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/e3e962ec-252e-41ff-b91d-0629d7282f00/014486e253361c9da7ca0974b2326606/dotnet-hosting-3.1.30-win.exe

[//]: # ( SDK 3.1.424)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/abae2803-1012-48e2-a720-355795f80d79/47650a0b203a6f28019fe6f68215528e/dotnet-sdk-3.1.424-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dfe62f78-d4c1-4190-9d9d-44249e83a0c5/1fb0e84fb45e4e5d3207de6db85d99c3/dotnet-sdk-3.1.424-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/45cc59e3-5411-4a16-abeb-608a49357e22/cf1543f19cfe0f256b6c55b820ed5426/dotnet-sdk-3.1.424-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/28fd6fc0-f484-43d0-90cf-5e297a784e44/09c0612bb1cc46378546dfbdfd83014e/dotnet-sdk-3.1.424-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ce4021e6-1d4c-45f5-b047-4c9930476d8b/0752a299e004002d05c1fd32823ae5d9/dotnet-sdk-3.1.424-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0196b062-8cbf-448b-a3ea-feee21c2b4da/7b15b845099274b2f046af149e594f00/dotnet-sdk-3.1.424-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/32689e88-7340-47c7-8a67-d8e19a38c618/89d4815dfcc0c611cb0c599d0cefc71a/dotnet-sdk-3.1.424-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/64d4681b-f274-4b6a-bc78-825062708987/c6b80d2db9f38f0253d2f28bcf016be6/dotnet-sdk-3.1.424-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4332b326-fe73-4240-82b9-2826c88fee10/7790dba1ff61504ec8fe87ef27f7c7ee/dotnet-sdk-3.1.424-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9b930aa2-b70d-4282-a6dd-e20977b734f5/8ef0e5bdc1c35df7f43a4eec16b5d916/dotnet-sdk-3.1.424-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/27daf666-c5ca-489a-8f7a-e225dd3f941e/191491e9907eeb0e2fc101f5883f1417/dotnet-sdk-3.1.424-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8a85b5d2-7bb4-4cfe-be6b-2379bb218d1f/f95ffa6165dc8a8aea0f2fe81c4d60ee/dotnet-sdk-3.1.424-win-x86.zip
