# .NET Core 3.1.31 - November 08, 2022

.NET Core 3.1.31 and .NET Core SDK 3.1.425 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.425
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.9 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.9 | [3.1.425](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |


## Notable Changes
.NET Core 3.1.31 release carries non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7941](https://github.com/dotnet/core/issues/7941) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.31.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.31-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.31-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/november-2022-updates/

## Packages updated in this release

Package name | Version
:----------- | :------------------
Microsoft.NETCore.App.Host.linux-arm| 3.1.31
Microsoft.NETCore.App.Host.linux-arm64| 3.1.31
Microsoft.NETCore.App.Host.linux-musl-arm64| 3.1.31
Microsoft.NETCore.App.Host.linux-musl-x64| 3.1.31
Microsoft.NETCore.App.Host.linux-x64| 3.1.31
Microsoft.NETCore.App.Host.osx-x64| 3.1.31
Microsoft.NETCore.App.Host.win-arm| 3.1.31
Microsoft.NETCore.App.Host.win-arm64| 3.1.31
Microsoft.NETCore.App.Host.win-x64| 3.1.31
Microsoft.NETCore.App.Host.win-x86| 3.1.31
Microsoft.NETCore.App.Runtime.linux-arm| 3.1.31
Microsoft.NETCore.App.Runtime.linux-arm64| 3.1.31
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 3.1.31
Microsoft.NETCore.App.Runtime.linux-musl-x64| 3.1.31
Microsoft.NETCore.App.Runtime.linux-x64| 3.1.31
Microsoft.NETCore.App.Runtime.osx-x64| 3.1.31
Microsoft.NETCore.App.Runtime.win-arm| 3.1.31
Microsoft.NETCore.App.Runtime.win-arm64| 3.1.31
Microsoft.NETCore.App.Runtime.win-x64| 3.1.31
Microsoft.NETCore.App.Runtime.win-x86| 3.1.31
Microsoft.NETCore.DotNetAppHost| 3.1.31
Microsoft.NETCore.DotNetHost| 3.1.31
Microsoft.NETCore.DotNetHostPolicy| 3.1.31
Microsoft.NETCore.DotNetHostResolver| 3.1.31
Microsoft.WindowsDesktop.App.Runtime.win-x64| 3.1.31
Microsoft.WindowsDesktop.App.Runtime.win-x86| 3.1.31
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 3.1.31
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 3.1.31
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.31
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.31
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.31
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 3.1.31
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.31
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.31
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.31
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 3.1.31
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.31
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.31
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 3.1.31
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 3.1.31
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.31
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.31
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 3.1.31
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 3.1.31
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.31
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.31
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 3.1.31
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 3.1.31
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.31
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.31
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 3.1.31
runtime.win-arm.Microsoft.NETCore.DotNetHost| 3.1.31
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.31
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.31
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.31
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 3.1.31
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.31
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.31
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 3.1.31
runtime.win-x64.Microsoft.NETCore.DotNetHost| 3.1.31
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.31
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.31
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 3.1.31
runtime.win-x86.Microsoft.NETCore.DotNetHost| 3.1.31
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 3.1.31
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 3.1.31
Microsoft.AspNetCore.App.Runtime.linux-arm| 3.1.31
Microsoft.AspNetCore.App.Runtime.linux-arm64| 3.1.31
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 3.1.31
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 3.1.31
Microsoft.AspNetCore.App.Runtime.linux-x64| 3.1.31
Microsoft.AspNetCore.App.Runtime.osx-x64| 3.1.31
Microsoft.AspNetCore.App.Runtime.win-arm| 3.1.31
Microsoft.AspNetCore.App.Runtime.win-arm64| 3.1.31
AspNetCoreRuntime.3.1.x64| 3.1.31
AspNetCoreRuntime.3.1.x86| 3.1.31
dotnet-sql-cache| 3.1.31
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 3.1.31
Microsoft.AspNetCore.App.Runtime.win-x64| 3.1.31
Microsoft.AspNetCore.App.Runtime.win-x86| 3.1.31
Microsoft.AspNetCore.Authentication.AzureAD.UI| 3.1.31
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 3.1.31
Microsoft.AspNetCore.Authentication.Certificate| 3.1.31
Microsoft.AspNetCore.Authentication.Facebook| 3.1.31
Microsoft.AspNetCore.Authentication.Google| 3.1.31
Microsoft.AspNetCore.Authentication.JwtBearer| 3.1.31
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 3.1.31
Microsoft.AspNetCore.Authentication.Negotiate| 3.1.31
Microsoft.AspNetCore.Authentication.OpenIdConnect| 3.1.31
Microsoft.AspNetCore.Authentication.Twitter| 3.1.31
Microsoft.AspNetCore.Authentication.WsFederation| 3.1.31
Microsoft.AspNetCore.Authorization| 3.1.31
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 3.1.31
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 3.1.31
Microsoft.AspNetCore.AzureAppServicesIntegration| 3.1.31
Microsoft.AspNetCore.Components| 3.1.31
Microsoft.AspNetCore.Components.Analyzers| 3.1.31
Microsoft.AspNetCore.Components.Authorization| 3.1.31
Microsoft.AspNetCore.Components.Forms| 3.1.31
Microsoft.AspNetCore.Components.Web| 3.1.31
Microsoft.AspNetCore.ConcurrencyLimiter| 3.1.31
Microsoft.AspNetCore.Connections.Abstractions| 3.1.31
Microsoft.AspNetCore.Cryptography.Internal| 3.1.31
Microsoft.AspNetCore.Cryptography.KeyDerivation| 3.1.31
Microsoft.AspNetCore.DataProtection| 3.1.31
Microsoft.AspNetCore.DataProtection.Abstractions| 3.1.31
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 3.1.31
Microsoft.AspNetCore.DataProtection.Extensions| 3.1.31
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 3.1.31
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 3.1.31
Microsoft.AspNetCore.HeaderPropagation| 3.1.31
Microsoft.AspNetCore.Hosting.WindowsServices| 3.1.31
Microsoft.AspNetCore.Http.Connections.Client| 3.1.31
Microsoft.AspNetCore.Http.Connections.Common| 3.1.31
Microsoft.AspNetCore.Http.Features| 3.1.31
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 3.1.31
Microsoft.AspNetCore.Identity.Specification.Tests| 3.1.31
Microsoft.AspNetCore.Identity.UI| 3.1.31
Microsoft.AspNetCore.JsonPatch| 3.1.31
Microsoft.AspNetCore.Metadata| 3.1.31
Microsoft.AspNetCore.MiddlewareAnalysis| 3.1.31
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 3.1.31
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 3.1.31
Microsoft.AspNetCore.Mvc.Testing| 3.1.31
Microsoft.AspNetCore.NodeServices| 3.1.31
Microsoft.AspNetCore.Owin| 3.1.31
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 3.1.31
Microsoft.AspNetCore.SignalR.Client| 3.1.31
Microsoft.AspNetCore.SignalR.Client.Core| 3.1.31
Microsoft.AspNetCore.SignalR.Common| 3.1.31
Microsoft.AspNetCore.SignalR.Protocols.Json| 3.1.31
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 3.1.31
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 3.1.31
Microsoft.AspNetCore.SignalR.Specification.Tests| 3.1.31
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 3.1.31
Microsoft.AspNetCore.SpaServices| 3.1.31
Microsoft.AspNetCore.SpaServices.Extensions| 3.1.31
Microsoft.AspNetCore.TestHost| 3.1.31
Microsoft.dotnet-openapi| 3.1.31
Microsoft.DotNet.Web.Client.ItemTemplates| 3.1.31
Microsoft.DotNet.Web.ItemTemplates| 3.1.31
Microsoft.DotNet.Web.ProjectTemplates.3.1| 3.1.31
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1| 3.1.31
Microsoft.Extensions.ApiDescription.Client| 3.1.31
Microsoft.Extensions.ApiDescription.Server| 3.1.31
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 3.1.31
Microsoft.Extensions.Identity.Core| 3.1.31
Microsoft.Extensions.Identity.Stores| 3.1.31
Microsoft.DotNet.Common.ItemTemplates| 3.1.31
Microsoft.DotNet.Common.ProjectTemplates.1.x| 3.1.31
Microsoft.DotNet.Common.ProjectTemplates.2.0| 3.1.31
Microsoft.DotNet.Common.ProjectTemplates.2.1| 3.1.31
Microsoft.DotNet.Common.ProjectTemplates.2.2| 3.1.31
Microsoft.DotNet.Common.ProjectTemplates.3.0| 3.1.31
Microsoft.DotNet.Common.ProjectTemplates.3.1| 3.1.31
Microsoft.AspNetCore.Mvc.Razor.Extensions| 3.1.31
Microsoft.AspNetCore.Razor.Language| 3.1.31
Microsoft.CodeAnalysis.Razor| 3.1.31
Microsoft.NET.Sdk.Razor| 3.1.31
dotnet-ef| 3.1.31
Microsoft.Data.Sqlite| 3.1.31
Microsoft.Data.Sqlite.Core| 3.1.31
Microsoft.EntityFrameworkCore| 3.1.31
Microsoft.EntityFrameworkCore.Abstractions| 3.1.31
Microsoft.EntityFrameworkCore.Analyzers| 3.1.31
Microsoft.EntityFrameworkCore.Cosmos| 3.1.31
Microsoft.EntityFrameworkCore.Design| 3.1.31
Microsoft.EntityFrameworkCore.InMemory| 3.1.31
Microsoft.EntityFrameworkCore.Proxies| 3.1.31
Microsoft.EntityFrameworkCore.Relational| 3.1.31
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 3.1.31
Microsoft.EntityFrameworkCore.Specification.Tests| 3.1.31
Microsoft.EntityFrameworkCore.Sqlite| 3.1.31
Microsoft.EntityFrameworkCore.Sqlite.Core| 3.1.31
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 3.1.31
Microsoft.EntityFrameworkCore.SqlServer| 3.1.31
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 3.1.31
Microsoft.EntityFrameworkCore.Tools| 3.1.31
Microsoft.Extensions.Caching.Abstractions| 3.1.31
Microsoft.Extensions.Caching.Memory| 3.1.31
Microsoft.Extensions.Caching.SqlServer| 3.1.31
Microsoft.Extensions.Caching.StackExchangeRedis| 3.1.31
Microsoft.Extensions.Configuration| 3.1.31
Microsoft.Extensions.Configuration.Abstractions| 3.1.31
Microsoft.Extensions.Configuration.Binder| 3.1.31
Microsoft.Extensions.Configuration.CommandLine| 3.1.31
Microsoft.Extensions.Configuration.EnvironmentVariables| 3.1.31
Microsoft.Extensions.Configuration.FileExtensions| 3.1.31
Microsoft.Extensions.Configuration.Ini| 3.1.31
Microsoft.Extensions.Configuration.Json| 3.1.31
Microsoft.Extensions.Configuration.KeyPerFile| 3.1.31
Microsoft.Extensions.Configuration.NewtonsoftJson| 3.1.31
Microsoft.Extensions.Configuration.UserSecrets| 3.1.31
Microsoft.Extensions.Configuration.Xml| 3.1.31
Microsoft.Extensions.DependencyInjection| 3.1.31
Microsoft.Extensions.DependencyInjection.Abstractions| 3.1.31
Microsoft.Extensions.DependencyInjection.Specification.Tests| 3.1.31
Microsoft.Extensions.DiagnosticAdapter| 3.1.31
Microsoft.Extensions.Diagnostics.HealthChecks| 3.1.31
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 3.1.31
Microsoft.Extensions.FileProviders.Abstractions| 3.1.31
Microsoft.Extensions.FileProviders.Composite| 3.1.31
Microsoft.Extensions.FileProviders.Embedded| 3.1.31
Microsoft.Extensions.FileProviders.Physical| 3.1.31
Microsoft.Extensions.FileSystemGlobbing| 3.1.31
Microsoft.Extensions.Hosting| 3.1.31
Microsoft.Extensions.Hosting.Abstractions| 3.1.31
Microsoft.Extensions.Hosting.Systemd| 3.1.31
Microsoft.Extensions.Hosting.WindowsServices| 3.1.31
Microsoft.Extensions.Http| 3.1.31
Microsoft.Extensions.Http.Polly| 3.1.31
Microsoft.Extensions.Localization| 3.1.31
Microsoft.Extensions.Localization.Abstractions| 3.1.31
Microsoft.Extensions.Logging| 3.1.31
Microsoft.Extensions.Logging.Abstractions| 3.1.31
Microsoft.Extensions.Logging.AzureAppServices| 3.1.31
Microsoft.Extensions.Logging.Configuration| 3.1.31
Microsoft.Extensions.Logging.Console| 3.1.31
Microsoft.Extensions.Logging.Debug| 3.1.31
Microsoft.Extensions.Logging.EventLog| 3.1.31
Microsoft.Extensions.Logging.EventSource| 3.1.31
Microsoft.Extensions.Logging.TraceSource| 3.1.31
Microsoft.Extensions.ObjectPool| 3.1.31
Microsoft.Extensions.Options| 3.1.31
Microsoft.Extensions.Options.ConfigurationExtensions| 3.1.31
Microsoft.Extensions.Options.DataAnnotations| 3.1.31
Microsoft.Extensions.Primitives| 3.1.31
Microsoft.Extensions.WebEncoders| 3.1.31
Microsoft.JSInterop| 3.1.31

[//]: # ( Runtime 3.1.31)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/018a8fa8-fbbe-4aad-bf2f-7bdccf06692c/7105094bfed3bf67035e3e17bc405dbb/dotnet-runtime-3.1.31-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dbdcd07a-e519-470a-a03e-702f4cbf65d7/e1bc1991aa91cc52582d446ae4b63691/dotnet-runtime-3.1.31-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/70309a33-2d13-460a-9862-7d437ba909d2/09f474548b3b7f48ebaf8fbb553b5a22/dotnet-runtime-3.1.31-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c7bf1c6-5bb8-43c7-b431-bcefbb7ed164/3b53c5ff5dc3b12fa3e5ce8d3c42f6c1/dotnet-runtime-3.1.31-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/046afe25-7b88-48ad-a06c-1c3625115c63/6814f9ca777bc7e2cb4b373027dcdd76/dotnet-runtime-3.1.31-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3e1e79af-786f-469a-ad76-4aea17e95b21/c2aabc56f79dd545665a275fb12d6d54/dotnet-runtime-3.1.31-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3a01bc5f-4deb-4cf5-bbdd-19a1dc406b2c/1c66b68807fe87cda620898c088000c4/dotnet-runtime-3.1.31-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/df21d06b-791b-4230-a812-0878577752f4/f646c8f15a63c4027566e386ae2555ed/dotnet-runtime-3.1.31-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b34921a9-2b4e-4a24-afba-c8c0e8a069d3/8510396767c68fa5ad6287c1a6cb46de/dotnet-runtime-3.1.31-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ad386cbd-2f5b-496b-8455-b221d940dfd2/63dad5e2d9c9886fd2ec0f69c0b4e02d/dotnet-runtime-3.1.31-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0d80a141-e930-4876-827c-71f99681ac69/bd423a35d318c263b6aeaaa715d70b5c/dotnet-runtime-3.1.31-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/bfeea18b-0ba8-429f-9027-a8f09bf3012b/aea8f3bc59922233b7c1fc750fb49461/dotnet-runtime-3.1.31-win-x86.zip

[//]: # ( WindowsDesktop 3.1.31)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f68e8704-171f-47dc-88a5-40572a22319a/43a6b2785e73b2177a4401ceccd01ef3/windowsdesktop-runtime-3.1.31-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/df67c05e-3019-4d7f-846b-e08b92924b60/18a670ed3b1b60c5f7061f7bdaa6f7f6/windowsdesktop-runtime-3.1.31-win-x86.exe

[//]: # ( ASP 3.1.31)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1ee634bf-a05b-4f51-a056-d1db21079063/9522ef7e1db54dfb73593dc3ab8c80d3/aspnetcore-runtime-3.1.31-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/216fe20f-6c45-4a87-b206-6c22360567fd/902208836df9ddcf4eb177771b2c6fea/aspnetcore-runtime-3.1.31-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/698d4db8-4c24-4f96-9020-b486aad3669a/9c86fe8a3acd45b1b9125feca8563d4c/aspnetcore-runtime-3.1.31-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c828336f-67db-4323-8c8f-f18c70437748/cfd553bfa706bcb26c3be6e2e12a0c90/aspnetcore-runtime-3.1.31-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2fc0069c-e99a-4296-99ee-a422b3cf50de/df8aee91eeaf50a12c810c3845341eb3/aspnetcore-runtime-3.1.31-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25282f2c-c43e-4c0f-aa09-f72c565e009e/b581cf1c97879ca4913a1763c7d1fe8d/aspnetcore-runtime-3.1.31-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/6e403837-c094-4920-af9c-22af2b2ea813/2ed77629bd01c0b289fc17a321ab8c9f/aspnetcore-runtime-3.1.31-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/72d8cc8e-b5b3-4c7e-ad32-5fb8ff942c6a/77b437b571321da8009cc678c6d68172/aspnetcore-runtime-3.1.31-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b49c9239-8388-436f-8761-f23b5ae12145/3a380dd2930b26599453ec42366de9b5/aspnetcore-runtime-3.1.31-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/acc596b0-0cf3-4925-8d8f-d0f986760026/05fac10dd66f631d40380950fbbeab79/aspnetcore-runtime-3.1.31-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/25b882c1-0525-42d3-a610-28da271a13c0/13824db5f92585dabf955fd37f90ca41/aspnetcore-runtime-3.1.31-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/b84cc7e8-5bf7-4e35-bc2a-94903c823b5c/12f4767bded70bcfb4d56b3a6bfa005d/dotnet-hosting-3.1.31-win.exe

[//]: # ( SDK 3.1.425)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/17fc9caa-076e-41c0-907c-f027140b081f/ac9ba7784bf06b63185ead3a2aa2f4f4/dotnet-sdk-3.1.425-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4a8d050-e3d0-4f07-b222-5cadb21320f2/05d4d832757a78ec88fb56d8f9f4cc65/dotnet-sdk-3.1.425-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e063f018-9aca-4b38-98de-542fb7f320cd/de738960ee0d5520df01f4a28ac82731/dotnet-sdk-3.1.425-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c2574deb-9c23-4851-89bd-211243ecd85b/046fc7e68a8e7e6e5854fc0b3b56e59c/dotnet-sdk-3.1.425-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3515d7fa-b7ce-4150-af0c-7cd5fc45bde4/390a971897ccf36baa002f145f0e9227/dotnet-sdk-3.1.425-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/861832ec-7a22-401f-ab1c-1bed35a50bbc/77067aa8919546dbf9ebef6b34137770/dotnet-sdk-3.1.425-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8d52dd3a-13f9-4b1e-ae1b-7afc8896bf08/f01ed5a9f1eb3d425daec9e900a334cf/dotnet-sdk-3.1.425-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/eac93eac-719f-449d-bffa-06d962f08da8/9fd6bd1e98410710bc4e14f285793127/dotnet-sdk-3.1.425-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9cf7e571-76c7-4ce8-9777-37bd6c3540e9/5c01197afed195cdb6cd2ae9e49606fc/dotnet-sdk-3.1.425-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ac1a4171-bb38-473b-b7f4-7a5392076ebc/26fa10317470fa894c16c24037ba504e/dotnet-sdk-3.1.425-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d026a1fc-ab34-4274-85c9-e67f5d6eb001/be08291455be66700e697cd5fb60fabb/dotnet-sdk-3.1.425-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d595e303-d26d-447c-92e7-5dc32c8e70b9/0669c3a6247a96a98ea96b1698294970/dotnet-sdk-3.1.425-win-x86.zip
