# .NET Core 3.1.32 - December 13, 2022

.NET Core 3.1.32 and .NET Core SDK 3.1.426 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.426
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.9 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.9 | [3.1.426](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/supported-versions-net) |


## Notable Changes
.NET Core 3.1.32 release carries security fixes.

# Microsoft Security Advisory CVE-2022-41089 | .NET Remote Code Execution Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core 3.1, .NET 6.0., and .NET 7.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A remote code execution vulnerability exists in .NET Core 3.1, .NET 6.0, and .NET 7.0, where a malicious actor could cause a user to run arbitrary code as a result of parsing maliciously crafted xps files.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8037](https://github.com/dotnet/core/issues/8037) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.32.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.32-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.32-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/december-2022-updates/

## Packages updated in this release

Package name | Version
:----------- | :------------------
Microsoft.NETCore.App.Runtime.linux-arm| 3.1.32
Microsoft.NETCore.App.Host.linux-x64| 3.1.32
Microsoft.NETCore.App.Host.win-x64| 3.1.32
Microsoft.NETCore.App.Host.win-x86| 3.1.32
Microsoft.NETCore.App.Runtime.linux-x64| 3.1.32
Microsoft.NETCore.App.Runtime.win-x86| 3.1.32
Microsoft.NETCore.DotNetHost| 3.1.32
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.32
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 3.1.32
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 3.1.32
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.32
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.32
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.32
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 3.1.32
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.32
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 3.1.32
Microsoft.NETCore.App.Host.linux-arm| 3.1.32
Microsoft.NETCore.App.Host.linux-musl-arm64| 3.1.32
Microsoft.NETCore.App.Host.osx-x64| 3.1.32
Microsoft.NETCore.App.Runtime.linux-musl-x64| 3.1.32
Microsoft.NETCore.App.Runtime.win-arm| 3.1.32
Microsoft.NETCore.App.Runtime.win-x64| 3.1.32
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 3.1.32
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.32
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.32
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 3.1.32
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.32
runtime.win-x64.Microsoft.NETCore.DotNetHost| 3.1.32
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.32
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 3.1.32
Microsoft.NETCore.App.Host.linux-arm64| 3.1.32
Microsoft.NETCore.App.Host.linux-musl-x64| 3.1.32
Microsoft.NETCore.App.Host.win-arm| 3.1.32
Microsoft.NETCore.App.Host.win-arm64| 3.1.32
Microsoft.WindowsDesktop.App.Runtime.win-x64| 3.1.32
Microsoft.WindowsDesktop.App.Runtime.win-x86| 3.1.32
Microsoft.NETCore.DotNetHostResolver| 3.1.32
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.32
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 3.1.32
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 3.1.32
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.32
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 3.1.32
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.32
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.32
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 3.1.32
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 3.1.32
runtime.win-x86.Microsoft.NETCore.DotNetHost| 3.1.32
Microsoft.NETCore.App.Runtime.linux-arm64| 3.1.32
Microsoft.NETCore.App.Runtime.osx-x64| 3.1.32
Microsoft.NETCore.App.Runtime.win-arm64| 3.1.32
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 3.1.32
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 3.1.32
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.32
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.32
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 3.1.32
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.32
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.32
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 3.1.32
Microsoft.NETCore.DotNetAppHost| 3.1.32
Microsoft.NETCore.DotNetHostPolicy| 3.1.32
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.32
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.32
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.32
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 3.1.32
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.32
runtime.win-arm.Microsoft.NETCore.DotNetHost| 3.1.32
nupkgs\corefx\packages\Microsoft.Windows.Compatibility.3.1.4.nupkg
nupkgs\corefx\packages\Microsoft.NETCore.Platforms.3.1.12.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 3.1.32
Microsoft.AspNetCore.Authentication.AzureAD.UI| 3.1.32
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 3.1.32
Microsoft.AspNetCore.Authentication.Twitter| 3.1.32
Microsoft.AspNetCore.Authentication.WsFederation| 3.1.32
Microsoft.AspNetCore.App.Runtime.linux-arm| 3.1.32
Microsoft.AspNetCore.App.Runtime.linux-arm64| 3.1.32
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 3.1.32
dotnet-sql-cache| 3.1.32
Microsoft.AspNetCore.Components.Forms| 3.1.32
Microsoft.AspNetCore.Cryptography.KeyDerivation| 3.1.32
Microsoft.AspNetCore.DataProtection.Extensions| 3.1.32
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 3.1.32
Microsoft.AspNetCore.Http.Connections.Client| 3.1.32
Microsoft.AspNetCore.Http.Features| 3.1.32
Microsoft.AspNetCore.App.Runtime.linux-x64| 3.1.32
Microsoft.AspNetCore.App.Runtime.osx-x64| 3.1.32
AspNetCoreRuntime.3.1.x86| 3.1.32
Microsoft.AspNetCore.App.Runtime.win-x64| 3.1.32
Microsoft.AspNetCore.MiddlewareAnalysis| 3.1.32
Microsoft.Extensions.Identity.Core| 3.1.32
Microsoft.AspNetCore.Components.Web| 3.1.32
Microsoft.AspNetCore.Cryptography.Internal| 3.1.32
Microsoft.AspNetCore.DataProtection.Abstractions| 3.1.32
Microsoft.AspNetCore.Http.Connections.Common| 3.1.32
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 3.1.32
Microsoft.AspNetCore.JsonPatch| 3.1.32
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 3.1.32
Microsoft.AspNetCore.NodeServices| 3.1.32
Microsoft.AspNetCore.SignalR.Common| 3.1.32
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 3.1.32
Microsoft.AspNetCore.SignalR.Specification.Tests| 3.1.32
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 3.1.32
Microsoft.AspNetCore.Authentication.Google| 3.1.32
Microsoft.AspNetCore.Authentication.OpenIdConnect| 3.1.32
Microsoft.AspNetCore.Authorization| 3.1.32
Microsoft.AspNetCore.AzureAppServicesIntegration| 3.1.32
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 3.1.32
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 3.1.32
Microsoft.AspNetCore.HeaderPropagation| 3.1.32
Microsoft.AspNetCore.Identity.UI| 3.1.32
Microsoft.dotnet-openapi| 3.1.32
Microsoft.DotNet.Web.Client.ItemTemplates| 3.1.32
Microsoft.DotNet.Web.ItemTemplates| 3.1.32
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 3.1.32
Microsoft.Extensions.Identity.Stores| 3.1.32
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 3.1.32
AspNetCoreRuntime.3.1.x64| 3.1.32
Microsoft.AspNetCore.Components.Authorization| 3.1.32
Microsoft.AspNetCore.ConcurrencyLimiter| 3.1.32
Microsoft.AspNetCore.Identity.Specification.Tests| 3.1.32
Microsoft.AspNetCore.SignalR.Client| 3.1.32
Microsoft.AspNetCore.SignalR.Protocols.Json| 3.1.32
Microsoft.AspNetCore.SpaServices| 3.1.32
Microsoft.Extensions.ApiDescription.Client| 3.1.32
Microsoft.Extensions.ApiDescription.Server| 3.1.32
Microsoft.AspNetCore.Authentication.Facebook| 3.1.32
Microsoft.AspNetCore.Authentication.JwtBearer| 3.1.32
Microsoft.AspNetCore.Authentication.Negotiate| 3.1.32
Microsoft.AspNetCore.Components| 3.1.32
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 3.1.32
Microsoft.AspNetCore.Owin| 3.1.32
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 3.1.32
Microsoft.DotNet.Web.ProjectTemplates.3.1| 3.1.32
Microsoft.AspNetCore.TestHost| 3.1.32
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1| 3.1.32
Microsoft.AspNetCore.App.Runtime.win-arm| 3.1.32
Microsoft.AspNetCore.App.Runtime.win-arm64| 3.1.32
Microsoft.AspNetCore.App.Runtime.win-x86| 3.1.32
Microsoft.AspNetCore.Authentication.Certificate| 3.1.32
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 3.1.32
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 3.1.32
Microsoft.AspNetCore.Components.Analyzers| 3.1.32
Microsoft.AspNetCore.Connections.Abstractions| 3.1.32
Microsoft.AspNetCore.DataProtection| 3.1.32
Microsoft.AspNetCore.Hosting.WindowsServices| 3.1.32
Microsoft.AspNetCore.Metadata| 3.1.32
Microsoft.AspNetCore.Mvc.Testing| 3.1.32
Microsoft.AspNetCore.SignalR.Client.Core| 3.1.32
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 3.1.32
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 3.1.32
Microsoft.AspNetCore.SpaServices.Extensions| 3.1.32
Microsoft.DotNet.Common.ProjectTemplates.2.1| 3.1.32
Microsoft.DotNet.Common.ItemTemplates| 3.1.32
Microsoft.DotNet.Common.ProjectTemplates.2.2| 3.1.32
Microsoft.DotNet.Common.ProjectTemplates.1.x| 3.1.32
Microsoft.DotNet.Common.ProjectTemplates.3.0| 3.1.32
Microsoft.DotNet.Common.ProjectTemplates.2.0| 3.1.32
Microsoft.DotNet.Common.ProjectTemplates.3.1| 3.1.32
dotnet-ef| 3.1.32
Microsoft.Data.Sqlite.Core| 3.1.32
Microsoft.EntityFrameworkCore.Specification.Tests| 3.1.32
Microsoft.EntityFrameworkCore.Analyzers| 3.1.32
Microsoft.EntityFrameworkCore.InMemory| 3.1.32
Microsoft.EntityFrameworkCore.Relational| 3.1.32
Microsoft.EntityFrameworkCore.Sqlite| 3.1.32
Microsoft.EntityFrameworkCore.SqlServer| 3.1.32
Microsoft.Data.Sqlite| 3.1.32
Microsoft.EntityFrameworkCore.Abstractions| 3.1.32
Microsoft.EntityFrameworkCore.Design| 3.1.32
Microsoft.EntityFrameworkCore.Proxies| 3.1.32
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 3.1.32
Microsoft.EntityFrameworkCore.Tools| 3.1.32
Microsoft.EntityFrameworkCore| 3.1.32
Microsoft.EntityFrameworkCore.Cosmos| 3.1.32
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 3.1.32
Microsoft.EntityFrameworkCore.Sqlite.Core| 3.1.32
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 3.1.32
Microsoft.Extensions.Caching.SqlServer| 3.1.32
Microsoft.Extensions.Configuration.Abstractions| 3.1.32
Microsoft.Extensions.Configuration.CommandLine| 3.1.32
Microsoft.Extensions.Configuration.NewtonsoftJson| 3.1.32
Microsoft.Extensions.DependencyInjection| 3.1.32
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 3.1.32
Microsoft.Extensions.FileProviders.Composite| 3.1.32
Microsoft.Extensions.Hosting.Abstractions| 3.1.32
Microsoft.Extensions.ObjectPool| 3.1.32
Microsoft.JSInterop| 3.1.32
Microsoft.Extensions.Caching.Abstractions| 3.1.32
Microsoft.Extensions.Configuration| 3.1.32
Microsoft.Extensions.Configuration.KeyPerFile| 3.1.32
Microsoft.Extensions.Configuration.UserSecrets| 3.1.32
Microsoft.Extensions.DependencyInjection.Abstractions| 3.1.32
Microsoft.Extensions.DiagnosticAdapter| 3.1.32
Microsoft.Extensions.FileProviders.Embedded| 3.1.32
Microsoft.Extensions.Http| 3.1.32
Microsoft.Extensions.Localization.Abstractions| 3.1.32
Microsoft.Extensions.Logging.Configuration| 3.1.32
Microsoft.Extensions.Logging.EventLog| 3.1.32
Microsoft.Extensions.Logging.TraceSource| 3.1.32
Microsoft.Extensions.Options| 3.1.32
Microsoft.Extensions.FileProviders.Abstractions| 3.1.32
Microsoft.Extensions.FileSystemGlobbing| 3.1.32
Microsoft.Extensions.Hosting| 3.1.32
Microsoft.Extensions.Hosting.Systemd| 3.1.32
Microsoft.Extensions.Http.Polly| 3.1.32
Microsoft.Extensions.Logging| 3.1.32
Microsoft.Extensions.Logging.Console| 3.1.32
Microsoft.Extensions.Options.ConfigurationExtensions| 3.1.32
Microsoft.Extensions.Primitives| 3.1.32
Microsoft.Extensions.Caching.Memory| 3.1.32
Microsoft.Extensions.Configuration.EnvironmentVariables| 3.1.32
Microsoft.Extensions.Configuration.Json| 3.1.32
Microsoft.Extensions.Caching.StackExchangeRedis| 3.1.32
Microsoft.Extensions.Configuration.Binder| 3.1.32
Microsoft.Extensions.Configuration.FileExtensions| 3.1.32
Microsoft.Extensions.Configuration.Ini| 3.1.32
Microsoft.Extensions.Configuration.Xml| 3.1.32
Microsoft.Extensions.DependencyInjection.Specification.Tests| 3.1.32
Microsoft.Extensions.Diagnostics.HealthChecks| 3.1.32
Microsoft.Extensions.FileProviders.Physical| 3.1.32
Microsoft.Extensions.Hosting.WindowsServices| 3.1.32
Microsoft.Extensions.Localization| 3.1.32
Microsoft.Extensions.Logging.Abstractions| 3.1.32
Microsoft.Extensions.Logging.AzureAppServices| 3.1.32
Microsoft.Extensions.Logging.Debug| 3.1.32
Microsoft.Extensions.Logging.EventSource| 3.1.32
Microsoft.Extensions.Options.DataAnnotations| 3.1.32
Microsoft.Extensions.WebEncoders| 3.1.32


[//]: # ( Runtime 3.1.32)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0581a17a-bd80-44ad-81c4-263669a29549/5607ac4ee7bc42dd30a5cfc1749300ee/dotnet-runtime-3.1.32-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/edfb706e-83fe-4a81-804c-23d80b041b70/4f98b067bd2817976a4362c25fbf70e7/dotnet-runtime-3.1.32-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9d42af6c-d101-44a7-90c6-7cb8998370dd/7758de1014bbb0ecc4d884f6aefcb0c2/dotnet-runtime-3.1.32-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/62feabe5-70ce-4d6b-8b50-a0f6914b86cc/f9aa8a11f0311a5af16035ba94e34737/dotnet-runtime-3.1.32-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fea239ad-fd47-4764-aa71-6a147a82f632/20ee58b0bf08ae9f6e76e37ba3765c57/dotnet-runtime-3.1.32-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fb1388fc-c9a4-44f7-93a3-0f0eb0b8ba35/f585f7af9b2c88b80a4e85b2128aaa28/dotnet-runtime-3.1.32-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09f14240-76bf-43df-bdf1-636aa56cbd5c/4898c400f81d0bac651bcf84dc487b6f/dotnet-runtime-3.1.32-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/307dfda4-4e30-4722-a4dd-8c17934e4f40/61fd1a1a347fef55db6c93ac4b7422aa/dotnet-runtime-3.1.32-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/476eba79-f17f-49c8-a213-0f24a22cd026/37c02de81ff5b76ac57a5427462395f1/dotnet-runtime-3.1.32-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d4368ac4-925b-426e-a253-7d675e5cddd6/9749cb293185da421a6958382b5d8b30/dotnet-runtime-3.1.32-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/de4b3438-24a2-4d1d-a845-97355cf97b71/515abb880478b49f7c1bced8fbf07b16/dotnet-runtime-3.1.32-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c8839703-3936-42f5-99e0-8efc20f94608/63636e7975bb551934b3c4deb43ceb4c/dotnet-runtime-3.1.32-win-x86.zip

[//]: # ( WindowsDesktop 3.1.32)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b92958c6-ae36-4efa-aafe-569fced953a5/1654639ef3b20eb576174c1cc200f33a/windowsdesktop-runtime-3.1.32-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3f353d2c-0431-48c5-bdf6-fbbe8f901bb5/542a4af07c1df5136a98a1c2df6f3d62/windowsdesktop-runtime-3.1.32-win-x86.exe

[//]: # ( ASP 3.1.32)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c0aab0e-eb92-4609-a8f4-ce7de13c8fe8/e350028fdb935079d6478a6874abb21c/aspnetcore-runtime-3.1.32-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7a713b60-c2fb-4dc9-ad35-df86c4bfac0c/fff24659d0a2ad9c6b622be1722b8f72/aspnetcore-runtime-3.1.32-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2672b266-880f-4ec1-ab89-bcd235c59193/d37f0755df26313e7a7bbf6dbcf9184e/aspnetcore-runtime-3.1.32-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e94c26b7-6ac0-46b9-81f1-e008ce8348cb/41d57ffacf3e151de8039ec3cd007a68/aspnetcore-runtime-3.1.32-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39c3ef4c-73c7-4248-8c54-0865d5feb8b2/3420b1ff6b0f36e63044d6f7a794b579/aspnetcore-runtime-3.1.32-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/70cd4d7b-0186-4ce2-a710-f50d6dec246f/84c5b21b8a487127589095336c5158b5/aspnetcore-runtime-3.1.32-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/585888eb-c415-41cf-9c4c-16eec9623ef1/1efc5936163b1d8921be22c0f6bef2f8/aspnetcore-runtime-3.1.32-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/98910750-2644-472c-ab2b-17f315ccb953/c2a4c223ee11e2eec7d13744e7a45547/aspnetcore-runtime-3.1.32-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/907c795f-bdc5-45d2-8ce7-d19dbf322da0/48290bd2e01d8c54771eb137da543ad7/aspnetcore-runtime-3.1.32-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/63b482d2-04b2-4dd4-baaf-d1e78de80738/40321091c872f4e77337b68fc61a5a07/aspnetcore-runtime-3.1.32-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3ce9a9a6-5108-43b1-bcc4-20fcfa904760/95e4d31856e2b0327e6fdc9cf8c50cc4/aspnetcore-runtime-3.1.32-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/6744eb9d-dcd4-4386-9d87-b03b70fc58ce/818fadf3f3d919c17ba845b2195bfd9b/dotnet-hosting-3.1.32-win.exe

[//]: # ( SDK 3.1.426)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2043e641-977d-43ac-b42a-f47fd9ee79ba/5b10d12a0626adaed720358ab8ad0b7e/dotnet-sdk-3.1.426-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/79f1cf3e-ccc7-4de4-9f4c-1a6e061cb867/68cab78b3f9a5a8ce2f275b983204376/dotnet-sdk-3.1.426-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f8834fef-d2ab-4cf6-abc3-d8d79cfcde11/0ee05ef4af5fe324ce2977021bf9f340/dotnet-sdk-3.1.426-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e89c4f00-5cbb-4810-897d-f5300165ee60/027ace0fdcfb834ae0a13469f0b1a4c8/dotnet-sdk-3.1.426-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/289315e5-9e62-4fe0-84f0-74cb859a3e16/d7064a54c6a46dcafe9f24abae102961/dotnet-sdk-3.1.426-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c319dd8b-4ea5-473e-8609-c36f31c8186e/c9633afb3084888a8c62fa224512050b/dotnet-sdk-3.1.426-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e45c25b7-623f-4b98-8918-13a671884860/d6e4526d0dd31d388b36a749f90ae6e2/dotnet-sdk-3.1.426-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/934b9504-42b3-4463-9633-e083fb011a8a/5f914380af9ee42011774cefcc484e8b/dotnet-sdk-3.1.426-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b70ad520-0e60-43f5-aee2-d3965094a40d/667c122b3736dcbfa1beff08092dbfc3/dotnet-sdk-3.1.426-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/18f0e7dd-c821-49b5-9fb1-f161611b7712/5b96d5b15f5f0565adeb42e52667bd08/dotnet-sdk-3.1.426-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e0f36c72-8edf-4c6b-a835-e74cfcc6fc23/b5e69be920e77652ce6f31a0f48ab71d/dotnet-sdk-3.1.426-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3c9e415a-5e86-4006-b5f0-e4dac5b16fea/425ddf8d26a54a59934d5d17533fd82b/dotnet-sdk-3.1.426-win-x86.zip
