# .NET Core 3.1.202 - May 12, 2020

This .NET Core SDK release includes the following released .NET Core and ASP.NET Core Runtimes.

* .NET Core SDK 3.1.202
* .NET Core Runtime 3.1.4
* ASP.NET Core 3.1.4

See the [Release Notes](3.1.4.md) for details about what is included in this update.


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.4 | [3.1.103](3.1.4.md) |
| Windows | Visual Studio 2019 version 16.5 | [3.1.201](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |


## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distributions which are not directly supported by .NET Core can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel 3.1/stable –-classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [.NET for Linux Distributions](../../../linux.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically include package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |


## Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-3.1
```

## Run applications

If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-3.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](../linux-packages.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-3.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-3.1` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-3.1.4-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.201-sdk.md
[snap-install]: 3.1.4-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.4-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.4-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://learn.microsoft.com/dotnet/core/install/

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-march-2020/





[//]: # ( Runtime 3.1.4)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f9c95fa6-0fa0-4fa5-b6f2-e782b4044b76/42cd3637fb99a9ffde1469ef936be0c3/dotnet-runtime-3.1.4-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/da94a32f-8fa7-4df8-b54c-f3442dc2a17a/0badd31a0487b0318a3234baf023aa3c/dotnet-runtime-3.1.4-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/26671baf-7f0d-4b0c-aeaf-ed00f1f1cd39/b4b9f36c3937020834255c3ca55f6ed2/dotnet-runtime-3.1.4-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b86bf782-f36a-435d-8e85-0749e1874c97/0723f572c097721865568117e840d322/dotnet-runtime-3.1.4-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3558096-9333-41fe-9195-0bd5558bde88/7a1ff566cbdab177d49fafcb66f4316b/dotnet-runtime-3.1.4-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b51c2705-f7e1-4a59-b6ba-2a70d9caded3/da2567cee8519d5dc4185cbee8f97498/dotnet-runtime-3.1.4-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/34e036e2-1189-4b34-9a94-bba712581532/60fa96357a11d25d4c75a8d0f107338f/dotnet-runtime-3.1.4-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d93f93da-7d59-4b65-8d02-d60894d69785/1e05bdf2757fb14b82108df98f89bde0/dotnet-runtime-3.1.4-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/32e90964-8aed-4e70-8f30-e6aa5f8f5227/b998e9b6b5701a6dc3c1709bc2862958/dotnet-runtime-3.1.4-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/93d4ac87-6db0-4ddd-9bef-8050067b5e5d/605b178040bdd75b63d021d9387219ea/dotnet-runtime-3.1.4-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d75cf6a6-22e6-4e25-9e87-380417656586/811507607c6999f3a842b27efddd3a01/dotnet-runtime-3.1.4-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/03b8b6cb-c80c-43ea-9136-1156e839bb52/31c13e5a5b028a3c721a50df8f02caf0/dotnet-runtime-3.1.4-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8dbd1e36-4d86-4989-ae0b-d16041575fcd/105512c7459d0ff04cffbb6453657874/dotnet-runtime-3.1.4-win-x86.zip

[//]: # ( WindowsDesktop )
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d8cf1fe3-21c2-4baf-988f-f0152996135e/0c00b94713ee93e7ad5b4f82e2b86607/windowsdesktop-runtime-3.1.4-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2d4b7600-5f32-4a1f-abd5-47cdb2d1362b/7b8b7635e3bb63f6b2cc9a1c624b5325/windowsdesktop-runtime-3.1.4-win-x86.exe

[//]: # ( ASP 3.1.4)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06f9feeb-cd19-49e9-a5cd-a230e1d8c52f/a232fbb4a6e6a90bbe624225e180308a/aspnetcore-runtime-3.1.4-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f94ccdf-a791-4978-a0e1-0309911f60a4/d734c7f79e6b180b7b91f3d7e78d24d8/aspnetcore-runtime-3.1.4-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae7297ec-38e1-42d2-aa14-2e4d911b0650/fa4654872f079cbab2f0e1d16045b577/aspnetcore-runtime-3.1.4-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68df043e-52ef-414c-99bf-35dfe2c83759/ea6c41fb0ec443a01fbeccf348d64775/aspnetcore-runtime-3.1.4-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1ddc998-933c-47af-b8c7-dc2503e44e91/42d8cd08b2055df52c9457c993911f2e/aspnetcore-runtime-3.1.4-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/82d29bd5-dbde-44bf-bab2-ca2ad773de20/5d33f6c2721fc1588631eeb59237289f/aspnetcore-runtime-3.1.4-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/3bb0854c-541c-46c1-9efa-f26e9dfc701b/b53fb590dca38a967f1b1e12a5c10165/aspnetcore-runtime-3.1.4-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f9598bd0-060a-46c1-b5ce-65f1663f6204/afb4dd9e1377f63a5c124d60fb119764/aspnetcore-runtime-3.1.4-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b0ae36b7-15a2-4ed5-8055-74946bee46cf/b56a70de4576bb3c3af8e15af19b4d70/aspnetcore-runtime-3.1.4-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/adef45e2-4f8f-4880-b1f7-08c63edd640f/cf3e68f27ae8cb1e820af6ecafc24eee/aspnetcore-runtime-3.1.4-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b1d37d39-7eb2-411a-b3ca-9f784d3ab69a/d3001a1986b55d69d52a6e96d3918c29/aspnetcore-runtime-3.1.4-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/5bed16f2-fd1a-4027-bee3-3d6a1b5844cc/dd22ca2820fadb57fd5378e1763d27cd/dotnet-hosting-3.1.4-win.exe

[//]: # ( SDK 3.1.202 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/647e322c-e198-4bff-ba2a-a1a5b8477033/87b7b0af543dba7048a57ee2ab5a31ee/dotnet-sdk-3.1.202-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/15434752-2803-4722-b406-9a62d3e089d5/159bd7713f8a7ff82d7b2f756ae87f4f/dotnet-sdk-3.1.202-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f25da546-fa02-430f-8a90-a306b97654cf/e9bbc498aabfc92db96df09b325769a4/dotnet-sdk-3.1.202-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d4c708b-38db-48b2-8532-9fc8a3ab0e42/23229fd17482119822bd9261b3570d87/dotnet-sdk-3.1.202-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1016a722-2794-4381-88b8-29bf382901be/ea17a73205f9a7d33c2a4e38544935ba/dotnet-sdk-3.1.202-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08088821-e58b-4bf3-9e4a-2c04448eee4b/e6e50aff8769ad382ed279730405ee3e/dotnet-sdk-3.1.202-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20de4099-de97-4123-a2e8-a1700a528f1e/0ad9784f4f4e2ce307a9f175086da997/dotnet-sdk-3.1.202-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/a28cd4b5-0a4e-4123-b8c7-2d18d7cb3d45/5c90ac7db0c3ee6f0696e25edf65f8f7/dotnet-sdk-3.1.202-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f222bff9-8f0a-4720-b9db-7f80c31c6561/5d522c84f2715df94f7a988d8ab547b8/dotnet-sdk-3.1.202-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/090e6423-fe28-48cd-a431-a211d43517aa/7fb2b2d8e7ff32777e189a105c7af396/dotnet-sdk-3.1.202-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/54e11f2e-481c-4923-8f72-68f9f5a39dc6/0557eb054165b0c00e655ed6f2f67bb9/dotnet-sdk-3.1.202-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3db2254d-c77b-44d2-8800-185811647d3b/083a2e65638978f1d97e4f5fe67043e8/dotnet-sdk-3.1.202-win-x86.zip


[//]: # ( Symbols )
