# .NET Core 3.1.4 - May 12, 2020

[.NET Core 3.1.4](https://dotnet.microsoft.com/download/dotnet/3.1) is available for download and usage in your environment. This release includes .NET Core 3.1.4 and .NET Core SDK 3.1.104.

* [Blog Roundup][dotnet-blog]
* [Downloads](https://dotnet.microsoft.com/download/dotnet/3.1)
* [Changes in this release](#changes-in-314)
* [Known issues](../3.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

The .NET Core SDK 3.1.104 includes .NET Core 3.1 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.1.104, the following command will show that you're running version `3.1.104` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4675](https://github.com/dotnet/core/issues/4675) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.4 | [3.1.104](#downloads) |
| Windows | Visual Studio 2019 version 16.5 | [3.1.202](3.1.202-download.md) |
| Windows | Visual Studio 2019 version 16.6 | [3.1.300](3.1.300-sdk.md) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md)
* [dotnet/core/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md)
* [dotnet/core/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)
* [dotnet/aspnetcore](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md)

### Azure App Services

* .NET Core 3.1.4 is being deployed to Azure App Services and the deployment is expected to complete later in May 2020.

## .NET Core Lifecycle News

Ubuntu 20.04 has been added as [supported OS](../3.1-supported-os.md) with this update of .NET Core 3.1.

.NET Core 3.1 is now available natively in the Fedora 32 package archives. See the [Fedora documentation](https://docs.fedoraproject.org/en-US/fedora/f32/release-notes/developers/Development_Dotnet/) for details.

Alpine 3.8 has been out of support since [May 01, 2020](https://wiki.alpinelinux.org/wiki/Alpine_Linux:Releases) and .NET Core no longer provides support for it.

## Changes in 3.1.4

.NET Core 3.1.4 release carries both security and non-security fixes.

### [CVE-2020-1108: .NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-1108)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service vulnerability which exists when .NET Core improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core web application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the .NET Core application.

For more information, see the [Github announcement](https://github.com/dotnet/announcements/issues/156).

### [CVE-2020-1161: ASP.NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-1161)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service vulnerability exists when ASP.NET Core improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against an ASP.NET Core web application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the ASP.NET Core application.

The update addresses the vulnerability by correcting how the ASP.NET Core web application handles web requests.

For more information, see the [Github announcement](https://github.com/aspnet/Announcements/issues/416).

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A3.1.4+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A3.1.4+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/search?q=is%3Apr+label%3AServicing-approved+milestone%3A3.1.4+repo%3Adotnet%2Faspnetcore+repo%3Adotnet%2Fextensions+repo%3Adotnet%2Faspnetcore-tooling+repo%3Adotnet%2Fblazor+repo%3Adotnet%2Fefcore+repo%3Adotnet%2Fef6)
* [Core-Setup](https://github.com/dotnet/core-setup/issues?utf8=✓&q=milestone:3.1.4+label:servicing-approved)

### macOS Notarization Change
  Running "dotnet build" will generate dll instead of binary on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://learn.microsoft.com/dotnet/core/install/macos-notarization-issues). If you want to opt into using the AppHost, please use following:
```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

## Packages updated in this release:

Package name | Version
:----------- | :------------------
EntityFramework | 6.4.4
EntityFramework.SqlServerCompact | 6.4.4
Microsoft.Extensions.Identity.Stores | 3.1.4
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.4
Microsoft.Extensions.Identity.Core | 3.1.4
Microsoft.Extensions.ApiDescription.Client | 3.1.4
dotnet-sql-cache | 3.1.4
AspNetCoreRuntime.3.1.x86 | 3.1.4
AspNetCoreRuntime.3.1.x64 | 3.1.4
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.4
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.4
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.4
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.4
Microsoft.AspNetCore.Authentication.Google | 3.1.4
Microsoft.AspNetCore.Authentication.Facebook | 3.1.4
Microsoft.AspNetCore.Authentication.Certificate | 3.1.4
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.4
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.4
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.4
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.4
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.4
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.4
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.4
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.4
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.4
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.4
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.4
Microsoft.Extensions.ApiDescription.Server | 3.1.4
Microsoft.AspNetCore.Authentication.Twitter | 3.1.4
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.4
Microsoft.AspNetCore.Authorization | 3.1.4
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.4
Microsoft.AspNetCore.Identity.UI | 3.1.4
Microsoft.AspNetCore.JsonPatch | 3.1.4
Microsoft.AspNetCore.Metadata | 3.1.4
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.4
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.4
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.4
Microsoft.AspNetCore.Mvc.Testing | 3.1.4
Microsoft.AspNetCore.NodeServices | 3.1.4
Microsoft.AspNetCore.Owin | 3.1.4
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.4
Microsoft.AspNetCore.SignalR.Client | 3.1.4
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.4
Microsoft.DotNet.Web.Spa.ProjectTemplates | 3.1 | 3.1.4
Microsoft.DotNet.Web.ProjectTemplates | 3.1 | 3.1.4
Microsoft.DotNet.Web.ItemTemplates | 3.1.4
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.4
Microsoft.dotnet-openapi | 3.1.4
Microsoft.AspNetCore.TestHost | 3.1.4
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.4
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.4
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.4
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.4
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.4
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.4
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.4
Microsoft.AspNetCore.SignalR.Common | 3.1.4
Microsoft.AspNetCore.SpaServices | 3.1.4
Microsoft.AspNetCore.Http.Features | 3.1.4
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.4
Microsoft.AspNetCore.Http.Connections.Client | 3.1.4
Microsoft.AspNetCore.Http.Connections.Common | 3.1.4
Microsoft.AspNetCore.Components | 3.1.4
Microsoft.AspNetCore.Components.Authorization | 3.1.4
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.4
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.4
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.4
Microsoft.AspNetCore.Components.Forms | 3.1.4
Microsoft.AspNetCore.Components.Analyzers | 3.1.4
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.4
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.4
Microsoft.AspNetCore.HeaderPropagation | 3.1.4
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.4
Microsoft.AspNetCore.Components.Web | 3.1.4
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.4
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.4
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.4
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.4
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.4
Microsoft.AspNetCore.DataProtection | 3.1.4
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.4
Microsoft.AspNetCore.Cryptography.Internal | 3.1.4
Microsoft.AspNetCore.Connections.Abstractions | 3.1.4
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.4
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.4
Microsoft.AspNetCore.Razor.Language | 3.1.4
Microsoft.CodeAnalysis.Razor | 3.1.4
Microsoft.NET.Sdk.Razor | 3.1.4
Microsoft.EntityFrameworkCore.Tools | 3.1.4
Microsoft.EntityFrameworkCore.InMemory | 3.1.4
Microsoft.EntityFrameworkCore | 3.1.4
Microsoft.EntityFrameworkCore.Abstractions | 3.1.4
Microsoft.EntityFrameworkCore.Analyzers | 3.1.4
Microsoft.EntityFrameworkCore.Cosmos | 3.1.4
Microsoft.EntityFrameworkCore.Design | 3.1.4
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.4
Microsoft.EntityFrameworkCore.Proxies | 3.1.4
Microsoft.EntityFrameworkCore.Relational | 3.1.4
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.4
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.4
Microsoft.EntityFrameworkCore.Sqlite | 3.1.4
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.4
dotnet-ef | 3.1.4
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.4
Microsoft.EntityFrameworkCore.SqlServer | 3.1.4
Microsoft.Data.Sqlite.Core | 3.1.4
Microsoft.Data.Sqlite | 3.1.4
Microsoft.JSInterop | 3.1.4
Microsoft.Extensions.FileProviders.Physical | 3.1.4
Microsoft.Extensions.FileProviders.Embedded | 3.1.4
Microsoft.Extensions.FileProviders.Composite | 3.1.4
Microsoft.Extensions.FileProviders.Abstractions | 3.1.4
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.4
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.4
Microsoft.Extensions.DiagnosticAdapter | 3.1.4
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.4
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.4
Microsoft.Extensions.DependencyInjection | 3.1.4
Microsoft.Extensions.Configuration.Xml | 3.1.4
Microsoft.Extensions.Configuration.UserSecrets | 3.1.4
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.4
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.4
Microsoft.Extensions.Configuration.Json | 3.1.4
Microsoft.Extensions.WebEncoders | 3.1.4
Microsoft.Extensions.Configuration.Ini | 3.1.4
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.4
Microsoft.Extensions.Configuration.CommandLine | 3.1.4
Microsoft.Extensions.Configuration.Binder | 3.1.4
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.4
Microsoft.Extensions.Configuration.Abstractions | 3.1.4
Microsoft.Extensions.Configuration | 3.1.4
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.4
Microsoft.Extensions.Caching.SqlServer | 3.1.4
Microsoft.Extensions.Caching.Memory | 3.1.4
Microsoft.Extensions.Caching.Abstractions | 3.1.4
Microsoft.Extensions.Configuration.FileExtensions | 3.1.4
Microsoft.Extensions.FileSystemGlobbing | 3.1.4
Microsoft.Extensions.Primitives | 3.1.4
Microsoft.Extensions.Options.DataAnnotations | 3.1.4
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.4
Microsoft.Extensions.Options | 3.1.4
Microsoft.Extensions.ObjectPool | 3.1.4
Microsoft.Extensions.Logging.TraceSource | 3.1.4
Microsoft.Extensions.Logging.EventSource | 3.1.4
Microsoft.Extensions.Logging.EventLog | 3.1.4
Microsoft.Extensions.Logging.Debug | 3.1.4
Microsoft.Extensions.Logging.Configuration | 3.1.4
Microsoft.Extensions.Logging.AzureAppServices | 3.1.4
Microsoft.Extensions.Logging.Abstractions | 3.1.4
Microsoft.Extensions.Logging | 3.1.4
Microsoft.Extensions.Localization.Abstractions | 3.1.4
Microsoft.Extensions.Localization | 3.1.4
Microsoft.Extensions.Http.Polly | 3.1.4
Microsoft.Extensions.Http | 3.1.4
Microsoft.Extensions.Hosting.WindowsServices | 3.1.4
Microsoft.Extensions.Hosting.Systemd | 3.1.4
Microsoft.Extensions.Hosting.Abstractions | 3.1.4
Microsoft.Extensions.Hosting | 3.1.4
Microsoft.Extensions.Logging.Console | 3.1.4
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.4
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.4
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.4
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.4
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.4
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.4
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.4
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.4
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.4
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.4
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.4
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.4
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.4
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.4
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.4
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.4
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.4
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.4
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.4
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.4
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.4
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.4
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.4
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.4
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.4
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.4
Microsoft.NETCore.App.Host.linux-arm | 3.1.4
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.4
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.4
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.4
Microsoft.NETCore.App.Host.linux-x64 | 3.1.4
Microsoft.NETCore.App.Host.osx-x64 | 3.1.4
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.4
Microsoft.NETCore.App.Host.win-arm | 3.1.4
Microsoft.NETCore.App.Host.win-arm64 | 3.1.4
Microsoft.NETCore.App.Host.win-x64 | 3.1.4
Microsoft.NETCore.App.Host.win-x86 | 3.1.4
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.4
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.4
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.4
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.4
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.4
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.4
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.4
Microsoft.NETCore.App.Runtime.win-arm | 3.1.4
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.4
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.4
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.4
Microsoft.NETCore.DotNetAppHost | 3.1.4
Microsoft.NETCore.DotNetHost | 3.1.4
Microsoft.NETCore.DotNetHostPolicy | 3.1.4
Microsoft.NETCore.DotNetHostResolver | 3.1.4
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.4
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.4
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.4
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.4
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.4
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.4
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.4
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.4
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.4
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.4
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.4
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.4
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.4
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.4
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.4
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.4
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.4
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.4
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.4
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.4
Microsoft.DotNet.PlatformAbstractions | 3.1.4
Microsoft.NET.HostModel | 3.1.4
Microsoft.Extensions.DependencyModel | 3.1.4
System.Threading.Tasks.Dataflow | 4.11.1
System.Text.Json | 4.7.2
System.Collections.Immutable | 1.7.1
Microsoft.XmlSerializer.Generator | 2.2.1
Microsoft.NETCore.Platforms | 3.1.1
Microsoft.Bcl.AsyncInterfaces | 1.1.1
System.Composition | 1.4.1
System.Composition.AttributedModel | 1.4.1
System.Composition.Convention | 1.4.1
System.Text.Encodings.Web | 4.7.1
System.Text.Encoding.CodePages | 4.7.1
System.Resources.Extensions | 4.7.1
System.Reflection.MetadataLoadContext | 4.7.1
System.Reflection.Metadata | 1.8.1
System.Reflection.DispatchProxy | 4.7.1
System.Threading.Channels | 4.7.1
System.Net.WebSockets.WebSocketProtocol | 4.7.1
System.Json | 4.7.1
System.IO.Pipelines | 4.7.1
System.Diagnostics.DiagnosticSource | 4.7.1
System.Data.OleDb | 4.7.1
System.Composition.TypedParts | 1.4.1
System.Composition.Runtime | 1.4.1
System.Composition.Hosting | 1.4.1
System.Net.Http.WinHttpHandler | 4.7.1
dotnet-svcutil.xmlserializer | 1.2.0

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.4.md
[snap-install]: 3.1.4-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.4-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.4-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://learn.microsoft.com/dotnet/core/install/

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-may-2020/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-1/



[//]: # ( Runtime 3.1.4)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f9c95fa6-0fa0-4fa5-b6f2-e782b4044b76/42cd3637fb99a9ffde1469ef936be0c3/dotnet-runtime-3.1.4-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/da94a32f-8fa7-4df8-b54c-f3442dc2a17a/0badd31a0487b0318a3234baf023aa3c/dotnet-runtime-3.1.4-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/26671baf-7f0d-4b0c-aeaf-ed00f1f1cd39/b4b9f36c3937020834255c3ca55f6ed2/dotnet-runtime-3.1.4-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b86bf782-f36a-435d-8e85-0749e1874c97/0723f572c097721865568117e840d322/dotnet-runtime-3.1.4-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3558096-9333-41fe-9195-0bd5558bde88/7a1ff566cbdab177d49fafcb66f4316b/dotnet-runtime-3.1.4-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b51c2705-f7e1-4a59-b6ba-2a70d9caded3/da2567cee8519d5dc4185cbee8f97498/dotnet-runtime-3.1.4-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/34e036e2-1189-4b34-9a94-bba712581532/60fa96357a11d25d4c75a8d0f107338f/dotnet-runtime-3.1.4-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d93f93da-7d59-4b65-8d02-d60894d69785/1e05bdf2757fb14b82108df98f89bde0/dotnet-runtime-3.1.4-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/32e90964-8aed-4e70-8f30-e6aa5f8f5227/b998e9b6b5701a6dc3c1709bc2862958/dotnet-runtime-3.1.4-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/93d4ac87-6db0-4ddd-9bef-8050067b5e5d/605b178040bdd75b63d021d9387219ea/dotnet-runtime-3.1.4-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d75cf6a6-22e6-4e25-9e87-380417656586/811507607c6999f3a842b27efddd3a01/dotnet-runtime-3.1.4-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/03b8b6cb-c80c-43ea-9136-1156e839bb52/31c13e5a5b028a3c721a50df8f02caf0/dotnet-runtime-3.1.4-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8dbd1e36-4d86-4989-ae0b-d16041575fcd/105512c7459d0ff04cffbb6453657874/dotnet-runtime-3.1.4-win-x86.zip

[//]: # ( WindowsDesktop )
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d8cf1fe3-21c2-4baf-988f-f0152996135e/0c00b94713ee93e7ad5b4f82e2b86607/windowsdesktop-runtime-3.1.4-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2d4b7600-5f32-4a1f-abd5-47cdb2d1362b/7b8b7635e3bb63f6b2cc9a1c624b5325/windowsdesktop-runtime-3.1.4-win-x86.exe

[//]: # ( ASP 3.1.4)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06f9feeb-cd19-49e9-a5cd-a230e1d8c52f/a232fbb4a6e6a90bbe624225e180308a/aspnetcore-runtime-3.1.4-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f94ccdf-a791-4978-a0e1-0309911f60a4/d734c7f79e6b180b7b91f3d7e78d24d8/aspnetcore-runtime-3.1.4-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae7297ec-38e1-42d2-aa14-2e4d911b0650/fa4654872f079cbab2f0e1d16045b577/aspnetcore-runtime-3.1.4-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68df043e-52ef-414c-99bf-35dfe2c83759/ea6c41fb0ec443a01fbeccf348d64775/aspnetcore-runtime-3.1.4-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1ddc998-933c-47af-b8c7-dc2503e44e91/42d8cd08b2055df52c9457c993911f2e/aspnetcore-runtime-3.1.4-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/82d29bd5-dbde-44bf-bab2-ca2ad773de20/5d33f6c2721fc1588631eeb59237289f/aspnetcore-runtime-3.1.4-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/3bb0854c-541c-46c1-9efa-f26e9dfc701b/b53fb590dca38a967f1b1e12a5c10165/aspnetcore-runtime-3.1.4-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f9598bd0-060a-46c1-b5ce-65f1663f6204/afb4dd9e1377f63a5c124d60fb119764/aspnetcore-runtime-3.1.4-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b0ae36b7-15a2-4ed5-8055-74946bee46cf/b56a70de4576bb3c3af8e15af19b4d70/aspnetcore-runtime-3.1.4-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/adef45e2-4f8f-4880-b1f7-08c63edd640f/cf3e68f27ae8cb1e820af6ecafc24eee/aspnetcore-runtime-3.1.4-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b1d37d39-7eb2-411a-b3ca-9f784d3ab69a/d3001a1986b55d69d52a6e96d3918c29/aspnetcore-runtime-3.1.4-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/5bed16f2-fd1a-4027-bee3-3d6a1b5844cc/dd22ca2820fadb57fd5378e1763d27cd/dotnet-hosting-3.1.4-win.exe


[//]: # ( SDK 3.1.104 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/74e61bc8-e8b1-4728-9c56-7d978010e4dd/a3c8533ed97dcfea09fe64e6969cd60c/dotnet-sdk-3.1.104-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7148dc66-dc70-4d6f-ae3d-c65aa8443259/734885b4dafa4097c0b264ca20be7e26/dotnet-sdk-3.1.104-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6fc7ce85-b14f-4718-9a9e-cdcf3c74f1ed/312edf594fe97da6ccdede646e18d479/dotnet-sdk-3.1.104-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c9c8cca6-2281-4ce8-980f-f49723057f09/06fef88edc9d38fbfefc315953e368ea/dotnet-sdk-3.1.104-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5b9e32f2-51fb-46fd-84c1-60e22a0ddb25/e3ec8fe853079bad6f3c4668754673ee/dotnet-sdk-3.1.104-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c067f1f7-0be9-4178-9dbd-b4029a337961/ddfd7200138fca35ba1786d713bb21bd/dotnet-sdk-3.1.104-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a8a4aa8f-35f9-4aaf-866e-755032f0a1c7/8af868783d6dfb81d1cb568558158225/dotnet-sdk-3.1.104-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/760831c2-779f-4a3e-8a0e-5a92af17ef0f/83b7d9d1295c6c31913f4878485c52b4/dotnet-sdk-3.1.104-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/fd156376-5a4a-4034-b3a3-4982a8d86f6a/26af9295c17ea10ed3b57ab0738bf819/dotnet-sdk-3.1.104-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e6f1ffa8-2025-436c-b368-49d5235d3c53/81da2fa5b34e27e99127a49823dbfe48/dotnet-sdk-3.1.104-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/772b8bd7-2e36-48ee-ad40-ccaedc9afe93/e924b0e63b91e5f211c4605f370a8d0b/dotnet-sdk-3.1.104-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c29c71b2-87fd-4054-89d1-48c257265d03/ef377454ac4a0d520cd97950d0d006fc/dotnet-sdk-3.1.104-win-x86.zip

[//]: # ( Symbols )
