# .NET Core 3.1.6 - July 14, 2020

[.NET Core 3.1.6](https://dotnet.microsoft.com/download/dotnet/3.1) is available for download and usage in your environment. This release includes .NET Core 3.1.6 and .NET Core SDK 3.1.106.

* [Blog Roundup][dotnet-blog]
* [Downloads](https://dotnet.microsoft.com/download/dotnet/3.1)
* [Changes in this release](#changes-in-316)
* [Known issues](../3.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

The .NET Core SDK 3.1.106 includes .NET Core 3.1 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.1.106, the following command will show that you're running version `3.1.106` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4939](https://github.com/dotnet/core/issues/4939) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.6 | [3.1.302](3.1.302-download.md) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.106](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md)
* [dotnet/core/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md)
* [dotnet/core/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)
* [dotnet/aspnetcore](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md)

### Azure App Services

* .NET Core 3.1.6 is being deployed to Azure App Services and the deployment is expected to complete later in July 2020.

## Changes in 3.1.6

.NET Core 3.1.6 release carries both security and non-security fixes.

### [CVE-2020-1147 | NET Core Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-1147)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a remote code execution vulnerability exists in .NET software when the software fails to check the source markup of an XML file. An attacker who successfully exploited the vulnerability could run arbitrary code in the context of the current user.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to an ASP.NET Core application, or other application that parses certain types of XML.

The security update addresses the vulnerability by restricting the types that are allowed to be present in the XML payload.

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A3.1.6+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A3.1.6+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/search?q=is%3Apr+label%3AServicing-approved+milestone%3A3.1.6+repo%3Adotnet%2Faspnetcore+repo%3Adotnet%2Fextensions+repo%3Adotnet%2Faspnetcore-tooling+repo%3Adotnet%2Fblazor+repo%3Adotnet%2Fefcore+repo%3Adotnet%2Fef6)
* [Winforms](https://github.com/dotnet/winforms/issues?utf8=%E2%9C%93&q=milestone:3.1.6+label:servicing-approved)

### macOS Notarization Change

  Running "dotnet build" will generate dll instead of binary on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://learn.microsoft.com/dotnet/core/install/macos-notarization-issues). If you want to opt into using the AppHost, please use following:

```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.6.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.6.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.6.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.6.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.6.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.6.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.6.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.6.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.6.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.6.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.6.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.6.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.6.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.6.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.6.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.6.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.6.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.6.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.6.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.6.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.6.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.6.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.6.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.6.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.6.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.6.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.6.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.6.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.6.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.6.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.6.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.6.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.6.nupkg
Microsoft.NET.HostModel | 3.1.6.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.6.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.6.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.6.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.6.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.6.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.6.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.6.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.6.nupkg
Microsoft.DotNet.PlatformAbstractions | 3.1.6.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.6.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.6.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.6.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.6.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.6.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.6.nupkg
Microsoft.NETCore.DotNetHost | 3.1.6.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.6.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.6.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.6.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.6.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.6.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.6.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.6.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.6.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.6.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.6.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.6.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.6.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.6.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.6.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.6.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.6.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.6.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.6.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.6.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.6.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.6.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.6.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.6.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.6.nupkg
Microsoft.Extensions.DependencyModel | 3.1.6.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.6.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.6.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.6.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.6.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.6.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.6.nupkg
Microsoft.AspNetCore.TestHost | 3.1.6.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.6.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.6.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.6.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.6.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.6.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.6.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.6.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.6.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.6.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.6.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.6.nupkg
Microsoft.Authentication.WebAssembly.Msal | 3.2.1.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.6.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.6.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.6.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 3.2.1.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 3.2.1.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.6.nupkg
Microsoft.JSInterop.WebAssembly | 3.2.1.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.6.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.6.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.6.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.6.nupkg
Microsoft.AspNetCore.Owin | 3.1.6.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.6.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.6.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.6.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.6.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.6.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.6.nupkg
Microsoft.Extensions.Identity.Core | 3.1.6.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.6.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.6.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.6.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.6.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.6.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.6.nupkg
Microsoft.AspNetCore.Authorization | 3.1.6.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.6.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.6.nupkg
dotnet-sql-cache | 3.1.6.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.6.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.6.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.6.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.6.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.6.nupkg
Microsoft.dotnet-openapi | 3.1.6.nupkg
Microsoft.AspNetCore.Components | 3.1.6.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.6.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.6.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Templates | 3.2.1.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.6.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.6.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.6.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.6.nupkg
Microsoft.AspNetCore.Metadata | 3.1.6.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.6.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.6.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 3.2.1.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.6.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.6.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.6.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.6.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.6.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.6.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.6.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.6.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.6.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.6.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.6.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.6.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.6.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.6.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Build | 3.2.1.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DebugProxy | 3.2.1.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 3.2.1.nupkg
Microsoft.AspNetCore.Components.WebAssembly.HttpHandler | 3.2.1.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Runtime | 3.2.0.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.6.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.6.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.6.nupkg
Microsoft.NET.Sdk.Razor | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.6.nupkg
dotnet-ef | 3.1.6.nupkg
Microsoft.Data.Sqlite.Core | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.6.nupkg
Microsoft.EntityFrameworkCore | 3.1.6.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.6.nupkg
Microsoft.Data.Sqlite | 3.1.6.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.6.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.6.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.6.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.6.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.6.nupkg
Microsoft.Extensions.Configuration | 3.1.6.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.6.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.6.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.6.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.6.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.6.nupkg
Microsoft.Extensions.WebEncoders | 3.1.6.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.6.nupkg
Microsoft.Extensions.Primitives | 3.1.6.nupkg
Microsoft.Extensions.ObjectPool | 3.1.6.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.6.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.6.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.6.nupkg
Microsoft.JSInterop | 3.1.6.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.6.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.6.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.6.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.6.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.6.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.6.nupkg
Microsoft.Extensions.Localization | 3.1.6.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.6.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.6.nupkg
Microsoft.Extensions.Logging | 3.1.6.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.6.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.6.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.6.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.6.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.6.nupkg
Microsoft.Extensions.Options | 3.1.6.nupkg
Microsoft.Extensions.Logging.Console | 3.1.6.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.6.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.6.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.6.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.6.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.6.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.6.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.6.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.6.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.6.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.6.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.6.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.6.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.6.nupkg
Microsoft.Extensions.Http.Polly | 3.1.6.nupkg
Microsoft.Extensions.Http | 3.1.6.nupkg
Microsoft.Extensions.Hosting | 3.1.6.nupkg

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.6.md
[snap-install]: 3.1.6-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.6-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.6-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://learn.microsoft.com/dotnet/core/install/

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-june-2020-updates-2-1-19-and-3-1-5/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-1/

[//]: # ( Runtime 3.1.6)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/61d5be60-d855-4125-bce5-668dca9aefce/f91eb908b962e442532b6cd9e534a082/dotnet-runtime-3.1.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9ad80afc-8284-499d-a65e-b94e3a16f273/1ed772df6ba063852e74c113b73497a5/dotnet-runtime-3.1.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/562b2474-33f3-49a5-9272-e6b3a6e2149e/17049664f4fc64e78dee7aee0fd33b96/dotnet-runtime-3.1.6-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fbd093b6-1da8-4d4c-b6f7-37f9fad34f6e/1860e76742a5cb2a0261f19a37fcdf4d/dotnet-runtime-3.1.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7c2978aa-1a4c-4fb0-a7cd-1dbaf1ce405d/c54e21f55dfa49d2ccdb599fa2edb9ed/dotnet-runtime-3.1.6-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/913dab92-cfee-4014-bc48-d520b44731c0/1e8734857e417362484c7b8f35563946/dotnet-runtime-3.1.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d1a67dcf-12d9-4ecd-86a4-c4a659f0eebf/519db8ce56503d551d35ef9378239c70/dotnet-runtime-3.1.6-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/72fb69dc-0e47-4e48-a41f-bb1be044b304/48713906e9ab72f5f75fc2093045be2e/dotnet-runtime-3.1.6-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/4f3e9a48-a899-413e-8672-19228c591585/a1a018600cd27aa71892c60cc39b98cb/dotnet-runtime-3.1.6-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/518aafee-1285-4153-a30a-e4eefd538c90/6437d77a67b9c6b8cf0b7b3323004229/dotnet-runtime-3.1.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f01755a3-b9cf-4d63-acdd-e331337548d6/ab5385bc8a555e741bc093b3459015b7/dotnet-runtime-3.1.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/717d875c-557e-4d61-a201-8822a2fe8003/ca8639545eb797adfdb8106d8f1a0791/dotnet-runtime-3.1.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dcbf81b8-85d5-4180-8697-ce5a3efb61cb/82208fc57e6c57e336ec4caa7320e785/dotnet-runtime-3.1.6-win-x86.zip

[//]: # ( WindowsDesktop 3.1.6)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3eb7efa1-96c6-4e97-bb9f-563ecf595f8a/7efd9c1cdd74df8fb0a34c288138a84f/windowsdesktop-runtime-3.1.6-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d5fc4fb5-7374-4886-8815-68b7bf788b5b/3aeb172d4a3c5e01078738440442f4c7/windowsdesktop-runtime-3.1.6-win-x86.exe

[//]: # ( ASP 3.1.6)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/92e90ed5-dba3-427b-a876-8b46fe5e16b6/69cae4fe4a0ec6bc7585de6fa889fd66/aspnetcore-runtime-3.1.6-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/76829580-79b2-4ec5-97ff-1a733936af14/6ba68613c7491951b896396f7d7490d9/aspnetcore-runtime-3.1.6-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/390902a9-f6b5-4351-bffc-c1b6e367be82/f30075e5fbf8530310fcf6d9ddeca760/aspnetcore-runtime-3.1.6-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/34014520-3b9c-43a0-bc79-a5323655e235/fda26e0a67b9cf21ad648ff0c6259668/aspnetcore-runtime-3.1.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9eadec7a-dd7e-476d-a348-c4bf946a0bad/c11b5123931ee17faba27e5debe74731/aspnetcore-runtime-3.1.6-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/23d6c3a0-6c26-4bfa-80fb-8204c4d214c3/7e34432dca2915d823acb07287f75238/aspnetcore-runtime-3.1.6-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/d5eab265-5a44-4cc4-a311-e25005abd99c/c4bc72c27498ab0e82b41f4e094f876b/aspnetcore-runtime-3.1.6-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/08874f02-fa49-4601-8234-a4adaf7be8ac/ad7e7cda61502321c08b99e297de334f/aspnetcore-runtime-3.1.6-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ef32bac8-be30-4609-b801-59744b9b8270/f5e2bf611cb36f4141d849ec583dc554/aspnetcore-runtime-3.1.6-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ac814d0a-67b7-4ef2-86c7-27afbdbf68a0/655424a5eb8f37b330b46130cb9e795b/aspnetcore-runtime-3.1.6-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/402055ae-4406-46c4-be5e-19d67daf6f15/ab82f9b8e11093d082c23150a94bd8cf/aspnetcore-runtime-3.1.6-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/9b9f4a6e-aef8-41e0-90db-bae1b0cf4e34/4ab93354cdff8991d91a9f40d022d450/dotnet-hosting-3.1.6-win.exe


[//]: # ( SDK 3.1.106 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ad10d24d-9823-42fc-bf2a-1d598d8999c6/80f944ded4c6d3fd73cd6a00f6ae660f/dotnet-sdk-3.1.106-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/026fec12-345b-4c61-8731-1c0184594fc3/1738a6c43d2739dc6c2a9ec5caf0c41f/dotnet-sdk-3.1.106-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aa3855cc-b349-44c6-b2dc-3df0869c75a8/41344d5ee53573d1f3b1a8d22a556c2f/dotnet-sdk-3.1.106-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/03bf81cd-0275-4998-8a24-dc359fc5fed3/7450f821f9cd33c205378e1a0a5b2cb2/dotnet-sdk-3.1.106-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ac3bd3ba-6a6c-4eff-a51c-835fce92b9db/77db90a6e13a5fe71dcea5d86a496fc2/dotnet-sdk-3.1.106-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b51a04b2-1eb7-43d6-b1d7-31357f3499a2/410069a1ed2f60756de1ae7f3af2bfe4/dotnet-sdk-3.1.106-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/13e74702-4d23-416a-9651-554c967103ce/6e4662d42731a5ec57468d1e737c4473/dotnet-sdk-3.1.106-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/d3106be4-c42d-4e32-bd0f-5a419eeaf404/6df81d89b95b6c4c61cdf49d3d4c2f9d/dotnet-sdk-3.1.106-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/370096bd-b9ec-4752-b7ae-04817f14458e/aa285c99dcdd9c4c736106870a781e4b/dotnet-sdk-3.1.106-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/30db76c1-f2fa-4139-ab52-591e3286f21b/73a95638aaf5eef5c7c66088ca9ad0fa/dotnet-sdk-3.1.106-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/242ed6f4-c944-404f-ba39-63f149616483/c12ace48b97248d0d0124edd8322f0c6/dotnet-sdk-3.1.106-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/472121cf-0125-4a48-90fa-8c5e9dbfd910/c29e5a3a35eb3d0a6dbe2c23fac49a8a/dotnet-sdk-3.1.106-win-x86.zip
