# .NET Core 3.1.7 - August 11, 2020

[.NET Core 3.1.7](https://dotnet.microsoft.com/download/dotnet/3.1) is available for download and usage in your environment. This release includes .NET Core 3.1.7 and .NET Core SDK 3.1.107.

* [Blog Roundup][dotnet-blog]
* [Downloads](https://dotnet.microsoft.com/download/dotnet/3.1)
* [Changes in this release](#changes-in-317)
* [Known issues](../3.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

The .NET Core SDK 3.1.107 includes .NET Core 3.1 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.1.107, the following command will show that you're running version `3.1.107` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5057](https://github.com/dotnet/core/issues/5057) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.401](3.1.401-download.md) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.107](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md)
* [dotnet/core/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md)
* [dotnet/core/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)
* [dotnet/aspnetcore](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md)

### Azure App Services

* .NET Core 3.1.7 is being deployed to Azure App Services and the deployment is expected to complete later in August 2020.


## Changes in 3.1.7

.NET Core 3.1.7 release carries both security and non-security fixes.

### [CVE-2020-1597 | NET Core Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-1597)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when ASP.NET Core improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against an ASP.NET Core web application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the ASP.NET Core application.

The update addresses the vulnerability by correcting how the ASP.NET Core web application handles web requests.

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A3.1.7+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A3.1.7+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/search?q=is%3Apr+label%3AServicing-approved+milestone%3A3.1.7+repo%3Adotnet%2Faspnetcore+repo%3Adotnet%2Fextensions+repo%3Adotnet%2Faspnetcore-tooling+repo%3Adotnet%2Fblazor+repo%3Adotnet%2Fefcore+repo%3Adotnet%2Fef6)

### macOS Notarization Change
  Running "dotnet build" will generate a dll instead of a dylib on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://learn.microsoft.com/dotnet/core/install/macos-notarization-issues). If you want to opt into using the AppHost, please use following:
```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.7.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.7.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.7.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.7.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.7.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.7.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.7.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.7.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.7.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.7.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.7.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.7.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.7.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.7.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.7.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.7.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.7.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.7.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.7.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.7.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.7.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.7.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.7.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.7.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.7.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.7.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.7.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.7.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.7.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.7.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.7.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.7.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.7.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.7.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.7.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.7.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.7.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.7.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.7.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.7.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.7.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.7.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.7.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.7.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.7.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.7.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.7.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.7.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.7.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.7.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.7.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.7.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.7.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.7.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.7.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.7.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.7.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.7.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.7.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.7.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.7.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.7.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.7.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.7.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.7.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.7.nupkg
Microsoft.NETCore.DotNetHost | 3.1.7.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.7.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.7.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.7.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.7.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.7.nupkg
System.Data.SqlClient | 4.8.2.nupkg
Microsoft.IO.Redist | 4.7.1.nupkg
Microsoft.NETCore.Platforms | 3.1.2.nupkg
Microsoft.Windows.Compatibility | 3.1.1.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.7.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.7.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.7.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.7.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.7.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.7.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.7.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.7.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.7.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.7.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.7.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.7.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.7.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.7.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.7.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.7.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.7.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.7.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.7.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.7.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.7.nupkg
Microsoft.AspNetCore.Authorization | 3.1.7.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.7.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.7.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.7.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.7.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.7.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.7.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.7.nupkg
Microsoft.dotnet-openapi | 3.1.7.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.7.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.7.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.7.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.7.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.7.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.7.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.7.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.7.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.7.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.7.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.7.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.7.nupkg
Microsoft.Extensions.Identity.Core | 3.1.7.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.7.nupkg
dotnet-sql-cache | 3.1.7.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.7.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.7.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.7.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.7.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.7.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.7.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.7.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.7.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.7.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.7.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.7.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.7.nupkg
Microsoft.AspNetCore.Metadata | 3.1.7.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.7.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.7.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.7.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.7.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.7.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.7.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.7.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.7.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.7.nupkg
Microsoft.AspNetCore.Owin | 3.1.7.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.7.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.7.nupkg
Microsoft.AspNetCore.TestHost | 3.1.7.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.7.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.7.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.7.nupkg
Microsoft.AspNetCore.Components | 3.1.7.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.7.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.7.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.7.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.7.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.7.nupkg
Microsoft.NET.Sdk.Razor | 3.1.7.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.7.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.7.nupkg
Microsoft.Data.Sqlite.Core | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.7.nupkg
Microsoft.EntityFrameworkCore | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.7.nupkg
dotnet-ef | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.7.nupkg
Microsoft.Data.Sqlite | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.7.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.7.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.7.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.7.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.7.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.7.nupkg
Microsoft.Extensions.WebEncoders | 3.1.7.nupkg
Microsoft.Extensions.Configuration | 3.1.7.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.7.nupkg
Microsoft.Extensions.Primitives | 3.1.7.nupkg
Microsoft.Extensions.Options | 3.1.7.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.7.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.7.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.7.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.7.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.7.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.7.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.7.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.7.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.7.nupkg
Microsoft.Extensions.ObjectPool | 3.1.7.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.7.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.7.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.7.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.7.nupkg
Microsoft.Extensions.Http.Polly | 3.1.7.nupkg
Microsoft.Extensions.Http | 3.1.7.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.7.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.7.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.7.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.7.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.7.nupkg
Microsoft.Extensions.Localization | 3.1.7.nupkg
Microsoft.Extensions.Hosting | 3.1.7.nupkg
Microsoft.JSInterop | 3.1.7.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.7.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.7.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.7.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.7.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.7.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.7.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.7.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.7.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.7.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.7.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.7.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.7.nupkg
Microsoft.Extensions.Logging.Console | 3.1.7.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.7.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.7.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.7.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.7.nupkg
Microsoft.Extensions.Logging | 3.1.7.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.7.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.7.md
[snap-install]: 3.1.7-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.7-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.7-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://learn.microsoft.com/dotnet/core/install/

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-august-2020/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-1/


[//]: # ( Runtime 3.1.7)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/69984653-402e-442c-9588-eb92560d0fce/5ad7995a09334dd2ee56f00fb6dc0521/dotnet-runtime-3.1.7-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e0982947-c956-4c44-b94a-3ecc13d7aa64/28f9a7f461d5aac85121492ba4513517/dotnet-runtime-3.1.7-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d56c7d29-8122-4e5d-8b0a-030aa5290d3f/5810b5c16c76deface341885710d2980/dotnet-runtime-3.1.7-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/323a09ee-4171-4376-abcd-40bf12e20b1f/70ce498e556a40cd37774a083b73af5b/dotnet-runtime-3.1.7-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e42ed5c3-d7a3-404d-a242-cfd10ef626ff/b723e456ffaf60b6df6c6d5b0a792aba/dotnet-runtime-3.1.7-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/182b16ca-1334-40af-a1ca-8e4a9cb07c63/5368671138c576ad48c6e7715e929203/dotnet-runtime-3.1.7-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f4677b54-3e9d-4d23-9153-6f75db881e67/2ab1f6fe3a982f683a8c7aa163861af7/dotnet-runtime-3.1.7-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bd7ec684-d8c2-4fa8-99f5-eb12321ad85b/8e593dc79ebfa2ffdc397620feeecb0f/dotnet-runtime-3.1.7-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/9cefa036-0ba8-4929-a0f8-6676dcdd8585/c23ffac90ddc2ada5dd94d9c3073db07/dotnet-runtime-3.1.7-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c9326fc1-401a-4957-8fc4-9594b141de91/fe32ec0c9f2974ef72af7c3e2c7232cb/dotnet-runtime-3.1.7-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8eaa2801-8ee8-49ee-9615-520164098473/e706f903c0f4df8752a70b06771a4bdf/dotnet-runtime-3.1.7-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8966b729-62af-4cf1-ac51-9ba6eb0a7c78/4f3c1603e41c0b8fb799837f55e6b3fd/dotnet-runtime-3.1.7-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d21813b5-cee7-499d-a9f0-583f66e8cef9/c3e2a452c7ed781aba9b17778b5ddae6/dotnet-runtime-3.1.7-win-x86.zip

[//]: # ( WindowsDesktop 3.1.7)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5e4695fb-da51-4fa8-a090-07a64480888c/65aa842670d2280b5d05b8a070a9f495/windowsdesktop-runtime-3.1.7-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3e6c8a13-9d89-4991-b683-b6bb279bc096/d1c44ba0c34f2be8878c36d27287e1a5/windowsdesktop-runtime-3.1.7-win-x86.exe

[//]: # ( ASP 3.1.7)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ed60e45-f93a-4a8b-ab92-4034fcf00618/cf2aafe9bc91f28bd4d7b7436c31e27e/aspnetcore-runtime-3.1.7-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d8bf507-759a-4cc6-92ae-8ef63478398a/6b298aad0f6ce04ebc09daa1007a4248/aspnetcore-runtime-3.1.7-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/261de71f-9189-4e0f-8da7-0d63d556b610/f149cc9d18e934ecb888dbebfc96c388/aspnetcore-runtime-3.1.7-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5111d26b-6749-452d-a6b2-456161b6d29f/ed5f7a9d0b2903e028def142dd70ccd0/aspnetcore-runtime-3.1.7-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e7d0601d-41b4-483f-b411-f2b42708054a/191b56b81e1830b413d0794728831eea/aspnetcore-runtime-3.1.7-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b0365f9c-270c-4454-9b92-1d455d402c72/c41415c12b649360a6ad20067b04c8f0/aspnetcore-runtime-3.1.7-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/80863826-3ba1-40f5-898e-c71bb5190a48/0ae020ed49cf8fce8697f284f632c820/aspnetcore-runtime-3.1.7-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4957d824-3b3b-497a-b499-55022088ed93/b2ee157a32d7718897024d03b7126b59/aspnetcore-runtime-3.1.7-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7fb1dd11-760b-4f3c-ac98-2a708b713278/d8bd66ce86ebb551df553b3d6a2be3eb/aspnetcore-runtime-3.1.7-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/367c9699-606d-4671-a3e8-d13f943d620a/d9873b044b80613cbfa642f28d6bec0f/aspnetcore-runtime-3.1.7-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1d8ee077-6f24-418d-9012-a727dba47ea0/88ae0a647770d08098713684940a0970/aspnetcore-runtime-3.1.7-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/21a5322f-cf9c-40e0-af41-4cdf14b3fb17/ff1390906525099bcd6b322279e09938/dotnet-hosting-3.1.7-win.exe

[//]: # ( SDK 3.1.107 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/41775681-e8a1-4cdd-b1d2-967c25d2b5d6/7b968b58d157f7159ec4b6466c76ff02/dotnet-sdk-3.1.107-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6e1897f2-8de1-41f2-828e-f2651d6448f9/c25e59f180ffb6a31d5e3f0a163391a0/dotnet-sdk-3.1.107-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7642623-dc1a-4412-b76f-8fa72dd9869e/6eaab442916da0a323c61abcaf3b0443/dotnet-sdk-3.1.107-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b8ea2bd6-57e1-41cd-a369-c0fa1a2e42cb/ca094f98bc3c6388d048f0633f6f0f79/dotnet-sdk-3.1.107-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c3a5c00c-b027-4044-a163-916fc0c91280/bd06737d89c367c077a4d009e1641cf1/dotnet-sdk-3.1.107-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/169ecfbc-628f-443a-a7ba-ded8e3aa4a4e/87e226f50b2994380ff68e9e45b71951/dotnet-sdk-3.1.107-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d60eb84b-4bbb-4790-8c95-e26e453ab8fa/debb3ffdf950de7fef845fea0324e17a/dotnet-sdk-3.1.107-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/f7c833d6-5b28-4195-bd5f-b7577718704e/3ee90219c66a14578328412aca24b1fe/dotnet-sdk-3.1.107-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e24a5908-d199-4575-b94b-5828bbbc956e/bc1b7a8c4e06a18780eeb15925aaee9b/dotnet-sdk-3.1.107-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9c531141-ea78-4f81-8408-955d81ce60c6/f328307a22d51047fba09cb2fac7ffa9/dotnet-sdk-3.1.107-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/20000b4c-0e06-4c0c-8807-e74e7c442c99/1b83eabbf3083df54f3fe3beb562d61d/dotnet-sdk-3.1.107-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6c42e3c1-24b4-49f5-9e93-7249d5bd652c/bddf51de5b9148aafab9c8301c3661db/dotnet-sdk-3.1.107-win-x86.zip
