# .NET Core 3.1.8 - September 08, 2020

[.NET Core 3.1.8](https://dotnet.microsoft.com/download/dotnet/3.1) is available for download and usage in your environment. This release includes .NET Core 3.1.8 and .NET Core SDK 3.1.108.

* [Blog Roundup][dotnet-blog]
* [Downloads](https://dotnet.microsoft.com/download/dotnet/3.1)
* [Changes in this release](#changes-in-318)
* [Known issues](../3.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

The .NET Core SDK 3.1.108 includes .NET Core 3.1 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.1.108, the following command will show that you're running version `3.1.108` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5170](https://github.com/dotnet/core/issues/5170) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.402](3.1.402-download.md) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.108](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md)
* [dotnet/core/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md)
* [dotnet/core/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)
* [dotnet/aspnetcore](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md)

### Azure App Services

* .NET Core 3.1.8 is being deployed to Azure App Services and the deployment is expected to complete later in September 2020.


## Changes in 3.1.8

.NET Core 3.1.8 release carries both security and non-security fixes.

### [CVE-2020-1045 | Microsoft ASP.NET Core Security Feature Bypass Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-1045)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A security feature bypass vulnerability exists in the way Microsoft ASP.NET Core parses encoded cookie names.

The ASP.NET Core cookie parser decodes the cookie name which could allow a malicious attacker to use percent encoded characters to masquerade as a different cookie with different security features.

The security update addresses the vulnerability by fixing the way the ASP.NET Core cookie parser handles encoded names.

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A3.1.8+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A3.1.8+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/search?q=is%3Apr+label%3AServicing-approved+milestone%3A3.1.8+repo%3Adotnet%2Faspnetcore+repo%3Adotnet%2Fextensions+repo%3Adotnet%2Faspnetcore-tooling+repo%3Adotnet%2Fblazor+repo%3Adotnet%2Fefcore+repo%3Adotnet%2Fef6)

### macOS Notarization Change
  Running "dotnet build" will generate a dll instead of a dylib on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://learn.microsoft.com/dotnet/core/install/macos-notarization-issues). If you want to opt into using the AppHost, please use following:
```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.8.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.8.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.8.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.8.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.8.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.8.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.8.nupkg
Microsoft.NETCore.DotNetHost | 3.1.8.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.8.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.8.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.8.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.8.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.8.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.8.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.8.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.8.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.8.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.8.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.8.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.8.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.8.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.8.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.8.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.8.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.8.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.8.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.8.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.8.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.8.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.8.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.8.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.8.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.8.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.8.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.8.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.8.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.8.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.8.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.8.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.8.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.8.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.8.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.8.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.8.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.8.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.8.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.8.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.8.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.8.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.8.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.8.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.8.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.8.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.8.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.8.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.8.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.8.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.8.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.8.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.8.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.8.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.8.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.8.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.8.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.8.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.8.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.8.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.8.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.8.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.8.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.8.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.8.nupkg
Microsoft.NETCore.Platforms | 3.1.3.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.8.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.8.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.8.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.8.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.8.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.8.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.8.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.8.nupkg
Microsoft.dotnet-openapi | 3.1.8.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.8.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.8.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.8.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.8.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.8.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.8.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.8.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.8.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.8.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.8.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.8.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.8.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.8.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.8.nupkg
Microsoft.Extensions.Identity.Core | 3.1.8.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.8.nupkg
Microsoft.AspNetCore.Metadata | 3.1.8.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.8.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.8.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.8.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.8.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.8.nupkg
Microsoft.AspNetCore.Components | 3.1.8.nupkg
Microsoft.AspNetCore.Authorization | 3.1.8.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.8.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.8.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.8.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.8.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.8.nupkg
Microsoft.AspNetCore.Owin | 3.1.8.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.8.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.8.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.8.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.8.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.8.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.8.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.8.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.8.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.8.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.8.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.8.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.8.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.8.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.8.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.8.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.8.nupkg
Microsoft.AspNetCore.TestHost | 3.1.8.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.8.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.8.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.8.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.8.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.8.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.8.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.8.nupkg
dotnet-sql-cache | 3.1.8.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.8.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.8.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.8.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.8.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.8.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.8.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.8.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.8.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.8.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.8.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.8.nupkg
Microsoft.AspNetCore.App.Ref | 3.1.8.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.8.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.8.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.8.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.8.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.8.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.8.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.8.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.8.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.8.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.8.nupkg
Microsoft.NET.Sdk.Razor | 3.1.8.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.8.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.8.nupkg
Microsoft.Data.Sqlite.Core | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.8.nupkg
Microsoft.Data.Sqlite | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.8.nupkg
dotnet-ef | 3.1.8.nupkg
Microsoft.EntityFrameworkCore | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.8.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.8.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.8.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.8.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.8.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.8.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.8.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.8.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.8.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.8.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.8.nupkg
Microsoft.JSInterop | 3.1.8.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.8.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.8.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.8.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.8.nupkg
Microsoft.Extensions.Primitives | 3.1.8.nupkg
Microsoft.Extensions.Options | 3.1.8.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.8.nupkg
Microsoft.Extensions.Http | 3.1.8.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.8.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.8.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.8.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.8.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.8.nupkg
Microsoft.Extensions.Logging | 3.1.8.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.8.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.8.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.8.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.8.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.8.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.8.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.8.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.8.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.8.nupkg
Microsoft.Extensions.Hosting | 3.1.8.nupkg
Microsoft.Extensions.Http.Polly | 3.1.8.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.8.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.8.nupkg
Microsoft.Extensions.Configuration | 3.1.8.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.8.nupkg
Microsoft.Extensions.WebEncoders | 3.1.8.nupkg
Microsoft.Extensions.ObjectPool | 3.1.8.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.8.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.8.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.8.nupkg
Microsoft.Extensions.Localization | 3.1.8.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.8.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.8.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.8.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.8.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.8.nupkg
Microsoft.Extensions.Logging.Console | 3.1.8.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.8.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.8.md
[snap-install]: 3.1.8-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.8-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.8-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-september-2020/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-1/


[//]: # ( Runtime 3.1.8)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3f331a87-d2e9-46c1-b7ef-369f8540e966/2e534214982575ee3c79a9ce9f9a4483/dotnet-runtime-3.1.8-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aa592fad-b5ef-428e-89b4-7a38cdabb787/1f97cb89b880e222fad432ffefe4a36c/dotnet-runtime-3.1.8-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/02bf5a05-bcf0-4efa-a447-7e22ab095ca9/76879859f7e32da1976c9877188feb37/dotnet-runtime-3.1.8-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd533aaa-9707-4188-8381-96a37e1102b8/9df9516fd0ebb7e324c5779d035a59a3/dotnet-runtime-3.1.8-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e4e47a0a-132e-416a-b8eb-f3373ad189d9/43af4412e27696c3c16e50f496f6c7af/dotnet-runtime-3.1.8-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c7360900-c6b2-403a-b1e8-ca41bad62fda/1c530d962da48b1f8bc7ad857683c354/dotnet-runtime-3.1.8-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d40f886c-8ddd-41e0-94cc-965b8fe861c1/d4f12ce3bef0a2f1ba5a2806c3987ed6/dotnet-runtime-3.1.8-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/35574a96-e5c0-4875-b575-da5f143d3831/6b9bd13de6e67a75b23441c21ade7885/dotnet-runtime-3.1.8-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/3c2e85bc-4ba4-48ad-aa6a-ade1b0efba53/fd2505372c3958e11b15946748bbfb44/dotnet-runtime-3.1.8-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e97d7732-c06a-4643-a38d-648a84b11469/1a2a148ed597c162945b348102927cb0/dotnet-runtime-3.1.8-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/962e31ec-a17f-4420-9a07-131b4fa2c92e/7e33ff11e950b03085d7ac33f4f7a1ab/dotnet-runtime-3.1.8-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ae01518b-55e7-4739-a2ab-fd09866069cf/0341c091719e4a41fd388a32b91bfc02/dotnet-runtime-3.1.8-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c781ea3d-e64f-48ce-b80e-1027c492bb82/5ef1a8dfed21f600d1c21b413c66bf43/dotnet-runtime-3.1.8-win-x86.zip

[//]: # ( WindowsDesktop 3.1.8)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/add2ffbe-a288-4d47-8b09-a39c8645f505/8516700dd5bd85fe07e8010e55d8f653/windowsdesktop-runtime-3.1.8-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/712f4ec2-79a4-4897-af5b-6c814dd49741/2025ef17bfc218cce1699787352d84b8/windowsdesktop-runtime-3.1.8-win-x86.exe

[//]: # ( ASP 3.1.8)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/390b186e-eefc-4dab-a5bb-1c549970771b/6dacdae3ab014ed7e2d7f10e233211db/aspnetcore-runtime-3.1.8-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/251cd0f7-2655-4f04-940d-6fb852c4389d/65f8897905e79ee9306be9428dad88fe/aspnetcore-runtime-3.1.8-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ee24557-166d-4ace-9f0c-41fda4fbaa02/dfba7792005f57fec05de0b644667c11/aspnetcore-runtime-3.1.8-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/afcea1e4-262f-4f26-9e6b-5f820d9822e3/b7a7e1ed4384d3daf1e4da6811e7961f/aspnetcore-runtime-3.1.8-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7c8f82a-8c47-497d-875b-2ac210599ec5/e8aea0c195efed8a9aff2ba687db8c26/aspnetcore-runtime-3.1.8-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e87fff5e-7407-470b-afc4-eec92e51c5a6/47bada16baeceabcfa3b955727465f0d/aspnetcore-runtime-3.1.8-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/f62e619b-2e6b-4e37-ab04-045b09a19f8f/939970b6e3af94f6a957f1716ee5241b/aspnetcore-runtime-3.1.8-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/52164f25-0e92-4326-9faf-3a0ae2ca7f2e/18f03cd814b2e2b507baf51760d0a576/aspnetcore-runtime-3.1.8-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/145378a7-34ed-4b5b-a44f-964b3bbda2d7/4e61d9bc9003af03c8132c6b752d5d75/aspnetcore-runtime-3.1.8-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3eba97d8-404a-4e28-a593-d5344d49a0f3/f1adecf0d72ebb83ed6d157193f55e8f/aspnetcore-runtime-3.1.8-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/abc29cf6-ee1d-4a93-b18e-f66786977a36/791aaa942aef2c33128456d52e5e447f/aspnetcore-runtime-3.1.8-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/854cbd11-4b96-4a44-9664-b95991c0c4f7/8ec4944a5bd770faba2f769e647b1e6e/dotnet-hosting-3.1.8-win.exe


[//]: # ( SDK 3.1.108 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/52fb935e-f2b3-42c3-9695-d53e7c693baa/6c38b8ac3bc97ea2f09a03a60cdacdc5/dotnet-sdk-3.1.108-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/572d9a06-dd1e-4349-a443-702b5382605c/dbe9647eceb84dea786af91cd11a9e3e/dotnet-sdk-3.1.108-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8c0d4257-3738-4fac-ac62-88568c1d3d6d/cab341e77694f818d5eb3394a53d2d81/dotnet-sdk-3.1.108-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6100b24-89dc-4e8e-9778-0c7bc06cd79d/5237c0d25d08028e33dec42e9875fcc1/dotnet-sdk-3.1.108-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/dfa54ec7-bf38-401c-b52d-9b5484374378/d437385f9f5c1beb1b5f79f04c389b64/dotnet-sdk-3.1.108-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b61aba12-a766-4ae8-93f0-acd9868a74ad/7021f4c244484cb1aa95707550ec08b8/dotnet-sdk-3.1.108-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3bf93075-36ce-42d6-89c6-e68233d3d18d/a3d80cf18fe706921b9e7461580f310f/dotnet-sdk-3.1.108-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/5a244354-4dc3-4149-a9f6-08c58bce85dd/ce26eb27ef930f2814112fd1bafab20f/dotnet-sdk-3.1.108-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1c17ecd5-6e2e-4da5-81c0-529d5e557873/8a3acec6c7cfc5951b8c69ae52f7d9d8/dotnet-sdk-3.1.108-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d074e80b-cb5e-439f-b7bc-65cc6f014518/c2a4f5a4d838a4c754cdca31b0d133a8/dotnet-sdk-3.1.108-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7e61f5a8-264f-4d09-b861-61dd84f552c3/c7482506e36ec057ad0bced719954e15/dotnet-sdk-3.1.108-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/77ae50de-83a2-46be-876a-ea725bc558a4/8c46452678b370015ae480ee040fa8bd/dotnet-sdk-3.1.108-win-x86.zip
