# .NET Core 3.1.9 - October 13, 2020

[.NET Core 3.1.9](https://dotnet.microsoft.com/download/dotnet/3.1) is available for download and usage in your environment. This release includes .NET Core 3.1.9 and .NET Core SDK 3.1.109.

* [Blog Roundup][dotnet-blog]
* [Downloads](https://dotnet.microsoft.com/download/dotnet/3.1)
* [Changes in this release](#changes-in-319)
* [Known issues](../3.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

The .NET Core SDK 3.1.109 includes .NET Core 3.1 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.1.109, the following command will show that you're running version `3.1.109` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5347](https://github.com/dotnet/core/issues/5347) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.403](3.1.403-download.md) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.109](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md)
* [dotnet/core/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md)
* [dotnet/core/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)
* [dotnet/aspnetcore](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md)

### Azure App Services

* .NET Core 3.1.9 is being deployed to Azure App Services and the deployment is expected to complete later in October 2020.

## .NET Core Lifecycle News

Fedroa 33 and Ubuntu 20.10 has been added as [supported OS](../3.1-supported-os.md) with this update of .NET Core 3.1.

## Changes in 3.1.9

.NET Core 3.1.9 release carries only non-security fixes.

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A3.1.9+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A3.1.9+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/search?q=is%3Apr+label%3AServicing-approved+milestone%3A3.1.9+repo%3Adotnet%2Faspnetcore+repo%3Adotnet%2Fextensions+repo%3Adotnet%2Faspnetcore-tooling+repo%3Adotnet%2Fblazor+repo%3Adotnet%2Fefcore+repo%3Adotnet%2Fef6)

## Adding a switch to enable sending ISO-8859-1 headers with SocketsHttpHandler

Since the introduction of `SocketsHttpHandler` in .NET Core 2.1, an attempt to send non-ASCII characters in HTTP headers throws an `HttpRequestException`. This (RFC-conform) behavior turned out to be a blocker for some users trying to migrate from .NET Framework. In .NET 5 we are addressing this by the introduction of [`SocketsHttpHandler.RequestHeaderEncodingSelector`](https://learn.microsoft.com/dotnet/api/system.net.http.socketshttphandler.requestheaderencodingselector?view=net-5.0). To unblock users who are not (yet) able to migrate to .NET 5.0, we also added a runtime-configuration switch as part of .NET Core 3.1 servicing. This switch allows relaxing the HTTP header validation, enabling `SocketsHttpHandler` to send ISO-8859-1 (Latin-1) encoded characters in headers.

- `AppContext` switch: `System.Net.Http.SocketsHttpHandler.AllowLatin1Headers`. `false` - disabled, `true` - enabled
- Environment variable: `DOTNET_SYSTEM_NET_HTTP_SOCKETSHTTPHANDLER_ALLOWLATIN1HEADERS`. `0` - disabled, `1` - enabled

**Note:**

This switch is specific to .NET Core 3.1 since service release 3.1.9, and not available in later versions.



## macOS Notarization Change
  Running "dotnet build" will generate a dll instead of a dylib on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://learn.microsoft.com/dotnet/core/install/macos-notarization-issues). If you want to opt into using the AppHost, add the following to your project file:
```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.9.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.9.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.9.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.9.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.9.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.9.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.9.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.9.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.9.nupkg
Microsoft.NETCore.DotNetHost | 3.1.9.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.9.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.9.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.9.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.9.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.9.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.9.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.9.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.9.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.9.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.9.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.9.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.9.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.9.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.9.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.9.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.9.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.9.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.9.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.9.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.9.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.9.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.9.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.9.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.9.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.9.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.9.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.9.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.9.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.9.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.9.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.9.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.9.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.9.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.9.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.9.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.9.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.9.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.9.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.9.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.9.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.9.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.9.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.9.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.9.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.9.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.9.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.9.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.9.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.9.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.9.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.9.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.9.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.9.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.9.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.9.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.9.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.9.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.9.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.9.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.9.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.9.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.9.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.9.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.9.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.9.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.9.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.9.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.9.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.9.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.9.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.9.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.9.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.9.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.9.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.9.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.9.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.9.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.9.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.9.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.9.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.9.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.9.nupkg
Microsoft.AspNetCore.Metadata | 3.1.9.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.9.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.9.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.9.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.9.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.9.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.9.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.9.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.9.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.9.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.9.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.9.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.9.nupkg
Microsoft.Extensions.Identity.Core | 3.1.9.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.9.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.9.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.9.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.9.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.9.nupkg
Microsoft.dotnet-openapi | 3.1.9.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.9.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.9.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.9.nupkg
Microsoft.AspNetCore.Authorization | 3.1.9.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.9.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.9.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.9.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.9.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.9.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.9.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.9.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.9.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.9.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.9.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.9.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.9.nupkg
dotnet-sql-cache | 3.1.9.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.9.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.9.nupkg
Microsoft.AspNetCore.Owin | 3.1.9.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.9.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.9.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.9.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.9.nupkg
Microsoft.AspNetCore.Components | 3.1.9.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.9.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.9.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.9.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.9.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.9.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.9.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.9.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.9.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.9.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.9.nupkg
Microsoft.AspNetCore.TestHost | 3.1.9.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.9.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.9.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.9.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.9.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.9.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.9.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.9.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.9.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.9.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.9.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.9.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.9.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.9.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.9.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.9.nupkg
System.ServiceModel.Primitives | 4.8.0-preview2.20277.5.nupkg
System.ServiceModel.NetTcp | 4.8.0-preview2.20277.5.nupkg
System.ServiceModel.Duplex | 4.8.0-preview2.20277.5.nupkg
System.ServiceModel.Security | 4.8.0-preview2.20277.5.nupkg
System.ServiceModel.Http | 4.8.0-preview2.20277.5.nupkg
System.Private.ServiceModel | 4.8.0-preview2.20277.5.nupkg
System.IO.Pipelines | 4.7.3.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.9.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.9.nupkg
Microsoft.NET.Sdk.Razor | 3.1.9.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.9.nupkg
Microsoft.Data.Sqlite | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.9.nupkg
Microsoft.EntityFrameworkCore | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.9.nupkg
dotnet-ef | 3.1.9.nupkg
Microsoft.Data.Sqlite.Core | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.9.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.9.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.9.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.9.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.9.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.9.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.9.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.9.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.9.nupkg
Microsoft.Extensions.Configuration | 3.1.9.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.9.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.9.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.9.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.9.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.9.nupkg
Microsoft.Extensions.Primitives | 3.1.9.nupkg
Microsoft.Extensions.ObjectPool | 3.1.9.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.9.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.9.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.9.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.9.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.9.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.9.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.9.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.9.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.9.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.9.nupkg
Microsoft.Extensions.Http | 3.1.9.nupkg
Microsoft.JSInterop | 3.1.9.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.9.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.9.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.9.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.9.nupkg
Microsoft.Extensions.WebEncoders | 3.1.9.nupkg
Microsoft.Extensions.Options | 3.1.9.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.9.nupkg
Microsoft.Extensions.Logging.Console | 3.1.9.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.9.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.9.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.9.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.9.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.9.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.9.nupkg
Microsoft.Extensions.Hosting | 3.1.9.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.9.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.9.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.9.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.9.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.9.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.9.nupkg
Microsoft.Extensions.Localization | 3.1.9.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.9.nupkg
Microsoft.Extensions.Http.Polly | 3.1.9.nupkg
Microsoft.Extensions.Logging | 3.1.9.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.8.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.8.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.8.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.8.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.8.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.8.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.8.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.1.9.md
[snap-install]: 3.1.9-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.9-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.9-sha.txt

[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-october-2020/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-1/


[//]: # ( Runtime 3.1.9)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7c1177f6-feb9-4404-a795-adb77e78b9ab/d3ca4e135e1af71bea28623774f8df27/dotnet-runtime-3.1.9-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f6ca8333-82a2-4380-9d47-e152f47e85b8/1e3f6e0149761e884f63b14fa9d921f3/dotnet-runtime-3.1.9-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06297d4b-3e26-4ec2-a8d5-fe34a5ef0c85/e46a3e9d1825986b87bfed87a986eb6e/dotnet-runtime-3.1.9-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4ca97cf7-07c1-4846-938f-e7e9d0e8a3de/0c16e1051ec3169519ab7027ae54a087/dotnet-runtime-3.1.9-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb8a9fd4-c015-4c0e-a478-6da0b590bc39/d831b206c30e0aa23501b4a210dec9b1/dotnet-runtime-3.1.9-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/175aea5a-1b4a-4faa-b29d-ff72fa8c16bc/fcef8fc0139672f19ec8b9913824b6bb/dotnet-runtime-3.1.9-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/28d117d1-c52e-40e9-a692-cf6f32b7d8a9/be1562cfffcb0744e4c2555f668072e4/dotnet-runtime-3.1.9-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a8dda14-5813-45d1-8b26-7ac52b354834/b317ebba1f4a67b944621a3776a2da2d/dotnet-runtime-3.1.9-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/2d753111-1c85-4dd1-be02-e5b229d170b7/3c9ccda18a20d0f41983c1e5b648b184/dotnet-runtime-3.1.9-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ceff8b33-6f27-425f-957d-91039cf01a9c/312410f11691fae3272f4274f787eb12/dotnet-runtime-3.1.9-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0e310530-ba28-4f1f-bc9c-d52724dcbdd8/6ba67b12380ed99998d51ffa2a0287b6/dotnet-runtime-3.1.9-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8b0aa62d-5065-4b3d-8fed-b6f82ada03f8/80faca44ed02c99c1e343ffda4a5e5c7/dotnet-runtime-3.1.9-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6b892eec-d99d-40b9-a13f-a0927c568f3e/d52d6c1e6e2322708dcd445abc3947fd/dotnet-runtime-3.1.9-win-x86.zip

[//]: # ( WindowsDesktop 3.1.9)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6a3a8a8b-4aaa-4d3f-bce6-b512f2ef5a2c/e6963fbe57cdd8258a9f0997cc3a6669/windowsdesktop-runtime-3.1.9-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1419cd1f-64ac-44c7-bfe0-937fd5e5f39a/e72ec98df78dfbb3a5bbf35b66cb7c15/windowsdesktop-runtime-3.1.9-win-x86.exe

[//]: # ( ASP 3.1.9)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c8cd43dd-e9de-4ff9-9cea-2f02fba6869c/d5c653c12ec93cb71e30b21856acea66/aspnetcore-runtime-3.1.9-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dffd493f-9eb8-483f-81c7-a9e2201574ef/54e7464241e01e7031fd89e6fe88e6da/aspnetcore-runtime-3.1.9-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/df551158-70c8-4af6-beab-ce80d9092888/5f9be026830c708fba7724ba108fd9c7/aspnetcore-runtime-3.1.9-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/85c50e50-085c-46a6-a585-88aa13f4a1af/b04c24d8bc68449748509372a834f4c6/aspnetcore-runtime-3.1.9-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/933b0cb8-3494-4ca4-8c9e-1bcfd3568ab0/8704eef073efdfecdaaad4a18beb05ac/aspnetcore-runtime-3.1.9-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5fd170f1-05d8-4126-ae8f-9ff9dc683466/997547015dac7edcb155e5ac917b0c72/aspnetcore-runtime-3.1.9-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/4aee42bd-1598-4b26-bc4a-80940859ca82/3ab43bc8b9a4f8de870a7b9855d1447e/aspnetcore-runtime-3.1.9-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/87bcc889-4afa-4c88-839c-d72497b84407/42105fc6c95feb5faa64b2be1b76a830/aspnetcore-runtime-3.1.9-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/acdf7879-d422-4195-90a1-1f4a6e8550da/e75bde72d8790d478a698ad40f390b3e/aspnetcore-runtime-3.1.9-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5d18182f-178e-4734-a83e-803d65ce6353/445ae43d1955e368b35df7c8a884cb54/aspnetcore-runtime-3.1.9-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8a1f6e8f-eeef-4566-be27-28a870f3f3fb/1496eb9467f1e4091cd904035e96b514/aspnetcore-runtime-3.1.9-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/beca42b0-54a8-4364-86b8-a3d88003fbb7/592e0eec1e5e53f78d9647f7112cc743/dotnet-hosting-3.1.9-win.exe

[//]: # ( SDK 3.1.109 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d9a0b670-88f8-44ac-a6b1-9020c783c518/8bbec2b438275789bc1dbc95b8f89adf/dotnet-sdk-3.1.109-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/27fdcb48-766c-4f0e-8032-9f2afa40d3af/f2c6dac373046fa2d70e9a41b4a7dadf/dotnet-sdk-3.1.109-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4a45d6c6-951e-4205-ad51-cb10adefb88d/d0a059fab437a866b417e43e2cf9b579/dotnet-sdk-3.1.109-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/401ae772-3b16-40c7-a332-e7c0622c97fd/58016e724bc0dfa0c1f2ef0233b95aed/dotnet-sdk-3.1.109-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/311c13d3-1097-480f-b04d-5a2443948cc3/11250fe3b932fc15bc909606d5468223/dotnet-sdk-3.1.109-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6d684473-a89a-48c3-b91a-f04a43fbf1ff/5ba63e071b6c99d8568dbde1982cdf09/dotnet-sdk-3.1.109-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b21de37f-c225-42ad-9ea5-1ed1b5c7795a/131191ac6bd0fafb4efdd54f9042237a/dotnet-sdk-3.1.109-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/14a0cb3a-18a0-4d0f-a4e4-4d5bc1ebd47d/79e65c5802d748d43b99a66fe7b7501c/dotnet-sdk-3.1.109-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/48c6b7dd-fc04-4119-94fe-21adc27d3f18/719d076175946d2375bba25df293056f/dotnet-sdk-3.1.109-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f090672d-ffb0-4126-8154-68649cc55ad4/a09964d24b1bf583ad2f283f84c0a89c/dotnet-sdk-3.1.109-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/596a1e26-1cca-4f4f-a321-962247a159e6/f8c4d8dcc434f122cd04ff02ab890a81/dotnet-sdk-3.1.109-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7ac7b3e8-e3b0-49f1-8acf-67a41fe0fabd/af6f916191298dca36963978dbc54db0/dotnet-sdk-3.1.109-win-x86.zip
