# .NET 5.0.0 - November 10, 2020

The .NET 5.0.0 and .NET SDK 5.0.100 releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe]  |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](5.0.0-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.100
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) already supports .NET 5.0 and C# 9.

## Notable Changes

* [What's new in .NET 5.0](https://learn.microsoft.com/dotnet/core/dotnet-five)
* [.NET 5.0 Blog][dotnet-blog]
* [ASP.NET Core Blog][aspnet-blog]
* [EF Core Blog][ef-blog]
* [Known issues](../5.0-known-issues.md)


Release feature and bug lists:.

* ASP.NET Core: [bugs][aspnet_bugs] | [features][aspnet_features]
* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5545](https://github.com/dotnet/core/issues/5545) for your questions and comments.

## Contributors

The list of contributors can be found in the [5.0 Contributor List](../5.0-contributor-list.md).

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 5.0.0.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.0-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.0-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-5-0/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/announcing-asp-net-core-in-net-5/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-the-release-of-ef-core-5-0/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A5.0.0+is%3Aclosed+label%3Atype-bug+is%3Aclosed
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A5.0.0+is%3Aclosed+label%3Atype-enhancement+is%3Aclosed

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.0+label%3ADone+label%3Abug+is%3Aclosed
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.0+label%3ADone+label%3Aenhancement+is%3Aclosed
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A5.0+label%3Abug+is%3Aclosed
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A5.0+label%3Aenhancement+is%3Aclosed

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.1xx+is%3Aclosed

[linux-packages]: 5.0.0-install-instructions.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
System.ServiceModel.Security | 4.8.0.nupkg
System.ServiceModel.Primitives | 4.8.0.nupkg
System.ServiceModel.NetTcp | 4.8.0.nupkg
System.ServiceModel.Http | 4.8.0.nupkg
System.ServiceModel.Federation | 4.8.0.nupkg
System.ServiceModel.Duplex | 4.8.0.nupkg
System.Private.ServiceModel | 4.8.0.nupkg
Microsoft.Extensions.Http.Polly | 5.0.0.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 5.0.0.nupkg
Microsoft.Extensions.Hosting.Systemd | 5.0.0.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 5.0.0.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 5.0.0.nupkg
Microsoft.Extensions.Caching.SqlServer | 5.0.0.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.0.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.0.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.0.nupkg
Microsoft.WindowsDesktop.App.Ref | 5.0.0.nupkg
System.Composition.Runtime | 5.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.ILAsm | 5.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.ILDAsm | 5.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.TestHost | 5.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.ILAsm | 5.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.ILDAsm | 5.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.TestHost | 5.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.ILAsm | 5.0.0.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.TestHost | 5.0.0.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.ILAsm | 5.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.ILAsm | 5.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.ILDAsm | 5.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.TestHost | 5.0.0.nupkg
runtime.linux-arm.runtime.native.System.IO.Ports | 5.0.0-rtm.20519.4.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.0.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.0.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.0.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.0.nupkg
runtime.linux-arm64.Microsoft.NETCore.ILAsm | 5.0.0.nupkg
runtime.linux-arm64.Microsoft.NETCore.ILDAsm | 5.0.0.nupkg
runtime.linux-arm64.Microsoft.NETCore.TestHost | 5.0.0.nupkg
runtime.linux-arm64.runtime.native.System.IO.Ports | 5.0.0-rtm.20519.4.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.0.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.0.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.0.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.0.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.ILDAsm | 5.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.ILDAsm | 5.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.TestHost | 5.0.0.nupkg
runtime.linux-x64.runtime.native.System.IO.Ports | 5.0.0-rtm.20519.4.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.ILAsm | 5.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.ILDAsm | 5.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.TestHost | 5.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.ILAsm | 5.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.ILDAsm | 5.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.TestHost | 5.0.0.nupkg
System.CodeDom | 5.0.0.nupkg
System.Collections.Immutable | 5.0.0.nupkg
System.ComponentModel.Annotations | 5.0.0.nupkg
System.ComponentModel.Composition | 5.0.0.nupkg
System.ComponentModel.Composition.Registration | 5.0.0.nupkg
System.Composition | 5.0.0.nupkg
System.Composition.AttributedModel | 5.0.0.nupkg
System.Composition.Convention | 5.0.0.nupkg
System.Composition.Hosting | 5.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.TestHost | 5.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.ILDAsm | 5.0.0.nupkg
runtime.native.System.IO.Ports | 5.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.ILAsm | 5.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.ILDAsm | 5.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.TestHost | 5.0.0.nupkg
runtime.osx-x64.runtime.native.System.IO.Ports | 5.0.0-rtm.20519.4.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.ILAsm | 5.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.ILDAsm | 5.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.TestHost | 5.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.ILAsm | 5.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.0.nupkg
Microsoft.XmlSerializer.Generator | 5.0.0.nupkg
Microsoft.Extensions.Logging.Console | 5.0.0.nupkg
Microsoft.Extensions.Logging.Debug | 5.0.0.nupkg
Microsoft.Extensions.Logging.EventLog | 5.0.0.nupkg
Microsoft.Extensions.Logging.EventSource | 5.0.0.nupkg
Microsoft.Extensions.Logging.TraceSource | 5.0.0.nupkg
Microsoft.Extensions.Options | 5.0.0.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 5.0.0.nupkg
Microsoft.Extensions.Options.DataAnnotations | 5.0.0.nupkg
Microsoft.Extensions.Primitives | 5.0.0.nupkg
Microsoft.ILVerification | 5.0.0.nupkg
Microsoft.IO.Redist | 5.0.0.nupkg
Microsoft.NET.Sdk.IL | 5.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.0.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.0.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.0.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.0.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.0.nupkg
Microsoft.Extensions.Logging.Configuration | 5.0.0.nupkg
Microsoft.Extensions.Logging.Abstractions | 5.0.0.nupkg
Microsoft.Extensions.Logging | 5.0.0.nupkg
Microsoft.Diagnostics.Tracing.EventSource.Redist | 5.0.0.nupkg
Microsoft.Extensions.Caching.Abstractions | 5.0.0.nupkg
Microsoft.Extensions.Caching.Memory | 5.0.0.nupkg
Microsoft.Extensions.Configuration | 5.0.0.nupkg
Microsoft.Extensions.Configuration.Abstractions | 5.0.0.nupkg
Microsoft.Extensions.Configuration.Binder | 5.0.0.nupkg
Microsoft.Extensions.Configuration.CommandLine | 5.0.0.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 5.0.0.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 5.0.0.nupkg
Microsoft.Extensions.Configuration.Ini | 5.0.0.nupkg
Microsoft.Extensions.Configuration.Json | 5.0.0.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.0.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 5.0.0.nupkg
Microsoft.Extensions.DependencyInjection | 5.0.0.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 5.0.0.nupkg
Microsoft.Extensions.DependencyModel | 5.0.0.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 5.0.0.nupkg
Microsoft.Extensions.FileProviders.Composite | 5.0.0.nupkg
Microsoft.Extensions.FileProviders.Physical | 5.0.0.nupkg
Microsoft.Extensions.FileSystemGlobbing | 5.0.0.nupkg
Microsoft.Extensions.Hosting | 5.0.0.nupkg
Microsoft.Extensions.Hosting.Abstractions | 5.0.0.nupkg
Microsoft.Extensions.Http | 5.0.0.nupkg
Microsoft.Extensions.Configuration.Xml | 5.0.0.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.0.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.tvos-arm64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.tvos-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.0.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.0.nupkg
Microsoft.NETCore.DotNetHost | 5.0.0.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.0.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.0.nupkg
Microsoft.NETCore.ILAsm | 5.0.0.nupkg
Microsoft.NETCore.ILDAsm | 5.0.0.nupkg
Microsoft.NETCore.Platforms | 5.0.0.nupkg
Microsoft.NETCore.Targets | 5.0.0.nupkg
Microsoft.NETCore.TestHost | 5.0.0.nupkg
Microsoft.Win32.Registry | 5.0.0.nupkg
Microsoft.Win32.Registry.AccessControl | 5.0.0.nupkg
Microsoft.Win32.SystemEvents | 5.0.0.nupkg
Microsoft.Windows.Compatibility | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.0.nupkg
Microsoft.NETCore.App.Ref | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.android-arm | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.android-arm64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.android-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.android-x86 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.ios-arm | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.ios-arm64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.ios-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.ios-x86 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.0.nupkg
System.Composition.TypedParts | 5.0.0.nupkg
System.Configuration.ConfigurationManager | 5.0.0.nupkg
System.Data.Odbc | 5.0.0.nupkg
Microsoft.Bcl.AsyncInterfaces | 5.0.0.nupkg
System.Security.Cryptography.OpenSsl | 5.0.0.nupkg
System.Security.Cryptography.Pkcs | 5.0.0.nupkg
System.Security.Cryptography.ProtectedData | 5.0.0.nupkg
System.Security.Cryptography.Xml | 5.0.0.nupkg
System.Security.Permissions | 5.0.0.nupkg
System.Security.Principal.Windows | 5.0.0.nupkg
System.ServiceModel.Syndication | 5.0.0.nupkg
System.ServiceProcess.ServiceController | 5.0.0.nupkg
System.Text.Encoding.CodePages | 5.0.0.nupkg
System.Text.Encodings.Web | 5.0.0.nupkg
System.Text.Json | 5.0.0.nupkg
System.Threading.AccessControl | 5.0.0.nupkg
System.Threading.Channels | 5.0.0.nupkg
System.Threading.Tasks.Dataflow | 5.0.0.nupkg
System.Windows.Extensions | 5.0.0.nupkg
System.Security.Cryptography.Cng | 5.0.0.nupkg
System.Security.AccessControl | 5.0.0.nupkg
System.Runtime.CompilerServices.Unsafe | 5.0.0.nupkg
System.Runtime.Caching | 5.0.0.nupkg
System.Data.OleDb | 5.0.0.nupkg
System.Diagnostics.DiagnosticSource | 5.0.0.nupkg
System.Diagnostics.EventLog | 5.0.0.nupkg
System.Diagnostics.PerformanceCounter | 5.0.0.nupkg
System.DirectoryServices | 5.0.0.nupkg
System.DirectoryServices.AccountManagement | 5.0.0.nupkg
System.DirectoryServices.Protocols | 5.0.0.nupkg
System.Drawing.Common | 5.0.0.nupkg
System.Formats.Asn1 | 5.0.0.nupkg
System.Formats.Cbor | 5.0.0.nupkg
System.IO.FileSystem.AccessControl | 5.0.0.nupkg
System.IO.Packaging | 5.0.0.nupkg
System.IO.Pipes.AccessControl | 5.0.0.nupkg
System.IO.Ports | 5.0.0.nupkg
System.Management | 5.0.0.nupkg
System.Net.Http.Json | 5.0.0.nupkg
System.Net.Http.WinHttpHandler | 5.0.0.nupkg
System.Net.WebSockets.WebSocketProtocol | 5.0.0.nupkg
System.Reflection.Context | 5.0.0.nupkg
System.Reflection.Metadata | 5.0.0.nupkg
System.Reflection.MetadataLoadContext | 5.0.0.nupkg
System.Resources.Extensions | 5.0.0.nupkg
System.IO.Pipelines | 5.0.0.nupkg
dotnet-ilverify | 5.0.0.nupkg
dotnet-sql-cache | 5.0.0.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.0.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.0.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.0.nupkg
Microsoft.AspNetCore.Authorization | 5.0.0.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.0.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.0.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.0.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.0.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.0.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.0.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.0.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.0.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.0.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.0.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.0.nupkg
Microsoft.AspNetCore.App.Ref | 5.0.0.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.0.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.0.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.0.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.0.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.0.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.0.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.0.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.0.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.0.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.0.nupkg
Microsoft.dotnet-openapi | 5.0.0.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.0.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.0.nupkg
Microsoft.AspNetCore.TestHost | 5.0.0.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.0.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.0.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.0.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.0.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.0.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.0.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.0.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.0.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.0.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.0.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.0.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.0.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.0.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.0.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.0.nupkg
Microsoft.JSInterop | 5.0.0.nupkg
Microsoft.Extensions.WebEncoders | 5.0.0.nupkg
Microsoft.Extensions.ObjectPool | 5.0.0.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.0.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.0.nupkg
Microsoft.Extensions.Localization | 5.0.0.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.0.nupkg
Microsoft.Extensions.Identity.Core | 5.0.0.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.0.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.0.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.0.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.0.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.0.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.0.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.0.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.0.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.0.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.0.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.0.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.0.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.0.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.0.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.0.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.0.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.0.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.0.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.0.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.0.nupkg
Microsoft.AspNetCore.Components | 5.0.0.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.0.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.0.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.0.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.0.nupkg
Microsoft.AspNetCore.Razor.Test.MvcShim.Version2_X | 5.0.0.nupkg
Microsoft.AspNetCore.Razor.Test.MvcShim.Version1_X | 5.0.0.nupkg
Microsoft.AspNetCore.Razor.Test.MvcShim.ClassLib | 5.0.0.nupkg
Microsoft.AspNetCore.Razor.Test.MvcShim | 5.0.0.nupkg
Microsoft.AspNetCore.Razor.Test.ComponentShim | 5.0.0.nupkg
Microsoft.AspNetCore.Razor.Test.Common | 5.0.0.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.0.nupkg
Microsoft.AspNetCore.Owin | 5.0.0.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.0.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.0.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.0.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.0.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.0.nupkg
Microsoft.AspNetCore.Metadata | 5.0.0.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.0.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.0.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.0.nupkg
dotnet-ef | 5.0.0.nupkg
Microsoft.Data.Sqlite | 5.0.0.nupkg
Microsoft.Data.Sqlite.Core | 5.0.0.nupkg
Microsoft.EntityFrameworkCore | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.0.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.0.nupkg
Microsoft.TemplateSearch.Common | 5.0.0.nupkg
Microsoft.TemplateEngine.Utils | 5.0.0.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.0.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.0.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.0.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.0.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.0.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.0.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.0.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.0.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.0.nupkg
Microsoft.TemplateEngine.Core | 5.0.0.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.0.nupkg
Microsoft.TemplateEngine.Edge | 5.0.0.nupkg
Microsoft.TemplateEngine.IDE | 5.0.0.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.0.nupkg


[//]: # ( Runtime 5.0.0)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5fc4659b-86c2-4e8f-b409-853e6d8224a5/6de0fc8c6e26f308bf246aaa967c9fc1/dotnet-runtime-5.0.0-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4b114207-eaa2-40fe-8524-bd3c56b2fd9a/1d74fdea8701948c0150c39645455b2f/dotnet-runtime-5.0.0-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6cec2d5-8ff0-4318-86a5-b63af83122f3/b8292678eff99395e008367371d83bc8/dotnet-runtime-5.0.0-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a4cbacdd-717e-415d-8695-1503ece2616e/c947d9acc995e9b055068bf4cbd8c81c/dotnet-runtime-5.0.0-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c84d49aa-200c-4400-a517-87cce5b7516d/94c89b00380eb212e19538b05f8cb968/dotnet-runtime-5.0.0-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9c1b257d-1db8-4dd6-8012-9e1371d28b19/ab6812447b1097b19f5306b2d020c7c1/dotnet-runtime-5.0.0-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/112291a5-e3e0-4741-9c66-c9cea6231f3f/3ebd75dfda0492fcbf50c6f939762c46/dotnet-runtime-5.0.0-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/fa94df7a-0350-4ac8-b789-1c4882d753db/acf0462ca7725bd9f5831a201843e19a/dotnet-runtime-5.0.0-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/3ef45865-b9d4-413f-86cb-37baee7c1419/ecaaaae8560a0785668fe1739b3ad521/dotnet-runtime-5.0.0-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/36a9dc4e-1745-4f17-8a9c-f547a12e3764/ae25e38f20a4854d5e015a88659a22f9/dotnet-runtime-5.0.0-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4c86f8a0-8f0b-454f-9419-081c2f21b348/52a1d3c12effa2bc1b552a4fd9f53d20/dotnet-runtime-5.0.0-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a7e15da3-7a15-43c2-a481-cf50bf305214/c69b951e8b47101e90b1289c387bb01a/dotnet-runtime-5.0.0-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/eec32c52-40f5-4ee4-8b3f-a78126c8d2f0/f526f4a1abd052bb58848f18775597ed/dotnet-runtime-5.0.0-win-x86.zip

[//]: # ( WindowsDesktop 5.0.0)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1b3a8899-127a-4465-a3c2-7ce5e4feb07b/1e153ad470768baa40ed3f57e6e7a9d8/windowsdesktop-runtime-5.0.0-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b2780d75-e54a-448a-95fc-da9721b2b4c2/62310a9e9f0ba7b18741944cbae9f592/windowsdesktop-runtime-5.0.0-win-x86.exe

[//]: # ( ASP 5.0.0)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1c5366e8-9b74-4017-96ae-47fc08832c22/504aed87590bd99c49d053bc6f980b6b/aspnetcore-runtime-5.0.0-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac555882-afa3-4f5b-842b-c4cec2ae0e90/84cdd6d47a9f79b6722f0e0a9b258888/aspnetcore-runtime-5.0.0-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f38125f-70f0-451c-8f4e-e7e0b102c1c6/96fce6e16fcbe341657e44023ab3c95c/aspnetcore-runtime-5.0.0-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d97e046-dde3-4d76-8d93-4ca21a628ba0/820bd340cad73af0cf5d568baf48bf83/aspnetcore-runtime-5.0.0-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ff9a5b2e-704b-4ff2-bf2f-4bac619915af/e771f72b10ad5160ab5f3d70c287e948/aspnetcore-runtime-5.0.0-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/173b9b16-4d0d-4387-acf0-f113a359ee77/cbc2f6c00ac56c44bda0e3c960e38bd1/aspnetcore-runtime-5.0.0-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/11b4ed9d-5cf4-4037-a6ed-87a14940637d/a3da5eb099fbd1649dbc90b2b00dc0ad/aspnetcore-runtime-5.0.0-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/92866d29-a298-4cab-b501-a65e43820f97/88d287b9fb4a12cfcdf4a6be85f4a638/aspnetcore-runtime-5.0.0-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6ddc3153-7600-4e14-9acb-b672c26c15bb/7ffc45bc16916fbde8a0f4abebe72df0/aspnetcore-runtime-5.0.0-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/115edeeb-c883-45be-90f7-8db7b6b3fa2f/6bf92152b2b9fa9c0d0b08a13b60e525/aspnetcore-runtime-5.0.0-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/43ced5d3-87a1-4891-9877-fa2dda4091d3/7658b8441a46d1ba9650fea4fdd429c0/aspnetcore-runtime-5.0.0-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/08d642f7-8ade-4de3-9eae-b77fd05e5f01/503da91e7ea62d8be06488b014643c12/dotnet-hosting-5.0.0-win.exe

[//]: # ( SDK 5.0.100 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e8912d3b-483b-4d6f-bd3a-3066b3194313/20f2261fe4e16e55df4bbe03c65a7648/dotnet-sdk-5.0.100-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/27840e8b-d61c-472d-8e11-c16784d40091/ae9780ccda4499405cf6f0924f6f036a/dotnet-sdk-5.0.100-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7139f9c3-5c9a-41f9-b49a-2a2bc21886fc/90a1fc71b18b7d64baa83c2325eff7b2/dotnet-sdk-5.0.100-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/820db713-c9a5-466e-b72a-16f2f5ed00e2/628aa2a75f6aa270e77f4a83b3742fb8/dotnet-sdk-5.0.100-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3bdcd7d2-1444-4f7d-a254-504a994ffe39/e4f42b83604673f971748c722aa20bec/dotnet-sdk-5.0.100-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0871336f-9a83-4ce4-80ca-625d03003369/2eb78456e0b106e9515dc03898d3867a/dotnet-sdk-5.0.100-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/95ac9cc2-49ec-43ca-9f2a-9230e4d6052e/493cdd41352863d840a7cd0997e4c9e0/dotnet-sdk-5.0.100-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f1bf8f4c-ba17-4144-8e4c-e46fd04d8147/f36a2d158383f78e8cea835219830822/dotnet-sdk-5.0.100-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2892493e-df43-409e-af68-8b14aa75c029/53156c889fc08f01b7ed8d7135badede/dotnet-sdk-5.0.100-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7b78bdaa-d0ac-41c4-9fdc-5820d7dc79b6/cea499dd314ba6394ccea51a2a2dcda9/dotnet-sdk-5.0.100-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/caa07f2f-f736-4115-80a1-b9c86fe3e55e/bd8df5ab7aad36795ef2c017594fafad/dotnet-sdk-5.0.100-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/46d55dd1-1630-472c-a951-edb8b0ab23e6/70d97e9619f0d086a99eeef0a465084d/dotnet-sdk-5.0.100-win-x86.zip
