# .NET 5.0.1 - December 08, 2020

The .NET 5.0.1 and .NET SDK 5.0.101 releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe]  |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](5.0.1-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.101
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.1 release carries only non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)


Release feature and bug lists:.

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A5.0.1+is%3Aclosed+label%3Aservicing-approved)
* [ASP.NET Core](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A5.0.1+is%3Aclosed+label%3Aservicing-approved)
* [EntityFramework Core](https://github.com/dotnet/efcore/issues?q=milestone%3A5.0.1+is%3Aclosed+label%3Aservicing-approved)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A5.0.1+is%3Aclosed+label%3Aservicing-approved)
* [SDK](https://github.com/dotnet/sdk/issues?q=milestone%3A5.0.1xx+is%3Aclosed+label%3Aservicing-approved+)
* [Extensions](https://github.com/dotnet/extensions/issues?q=milestone%3A5.0.1+is%3Aclosed+label%3Aservicing-approved)
* [Installer](https://github.com/dotnet/installer/issues?q=milestone%3A5.0.1xx+is%3Aclosed+label%3Aservicing-approved+)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5719](https://github.com/dotnet/core/issues/5719) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 5.0.1.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.1-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.1-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-december-2020/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A5.0.1+is%3Aclosed+label%3Atype-bug+is%3Aclosed
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A5.0.1+is%3Aclosed+label%3Atype-enhancement+is%3Aclosed

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.1+label%3ADone+label%3Abug+is%3Aclosed
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.1+label%3ADone+label%3Aenhancement+is%3Aclosed
[runtime_bugs]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.1+is%3Aclosed+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A5.0+label%3Aenhancement+is%3Aclosed

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.1xx+is%3Aclosed

[linux-packages]: 5.0.1-install-instructions.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.Extensions.Http.Polly | 5.0.1.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 5.0.1.nupkg
Microsoft.Extensions.Hosting.Systemd | 5.0.1.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 5.0.1.nupkg
Microsoft.Extensions.Caching.SqlServer | 5.0.1.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 5.0.1.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.1.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.1.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.1.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.1.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.1.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.1.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.1.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.1.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.1.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.1.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.1.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.android-arm64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.android-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.android-x86 | 5.0.1.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.1.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.1.nupkg
Microsoft.Extensions.DependencyInjection | 5.0.1.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.1.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.1.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.1.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.1.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.1.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.1.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.1.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.1.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.1.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.1.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.1.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.1.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.1.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.1.nupkg
System.IO.Pipelines | 5.0.1.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.1.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.1.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.1.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.1.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.ios-arm | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.ios-x86 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.ios-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.1.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.1.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.1.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.tvos-arm64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.1.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.1.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.1.nupkg
System.Security.Cryptography.Pkcs | 5.0.1.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.1.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.1.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.1.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.1.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.1.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.android-arm | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.ios-arm64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.1.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.tvos-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.1.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.1.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.1.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.1.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.1.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.1.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.1.nupkg
Microsoft.NETCore.DotNetHost | 5.0.1.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.1.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.1.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.1.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.1.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.1.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.1.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.1.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.1.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.1.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.1.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.1.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.1.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.1.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.1.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.1.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.1.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.1.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.1.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.1.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.1.nupkg
Microsoft.AspNetCore.Owin | 5.0.1.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.1.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.1.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.1.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.1.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.1.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.1.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.1.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.1.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.1.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.1.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.1.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.1.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.1.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.1.nupkg
dotnet-sql-cache | 5.0.1.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.1.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.1.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.1.nupkg
Microsoft.dotnet-openapi | 5.0.1.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.1.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.1.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.1.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.1.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.1.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.1.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.1.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.1.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.1.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.1.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.1.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.1.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.1.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.1.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.1.nupkg
Microsoft.Extensions.Localization | 5.0.1.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.1.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.1.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.1.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.1.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.1.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.1.nupkg
Microsoft.AspNetCore.TestHost | 5.0.1.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.1.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.1.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.1.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.1.nupkg
Microsoft.Extensions.WebEncoders | 5.0.1.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.1.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.1.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.1.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.1.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.1.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.1.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.1.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.1.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.1.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.1.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.1.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.1.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.1.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.1.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.1.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.1.nupkg
Microsoft.Extensions.ObjectPool | 5.0.1.nupkg
Microsoft.Extensions.Identity.Core | 5.0.1.nupkg
Microsoft.AspNetCore.Authorization | 5.0.1.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.1.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.1.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.1.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.1.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.1.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.1.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.1.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.1.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.1.nupkg
Microsoft.JSInterop | 5.0.1.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.1.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.1.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.1.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.1.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.1.nupkg
Microsoft.AspNetCore.Components | 5.0.1.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.1.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.1.nupkg
Microsoft.AspNetCore.Metadata | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.1.nupkg
Microsoft.Data.Sqlite | 5.0.1.nupkg
dotnet-ef | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.1.nupkg
Microsoft.Data.Sqlite.Core | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.1.nupkg
Microsoft.EntityFrameworkCore | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.1.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.1.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.1.nupkg
Microsoft.TemplateEngine.IDE | 5.0.1.nupkg
Microsoft.TemplateSearch.Common | 5.0.1.nupkg
Microsoft.TemplateEngine.Utils | 5.0.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.1.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.1.nupkg
Microsoft.TemplateEngine.Core | 5.0.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.1.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.1.nupkg
Microsoft.TemplateEngine.Edge | 5.0.1.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.1.nupkg


[//]: # ( Runtime 5.0.1)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/46b6dfbf-8da3-4e95-ae33-abd5c875bc3e/566db9b58e809f4ed6d571a1de09fc58/dotnet-runtime-5.0.1-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/070e2bba-564b-41d1-a5b7-2772db039ee7/4265da6f0e315dadef8742dcceab85c4/dotnet-runtime-5.0.1-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f4ac9c1e-bf59-4a14-8b3c-e10064fc317d/ca9ed1110309dfd3382717031cf7f6db/dotnet-runtime-5.0.1-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2a4a32a5-c6f1-4a4a-93b5-3be56bd78196/98fffa879c3e2e4709bee68bb452cd05/dotnet-runtime-5.0.1-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b2c8490-04c5-4c54-a05d-dbe4dd6c3f2c/85c2939a81302dcc822e01b5175c153e/dotnet-runtime-5.0.1-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4c8830a9-e80c-4dcf-b480-bb7763957f23/dae4366068a9b3dc61e40dcfee16b54c/dotnet-runtime-5.0.1-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8c19388a-413c-4467-8e4a-04ebfc3cf649/951f03ab26d23ecb68d4843ac54783d6/dotnet-runtime-5.0.1-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/9db358f1-61f1-4762-a29b-5189794567d1/7bc08ab5cbde9cfdf2fbaca1ffdd27f4/dotnet-runtime-5.0.1-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b0dbe14a-742e-4dda-97c9-0fc63b1fabd0/d4d3325bd9b69d7eaf5642602a9260a1/dotnet-runtime-5.0.1-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/93095e51-be33-4b28-99c8-5ae0ebba753d/501f77f4b95d2e9c3481246a3eff9956/dotnet-runtime-5.0.1-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/57aececf-1108-4d4d-8af4-457da60b4956/062208459fda57c607335f408a5c7a1f/dotnet-runtime-5.0.1-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f4fb5042-8134-4434-8835-499eb2f18b38/6a0d857f6f1833f5c54fbbe5ead028a7/dotnet-runtime-5.0.1-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/cda5eb17-f096-44f0-9405-cbf44de44513/4ebdeecf995ac2558f26f5e6fdafe2d5/dotnet-runtime-5.0.1-win-x86.zip

[//]: # ( WindowsDesktop 5.0.1)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c6a74d6b-576c-4ab0-bf55-d46d45610730/f70d2252c9f452c2eb679b8041846466/windowsdesktop-runtime-5.0.1-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/55bb1094-db40-411d-8a37-21186e9495ef/1a045e29541b7516527728b973f0fdef/windowsdesktop-runtime-5.0.1-win-x86.exe

[//]: # ( ASP 5.0.1)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/11977d43-d937-4fdb-a1fb-a20d56f1877d/73aa09b745586ac657110fd8b11c0275/aspnetcore-runtime-5.0.1-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e12f9b23-cb47-4718-9903-8a000f85a442/d1a6a6c75cc832ad8187f5bce0d6234a/aspnetcore-runtime-5.0.1-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09c5b087-033d-4e97-a945-c80b9380d5fb/48e3f28d6a8eebe881d7ceb8192f7806/aspnetcore-runtime-5.0.1-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b87727dd-e0e2-4253-b6f8-ba541195465c/78362e21fbb5b7faf869004993eea290/aspnetcore-runtime-5.0.1-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6bea1cea-89e8-4bf7-9fc1-f77380443db1/0fb741b7d587cce798ebee80732196ef/aspnetcore-runtime-5.0.1-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f1c49188-548d-4853-9c72-909f47b7fa81/e01f1507b8b8643caef55dda46fe7ec5/aspnetcore-runtime-5.0.1-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7413850b-de56-49bf-b2ed-564d4ef1d7f9/abfbfa6e9b5e612261db6fafc6fbaa6d/aspnetcore-runtime-5.0.1-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/48dd125b-b9ca-4fc7-b26c-558bff5bee13/214be31c3239444d4a9cfdf0574f3cd8/aspnetcore-runtime-5.0.1-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/542a8d9d-6450-4630-aa2d-277b258d85ad/f24090c31b34d6830b513287efd59d70/aspnetcore-runtime-5.0.1-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7d6ed29e-5c0d-47b4-8436-7f1d21a0bca4/e8609f033ad936c117f2d90b86fd05c4/aspnetcore-runtime-5.0.1-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c7fc17df-5e2e-402c-b4de-d689fddd075f/c523e5a4b3f37960ca89a52b99ab98cb/aspnetcore-runtime-5.0.1-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/b6271a4b-db02-4245-bf99-974ea96b7ca3/29389344a55c6792bd4e717a254168a2/dotnet-hosting-5.0.1-win.exe

[//]: # ( SDK 5.0.101 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/567a64a8-810b-4c3f-85e3-bc9f9e06311b/02664afe4f3992a4d558ed066d906745/dotnet-sdk-5.0.101-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2add7523-39ec-413a-b8a7-24361cc4e599/30489ebd7ebcc723da48a64669860fd0/dotnet-sdk-5.0.101-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a84c2dee-3074-4c27-9b31-af0bc9a9ebcf/a8eb9a11b81c5b7119cf1578632ed186/dotnet-sdk-5.0.101-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a0487784-534a-4912-a4dd-017382083865/be16057043a8f7b6f08c902dc48dd677/dotnet-sdk-5.0.101-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0a7fa783-02e1-4785-b7b1-3c430f8825dc/764e53ff2f5722bc1b8bbc178fe25930/dotnet-sdk-5.0.101-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1193fc39-e498-407d-bf65-071172fbfb8f/56c95047d1d187cec6dd107674b650a8/dotnet-sdk-5.0.101-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b69da517-2b8c-43a8-bf88-9780392d3fab/9e0167c144036b0221f3d864fbc48af8/dotnet-sdk-5.0.101-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2a5cf4c4-62e7-4738-be5b-065fed5a6496/699a781da0478af053e4c435491b1fe0/dotnet-sdk-5.0.101-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/acff3e6a-d8d6-4c2a-a0cb-1853b58055cc/7910b2a414caa17d30b0cb82583cb542/dotnet-sdk-5.0.101-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d96f04db-f33a-4c0a-bcaf-4fe94559b974/5ad3c8ea7232b361cc1acd89ae4c876c/dotnet-sdk-5.0.101-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f3ab5b2d-90a2-4235-ba83-b431af07cf08/a79a3138bbacde2e44341de3fe89242a/dotnet-sdk-5.0.101-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/91018cd2-d4e4-45da-920d-1a40970ed5bf/68efbc308fa59cc2c3ce41fe539d6179/dotnet-sdk-5.0.101-win-x86.zip
