# .NET 5.0.11 - October 12, 2021

The .NET 5.0.11, .NET 5.0.402 SDK  and [.NET SDK 5.0.208](5.0.208.md) releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.402
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.11 release carries both security and non-security fixes.

**Windows SDK Updates**

* .NET SDK 5.0.402 and .NET SDK 5.0.208 include several fixes to the Windows SDK targeting packages with [C#/WinRT 1.3.5](https://github.com/microsoft/CsWinRT/releases/tag/1.3.5.210915.1).


# Microsoft Security Advisory CVE-2021-41355 | .NET Core Information Disclosure Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Information Disclosure vulnerability exists in .NET where System.DirectoryServices.Protocols.LdapConnection may send credentials in plain text on Linux.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)

Release feature and bug lists:.

* [ASP.NET](https://github.com/dotnet/aspnetcore/pulls?q=milestone%3A5.0.11+is%3Aclosed+label%3Aservicing-approved+)
* [Winforms](https://github.com/dotnet/winforms/pulls?q=milestone%3A5.0.11+is%3Aclosed+label%3Aservicing-approved+)
* [WPF](https://github.com/dotnet/wpf/pulls?q=milestone%3A5.0.11+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/pulls?q=milestone%3A5.0.11+is%3Aclosed+label%3Aservicing-approved+)


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6794](https://github.com/dotnet/core/issues/6794) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 5.0.11.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.11-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.11-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/october-2021-updates/

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.11xx+is%3Aclosed

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.11.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.11.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.11.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.11.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.11.nupkg
System.DirectoryServices.Protocols |5.0.1.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.11.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.11.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.11.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.11.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.11.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.11.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.11.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.11.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.11.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.11.nupkg
Microsoft.NETCore.DotNetHost | 5.0.11.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.11.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.11.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.11.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.11.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.11.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.11.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.11.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.11.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.11.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.11.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.11.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.11.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.11.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.11.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.11.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.11.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.11.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.11.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.11.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.11.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.11.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.11.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.11.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.11.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.11.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.11.nupkg
Microsoft.NETCore.Platforms | 5.0.4.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.11.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.11.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.11.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.11.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.11.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.11.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.11.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.11.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.11.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.11.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.11.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.11.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.11.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.11.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.11.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.11.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.11.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.11.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.11.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.11.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.11.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.11.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.11.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.11.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.11.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.11.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.11.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.11.nupkg
Microsoft.AspNetCore.TestHost | 5.0.11.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.11.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.11.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.11.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.11.nupkg
Microsoft.Extensions.WebEncoders | 5.0.11.nupkg
Microsoft.Extensions.Identity.Core | 5.0.11.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.11.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.11.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.11.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.11.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.11.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.11.nupkg
Microsoft.AspNetCore.Metadata | 5.0.11.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.11.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.11.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.11.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.11.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.11.nupkg
dotnet-sql-cache | 5.0.11.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.11.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.11.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.11.nupkg
Microsoft.JSInterop | 5.0.11.nupkg
Microsoft.Extensions.ObjectPool | 5.0.11.nupkg
Microsoft.Extensions.Localization | 5.0.11.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.11.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.11.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.11.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.11.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.11.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.11.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.11.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.11.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.11.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.11.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.11.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.11.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.11.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.11.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.11.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.11.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.11.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.11.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.11.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.11.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.11.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.11.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.11.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.11.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.11.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.11.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.11.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.11.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.11.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.11.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.11.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.11.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.11.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.11.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.11.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.11.nupkg
Microsoft.AspNetCore.Authorization | 5.0.11.nupkg
Microsoft.dotnet-openapi | 5.0.11.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.11.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.11.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.11.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.11.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.11.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.11.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.11.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.11.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.11.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.11.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.11.nupkg
Microsoft.AspNetCore.Components | 5.0.11.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.11.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.11.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 5.0.11.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.11.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.11.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.11.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.11.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.11.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.11.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.11.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.11.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.11.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.11.nupkg
Microsoft.AspNetCore.Owin | 5.0.11.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.11.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.11.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.11.nupkg
Microsoft.Data.Sqlite.Core | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.11.nupkg
dotnet-ef | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.11.nupkg
Microsoft.Data.Sqlite | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.11.nupkg
Microsoft.EntityFrameworkCore | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.11.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.11.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.402.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.402.nupkg
Microsoft.TemplateSearch.Common | 5.0.402.nupkg
Microsoft.TemplateEngine.Utils | 5.0.402.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.402.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.402.nupkg
Microsoft.TemplateEngine.IDE | 5.0.402.nupkg
Microsoft.TemplateEngine.Core | 5.0.402.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.402.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.402.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.402.nupkg
Microsoft.TemplateEngine.Edge | 5.0.402.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.402.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.402.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.402.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.402.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 |  5.0.207.nupkg
Microsoft.TemplateSearch.Common |  5.0.207.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 |  5.0.207.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 |  5.0.207.nupkg
Microsoft.TemplateEngine.Abstractions |  5.0.207.nupkg
Microsoft.TemplateEngine.Core |  5.0.207.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 |  5.0.207.nupkg
Microsoft.TemplateEngine.Utils |  5.0.207.nupkg
Microsoft.DotNet.Common.ItemTemplates |  5.0.207.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 |  5.0.207.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 |  5.0.207.nupkg
Microsoft.TemplateEngine.Edge |  5.0.207.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x |  5.0.207.nupkg
Microsoft.TemplateEngine.IDE |  5.0.207.nupkg
Microsoft.TemplateEngine.Core.Contracts |  5.0.207.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects |  5.0.207.nupkg




[//]: # ( Runtime 5.0.11)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/42213f70-6317-4b02-a3b9-3d4dbe301b0a/f13a87a5bb4af3259ea552c0e7b3244e/dotnet-runtime-5.0.11-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1d77e74-541f-40a6-b84d-edc6626530f1/d65b9d134f80a8cbc0d4ee6437f67bf5/dotnet-runtime-5.0.11-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e51b3880-e184-4c8a-a531-901b27ee71a4/47e1ec82f56ed1575b968cdde05f8a6b/dotnet-runtime-5.0.11-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9ef5df77-b235-4185-a724-f9a06c957224/55d83e03b411b3fb5530ba4f70f0da8a/dotnet-runtime-5.0.11-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d661c5b-ad29-452d-8b78-b1ba2d61b29d/8c41ef905e0c9d7543b292432d7dd064/dotnet-runtime-5.0.11-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4652f15f-0061-4b13-aa61-0c1d23c3b290/af67e2036f0086a3794ba988233b41ae/dotnet-runtime-5.0.11-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f241f934-a4cc-400a-8d03-a5ab50c25fea/1c8600ad088a42b157c073454e80039a/dotnet-runtime-5.0.11-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7c468308-1a9c-4a27-995c-c6b7abb3b836/bbafc217b524cb3cceda376ae1d4f3c3/dotnet-runtime-5.0.11-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/7930c212-84fc-48e6-93c8-b604cc6463c8/bae4121788cb0ee15370ca45802a34af/dotnet-runtime-5.0.11-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0d8f2620-95cc-4d8d-bcce-83cbacb8b8ee/32dd6e205397aff3067789d4b6e264aa/dotnet-runtime-5.0.11-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/240681b9-686b-4147-bda0-ae3004addc6d/dba078f8eb8e6f9a6a9f616c414ef365/dotnet-runtime-5.0.11-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/77e2cc05-9221-4bee-9ed4-b3414aa8da5e/ae1e859ff4395b83e22a61ec24e299d0/dotnet-runtime-5.0.11-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5d8afe47-8a54-4ca0-b34d-57120fa66d23/114044f7cfa4d581a49cefc47f3a8717/dotnet-runtime-5.0.11-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6997580b-59bd-470c-921e-77ac2b8cad41/47826fe2d249b27f8bafed9d4f9c7af8/dotnet-runtime-5.0.11-win-x86.zip

[//]: # ( WindowsDesktop 5.0.11)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a5e2ce05-7b16-46fe-b88c-4d3bf94f9bc6/a374ef55059f7bfe61daca61a152c8a1/windowsdesktop-runtime-5.0.11-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/06de9c13-4207-44e3-a802-1c90ff44048d/0d6cb312c95c7094434c381f77c75d8c/windowsdesktop-runtime-5.0.11-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0393fb31-b54e-4325-ba45-2b682fd6a43d/90036afbb9671be618554bf8fae3f66f/windowsdesktop-runtime-5.0.11-win-x86.exe

[//]: # ( ASP 5.0.11)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7126edf-69d6-4c87-8701-9f1e8c9cc261/27ebfe3ee12c8b123cb98d7f02335126/aspnetcore-runtime-5.0.11-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95be731b-40c7-4fc8-8649-e74edf9c56d7/6d20942920ca8bebaccf8c359d3866a6/aspnetcore-runtime-5.0.11-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/35db3bba-18fa-4481-b954-fb798babc1cc/44a62da4e9d105e40433ee9d5cfd6ac9/aspnetcore-runtime-5.0.11-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89a19400-ce4c-4d1f-8788-c7f3d5584ae6/ddcdc6185b161e86d5de94b4fc69cc43/aspnetcore-runtime-5.0.11-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1941a86d-1233-4a05-aa93-f8fd8f431310/05ff89d2af9db7f2f597973ef83924f9/aspnetcore-runtime-5.0.11-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac2cec9e-f5ab-44db-8fa9-aba5e5cf7378/956dac1b6510675a0ae8705918e22df7/aspnetcore-runtime-5.0.11-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f21e896-2c53-47f1-874c-2a8758d0c388/5d79a59d2ca3e724e498b8d3530cd5d6/aspnetcore-runtime-5.0.11-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/22ffdd6e-8904-4ed6-af6e-24585a133732/770acce4be2152d3a1c55424719cf965/aspnetcore-runtime-5.0.11-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1f45eb5c-3d3d-423a-aacb-6a596f271632/df34923f6f1ec035b3049a7b5db05947/aspnetcore-runtime-5.0.11-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a5bc5aa8-1ff0-4da2-a2ac-3d45b2fd6776/f1c683975ea741327f7f0c2ccd534418/aspnetcore-runtime-5.0.11-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0358616c-d42e-435a-a970-c6d219fb2ada/076b712cc24c291b8f2387df9c853842/aspnetcore-runtime-5.0.11-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4c4e8fc8-ed7f-4a0c-8580-983dd9d14073/bc6c4f885f7316280ca1cee581256434/aspnetcore-runtime-5.0.11-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/df452763-4b7d-490a-bc03-bd1003d3ff4c/665ee1786528809f33e791558b69cf51/dotnet-hosting-5.0.11-win.exe

[//]: # ( SDK 5.0.402)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6947f5e-4fb9-4f53-a751-84d1ba02c980/ace871205811c028e669141856b33eda/dotnet-sdk-5.0.402-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7b43281-99bd-4ba8-895d-445c1b66d7e0/1aa47e66e91da87cac9badb5420e074f/dotnet-sdk-5.0.402-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/221ae33c-07ca-4b89-bdc0-885a3cf4de22/93f97668fec62fa76cdf6cb6efcb09e5/dotnet-sdk-5.0.402-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bfbbc5ab-16d1-49a5-8b79-737968383fe5/30a8e5e37581c4bf873225a4eb6fbd3c/dotnet-sdk-5.0.402-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6445c655-6a5f-4a71-8f29-36c93998958d/351a81788bf2e6c295cf70f51915d950/dotnet-sdk-5.0.402-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6788a5a5-1879-4095-948d-72c7fbdf350f/c996151548ec9f24d553817db64c3577/dotnet-sdk-5.0.402-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d7f16106-4577-4216-b887-925e50531d09/610e5193ce14a5755bc23496f8b3ae23/dotnet-sdk-5.0.402-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/88bc1553-e90f-4a4f-9574-65d9a5065cd2/1d5646e1abb8b4d4a61ba0b0be976047/dotnet-sdk-5.0.402-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/50ae4c83-5e38-4eba-b683-68313e7ed6f2/14a0ed0f807fc8ecf3f68cb3464016bc/dotnet-sdk-5.0.402-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/d78a5900-8b22-485c-9f5b-e59d345894b9/54624a256cc3b3461c76520a080eeb9c/dotnet-sdk-5.0.402-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a98ca4d4-a6bd-4052-8466-4445621e3ac5/41b6d2e47a5228d499efed5c1603a1f5/dotnet-sdk-5.0.402-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8a504918-9508-464d-80c6-4da7f9cc9ac6/f9d6ad00bbd798bafb549101b5b4a4c0/dotnet-sdk-5.0.402-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c826dbd3-e72f-46f7-a60a-8edde0e086de/aced282e985e941bfdd222781c722fe2/dotnet-sdk-5.0.402-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/35331d66-9652-4632-b008-fad03a1d7265/6ef6f64049d08afca95135ab84107f4c/dotnet-sdk-5.0.402-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/48be3e72-92fd-4b88-b88a-0ba9a53f6e8e/36e816df8be6949cc47cd8b6d4763b65/dotnet-sdk-5.0.402-win-x86.zip

