# .NET 5.0.12 - November 08, 2021

The .NET 5.0.12, .NET 5.0.403 SDK  and [.NET SDK 5.0.209](5.0.209.md) releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.403
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.12 release carries non-security fixes.


**Windows SDK Updates**
* TFM support for the Windows 11 SDK is available with  .NET SDK 5.0.403 and .NET SDK 5.0.209. To target the Windows 11 SDK (10.0.22000)  in .NET 5, set the `TargetFramework` property in your project file to `net5.0-windows10.0.22000.0`.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)

Release feature and bug lists:.

* [ASP.NET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A5.0.12+is%3Aclosed+label%3Aservicing-approved+)
* [EFCore](https://github.com/dotnet/efcore/issues?q=milestone%3A5.0.12++is%3Aclosed+label%3Aservicing-approved+)



## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6884](https://github.com/dotnet/core/issues/6884) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 5.0.12.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.12-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.12-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/november-2021-updates/

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.12xx+is%3Aclosed

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.12.symbols.nupkg
Microsoft.WindowsDesktop.App | 5.0.12-servicing.21523.4.symbols.nupkg
runtime.win-arm64.Microsoft.WindowsDesktop.App | 5.0.12-servicing.21523.4.symbols.nupkg
runtime.win-x86.Microsoft.WindowsDesktop.App | 5.0.12-servicing.21523.4.symbols.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.12.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.12.symbols.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.12.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.12.symbols.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.12.nupkg
runtime.win-x64.Microsoft.WindowsDesktop.App | 5.0.12-servicing.21523.4.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.12.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.12.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.12.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.12.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.12.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.12.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.12.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.12.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.12.nupkg
runtime.linux-x64.Microsoft.NETCore.App | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.12.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.12.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.nupkg
runtime.osx-x64.Microsoft.NETCore.App | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.ILDAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.ILAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.12.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.ILDAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.12.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.12.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.12.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.12.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.12.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.App | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.App | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.TestHost | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.12.symbols.nupkg
dotnet-ilverify | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.12.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.12.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.12.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.12.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.12.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.ILAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.ILDAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.12.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.App | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.TestHost | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.App | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.ILAsm | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.12.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.12.symbols.nupkg
Microsoft.ILVerification | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NET.Sdk.IL | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.12.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.TestHost | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.ILDAsm | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.12.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.12.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.12.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.12.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.12.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.12.nupkg
Microsoft.NETCore.DotNetHost | 5.0.12.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.App | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.12.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.TestHost | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.TestHost | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.12.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.TestHost | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.ILAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.12.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.ILDAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.12.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.ILDAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-musl-arm.Microsoft.CrossOsDiag.Private.CoreCLR | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.12.symbols.nupkg
runtime.linux-arm.Microsoft.CrossOsDiag.Private.CoreCLR | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.12.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.12.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.12.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.12.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.12.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.12.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.12.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.12.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.12.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.TestHost | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-x64.Microsoft.CrossOsDiag.Private.CoreCLR | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.ILAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.App | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.ILDAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.ILDAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.12.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.ILDAsm | 5.0.12-servicing.21522.7.symbols.nupkg
System.Drawing.Common | 5.0.3.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.12.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.12.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.12.symbols.nupkg
Microsoft.NET.HostModel | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.12.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.ILAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.12.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.TestHost | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.12.symbols.nupkg
Microsoft.NETCore.TestHost | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.12.symbols.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.12.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.12.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.12.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.12.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.12.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.nupkg
runtime.linux-x64.Microsoft.NETCore.TestHost | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.12.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.12.symbols.nupkg
runtime.linux-musl-x64.Microsoft.CrossOsDiag.Private.CoreCLR | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.ILAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.ILAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.App | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.ILDAsm | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.12.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.12.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.ILAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.ILAsm | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.BrowserDebugHost.Transport | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.12.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.12.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.12.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.12.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.12.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.nupkg
System.Drawing.Common | 5.0.3.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.12.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.12.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.12.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.12.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.12.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.12.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.12.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.ILDAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.ILAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.12.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.12.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.CrossOsDiag.Private.CoreCLR | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.ILAsm | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.TestHost | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.TestHost | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.12.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Internal | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.12.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.12.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.12.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.App | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.App | 5.0.12-servicing.21522.7.symbols.nupkg
runtime.linux-arm64.Microsoft.CrossOsDiag.Private.CoreCLR | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.NETCore.DotNetHost | 5.0.12.symbols.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.12.symbols.nupkg
Microsoft.NETCore.ILDAsm | 5.0.12-servicing.21522.7.symbols.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.12.symbols.nupkg
dotnet-sql-cache | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.12.symbols.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.12.symbols.nupkg
Microsoft.JSInterop | 5.0.12.symbols.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.12.symbols.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Components | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Metadata | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.12.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.12.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.12.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.12.symbols.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Owin | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.12.nupkg
Microsoft.dotnet-openapi | 5.0.12.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.12.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.12.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.12.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.12.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.12.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.12.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.12.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.12.nupkg
Microsoft.AspNetCore.Metadata | 5.0.12.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.12.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.12.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.TestHost | 5.0.12.symbols.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.12.symbols.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.12.symbols.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.12.symbols.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.12.symbols.nupkg
Microsoft.Extensions.Identity.Core | 5.0.12.symbols.nupkg
Microsoft.Extensions.Localization | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.12.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.12.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.12.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.12.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.12.nupkg
Microsoft.AspNetCore.TestHost | 5.0.12.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.12.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.12.nupkg
Microsoft.Extensions.WebEncoders | 5.0.12.nupkg
Microsoft.Extensions.Identity.Core | 5.0.12.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.12.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.12.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.12.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.12.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.12.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.12.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.12.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.12.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.12.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.12.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.12.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.12.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 5.0.12.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.12.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.12.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.12.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.12.symbols.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.12.symbols.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.12.symbols.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.12.symbols.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.12.symbols.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.12.symbols.nupkg
Microsoft.Extensions.WebEncoders | 5.0.12.symbols.nupkg
Microsoft.Extensions.ObjectPool | 5.0.12.symbols.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.12.symbols.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.12.symbols.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.12.symbols.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.12.symbols.nupkg
dotnet-sql-cache | 5.0.12.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.12.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.12.symbols.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.12.nupkg
Microsoft.AspNetCore.Owin | 5.0.12.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.12.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.12.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.12.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.12.nupkg
Microsoft.AspNetCore.Components | 5.0.12.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.12.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.12.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.12.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.12.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.12.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.12.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.12.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.12.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.12.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.12.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.12.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.12.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.12.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.12.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.12.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.12.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.12.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.12.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.12.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.12.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.12.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.12.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.12.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.12.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.12.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authorization | 5.0.12.symbols.nupkg
Microsoft.dotnet-openapi | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.12.symbols.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.12.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.12.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.12.symbols.nupkg
Microsoft.AspNetCore.Authorization | 5.0.12.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.12.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.12.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.12.nupkg
Microsoft.JSInterop | 5.0.12.nupkg
Microsoft.Extensions.ObjectPool | 5.0.12.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.12.nupkg
Microsoft.Extensions.Localization | 5.0.12.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.12.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.12.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.12.nupkg
Microsoft.EntityFrameworkCore | 5.0.12.symbols.nupkg
Microsoft.Data.Sqlite.Core | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.12.nupkg
Microsoft.Data.Sqlite | 5.0.12.nupkg
Microsoft.EntityFrameworkCore | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.12.nupkg
dotnet-ef | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.12.symbols.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.12.nupkg
Microsoft.Data.Sqlite.Core | 5.0.12.nupkg
dotnet-ef | 5.0.12.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.12.nupkg
Microsoft.TemplateSearch.Common | 5.0.403.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.403.nupkg
Microsoft.TemplateEngine.Utils | 5.0.403.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.403.nupkg
Microsoft.TemplateEngine.Edge | 5.0.403.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.403.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.403.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.403.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.403.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.403.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.403.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.403.nupkg
Microsoft.TemplateEngine.Core | 5.0.403.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.403.nupkg
Microsoft.TemplateEngine.IDE | 5.0.403.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.403.nupkg



[//]: # ( Runtime 5.0.12)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2ca66adb-937e-44f0-9a80-8ee752917e7a/37c2e836710260ce00783fe1c0cb031d/dotnet-runtime-5.0.12-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7c342ad2-2dae-471b-ae46-c0c820321c1f/a480ad8ca0bc826a48c9b1e56efd972b/dotnet-runtime-5.0.12-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5806401d-7ed9-4e3d-9601-cb157ae9de61/3596e23aecc66e8af6749c2a8db25768/dotnet-runtime-5.0.12-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a03bf2ad-1aec-4918-97b8-eb977f628aa3/6d27ce6285e334b1d180dc48b7c21219/dotnet-runtime-5.0.12-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3e4ac548-13b7-4c3a-8f14-4972ea5bee0c/dd9a95ac97af220c1e9f4ca0dc7e3667/dotnet-runtime-5.0.12-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/781b7ae6-166c-4114-97f8-926d2bf74d34/fe51479e3138d672c512ef0322be23d3/dotnet-runtime-5.0.12-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0439a1bb-d460-481c-8417-421e1d9d35c7/871e3f7dcdb93a40c65b1aeb759ff916/dotnet-runtime-5.0.12-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8f990fa6-6b13-40ad-95f6-383391ff3d91/7531048d16c01efdf3885da367aa8b89/dotnet-runtime-5.0.12-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c7d027eb-42ab-437a-ad08-4485efdadc59/e187284fb3d3685450165c863cbd405f/dotnet-runtime-5.0.12-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bb91d307-2b0c-475e-a9ff-4a67c591ad35/f1aa4ac6542d794dd386b00e5e5a3090/dotnet-runtime-5.0.12-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/28b0479a-2ca7-4441-97f2-64a3d64b2ea4/9995401dac4787a2d1104c73c4356f4d/dotnet-runtime-5.0.12-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/621870ff-5d50-4152-b9dc-5c91871a60ef/4a1bc4bbb530bdcd37a5c7a73ca91b00/dotnet-runtime-5.0.12-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/94445818-4766-4911-99cd-2cff1ce9dca6/31f17971ee0e6ac16a99a2368fd20567/dotnet-runtime-5.0.12-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e2639a13-ebc0-4674-80a2-f8a835c76674/5f13b8884a13bd60e396d8615ef0a346/dotnet-runtime-5.0.12-win-x86.zip

[//]: # ( WindowsDesktop 5.0.12)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/fd514c1e-52fd-4065-9a77-556038d7ee6f/73ebc0c45f39208c6ab01b1af87102e5/windowsdesktop-runtime-5.0.12-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1daf85dc-291b-4bb8-812e-a0df5cdb6701/85455a4a851347de26e2901e043b81e1/windowsdesktop-runtime-5.0.12-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d3318276-b6db-422e-a156-8fdab0b4f27f/c758ff5762bb1d618c093a6f125ed592/windowsdesktop-runtime-5.0.12-win-x86.exe

[//]: # ( ASP 5.0.12)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0d780521-07bf-4e3e-94d3-57168d50eff3/1c7c9b5dd51e4751c04af943c5263679/aspnetcore-runtime-5.0.12-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bfc8ae06-2830-4082-a09e-63b3c7134096/880a4712d4ba3491c88aa566553c4e8a/aspnetcore-runtime-5.0.12-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ba3f0b0-7485-4b09-9aee-57c6cf49c7e0/783cc3e110ed370753eb95d17706f0b3/aspnetcore-runtime-5.0.12-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b9285c3b-3ca8-41e6-b52b-8beedae2821f/b19417d56c22288bc0f000c69c28692c/aspnetcore-runtime-5.0.12-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3f3b44c-305a-44a0-a470-fd99311950b4/8be59e430dd7a9b1c7142b811fd9d44e/aspnetcore-runtime-5.0.12-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ad0a54ca-4b88-4762-a790-aebeaba6b9e7/0f796fb90696d078046d90d8a05c027e/aspnetcore-runtime-5.0.12-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06d71ed5-0755-40d6-8b8e-14a24b8a9cb7/47a8b4deda0deecf3658716b642c69bf/aspnetcore-runtime-5.0.12-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f7860011-5032-4a8e-a9fd-2b145cae783a/a266120ec13564bb39d2fcfff035da50/aspnetcore-runtime-5.0.12-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/818bbc20-7dca-4fc5-a068-70bedc521bd7/89e08866807f9221f4425c4d53b0acc9/aspnetcore-runtime-5.0.12-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8ab70bc9-c295-4587-bc09-0e8d0b94d36d/bfb35470c168caa4ba630b26aedd082c/aspnetcore-runtime-5.0.12-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e2e9672a-cdf7-4068-ac39-0b6e1b980979/5e2b2ebf050c718d1656c2e444c79916/aspnetcore-runtime-5.0.12-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4a83b5fd-ba8c-4f4b-89f9-e2bcebf5f85a/6227395b3168440c6f0546e8c59b330f/aspnetcore-runtime-5.0.12-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/bf3abcc3-5461-451c-9dd6-b74491cf0eed/84775adc7e46888289477b5c72e691fd/dotnet-hosting-5.0.12-win.exe

[//]: # ( SDK 5.0.403)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/93c86ea7-b04e-4d0f-b65a-3a982768e215/285ab1a46d5c4f2067f86f575262c79f/dotnet-sdk-5.0.403-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91015c72-ce5a-4840-9e87-5bfa4bb80224/b39692ac418d790ff7a2e092eb07de98/dotnet-sdk-5.0.403-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d61b893f-ff73-41ef-93e7-c5db4a76c5db/010b6ad1500557a4f00bb31a4295f197/dotnet-sdk-5.0.403-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4608c47-ee2e-4b05-aa3e-b5ed86b6431f/331d7f84d9f135c0a173b0fab64cde3b/dotnet-sdk-5.0.403-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c50e9ec5-729e-4417-b682-70f3d37d94b0/4fdc24e5027037d352d669bd28e29fe8/dotnet-sdk-5.0.403-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b77183fa-c045-4058-82c5-d37742ed5f2d/ddaccef3e448a6df348cae4d1d271339/dotnet-sdk-5.0.403-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/214fbdaa-ec34-44e1-bafe-ee6c4f5646d1/412ddb4b8bf5ae582dc595a674c613af/dotnet-sdk-5.0.403-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e33ad12e-b121-4205-934a-bb5fff892d1c/41598bac64f46f1e7a772867aaed638e/dotnet-sdk-5.0.403-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ccdb916-531f-4064-84e8-5475b273a4de/80dcfa0c2eb528f8b0e7c313ed36f4f1/dotnet-sdk-5.0.403-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/afcc405c-bd7d-4c4a-b933-59e2d6699b2e/6c78add4959849dd4b65a0f639ad809a/dotnet-sdk-5.0.403-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d013885b-e94d-419f-aa6e-ab872ddeebd4/a484b89231afa9a07ea9dd912c984793/dotnet-sdk-5.0.403-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5303da13-69f7-407a-955a-788ec4ee269c/dc803f35ea6e4d831c849586a842b912/dotnet-sdk-5.0.403-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d1ca6dbf-d054-46ba-86d1-36eb2e455ba2/e950d4503116142d9c2129ed65084a15/dotnet-sdk-5.0.403-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fb6e9e3b-ca0c-406e-8c37-452d31abf534/d24aac6e4f8ce972c4d78d54874c34bd/dotnet-sdk-5.0.403-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5b521d28-e971-402c-8f60-569204e0bf12/bc6d120de7a6e9245de6339db824a204/dotnet-sdk-5.0.403-win-x86.zip
