# .NET 5.0.14 - February 8, 2022

The .NET 5.0.14, .NET 5.0.405 SDK  and [.NET SDK 5.0.211](5.0.211.md) releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.405
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Deployment Update

Customers that have opted to receive .NET Core updates via the Microsoft Update channel will be offered updates to the Hosting Bundle starting with the February 2022 update. Updates for other .NET Core bundles (.NET Core Runtime, ASP.NET Core Runtime, Windows Desktop Runtime, and SDK) have been offered via Microsoft Update to customers that opt in since December 2020. See this [blog post](https://devblogs.microsoft.com/dotnet/net-core-updates-coming-to-microsoft-update) for more information.

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.14 release carries security and non-security fixes.

# Microsoft Security Advisory  CVE-2022-21986  | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET and .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Denial of Service vulnerability exists in .NET 6.0 and .NET 5.0 when the Kestrel web server processes certain HTTP/2 and HTTP/3 requests.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7172](https://github.com/dotnet/core/issues/7172) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 5.0.14.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.14-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.14-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/february-2022-updates/

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.13xx+is%3Aclosed

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.14.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.14.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.14.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.14.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.14.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.14.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.14.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.14.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.14.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.14.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.14.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.14.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.14.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.14.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.14.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.14.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.14.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.14.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.14.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.14.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.14.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.14.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.14.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.14.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.14.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.14.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.14.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.14.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.14.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.14.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.14.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.14.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.14.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.14.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.14.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.14.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.14.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.14.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.14.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.14.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.14.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.14.nupkg
Microsoft.NETCore.DotNetHost | 5.0.14.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.14.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.14.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.14.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.14.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.14.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.14.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.14.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.14.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.14.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.14.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.14.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.14.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.14.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.14.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.14.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.14.nupkg
AspNetCoreRuntime | 5.0.x86 | 5.0.14.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.14.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.14.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.14.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.14.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.14.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.14.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.14.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.14.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.14.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.14.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.14.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.14.nupkg
Microsoft.dotnet-openapi | 5.0.14.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.14.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.14.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.14.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.14.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.14.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.14.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.14.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.14.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.14.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.14.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.14.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.14.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.14.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.14.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.14.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.14.nupkg
Microsoft.AspNetCore.Authorization | 5.0.14.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.14.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.14.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.14.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.14.nupkg
Microsoft.Extensions.WebEncoders | 5.0.14.nupkg
Microsoft.JSInterop | 5.0.14.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.14.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.14.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.14.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.14.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.14.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.14.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.14.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.14.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.14.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.14.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.14.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.14.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.14.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.14.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.14.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.14.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.14.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.14.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.14.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.14.nupkg
Microsoft.AspNetCore.TestHost | 5.0.14.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.14.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.14.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.14.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.14.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.14.nupkg
Microsoft.Extensions.Localization | 5.0.14.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.14.nupkg
Microsoft.AspNetCore.Owin | 5.0.14.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.14.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.14.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.14.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.14.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.14.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.14.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.14.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.14.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.14.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.14.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.14.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.14.nupkg
Microsoft.AspNetCore.Components | 5.0.14.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.14.nupkg
Microsoft.AspNetCore.Metadata | 5.0.14.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 5.0.14.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.14.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.14.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.14.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.14.nupkg
dotnet-sql-cache | 5.0.14.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.14.nupkg
Microsoft.Extensions.ObjectPool | 5.0.14.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.14.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.14.nupkg
Microsoft.Extensions.Identity.Core | 5.0.14.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.14.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.14.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.14.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.14.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.14.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.14.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.14.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.14.nupkg
dotnet-ef | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.14.nupkg
Microsoft.Data.Sqlite | 5.0.14.nupkg
Microsoft.Data.Sqlite.Core | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.14.nupkg
Microsoft.EntityFrameworkCore | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.14.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.14.nupkg







[//]: # ( Runtime 5.0.14)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a33a7fce-f5ec-4155-8b47-db5f534616b5/009a2daa585e5168fffa041e0db11c58/dotnet-runtime-5.0.14-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86fc75ca-8ba0-4d49-b505-3a7e10b2e26d/dde7cd87f4ba2f07c5249e779c0fc0ff/dotnet-runtime-5.0.14-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4d5e8c2e-2510-47e9-be90-ad2b40bdea7b/b31004797f4d149ada205b087755887c/dotnet-runtime-5.0.14-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/46ca1a16-9ef7-480f-9252-40f5597d93ec/f60d384eb47c91257a4f3b7e81691702/dotnet-runtime-5.0.14-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4f15ed86-df02-4a8d-97e8-9912396b74fc/039b05eeb0755ea812b0588e87cb5eb7/dotnet-runtime-5.0.14-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7e0c48d-e0ce-4ef9-b30b-41a66a078b0a/26cba85b178af0458f09830a93ab956b/dotnet-runtime-5.0.14-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/49533d3a-a628-4539-a423-0b339af07303/3cd77c7c592725ca58fdc70c1090de6a/dotnet-runtime-5.0.14-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/215bd3ec-d345-4bcf-ac89-1095ae786261/4b468c72e60c62ee6dc9e13e7c8aa2b1/dotnet-runtime-5.0.14-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f9a0b7d2-8764-48b0-84bc-26e25b58239f/a2f6ddc78116040059ab7057eb8a492f/dotnet-runtime-5.0.14-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/da34f479-d917-4414-85b5-6689df45dad8/ad103e06f684332a11bdc5ac8388d13a/dotnet-runtime-5.0.14-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e4c6abab-bb6a-4e55-82e2-841f4a1badfe/37b49c5cd9453a3116473a4cf9490a17/dotnet-runtime-5.0.14-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/90f9f150-4768-4d8f-8516-a114b6a449d8/85bb8dbf8e225d12cc5e181b79d8ebc1/dotnet-runtime-5.0.14-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/706716bc-fd3c-4cef-a646-ecb617be32eb/ad00baee06de59b26a6725dc0364671f/dotnet-runtime-5.0.14-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/42bdf154-9ce2-40d9-99f2-036f04fe6788/b1c2f987441369495a84ce1d90d66f78/dotnet-runtime-5.0.14-win-x86.zip

[//]: # ( WindowsDesktop 5.0.14)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/500939fe-abf6-4104-8883-5e32a081025c/02b60c18722995c3c73eb70c103000ba/windowsdesktop-runtime-5.0.14-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2887cb40-178c-4c1c-8fc1-ad5b8a29075b/33b8f9d6bbcf1b8bef4170ff101e85d0/windowsdesktop-runtime-5.0.14-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5bc3f97a-fef2-49cc-8320-eb0910beb9d4/bf0980b7fd0e599cd862db7ab109c2f4/windowsdesktop-runtime-5.0.14-win-x86.exe

[//]: # ( ASP 5.0.14)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7a910e3-4d1d-4d14-a4c1-cd95c75edad3/7fb356b6848053fa8178b3451740c6b2/aspnetcore-runtime-5.0.14-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/960844f6-f1ef-4bd1-808e-3c6d7bdfc961/edd9f3c40525812c4035129939e8be51/aspnetcore-runtime-5.0.14-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dbf10879-3e94-4b5f-b714-5781241755fa/85d8dd6429df045f300bb05627762c30/aspnetcore-runtime-5.0.14-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6bb9baf-d083-49bf-be3e-9c49f0431595/5362de83ac461764edceaca561182cfc/aspnetcore-runtime-5.0.14-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f81d79df-1d45-4356-b6af-a834ce4329e8/e5c62b77f758adf3cf4a4ea6699fd011/aspnetcore-runtime-5.0.14-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f56adf04-e4a8-48bf-b2e2-722e7206a4f2/7f40d4ebeff281120ba76e7b091356b0/aspnetcore-runtime-5.0.14-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/942d1f83-3741-4d38-a65a-7eba6fa0c3ec/c5f80db85d86104993b6bb27a554c259/aspnetcore-runtime-5.0.14-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/65a27706-3b3b-4eae-af72-a13152ad508b/6e8f5b9ebf231d52040ffbb3b21e814d/aspnetcore-runtime-5.0.14-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/52a19242-a21c-421b-97d4-e69d70e802c5/db47df274b9c64ea2e22f90983e0e946/aspnetcore-runtime-5.0.14-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/37376bf6-3e4c-42d4-b09d-df50a07a26de/7bf55605d280d81356e1df73b61d6067/aspnetcore-runtime-5.0.14-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/144df243-2b0a-4b71-a258-2a3d6d5bb580/657500a79c0bcff546652624dbfe1741/aspnetcore-runtime-5.0.14-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e19a4a32-7f9f-497e-ae10-b12bac119c4d/1cc1d9d654156f3893478ba4dea7dc46/aspnetcore-runtime-5.0.14-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/5adf4f36-aff5-447f-99db-86eae913d4eb/b71f76ea31156438499da1d419c577ff/dotnet-hosting-5.0.14-win.exe

[//]: # ( SDK 5.0.405)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/05835b75-b3a8-446f-b436-5d4ca73a07ff/3c97bef6e58a5bd84ed9df3f625cd6bc/dotnet-sdk-5.0.405-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3c0011b6-9ec7-484e-9485-56512752c5b5/06c6163c7481da86a15811355ba8beaa/dotnet-sdk-5.0.405-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/46cf5192-28e0-4fef-a1ea-3c3a7c8334d8/38d75b84da6431154fc8969950ba2221/dotnet-sdk-5.0.405-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f05a8c18-b725-4fdf-aa61-7f834910f10f/b99d50df590d8dc1fcb040ad41959cd6/dotnet-sdk-5.0.405-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8031e025-0b70-40fd-b429-9dddb855dfb6/95e438d9f5bfd01c0fe0ecada7ec86a3/dotnet-sdk-5.0.405-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e10f8ecd-eb2c-42a0-a217-98a18517e12c/436b90a4d5be20456b210c406c0f7718/dotnet-sdk-5.0.405-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7e2c910c-3739-446f-9bca-4a60c1c3c4ae/92dbb5800fbe6b124e1707da875cf10d/dotnet-sdk-5.0.405-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/77ad3bf2-2229-44a0-a5d2-56d476bc9b90/a6356813f1e5934c1dff6f0391c5b826/dotnet-sdk-5.0.405-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/308f5dac-451a-4c73-b1be-2730f9bfa7f8/fb4c3bb3d1e91e650e45dda04802a43b/dotnet-sdk-5.0.405-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a731c2e1-5531-497a-9222-fd1004195f83/a5a89b1c3e74b606552a27effcf3ab38/dotnet-sdk-5.0.405-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/5209a6e9-b4a8-4239-85e1-78c4af8d280a/76d6fb769d70043758d447cca56acb4c/dotnet-sdk-5.0.405-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1055020b-9c1a-4fd1-bb3e-64de0de2ee65/fbb705491eaea5fd9137de9fd230bbba/dotnet-sdk-5.0.405-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/afa3d76a-ab36-42ea-8fab-55bab92a0f9f/e5c5794e246f56441949c23f36d62097/dotnet-sdk-5.0.405-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3af0272c-42b6-437d-8072-856ac0fa4c2d/ee64a16ea87f9df115aae37c9b0cc28a/dotnet-sdk-5.0.405-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2418f63a-4861-44d5-a70c-c08bb0dc5db3/baab3873e605d2a04b59c9f54e149127/dotnet-sdk-5.0.405-win-x86.zip
