# .NET 5.0.211 SDK - February 8, 2022

The .NET SDK 5.0.211 release is available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe]  \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz]  \|[Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.211
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.10](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7172](https://github.com/dotnet/core/issues/7172) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 5.0.14.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.14-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.14-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/february-2022-updates/

[linux-packages]: ../install-linux.md

[//]: # ( Runtime 5.0.14)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a33a7fce-f5ec-4155-8b47-db5f534616b5/009a2daa585e5168fffa041e0db11c58/dotnet-runtime-5.0.14-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86fc75ca-8ba0-4d49-b505-3a7e10b2e26d/dde7cd87f4ba2f07c5249e779c0fc0ff/dotnet-runtime-5.0.14-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4d5e8c2e-2510-47e9-be90-ad2b40bdea7b/b31004797f4d149ada205b087755887c/dotnet-runtime-5.0.14-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/46ca1a16-9ef7-480f-9252-40f5597d93ec/f60d384eb47c91257a4f3b7e81691702/dotnet-runtime-5.0.14-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4f15ed86-df02-4a8d-97e8-9912396b74fc/039b05eeb0755ea812b0588e87cb5eb7/dotnet-runtime-5.0.14-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7e0c48d-e0ce-4ef9-b30b-41a66a078b0a/26cba85b178af0458f09830a93ab956b/dotnet-runtime-5.0.14-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/49533d3a-a628-4539-a423-0b339af07303/3cd77c7c592725ca58fdc70c1090de6a/dotnet-runtime-5.0.14-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/215bd3ec-d345-4bcf-ac89-1095ae786261/4b468c72e60c62ee6dc9e13e7c8aa2b1/dotnet-runtime-5.0.14-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f9a0b7d2-8764-48b0-84bc-26e25b58239f/a2f6ddc78116040059ab7057eb8a492f/dotnet-runtime-5.0.14-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/da34f479-d917-4414-85b5-6689df45dad8/ad103e06f684332a11bdc5ac8388d13a/dotnet-runtime-5.0.14-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e4c6abab-bb6a-4e55-82e2-841f4a1badfe/37b49c5cd9453a3116473a4cf9490a17/dotnet-runtime-5.0.14-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/90f9f150-4768-4d8f-8516-a114b6a449d8/85bb8dbf8e225d12cc5e181b79d8ebc1/dotnet-runtime-5.0.14-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/706716bc-fd3c-4cef-a646-ecb617be32eb/ad00baee06de59b26a6725dc0364671f/dotnet-runtime-5.0.14-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/42bdf154-9ce2-40d9-99f2-036f04fe6788/b1c2f987441369495a84ce1d90d66f78/dotnet-runtime-5.0.14-win-x86.zip

[//]: # ( WindowsDesktop 5.0.14)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/500939fe-abf6-4104-8883-5e32a081025c/02b60c18722995c3c73eb70c103000ba/windowsdesktop-runtime-5.0.14-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2887cb40-178c-4c1c-8fc1-ad5b8a29075b/33b8f9d6bbcf1b8bef4170ff101e85d0/windowsdesktop-runtime-5.0.14-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5bc3f97a-fef2-49cc-8320-eb0910beb9d4/bf0980b7fd0e599cd862db7ab109c2f4/windowsdesktop-runtime-5.0.14-win-x86.exe

[//]: # ( ASP 5.0.14)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7a910e3-4d1d-4d14-a4c1-cd95c75edad3/7fb356b6848053fa8178b3451740c6b2/aspnetcore-runtime-5.0.14-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/960844f6-f1ef-4bd1-808e-3c6d7bdfc961/edd9f3c40525812c4035129939e8be51/aspnetcore-runtime-5.0.14-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dbf10879-3e94-4b5f-b714-5781241755fa/85d8dd6429df045f300bb05627762c30/aspnetcore-runtime-5.0.14-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6bb9baf-d083-49bf-be3e-9c49f0431595/5362de83ac461764edceaca561182cfc/aspnetcore-runtime-5.0.14-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f81d79df-1d45-4356-b6af-a834ce4329e8/e5c62b77f758adf3cf4a4ea6699fd011/aspnetcore-runtime-5.0.14-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f56adf04-e4a8-48bf-b2e2-722e7206a4f2/7f40d4ebeff281120ba76e7b091356b0/aspnetcore-runtime-5.0.14-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/942d1f83-3741-4d38-a65a-7eba6fa0c3ec/c5f80db85d86104993b6bb27a554c259/aspnetcore-runtime-5.0.14-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/65a27706-3b3b-4eae-af72-a13152ad508b/6e8f5b9ebf231d52040ffbb3b21e814d/aspnetcore-runtime-5.0.14-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/52a19242-a21c-421b-97d4-e69d70e802c5/db47df274b9c64ea2e22f90983e0e946/aspnetcore-runtime-5.0.14-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/37376bf6-3e4c-42d4-b09d-df50a07a26de/7bf55605d280d81356e1df73b61d6067/aspnetcore-runtime-5.0.14-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/144df243-2b0a-4b71-a258-2a3d6d5bb580/657500a79c0bcff546652624dbfe1741/aspnetcore-runtime-5.0.14-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e19a4a32-7f9f-497e-ae10-b12bac119c4d/1cc1d9d654156f3893478ba4dea7dc46/aspnetcore-runtime-5.0.14-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/5adf4f36-aff5-447f-99db-86eae913d4eb/b71f76ea31156438499da1d419c577ff/dotnet-hosting-5.0.14-win.exe

[//]: # ( SDK 5.0.211)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0a2b69e2-ba06-4c16-a9a0-0494c42a7e89/29dcbf1bede9f2144ca2e2e18858bcee/dotnet-sdk-5.0.211-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aa678558-596b-4133-9266-b2849298f99d/bb00bc2cbf187c08d876078bc0d850e4/dotnet-sdk-5.0.211-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3204153d-0d8c-4559-b75e-83597a4b691d/d0821fdffc007a9aafcf9a92aef5167c/dotnet-sdk-5.0.211-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2d80fa39-b8ad-4fd7-89ba-2d6b5b2dc168/40d7b15dc0dd1eb7c9ed2882a870cf21/dotnet-sdk-5.0.211-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/086b9edb-e1c0-4a17-b369-38ff57f5c95a/8a9f79c79d918f28d9e03fb568866c27/dotnet-sdk-5.0.211-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ca593d52-b865-4341-8ad9-edba982cd235/da5433ea2f93e9540c057e0ddeaeb1d6/dotnet-sdk-5.0.211-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/957b909f-3481-4271-8dc7-0b8afdff283c/a38a566c2ccd2387b0fc78eea4bd8ba4/dotnet-sdk-5.0.211-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e9feafac-acc8-48e9-9697-d6823d19e777/15106a794f18ed9048ccd1c034ca881d/dotnet-sdk-5.0.211-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0396f626-776a-493d-b856-70b1801998cc/3fd3dfdf863a9a46fecff1d44e4fb073/dotnet-sdk-5.0.211-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/42c9f226-598a-41e8-9d4e-0f74fe4b5f59/8783cea9793c71c4eadf39c9c37bc542/dotnet-sdk-5.0.211-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0eb9960a-da2e-448c-9ab8-e761497745f1/31e3a8e58aba741f56d56c896624fc7b/dotnet-sdk-5.0.211-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/188f2075-65f1-4fe1-b6dc-50f435031cab/5e3212f67f9a60626da175b54df1d363/dotnet-sdk-5.0.211-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/563b1fc8-4c10-40b1-ba95-fd8533ebc03c/a9bf16b360b5d118377cac21ff4bda74/dotnet-sdk-5.0.211-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1ff16e8b-c424-4ce3-9727-f15a8b85be2d/7bb4452e45a0241461bf1a32149bec98/dotnet-sdk-5.0.211-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d8008629-dd61-45a1-bfa4-3883ed2b4780/2f55d73819faec1405d69b2b6388a37c/dotnet-sdk-5.0.211-win-x86.zip
