# .NET 5.0.2 - January 12, 2021

The .NET 5.0.2 and .NET SDK 5.0.102 releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe]  |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](5.0.2-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.102
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.2 release carries both security and non-security fixes.

### [CVE-2021-1723 | ASP.NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-1723)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core and ASP.NET 5. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial-of-service vulnerability exists in the way Kestrel parses HTTP/2 requests. The security update addresses the vulnerability by fixing the way the Kestrel parses HTTP/2 requests.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)


Release feature and bug lists:.

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A5.0.2+is%3Aclosed+label%3Aservicing-approved)
* [ASP.NET Core](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A5.0.2+is%3Aclosed+label%3Aservicing-approved)
* [EntityFramework Core](https://github.com/dotnet/efcore/issues?q=milestone%3A5.0.2+is%3Aclosed+label%3Aservicing-approved)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A5.0.2+is%3Aclosed+label%3Aservicing-approved)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5838](https://github.com/dotnet/core/issues/5838) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 5.0.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.2-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-january-2021/
[ef_bugs]:

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.2xx+is%3Aclosed

[linux-packages]: 5.0.2-install-instructions.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.2.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.2.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.2.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.2.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.2.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.2.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.2.nupkg
System.Composition.Hosting | 5.0.1.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.2.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.2.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.2.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.2.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.2.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.2.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.2.nupkg
System.Composition.AttributedModel | 5.0.1.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.2.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.2.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.2.nupkg
System.Composition.Convention | 5.0.1.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.2.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.2.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.2.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.2.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.2.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.2.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.2.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.2.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.android-arm64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.android-x86 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.2.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.2.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.2.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.2.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.2.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.2.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.2.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.2.nupkg
System.Composition.Runtime | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.ios-arm64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.android-arm | 5.0.2.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.2.nupkg
Microsoft.NETCore.DotNetHost | 5.0.2.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.2.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.2.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.2.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.2.nupkg
System.Composition | 5.0.1.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.2.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.2.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.android-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.2.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.2.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.2.nupkg
System.Composition.TypedParts | 5.0.1.nupkg
System.Diagnostics.DiagnosticSource | 5.0.1.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.2.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.2.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.2.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.2.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.2.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.ios-arm | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.ios-x86 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.ios-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.2.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.2.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.tvos-arm64 | 5.0.2.nupkg
System.Text.Json | 5.0.1.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.2.nupkg
Microsoft.Windows.Compatibility | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.tvos-x64 | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.2.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.2.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.2.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.2.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.2.nupkg
Microsoft.AspNetCore.TestHost | 5.0.2.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.2.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.2.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.2.nupkg
Microsoft.JSInterop | 5.0.2.nupkg
Microsoft.Extensions.ObjectPool | 5.0.2.nupkg
Microsoft.Extensions.Identity.Core | 5.0.2.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.2.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.2.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.2.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.2.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.2.nupkg
Microsoft.AspNetCore.Authorization | 5.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.2.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.2.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.2.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.2.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.2.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.2.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.2.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.2.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.2.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.2.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.2.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.2.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.2.nupkg
dotnet-sql-cache | 5.0.2.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.2.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.2.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.2.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.2.nupkg
Microsoft.dotnet-openapi | 5.0.2.nupkg
Microsoft.AspNetCore.Owin | 5.0.2.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.2.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.2.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.2.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.2.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.2.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.2.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.2.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.2.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.2.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.2.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.2.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.2.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.2.nupkg
Microsoft.AspNetCore.Metadata | 5.0.2.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.2.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.2.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.2.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.2.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.2.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.2.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.2.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.2.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.2.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.2.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.2.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.2.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.2.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.2.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.2.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.2.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.2.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.2.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.2.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.2.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.2.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.2.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.2.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.2.nupkg
Microsoft.Extensions.Localization | 5.0.2.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.2.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.2.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.2.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.2.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.2.nupkg
Microsoft.AspNetCore.Components | 5.0.2.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.2.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.2.nupkg
Microsoft.Extensions.WebEncoders | 5.0.2.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.2.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.2.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.2.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.2.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.2.nupkg
dotnet-ef | 5.0.2.nupkg
Microsoft.EntityFrameworkCore | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.2.nupkg
Microsoft.Data.Sqlite | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.2.nupkg
Microsoft.Data.Sqlite.Core | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.2.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.2.nupkg
Microsoft.TemplateSearch.Common | 5.0.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.2.nupkg
Microsoft.TemplateEngine.Edge | 5.0.2.nupkg
Microsoft.TemplateEngine.Utils | 5.0.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.2.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.2.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.2.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.2.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.2.nupkg
Microsoft.TemplateEngine.Core | 5.0.2.nupkg
Microsoft.TemplateEngine.IDE | 5.0.2.nupkg


[//]: # ( Runtime 5.0.2)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4e24057a-80d3-4de8-bbab-f337f8cdf56f/6c4775b4dee44be13355ca74b86797cf/dotnet-runtime-5.0.2-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/da9f2fae-5a8b-40f4-b7e7-e4961f6e563c/f490ee2c3e2359eef0f9d3f5474a75c1/dotnet-runtime-5.0.2-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2d48075f-8d7e-4f17-ae96-33902e5d7cd1/f3f5376248a049b8476d8a582fb93ff7/dotnet-runtime-5.0.2-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/47f4383b-2508-4556-aec9-ed98f9c31bbc/16bf1a085390e9a8a9ddba95cb31353c/dotnet-runtime-5.0.2-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/824175f2-5577-46ec-a675-95d2f652575f/07dafc2398e669afa7d25f2d47398c36/dotnet-runtime-5.0.2-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b9f136a4-0898-4ad8-98b5-896629d24f14/ba28f0f0d1225b4dab1c38a737b9149c/dotnet-runtime-5.0.2-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6136d22d-3fd7-4b43-a963-cec1a12e06da/a512860af0f18b7b3a6dabe6f5e55b3f/dotnet-runtime-5.0.2-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/6768dc3b-0913-4526-8e86-6a63a40135b1/c4497bb6b72ccf139830075b862850af/dotnet-runtime-5.0.2-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/ac414c78-32bb-4fa7-b2a5-3ca19e577fff/e8c8c2391301b0cac9085422e0446b0b/dotnet-runtime-5.0.2-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8526b5e6-e6e7-4d0b-902b-1f4ad5dd1462/7de15b8c6ab0387402d5958e99a62ed9/dotnet-runtime-5.0.2-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4f44c1f4-2860-4b92-9e32-2d93ce2b16aa/93d5ad650664aec50d05ae6c436913f0/dotnet-runtime-5.0.2-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/46f8a025-ea67-4288-8e6a-709cfebc9b4b/69045dd85bcbfdd50441a87dedc13bd0/dotnet-runtime-5.0.2-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/aa281535-ba5d-4fea-a0ec-f47eb90436b4/3b070e6dff1b235d2c9780c52cb36522/dotnet-runtime-5.0.2-win-x86.zip

[//]: # ( WindowsDesktop 5.0.2)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/deffc9d5-ef77-4697-ac6e-33a58ccdc409/8386e478b5823a765dc1361155360877/windowsdesktop-runtime-5.0.2-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/adeb8933-7480-4015-abf6-ca31137ad7cd/1123096ebfa5ee3f36d77500b622e4d8/windowsdesktop-runtime-5.0.2-win-x86.exe

[//]: # ( ASP 5.0.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7aa18d1a-1c9a-4571-9668-3d76b5cda367/41a75d18282fa815c548be4dbc9dd55f/aspnetcore-runtime-5.0.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f77f99f3-ee58-421a-bf4d-75155e361b9b/ea196b00d51607ad1796aa82697ee8da/aspnetcore-runtime-5.0.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd4d5d32-f493-411e-9e04-ecaae0a372f0/252cc794c641b6bbdae0faeeb6e78152/aspnetcore-runtime-5.0.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/63fe4210-67f0-4d01-99c8-284e26978498/464f60cca9e84fc28371828552455d06/aspnetcore-runtime-5.0.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e2e14e82-11e6-430b-a1a1-b905ab23136c/35a5e31bee5151deb0532535b6a585e8/aspnetcore-runtime-5.0.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97fed7d4-e8d2-4142-8b49-5f7c2c567e4f/622e19cf8c9f33acfd1cc0d0f358b66d/aspnetcore-runtime-5.0.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8b8a56ce-3f25-45fc-9bc8-043bf216a9ac/3eccd27ea8e9feeb26cde6fceaf47362/aspnetcore-runtime-5.0.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/33c6f212-fcd3-428f-8ce5-9e4c0792fb58/06ffa38c3a903f8621e3ee2b78db40b7/aspnetcore-runtime-5.0.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9d0b45f7-1c23-4766-abf3-3e259eedc961/82c4672b26e83c5f396c22171943f31d/aspnetcore-runtime-5.0.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b2fd1b9b-1b96-457a-83fe-25089fd052c4/30b503f5ecbf04586aeff2e8658d5fb6/aspnetcore-runtime-5.0.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b5da785d-ce57-4b05-aef2-083776d6f765/cf64f37f9590bd28193a5658428342d8/aspnetcore-runtime-5.0.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/43ea9d7a-39c9-467a-83e6-548b3faf832d/5e7d573d9c4f40d0c1192aa2319f07c5/dotnet-hosting-5.0.2-win.exe

[//]: # ( SDK 5.0.102 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/726e260e-ce94-46c3-a169-57b2ebf5433d/5fb2a00b04b3509a0a6db63e302523a8/dotnet-sdk-5.0.102-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4fdd4708-8990-42db-998d-36ccfa593070/d67cb90c382e4eedbca8af1aebcbbe19/dotnet-sdk-5.0.102-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf715f3d-ab8a-42a1-83ce-f6e1524a9f58/8d970618369fe8e6917a49c05aac58db/dotnet-sdk-5.0.102-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7f736160-9f34-4595-8d72-13630c437aef/b9c4513afb0f8872eb95793c70ac52f6/dotnet-sdk-5.0.102-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/52bd43f7-88c9-420c-80c0-f19bae344293/a8d56f01fdb6f71adb5e22c3ddd1c3c6/dotnet-sdk-5.0.102-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1610d52e-df25-496d-ad60-fab11f4cdd40/73411a5ab50060a914bf71c044a7e4ea/dotnet-sdk-5.0.102-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/17a3de4c-bb2b-4e60-baaf-85395cf0fb2b/869c6316078ffa1575e78b8005ed30a1/dotnet-sdk-5.0.102-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/9b3f6a0a-345e-42d6-bdb0-7e1b671e0a5f/39daa777d12bb33d14eade85df41b5b4/dotnet-sdk-5.0.102-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/75483251-b77a-41a9-9ea2-05fb1668e148/2c27ea12ec2c93434c447f4009f2c2d2/dotnet-sdk-5.0.102-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8773ea25-70e8-47da-b46f-8b060f696dd6/1976c9d35ac773539c7064b39bb99b11/dotnet-sdk-5.0.102-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6fbee1fb-1fe5-40c8-b3e1-56988de60eb4/9c5b8606ebd7724b67f994adaf3ff574/dotnet-sdk-5.0.102-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/bb93ed48-502c-4ff0-83a3-b6d4ac79e58b/a41fa1c797e3c67ba68780f32b596c4a/dotnet-sdk-5.0.102-win-x86.zip
