# .NET 5.0.7 - June 08, 2021

The .NET 5.0.7 and .NET SDK 5.0.204 releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](5.0.7-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.204
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.7 release carries both security and non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)
* .NET SDK 5.0.204 and 5.0.301 includes fixes to the runtime and Windows SDK projections with C#/WinRT v1.2.6. Refer to the C#/WinRT v1.2.6 [release notes](https://github.com/microsoft/CsWinRT/releases/tag/1.2.6.210512.1) for more details.

Release feature and bug lists:.

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A5.0.7+is%3Aclosed+label%3Aservicing-approved)
* [ASP.NET](https://github.com/dotnet/aspnetcore/pulls?q=milestone%3A5.0.7+is%3Aclosed+label%3Aservicing-approved)

### Microsoft Security Advisory CVE-2021-31957 |  ASP.NET Denial of Service Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when ASP.NET Core improperly handles client disconnect.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6337](https://github.com/dotnet/core/issues/6337) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 5.0.7.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.7-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.7-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-june-2021/

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.7xx+is%3Aclosed

[linux-packages]: 5.0.7-install-instructions.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.7.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.7.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.7.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.7.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.7.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.7.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.7.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.7.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.7.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.7.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.7.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.7.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.7.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.7.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.7.nupkg
Microsoft.NETCore.DotNetHost | 5.0.7.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.7.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.7.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.7.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.7.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.7.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.7.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.7.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.7.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.7.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.7.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.7.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.7.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.7.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.7.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.7.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.7.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.7.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.7.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.7.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.7.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.7.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.7.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.7.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.7.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.7.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.7.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.7.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.7.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.7.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.7.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.7.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.7.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.7.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.7.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.7.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.7.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.7.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.7.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.7.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.7.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.7.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.7.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.7.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.7.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.7.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.7.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.7.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.7.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.7.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.7.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.7.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.7.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.7.nupkg
Microsoft.AspNetCore.Authorization | 5.0.7.nupkg
Microsoft.AspNetCore.Owin | 5.0.7.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.7.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.7.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.7.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.7.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.7.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.7.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.7.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.7.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.7.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.7.nupkg
Microsoft.AspNetCore.Components | 5.0.7.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.7.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.7.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.7.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.7.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.7.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.7.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.7.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.7.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.7.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.7.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.7.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.7.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.7.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.7.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.7.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.7.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.7.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.7.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.7.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.7.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.7.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.7.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.7.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.7.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.7.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.7.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.7.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.7.nupkg
dotnet-sql-cache | 5.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.7.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.7.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.7.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.7.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.7.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.7.nupkg
Microsoft.dotnet-openapi | 5.0.7.nupkg
Microsoft.AspNetCore.TestHost | 5.0.7.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.7.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.7.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.7.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.7.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.7.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.7.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.7.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.7.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.7.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.7.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.7.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.7.nupkg
Microsoft.JSInterop | 5.0.7.nupkg
Microsoft.Extensions.ObjectPool | 5.0.7.nupkg
Microsoft.Extensions.WebEncoders | 5.0.7.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.7.nupkg
Microsoft.Extensions.Identity.Core | 5.0.7.nupkg
Microsoft.Extensions.Localization | 5.0.7.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.7.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.7.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.7.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.7.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.7.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.7.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.7.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.7.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.7.nupkg
Microsoft.AspNetCore.Metadata | 5.0.7.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.7.nupkg
Microsoft.EntityFrameworkCore | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.7.nupkg
dotnet-ef | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.7.nupkg
Microsoft.Data.Sqlite.Core | 5.0.7.nupkg
Microsoft.Data.Sqlite | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.7.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.7.nupkg
Microsoft.TemplateSearch.Common | 5.0.204.nupkg
Microsoft.TemplateEngine.Utils | 5.0.204.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.204.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.204.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.204.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.204.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.204.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.204.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.204.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.204.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.204.nupkg
Microsoft.TemplateEngine.Core | 5.0.204.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.204.nupkg
Microsoft.TemplateEngine.Edge | 5.0.204.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.204.nupkg
Microsoft.TemplateEngine.IDE | 5.0.204.nupkg
Microsoft.TemplateSearch.Common | 5.0.300-preview.21260.2.nupkg
Microsoft.TemplateEngine.Utils | 5.0.300-preview.21260.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.300-preview.21260.2.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.300-preview.21260.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.300-preview.21260.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.300-preview.21260.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.300-preview.21260.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.300-preview.21260.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.300-preview.21260.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.300-preview.21260.2.nupkg
Microsoft.TemplateEngine.IDE | 5.0.300-preview.21260.2.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.300-preview.21260.2.nupkg
Microsoft.TemplateEngine.Core | 5.0.300-preview.21260.2.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.300-preview.21260.2.nupkg
Microsoft.TemplateEngine.Edge | 5.0.300-preview.21260.2.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.300-preview.21260.2.nupkg
Microsoft.TemplateSearch.Common | 5.0.300-preview.21159.1.nupkg
Microsoft.TemplateEngine.Utils | 5.0.300-preview.21159.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.300-preview.21159.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.300-preview.21159.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.300-preview.21159.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.300-preview.21159.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.300-preview.21159.1.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.300-preview.21159.1.nupkg
Microsoft.TemplateEngine.Core | 5.0.300-preview.21159.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.300-preview.21159.1.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.300-preview.21159.1.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.300-preview.21159.1.nupkg
Microsoft.TemplateEngine.Edge | 5.0.300-preview.21159.1.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.300-preview.21159.1.nupkg
Microsoft.TemplateEngine.IDE | 5.0.300-preview.21159.1.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.300-preview.21159.1.nupkg

[//]: # ( Runtime 5.0.7)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09a24e9f-0096-454a-b761-70cdf9504775/eafe9578bbedd15c9319b7580d5a20d9/dotnet-runtime-5.0.7-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9a37d9f-6158-43a4-a610-f0f9e8c2cb73/c69c6d22c668cb09b2d00bea8209335b/dotnet-runtime-5.0.7-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/890a960e-b478-4b4c-8b18-7b8e2bb4892e/716ffd5ec3f246689fbc6f34166f8200/dotnet-runtime-5.0.7-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fe3dcf97-d54b-4ef3-b304-202ef017ef0c/00e5f7239b72d0b36205c41abda44204/dotnet-runtime-5.0.7-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3d098e22-2e18-4ec5-9dd6-48221ae5da54/11557f45937144aef3a3434fac917c6c/dotnet-runtime-5.0.7-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f229fc63-747e-46c8-89ac-88563c2e0b7d/8e59115deda958a26e1546f603cbad9a/dotnet-runtime-5.0.7-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/335378b2-0aab-43bd-af4f-c68981adba0d/3307b1d830682a8511fbf193235c9fd2/dotnet-runtime-5.0.7-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0a3ab585-4d52-447f-b6a2-c25638d7fd7a/f19e512145c1a331a33781e1aea5270b/dotnet-runtime-5.0.7-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/fac5bbef-e7d7-4d95-87d1-f61ea2de2bf2/a97916ab72de907469b9daa8bdfd8259/dotnet-runtime-5.0.7-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0688a2f7-4058-44ec-a5e2-2ab0f97b3543/1b03cff49ef1bfc21c925e4631947618/dotnet-runtime-5.0.7-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/bccb30a0-58ee-4ef9-8944-ceafbd22d7f3/e07e886e84289b613cceefc224f0b35f/dotnet-runtime-5.0.7-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/228f6800-8b86-4310-bfb0-c0c70b02ca9c/bc078c051f431dac6bd45f98001789b3/dotnet-runtime-5.0.7-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3e9b22f6-05a9-4ca2-8154-fe3991ffed15/66f9745bed899f496446ffed876464a8/dotnet-runtime-5.0.7-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d679f0f4-3a68-4f52-844e-1788059c50a6/9780f129da4978a26fd6d0ecf715fa16/dotnet-runtime-5.0.7-win-x86.zip

[//]: # ( WindowsDesktop 5.0.7)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2b83d30e-5c86-4d37-a1a6-582e22ac07b2/c7b1b7e21761bbfb7b9951f5b258806e/windowsdesktop-runtime-5.0.7-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c8af603e-ef3d-4bf3-89b9-f11dce1c2fc9/d416996ef55aa134b8aba565685d1ed2/windowsdesktop-runtime-5.0.7-win-x86.exe
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/9532506e-81f3-41af-842f-01654c6d27ef/130c483c5b4401a4cee4b98cb308131c/windowsdesktop-runtime-5.0.7-win-arm64.exe

[//]: # ( ASP 5.0.7)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2f690848-1342-4768-a7d7-45fa476a4a22/50dd1c50ed7864140b04fec057bb8bd6/aspnetcore-runtime-5.0.7-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d0a22fa3-b916-49ce-8284-97131b424cb3/cb884163ad34b83f1ae1dbd33e09d77a/aspnetcore-runtime-5.0.7-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3910971c-4d8e-4daf-ab90-b92497811d4a/4b723cd010da5e542cef93791a5acffb/aspnetcore-runtime-5.0.7-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/da6e519e-de03-4f59-919d-6a2078315002/db88cc7ac18065edfeb29476a4793b23/aspnetcore-runtime-5.0.7-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/84b45146-0981-4100-a7ba-1ca66e53de6f/1329827fa5c8a5ddb84de5e84c6725ce/aspnetcore-runtime-5.0.7-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6be94b3-458f-43c4-8bb5-9ba261de8c9c/bbe13b54208d088b5fdf428759b5bc0a/aspnetcore-runtime-5.0.7-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8c4b18f1-cc83-4a85-b711-f7820e92bc35/5648074f913c376b06a64f8655ef202d/aspnetcore-runtime-5.0.7-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8b404a57-d8bf-4a0b-92df-e57c2d55c193/450d2422d7166365d1e878cbf130f915/aspnetcore-runtime-5.0.7-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/64ae43e4-fcf0-4247-80ec-ac87d7f198f7/af4cec1666bbc03578442c174f4ad4be/aspnetcore-runtime-5.0.7-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ec3e6a91-56df-4f3e-bf8a-676c35363c12/f6d290090fa8c6c3174d708034ef3401/aspnetcore-runtime-5.0.7-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8668be00-9f55-41ce-9ca3-a3f4f9ac2d90/bf1739f11cbf61a47d2cf5f4b54e277e/aspnetcore-runtime-5.0.7-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0859d762-5d48-4fbd-b8bf-0778448162b7/4976d5fbc2587851bc228fbcb5274851/aspnetcore-runtime-5.0.7-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/2a40c007-8ad7-4e80-a334-40bc47851e90/fc13a55a20414ef9689fcf60618c412f/dotnet-hosting-5.0.7-win.exe


[//]: # ( SDK 5.0.204 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39bd276b-f1fa-45f2-819e-9041feb4713b/e15713f8adf5bad4dbaf605beb6264d0/dotnet-sdk-5.0.204-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/36fbba7c-ae8f-4ae2-82f4-0ef93688fbb9/901237fc7af7b1b14ae4620c3d5fe85e/dotnet-sdk-5.0.204-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e967259d-23ac-4332-bed4-0249d249a94b/d7210616f4088170c6cfcee1c867a122/dotnet-sdk-5.0.204-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3f96fd11-1c00-4ba8-a6f6-599148e4230c/fa25a47bfae7f42b21c3869db931eae2/dotnet-sdk-5.0.204-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20606d7d-0aa0-4566-bc0a-ef387f15724c/57204d49e2f92bf3d1af3997525ef561/dotnet-sdk-5.0.204-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8d4759e7-b95e-4934-854b-088a3c719d47/bf4a2474c123ccf99405e9375d3439da/dotnet-sdk-5.0.204-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/823f2ece-a172-4962-a72e-f48b831b5664/2160eb90f832e4763b24419ab1eda398/dotnet-sdk-5.0.204-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/dde1a91a-2d06-4e23-ba37-7a20e826e00e/ddfecafdb1959f15c39381939fc9e029/dotnet-sdk-5.0.204-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1815bf39-af04-4d2e-aeef-8fc5cb27a5ba/4e47c40b91267e72ce027f238aa5f6e4/dotnet-sdk-5.0.204-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/189c2392-85d0-461e-a32c-c93ee88b4b7e/888e2722a4b6aae05bf861ccce9a63cb/dotnet-sdk-5.0.204-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/c1ecac1e-ccd3-48fa-9d89-d7880a129c70/392c209057fee94e1a4f80b5b84d11a7/dotnet-sdk-5.0.204-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d709f7d9-496e-46a6-82f2-9d419a50f099/8ac5592315ea90aabb0fc22d77da1dcb/dotnet-sdk-5.0.204-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/cb3f191a-32a2-48aa-9ff1-414fc5fe770a/fedd794c53d98c2f12f753a7b6e1c34a/dotnet-sdk-5.0.204-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a51f5831-a1ea-43ae-83c7-e87797c8d813/903fd3f92f73007cbb758b2e43dd37dd/dotnet-sdk-5.0.204-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9815d243-3540-4a6a-ad70-e2b653b83ab8/e59e2a04356a6f375c4082fd4d20e039/dotnet-sdk-5.0.204-win-x86.zip
