# .NET 5.0.8 - July 13, 2021

The .NET 5.0.8 and .NET SDK 5.0.205 releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](5.0.8-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.205
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.8 release carries non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)

**Windows SDK Updates**

-  .NET SDK 5.0.205 and 5.0.302 includes fixes to the runtime and Windows SDK projections with C#/WinRT v1.3.0. Refer to the C#/WinRT v1.3.0 [release notes](https://github.com/microsoft/CsWinRT/releases/tag/1.3.0.210617.2) for more details.

- TFM support has been added for targeting Windows 10, version 2104 which corresponds with Windows 10 SDK version 10.0.20348.0. Note this version is primarily intended for Windows Server development.

- Support has been added for targeting Windows Insider SDK flights. More information will be available at [aka.ms/windowsinsidersdk](https://aka.ms/windowsinsidersdk)

Release feature and bug lists:.

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A5.0.8+is%3Aclosed+label%3Aservicing-approved)
* [ASP.NET](https://github.com/dotnet/aspnetcore/pulls?q=milestone%3A5.0.8+is%3Aclosed+label%3Aservicing-approved)
* [EF Core](https://github.com/dotnet/efcore/issues?q=milestone%3A5.0.8+is%3Aclosed+label%3Aservicing-approved)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A5.0.8+is%3Aclosed+label%3Aservicing-approved)
* [WPF](https://github.com/dotnet/WPF/issues?q=milestone%3A5.0.8+is%3Aclosed+label%3Aservicing-approved)


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6459](https://github.com/dotnet/core/issues/6459) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 5.0.8.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.8-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.8-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-july-2021/

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.8xx+is%3Aclosed

[linux-packages]: 5.0.8-install-instructions.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.8.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.8.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.8.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.8.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.8.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.8.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.8.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.8.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.8.nupkg
Microsoft.NETCore.DotNetHost | 5.0.8.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.8.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.8.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.8.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.8.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.8.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.8.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.8.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.8.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.8.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.8.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.8.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.8.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.8.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.8.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.8.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.8.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.8.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.8.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.8.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.8.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.8.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.8.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.8.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.8.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.8.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.8.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.8.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.8.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.8.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.8.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.8.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.8.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.8.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.8.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.8.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.8.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.8.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.8.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.8.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.8.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.8.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.8.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.8.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.8.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.8.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.8.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.8.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.8.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.8.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.8.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.8.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.8.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.8.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.8.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.8.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.8.nupkg
Microsoft.Extensions.DependencyInjection | 5.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.8.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.8.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.8.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.8.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.8.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.8.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.8.nupkg
Microsoft.Extensions.ObjectPool | 5.0.8.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.8.nupkg
Microsoft.Extensions.Localization | 5.0.8.nupkg
Microsoft.Extensions.Identity.Core | 5.0.8.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.8.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.8.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.8.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.8.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.8.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.8.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.8.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.8.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.8.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.8.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.8.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.8.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.8.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.8.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.8.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.8.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.8.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.8.nupkg
Microsoft.AspNetCore.Authorization | 5.0.8.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.8.nupkg
Microsoft.dotnet-openapi | 5.0.8.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.8.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.8.nupkg
Microsoft.AspNetCore.TestHost | 5.0.8.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.8.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.8.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.8.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.8.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.8.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.8.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.8.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.8.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.8.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.8.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.8.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.8.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.8.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.8.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.8.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.8.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.8.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.8.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.8.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.8.nupkg
Microsoft.AspNetCore.Components | 5.0.8.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.8.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.8.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.8.nupkg
Microsoft.AspNetCore.Owin | 5.0.8.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.8.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.8.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.8.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.8.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.8.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.8.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.8.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.8.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.8.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.8.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.8.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.8.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.8.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.8.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.8.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.8.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.8.nupkg
dotnet-sql-cache | 5.0.8.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.8.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.8.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.8.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.8.nupkg
Microsoft.JSInterop | 5.0.8.nupkg
Microsoft.Extensions.WebEncoders | 5.0.8.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.8.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.8.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.8.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.8.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.8.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.8.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.8.nupkg
Microsoft.AspNetCore.Metadata | 5.0.8.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 5.0.8.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.8.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.8.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.8.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.8.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.8.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.8.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.8.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.8.nupkg
Microsoft.Data.Sqlite | 5.0.8.nupkg
Microsoft.Data.Sqlite.Core | 5.0.8.nupkg
dotnet-ef | 5.0.8.nupkg
Microsoft.EntityFrameworkCore | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.8.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.8.nupkg
Microsoft.TemplateEngine.Utils | 5.0.301-servicing.21309.4.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.301-servicing.21309.4.nupkg
Microsoft.TemplateSearch.Common | 5.0.301-servicing.21309.4.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.301-servicing.21309.4.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.301-servicing.21309.4.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.301-servicing.21309.4.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.301-servicing.21309.4.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.301-servicing.21309.4.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.301-servicing.21309.4.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.301-servicing.21309.4.nupkg
Microsoft.TemplateEngine.Core | 5.0.301-servicing.21309.4.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.301-servicing.21309.4.nupkg
Microsoft.TemplateEngine.Edge | 5.0.301-servicing.21309.4.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.301-servicing.21309.4.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.301-servicing.21309.4.nupkg
Microsoft.TemplateEngine.IDE | 5.0.301-servicing.21309.4.nupkg
Microsoft.TemplateSearch.Common | 5.0.205.nupkg
Microsoft.TemplateEngine.Utils | 5.0.205.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.205.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.205.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.205.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.205.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.205.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.205.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.205.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.205.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.205.nupkg
Microsoft.TemplateEngine.Edge | 5.0.205.nupkg
Microsoft.TemplateEngine.Core | 5.0.205.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.205.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.205.nupkg
Microsoft.TemplateEngine.IDE | 5.0.205.nupkg



[//]: # ( Runtime 5.0.8)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06f47628-7e59-4e2a-9002-72d7e11b8cde/79a68d8fc9812b4f94e4f9f32f3acbc8/dotnet-runtime-5.0.8-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9810823d-5422-4582-8765-22a88738f706/5f0f5842ed94d48513a88419d301d693/dotnet-runtime-5.0.8-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/96b693d4-10dc-4d88-86dd-bd24695a7691/68bd59eac4d6a9f44f024aa70dd042eb/dotnet-runtime-5.0.8-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/753f85fe-f4e4-45cc-ac1e-7154ea9e36e9/bccbd902d6b19c952e4eccffa14a4d76/dotnet-runtime-5.0.8-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f5660b5-77cf-480f-9486-42f6c80bed12/c68a7fa03b01ba754ee18c0f99f34186/dotnet-runtime-5.0.8-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/50687c84-e120-4410-bd4a-b1e0869d03f4/6038576259f95ef61d4d103ee3967130/dotnet-runtime-5.0.8-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/22fcfd90-7eb6-4718-8408-574b2b3e84c9/a57853c81e35f08027549da03abf01ef/dotnet-runtime-5.0.8-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd40e07f-816b-43b5-a278-4ed0eed1f58b/5b34893e70f2fa24cb46eaa46b2d46f7/dotnet-runtime-5.0.8-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a9db1e56-7737-41ae-a178-10f4beb43e2b/e22b30796381520980a22d3edd9ee922/dotnet-runtime-5.0.8-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e7bdfaef-5aa1-45ab-8df0-734137f78a04/17f4d5ae2f058b18241ffad65be533bf/dotnet-runtime-5.0.8-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b2696089-c2ea-4cb4-8d3e-4e5840bdc57b/ffbc7ae206aba305bcbc90b8df5b7421/dotnet-runtime-5.0.8-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5959491c-bd4c-48f7-8355-9f6caf800925/17278efdec18c9e5df76331293e12a68/dotnet-runtime-5.0.8-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d8bc3c6a-1f67-428b-b1aa-0abe824a80b1/6376c6f9c04af91fc0880098ca04ef20/dotnet-runtime-5.0.8-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2d30fb6c-b42c-46b7-9e0d-421f31f99594/58421cc2c65af81dfad8f566783732a3/dotnet-runtime-5.0.8-win-x86.zip

[//]: # ( WindowsDesktop 5.0.8)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/81f697ea-9349-4d91-bce3-8dd8800d2f25/5d86a5e914b0a1d8ec6c3265ce379d14/windowsdesktop-runtime-5.0.8-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9b564b8a-a26d-4bb3-8f30-1101ae71a55a/2cee4f9e4c0e77e3d0f866fdf690864e/windowsdesktop-runtime-5.0.8-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c1c0117b-3565-4661-9a77-7629c937f808/90a45135929796778a9fd418bbad6bb3/windowsdesktop-runtime-5.0.8-win-x86.exe

[//]: # ( ASP 5.0.8)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e928c60-5f60-4c62-8439-422be547605c/0d1dc316cf38efdb2557f639ca9da4ad/aspnetcore-runtime-5.0.8-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/36c6210a-5b28-4598-81f7-2cef1a0bd1d5/296782726e68368c8ddf87ba828b5fc7/aspnetcore-runtime-5.0.8-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/17f425d8-bb82-4374-8033-528b86797077/b06f1a3a53a1684c695077d67921c364/aspnetcore-runtime-5.0.8-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95721021-b4e7-43c2-8224-d487a8a243cd/b9b774d486c4d60f3be3cdeaf0072ab8/aspnetcore-runtime-5.0.8-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a353a835-3bc6-4fc8-9a05-26bea9826584/4c7f93cefdaee9134aff2b0ce5d61829/aspnetcore-runtime-5.0.8-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b54c42a-4904-419b-8c24-bb2f39d4c8ae/279cd30211d8e5a9abf3129d04b4eb0e/aspnetcore-runtime-5.0.8-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f3c2f283-48c4-44d9-be16-2aba37ec63fc/b431ca2b5e6c07fa1a686dade10b00b6/aspnetcore-runtime-5.0.8-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e356013e-6518-4334-843a-282637f22a32/40e38a58b2d767e2efb5b97c8695ca8c/aspnetcore-runtime-5.0.8-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7898c205-d8c4-45d0-93e1-d325bc6f90df/1e9b4a648b44d1b64622a38534900438/aspnetcore-runtime-5.0.8-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b67f2dbb-13e5-49c8-816e-ff588aaa4016/6698e25488c9c56572b593474e32b4bd/aspnetcore-runtime-5.0.8-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/781b6844-f7f0-4b23-a7fd-2b45e8073fab/43bf54933d3aaffa790c80a15b2b2c0c/aspnetcore-runtime-5.0.8-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dd1ffc9b-44b9-4e08-85cb-6f19df44bdb7/204b5732b9cb8cda30f0ab75b08ba06d/aspnetcore-runtime-5.0.8-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c887d56b-4667-4e1d-9b6c-95a32dd65622/97e3eef489af8a6950744c4f9bde73c0/dotnet-hosting-5.0.8-win.exe


[//]: # ( SDK 5.0.205 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a15a71e8-631f-41a0-862c-9cf33c0fff1c/28b81940dbb60bf81d3188df3efc2e4b/dotnet-sdk-5.0.205-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1aa61b18-8aba-4e6e-ba6b-ced9cb54b9e5/9d306fa9d5a5b73fcaabe3e3bd7b14ec/dotnet-sdk-5.0.205-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3139cf00-b3e0-45e2-9970-7b35a0f67dac/360ff7e2a947bbbacf91c81c6bc37ea6/dotnet-sdk-5.0.205-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97711662-7b8e-466b-ae74-89e8689c30d5/6e543beae04c625631a0d44a620b3a09/dotnet-sdk-5.0.205-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/361609a6-f2a9-471e-80f7-fe50ee0386ad/d8ba5dfabc93ac3b0b5ea75ceb2d6256/dotnet-sdk-5.0.205-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/38484f17-9b5c-46cc-809e-482b5bb12561/078593038374fbdd6b854aa480ed3334/dotnet-sdk-5.0.205-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/88f53a16-abc0-497d-8f05-cd53d4208b1b/1abd5b0aa11d341b176532372abee261/dotnet-sdk-5.0.205-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1fa3aa30-7843-4099-956a-86db49f03a6d/9870ef2689b5ece8f404c7c3c1451e38/dotnet-sdk-5.0.205-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1bb111a9-0153-4e73-9903-faa81a2cf4f3/b67d4db77e83b6bc3307f2a9988c034e/dotnet-sdk-5.0.205-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/963babd1-b57a-40ce-bd5a-182e161714ae/e456c0627427345b0343f45269d41bbb/dotnet-sdk-5.0.205-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d755d4c3-4a30-4969-91cb-d962ada9e70e/348f9cdffe0787654313b318264a349a/dotnet-sdk-5.0.205-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/74deec55-803d-49cd-943c-0498823475d4/aced91287c74c1bdaa5d8c849373feea/dotnet-sdk-5.0.205-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d51ff64e-115d-4bd9-8fa0-0f8de8c416ed/adb2fead2e3309d31818a75de8b38e9e/dotnet-sdk-5.0.205-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fecc01be-ff13-4b6c-bba6-593118023998/4d878659ec16b8bc1a8d02fe9786c69e/dotnet-sdk-5.0.205-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d69e25b5-d4f8-4dc7-b252-0f65377cb60c/eb71da3fe085592d7bf97ba2a9426a05/dotnet-sdk-5.0.205-win-x86.zip
