# .NET 5.0.9 - August 10, 2021

The .NET 5.0.9, .NET 5.0.400 SDK , [.NET SDK 5.0.303](5.0.303.md) and [.NET SDK 5.0.206](5.0.206.md) releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.400
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.9 release carries both security and non-security fixes.

**Windows SDK Updates**

- .NET SDK 5.0.400, .NET SDK 5.0.303, and .NET SDK 5.0.206 include fixes to the runtime and Windows SDK targeting packages with C#/WinRT 1.3.1. Refer to the C#/WinRT 1.3.1 [release notes](https://github.com/microsoft/CsWinRT/releases/tag/1.3.1.210715.2) for more details.
- Support has been added for targeting Windows Insider SDK flights with the TFM. More information is available at [aka.ms/windowsinsidersdk](https://aka.ms/windowsinsidersdk)
# Microsoft Security Advisory CVE-2021-34485 | .NET Core Information Disclosure Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1 and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

An information disclosure vulnerability exists in .NET 5.0, .NET Core 3.1 and .NET Core 2.1 when dumps created by the tool to collect crash dumps and dumps on demand are created with global read permissions on Linux and macOS.

# Microsoft Security Advisory CVE-2021-26423 | .NET Core Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1 and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists in .NET 5.0, .NET Core 3.1 and .NET Core 2.1 where .NET (Core) server applications providing WebSocket endpoints could be tricked into endlessly looping while trying to read a single WebSocket frame.

# Microsoft Security Advisory CVE-2021-34532 | ASP.NET Core Information Disclosure Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1 and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

An information disclosure vulnerability exists in .NET 5.0, .NET Core 3.1 and .NET Core 2.1 where an JWT token is logged if it cannot be parsed.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)

Release feature and bug lists:.

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A5.0.9+is%3Aclosed+label%3Aservicing-approved)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A5.0.9+is%3Aclosed+label%3Aservicing-approved)



## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6553](https://github.com/dotnet/core/issues/6553) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 5.0.9.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.9-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.9-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-august-2021/

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.9xx+is%3Aclosed

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.9.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.9.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.9.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.9.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.9.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.9.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.9.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.9.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.9.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.9.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.9.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.9.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.9.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.9.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.9.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.9.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.9.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.9.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.9.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.9.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.9.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.9.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.9.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.9.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.9.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.9.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.9.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.9.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.9.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.9.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.9.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.9.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.9.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.9.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.9.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.9.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.9.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.9.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.9.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.9.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.9.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.9.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.9.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.9.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.9.nupkg
Microsoft.NETCore.DotNetHost | 5.0.9.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.9.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.9.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.9.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.9.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.9.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.9.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.9.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.9.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.9.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.9.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.9.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.9.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.9.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.9.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.9.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.9.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.9.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.9.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.9.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.9.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.9.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.9.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.9.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.9.nupkg
dotnet-sql-cache | 5.0.9.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.9.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.9.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.9.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.9.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.9.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.9.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.9.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.9.nupkg
Microsoft.AspNetCore.Authorization | 5.0.9.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.9.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.9.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.9.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.9.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.9.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.9.nupkg
Microsoft.AspNetCore.TestHost | 5.0.9.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.9.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.9.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.9.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.9.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.9.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.9.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.9.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.9.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.9.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.9.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.9.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.9.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.9.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.9.nupkg
Microsoft.JSInterop | 5.0.9.nupkg
Microsoft.Extensions.ObjectPool | 5.0.9.nupkg
Microsoft.Extensions.WebEncoders | 5.0.9.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.9.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.9.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.9.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.9.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.9.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.9.nupkg
Microsoft.dotnet-openapi | 5.0.9.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.9.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.9.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.9.nupkg
Microsoft.Extensions.Localization | 5.0.9.nupkg
Microsoft.Extensions.Identity.Core | 5.0.9.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.9.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.9.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.9.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.9.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.9.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.9.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.9.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.9.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.9.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.9.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.9.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.9.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.9.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.9.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.9.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.9.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.9.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.9.nupkg
Microsoft.AspNetCore.Components | 5.0.9.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.9.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.9.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.9.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.9.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.9.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.9.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.9.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.9.nupkg
Microsoft.AspNetCore.Owin | 5.0.9.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.9.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.9.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.9.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.9.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.9.nupkg
Microsoft.AspNetCore.Metadata | 5.0.9.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.9.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.9.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 5.0.9.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.9.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.9.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.9.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.9.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.9.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.9.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.9.nupkg
Microsoft.Data.Sqlite | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.9.nupkg
dotnet-ef | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.9.nupkg
Microsoft.Data.Sqlite.Core | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.9.nupkg
Microsoft.EntityFrameworkCore | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.9.nupkg
dotnet-ef | 5.0.9.nupkg
Microsoft.Data.Sqlite | 5.0.9.nupkg
Microsoft.Data.Sqlite.Core | 5.0.9.nupkg
Microsoft.EntityFrameworkCore | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.9.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.9.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.303-servicing.21357.17.nupkg
Microsoft.TemplateSearch.Common | 5.0.303-servicing.21357.17.nupkg
Microsoft.TemplateEngine.Utils | 5.0.303-servicing.21357.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.303-servicing.21357.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.303-servicing.21357.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.303-servicing.21357.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.303-servicing.21357.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.303-servicing.21357.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.303-servicing.21357.17.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.303-servicing.21357.17.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.303-servicing.21357.17.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.303-servicing.21357.17.nupkg
Microsoft.TemplateEngine.Core | 5.0.303-servicing.21357.17.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.303-servicing.21357.17.nupkg
Microsoft.TemplateEngine.IDE | 5.0.303-servicing.21357.17.nupkg
Microsoft.TemplateEngine.Edge | 5.0.303-servicing.21357.17.nupkg
Microsoft.TemplateSearch.Common| 5.0.206.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.206.nupkg
Microsoft.TemplateEngine.Utils | 5.0.206.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.206.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.206.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.206.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.206.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.206.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1| 5.0.206.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.206.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.206.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.206.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.206.nupkg
Microsoft.TemplateEngine.IDE | 5.0.206.nupkg
Microsoft.TemplateEngine.Core | 5.0.206.nupkg
Microsoft.TemplateEngine.Edge | 5.0.206.nupkg
Microsoft.TemplateSearch.Common | 5.0.400-preview.21302.2.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.400-preview.21302.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.400-preview.21302.2.nupkg
Microsoft.TemplateEngine.Utils | 5.0.400-preview.21302.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.400-preview.21302.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.400-preview.21302.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.400-preview.21302.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.400-preview.21302.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.400-preview.21302.2.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.400-preview.21302.2.nupkg
Microsoft.TemplateEngine.Edge | 5.0.400-preview.21302.2.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.400-preview.21302.2.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.400-preview.21302.2.nupkg
Microsoft.TemplateEngine.Core | 5.0.400-preview.21302.2.nupkg
Microsoft.TemplateEngine.IDE | 5.0.400-preview.21302.2.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.400-preview.21302.2.nupkg



[//]: # ( Runtime 5.0.9)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7716be6b-9eba-40e6-b604-f3bb043605d3/fc391bf75d968ae2161e1f0df9cbf8df/dotnet-runtime-5.0.9-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/75ac6907-d1a1-415d-907d-d5466b2dc4c5/a3bdfe046a226d5ca6f2e129319b2f7b/dotnet-runtime-5.0.9-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/52124868-d55e-4d32-827f-8617bf840f98/86647a82ae66fda9a5f8080fadfe485b/dotnet-runtime-5.0.9-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09033abc-a409-43aa-89f9-2486ab7939f1/b28bad774c18a0d28c8682560d99d56e/dotnet-runtime-5.0.9-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ae2199b-bbc1-418a-b2a7-9d88940afbf9/8cfb3e9c6f52361910b093032e5256e3/dotnet-runtime-5.0.9-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0c1eabe6-32ef-4785-92d1-8f09a0951b9e/d90c850374a07505bd577d3cff5d7536/dotnet-runtime-5.0.9-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a847df19-d530-41c8-b766-cb60ee8af9a4/7edd7c2eae38d25d0d7c90350eefea64/dotnet-runtime-5.0.9-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2591fa2f-798c-4b4a-942c-f8332cd4933e/a783ad19a8c9c60eb4f13b2dd79cbab2/dotnet-runtime-5.0.9-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/48a03b96-948c-4b69-8838-2a7e73967e9b/03b067ea028508e7fe336180462827c2/dotnet-runtime-5.0.9-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1834aecf-ceeb-4a0a-9d82-777286d703c2/003c37d11e5dd0358c126ad8f586c374/dotnet-runtime-5.0.9-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f3bb58e7-45e1-46ef-9b90-877a450e345e/b18e3d2c429422e9c1238c9b66ded855/dotnet-runtime-5.0.9-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/19e22aa6-051b-4417-a117-42081655b56b/c29c7125b6b51df18a6ecb48f0bcc8d3/dotnet-runtime-5.0.9-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/334f5618-b0fa-474c-b55e-1d10c9142161/61eb66bf79d0e6cf36f894a5fe847634/dotnet-runtime-5.0.9-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ad4e04d4-bc99-4028-af41-30d5280010bc/1480ef24269af9dac1f19573b4da5ccb/dotnet-runtime-5.0.9-win-x86.zip

[//]: # ( WindowsDesktop 5.0.9)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/77535d55-6913-4f0d-bbdd-b0a52c00f9f7/e7ab952b5033a38d4d1b240bc9db0d16/windowsdesktop-runtime-5.0.9-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8bc41df1-cbb4-4da6-944f-6652378e9196/1014aacedc80bbcc030dabb168d2532f/windowsdesktop-runtime-5.0.9-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d889a1ec-bf19-4915-8d8c-81adda8d558b/fffa6e33af1b4cfcafdca9aac3aef476/windowsdesktop-runtime-5.0.9-win-x86.exe

[//]: # ( ASP 5.0.9)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08f79414-91fe-4072-a75b-7b7c21d0fced/46c49c781f43901eb7c27c465c448b0a/aspnetcore-runtime-5.0.9-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0e3da9ad-b838-419a-8ad5-caaff159083f/484d306f2778f15519201178961372bc/aspnetcore-runtime-5.0.9-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a5a05e15-b2ea-465f-861e-9778f9bc0798/e6cbbea5e1325d25a271957444b59e13/aspnetcore-runtime-5.0.9-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5302dd36-5397-4b5e-ba0d-7220a33dc51f/fd098ada9102db37f8c32a0eebb32361/aspnetcore-runtime-5.0.9-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/94ca051b-c763-4030-92aa-88b8b3f71622/1056f826a36aec34b65763db27312a4b/aspnetcore-runtime-5.0.9-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/19046594-e911-4784-a148-6de3d74d4a7f/d5c1ba792c4266a2d2a8eea41e81a060/aspnetcore-runtime-5.0.9-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/61dcf562-ed13-4592-9e94-b0849e6ae22e/ea664c2bf8f4249131fd595549e45d5f/aspnetcore-runtime-5.0.9-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/206efef8-47fd-4ea2-94d0-878dde9bdc74/73edea2d40fe223313a65d6df02560b0/aspnetcore-runtime-5.0.9-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4b0ef3e7-ba6b-4213-b866-318695afbf3b/4218a12f9588ce7d6d6d394f8f3ef22e/aspnetcore-runtime-5.0.9-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/21a5ee42-c681-427d-987f-d7350b5f72c9/ebd923b5d6e0923f42668aab85fa15db/aspnetcore-runtime-5.0.9-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5bec3496-6944-4edc-936e-5a1beedd4fdd/6fb2df0cbd879c27c22c9f705784b768/aspnetcore-runtime-5.0.9-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2ad80c99-205f-4a4d-8263-64fd8c935876/ea056f7a0147fcea729f07335e4e3ad3/aspnetcore-runtime-5.0.9-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/a0f49856-eec9-4962-8d81-b09af6be9435/1d5fc0083b7f7e10ebed181329ca88ae/dotnet-hosting-5.0.9-win.exe

[//]: # ( SDK 5.0.400)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/70bdb5a9-34cc-4f28-aa33-15535f73b593/7d31d53187c8937206bcc3b117b88978/dotnet-sdk-5.0.400-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4d323232-ffcc-4c09-a043-a36b554c883e/096822e81dc29383b649cd015d1ff99a/dotnet-sdk-5.0.400-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8b17651a-5960-4c33-8f40-24bde02e0d7c/625d059dfbcce13a48bf4ed242a0b823/dotnet-sdk-5.0.400-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1a90902b-4d5f-458b-bd3c-990a3dca3db0/b0041b433b3e79eb4a596550701a35ed/dotnet-sdk-5.0.400-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08b6d245-401d-4b11-8e75-f2db47b5f166/5809c92b864453f3f666b8a9ce82f826/dotnet-sdk-5.0.400-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/13b9d84c-a35b-4ffe-8f62-447a01403d64/1f9ae31daa0f7d98513e7551246899f2/dotnet-sdk-5.0.400-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/95823260-fbb1-480a-9428-36c98687b1a0/3ceac2fedbe5131cbc8db734d0431d04/dotnet-sdk-5.0.400-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/543144ce-10ad-4396-a464-28c440f8fe22/29bd5273237ed3a408aef1f8aacd239b/dotnet-sdk-5.0.400-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e5672550-7ab9-439a-8dd4-d5b02608abe3/d1b27ba9dcfa96cd891dde40a406fdc3/dotnet-sdk-5.0.400-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/5d938024-9d9b-46c3-bc5a-4c6bd8557a36/0eaeafcee760762e97dacee2f65bef46/dotnet-sdk-5.0.400-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/5e673ff1-0cf9-40dc-8fa7-f6c7e96a664d/f48fc51c80d42c09613e209e5550b75f/dotnet-sdk-5.0.400-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c1bfbb13-ad09-459c-99aa-8971582af86e/61553270dd9348d7ba29bacfbb4da7bd/dotnet-sdk-5.0.400-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f7ed6662-c39e-43da-be01-ef7cae72cd6d/58ed07e77e1a8ab0cab93c17edf33817/dotnet-sdk-5.0.400-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3ac5df29-caba-40f8-aeea-6e7a900dcfcc/a28a5c80da9e9971db504ff86da2e0ba/dotnet-sdk-5.0.400-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ed0d3d60-27c4-42fa-92ff-e78c37ad35ff/3a0e6a8f3fd43b6310141d7db04906e2/dotnet-sdk-5.0.400-win-x86.zip


