# System.Net.Security

``` diff
 namespace System.Net.Security {
     public class NegotiateStream : AuthenticatedStream {
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
+    public delegate ValueTask<SslServerAuthenticationOptions> ServerOptionsSelectionCallback(SslStream stream, SslClientHelloInfo clientHelloInfo, object state, CancellationToken cancellationToken);
+    public readonly struct SslClientHelloInfo {
+        public string ServerName { get; }
+        public SslProtocols SslProtocols { get; }
+    }
     public class SslServerAuthenticationOptions {
+        public SslStreamCertificateContext ServerCertificateContext { get; set; }
     }
     public class SslStream : AuthenticatedStream {
+        public string TargetHostName { get; }
+        public void AuthenticateAsClient(SslClientAuthenticationOptions sslClientAuthenticationOptions);
+        public void AuthenticateAsServer(SslServerAuthenticationOptions sslServerAuthenticationOptions);
+        public Task AuthenticateAsServerAsync(ServerOptionsSelectionCallback optionsCallback, object state, CancellationToken cancellationToken = default(CancellationToken));
+        ~SslStream();
     }
+    public sealed class SslStreamCertificateContext {
+        public static SslStreamCertificateContext Create(X509Certificate2 target, X509Certificate2Collection additionalCertificates, bool offline = false);
+    }
 }
```

