# Microsoft.AspNetCore.Components.Forms

``` diff
 namespace Microsoft.AspNetCore.Components.Forms {
+    public static class BrowserFileExtensions {
+        public static ValueTask<IBrowserFile> RequestImageFileAsync(this IBrowserFile browserFile, string format, int maxWith, int maxHeight);
+    }
     public sealed class EditContext {
+        public EditContextProperties Properties { get; }
     }
     public static class EditContextFieldClassExtensions {
+        public static void SetFieldCssClassProvider(this EditContext editContext, FieldCssClassProvider fieldCssClassProvider);
     }
+    public sealed class EditContextProperties {
+        public EditContextProperties();
+        public object this[object key] { get; set; }
+        public bool Remove(object key);
+        public bool TryGetValue(object key, out object value);
+    }
+    public class FieldCssClassProvider {
+        public FieldCssClassProvider();
+        public virtual string GetFieldCssClass(EditContext editContext, in FieldIdentifier fieldIdentifier);
+    }
+    public interface IBrowserFile {
+        string ContentType { get; }
+        DateTimeOffset LastModified { get; }
+        string Name { get; }
+        long Size { get; }
+        Stream OpenReadStream(long maxAllowedSize = (long)512000, CancellationToken cancellationToken = default(CancellationToken));
+    }
     public abstract class InputBase<TValue> : ComponentBase, IDisposable {
+        public string DisplayName { get; set; }
-        protected FieldIdentifier FieldIdentifier { get; set; }
+        protected internal FieldIdentifier FieldIdentifier { get; set; }
     }
+    public class InputFile : ComponentBase, IDisposable, IInputFileJsCallbacks {
+        public InputFile();
+        public IDictionary<string, object> AdditionalAttributes { get; set; }
+        public EventCallback<InputFileChangeEventArgs> OnChange { get; set; }
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
+        protected override Task OnAfterRenderAsync(bool firstRender);
+        protected override void OnInitialized();
+        void System.IDisposable.Dispose();
+    }
+    public sealed class InputFileChangeEventArgs : EventArgs {
+        public InputFileChangeEventArgs(IReadOnlyList<IBrowserFile> files);
+        public IBrowserFile File { get; }
+        public int FileCount { get; }
+        public IReadOnlyList<IBrowserFile> GetMultipleFiles(int maximumFileCount = 10);
+    }
+    public class InputRadio<TValue> : ComponentBase {
+        public InputRadio();
+        public IReadOnlyDictionary<string, object> AdditionalAttributes { get; set; }
+        public string Name { get; set; }
+        public TValue Value { get; set; }
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
+        protected override void OnParametersSet();
+    }
+    public class InputRadioGroup<TValue> : InputBase<TValue> {
+        public InputRadioGroup();
+        public RenderFragment ChildContent { get; set; }
+        public string Name { get; set; }
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
+        protected override void OnParametersSet();
+        protected override bool TryParseValueFromString(string value, out TValue result, out string validationErrorMessage);
+    }
+    public class RemoteBrowserFileStreamOptions {
+        public RemoteBrowserFileStreamOptions();
+        public int MaxBufferSize { get; set; }
+        public int MaxSegmentSize { get; set; }
+        public TimeSpan SegmentFetchTimeout { get; set; }
+    }
 }
```

