# Microsoft.AspNetCore.Components.Server.ProtectedBrowserStorage

``` diff
+namespace Microsoft.AspNetCore.Components.Server.ProtectedBrowserStorage {
+    public abstract class ProtectedBrowserStorage {
+        public ValueTask DeleteAsync(string key);
+        public ValueTask<ProtectedBrowserStorageResult<TValue>> GetAsync<TValue>(string key);
+        public ValueTask<ProtectedBrowserStorageResult<TValue>> GetAsync<TValue>(string purpose, string key);
+        public ValueTask SetAsync(string key, object value);
+        public ValueTask SetAsync(string purpose, string key, object value);
+    }
+    public readonly struct ProtectedBrowserStorageResult<TValue> {
+        public bool Success { get; }
+        public TValue Value { get; }
+    }
+    public sealed class ProtectedLocalStorage : ProtectedBrowserStorage {
+        public ProtectedLocalStorage(IJSRuntime jsRuntime, IDataProtectionProvider dataProtectionProvider);
+    }
+    public sealed class ProtectedSessionStorage : ProtectedBrowserStorage {
+        public ProtectedSessionStorage(IJSRuntime jsRuntime, IDataProtectionProvider dataProtectionProvider);
+    }
+}
```

