# Microsoft.AspNetCore.Components.Web.Virtualization

``` diff
+namespace Microsoft.AspNetCore.Components.Web.Virtualization {
+    public delegate ValueTask<ItemsProviderResult<TItem>> ItemsProviderDelegate<TItem>(ItemsProviderRequest request);
+    public readonly struct ItemsProviderRequest {
+        public ItemsProviderRequest(int startIndex, int count, CancellationToken cancellationToken);
+        public CancellationToken CancellationToken { get; }
+        public int Count { get; }
+        public int StartIndex { get; }
+    }
+    public readonly struct ItemsProviderResult<TItem> {
+        public ItemsProviderResult(IEnumerable<TItem> items, int totalItemCount);
+        public IEnumerable<TItem> Items { get; }
+        public int TotalItemCount { get; }
+    }
+    public readonly struct PlaceholderContext {
+        public PlaceholderContext(int index, float size = 0f);
+        public int Index { get; }
+        public float Size { get; }
+    }
+    public sealed class Virtualize<TItem> : ComponentBase, IAsyncDisposable, IVirtualizeJsCallbacks {
+        public Virtualize();
+        public RenderFragment<TItem> ChildContent { get; set; }
+        public RenderFragment<TItem> ItemContent { get; set; }
+        public ICollection<TItem> Items { get; set; }
+        public float ItemSize { get; set; }
+        public ItemsProviderDelegate<TItem> ItemsProvider { get; set; }
+        public int OverscanCount { get; set; }
+        public RenderFragment<PlaceholderContext> Placeholder { get; set; }
+        protected override void BuildRenderTree(RenderTreeBuilder builder);
+        public ValueTask DisposeAsync();
+        protected override Task OnAfterRenderAsync(bool firstRender);
+        protected override void OnParametersSet();
+        public Task RefreshDataAsync();
+    }
+}
```

