# Microsoft.JSInterop

``` diff
 namespace Microsoft.JSInterop {
+    public interface IJSInProcessObjectReference : IAsyncDisposable, IDisposable, IJSObjectReference {
+        TValue Invoke<TValue>(string identifier, params object[] args);
+    }
     public interface IJSInProcessRuntime : IJSRuntime {
-        T Invoke<T>(string identifier, params object[] args);

+        TResult Invoke<TResult>(string identifier, params object[] args);
     }
+    public interface IJSObjectReference : IAsyncDisposable {
+        ValueTask<TValue> InvokeAsync<TValue>(string identifier, object[] args);
+        ValueTask<TValue> InvokeAsync<TValue>(string identifier, CancellationToken cancellationToken, object[] args);
+    }
+    public interface IJSUnmarshalledObjectReference : IAsyncDisposable, IDisposable, IJSInProcessObjectReference, IJSObjectReference {
+        TResult InvokeUnmarshalled<T0, T1, T2, TResult>(string identifier, T0 arg0, T1 arg1, T2 arg2);
+        TResult InvokeUnmarshalled<T0, T1, TResult>(string identifier, T0 arg0, T1 arg1);
+        TResult InvokeUnmarshalled<T0, TResult>(string identifier, T0 arg0);
+        TResult InvokeUnmarshalled<TResult>(string identifier);
+    }
+    public interface IJSUnmarshalledRuntime {
+        TResult InvokeUnmarshalled<T0, T1, T2, TResult>(string identifier, T0 arg0, T1 arg1, T2 arg2);
+        TResult InvokeUnmarshalled<T0, T1, TResult>(string identifier, T0 arg0, T1 arg1);
+        TResult InvokeUnmarshalled<T0, TResult>(string identifier, T0 arg0);
+        TResult InvokeUnmarshalled<TResult>(string identifier);
+    }
+    public enum JSCallResultType {
+        Default = 0,
+        JSObjectReference = 1,
+    }
+    public static class JSInProcessObjectReferenceExtensions {
+        public static void InvokeVoid(this IJSInProcessObjectReference jsObjectReference, string identifier, params object[] args);
+    }
     public abstract class JSInProcessRuntime : JSRuntime, IJSInProcessRuntime, IJSRuntime {
-        protected abstract string InvokeJS(string identifier, string argsJson);
+        protected virtual string InvokeJS(string identifier, string argsJson);
+        protected abstract string InvokeJS(string identifier, string argsJson, JSCallResultType resultType, long targetInstanceId);
     }
+    public static class JSObjectReferenceExtensions {
+        public static ValueTask<TValue> InvokeAsync<TValue>(this IJSObjectReference jsObjectReference, string identifier, params object[] args);
+        public static ValueTask<TValue> InvokeAsync<TValue>(this IJSObjectReference jsObjectReference, string identifier, CancellationToken cancellationToken, params object[] args);
+        public static ValueTask<TValue> InvokeAsync<TValue>(this IJSObjectReference jsObjectReference, string identifier, TimeSpan timeout, params object[] args);
+        public static ValueTask InvokeVoidAsync(this IJSObjectReference jsObjectReference, string identifier, params object[] args);
+        public static ValueTask InvokeVoidAsync(this IJSObjectReference jsObjectReference, string identifier, CancellationToken cancellationToken, params object[] args);
+        public static ValueTask InvokeVoidAsync(this IJSObjectReference jsObjectReference, string identifier, TimeSpan timeout, params object[] args);
+    }
     public abstract class JSRuntime : IJSRuntime {
-        protected abstract void BeginInvokeJS(long taskId, string identifier, string argsJson);
+        protected virtual void BeginInvokeJS(long taskId, string identifier, string argsJson);
+        protected abstract void BeginInvokeJS(long taskId, string identifier, string argsJson, JSCallResultType resultType, long targetInstanceId);
     }
 }
```

