# System.Data.Common

``` diff
 namespace System.Data.Common {
     public abstract class DbConnection : Component, IAsyncDisposable, IDbConnection, IDisposable {
+        public virtual Task<DataTable> GetSchemaAsync(string collectionName, string[] restrictionValues, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<DataTable> GetSchemaAsync(string collectionName, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<DataTable> GetSchemaAsync(CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class DbDataReader : MarshalByRefObject, IAsyncDisposable, IDataReader, IDataRecord, IDisposable, IEnumerable {
+        public virtual Task<ReadOnlyCollection<DbColumn>> GetColumnSchemaAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<DataTable> GetSchemaTableAsync(CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class DbException : ExternalException {
+        public virtual bool IsTransient { get; }
+        public virtual string SqlState { get; }
     }
     public abstract class DbParameterCollection : MarshalByRefObject, ICollection, IDataParameterCollection, IEnumerable, IList {
+        int System.Collections.IList.Add(object value);
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
     }
     public abstract class DbTransaction : MarshalByRefObject, IAsyncDisposable, IDbTransaction, IDisposable {
+        public virtual bool SupportsSavepoints { get; }
+        public virtual void Release(string savepointName);
+        public virtual Task ReleaseAsync(string savepointName, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual void Rollback(string savepointName);
+        public virtual Task RollbackAsync(string savepointName, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual void Save(string savepointName);
+        public virtual Task SaveAsync(string savepointName, CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

