# System.Diagnostics.CodeAnalysis

``` diff
 namespace System.Diagnostics.CodeAnalysis {
+    public sealed class DynamicallyAccessedMembersAttribute : Attribute {
+        public DynamicallyAccessedMembersAttribute(DynamicallyAccessedMemberTypes memberTypes);
+        public DynamicallyAccessedMemberTypes MemberTypes { get; }
+    }
+    public enum DynamicallyAccessedMemberTypes {
+        All = -1,
+        None = 0,
+        NonPublicConstructors = 4,
+        NonPublicEvents = 4096,
+        NonPublicFields = 64,
+        NonPublicMethods = 16,
+        NonPublicNestedTypes = 256,
+        NonPublicProperties = 1024,
+        PublicConstructors = 3,
+        PublicEvents = 2048,
+        PublicFields = 32,
+        PublicMethods = 8,
+        PublicNestedTypes = 128,
+        PublicParameterlessConstructor = 1,
+        PublicProperties = 512,
+    }
+    public sealed class DynamicDependencyAttribute : Attribute {
+        public DynamicDependencyAttribute(DynamicallyAccessedMemberTypes memberTypes, string typeName, string assemblyName);
+        public DynamicDependencyAttribute(DynamicallyAccessedMemberTypes memberTypes, Type type);
+        public DynamicDependencyAttribute(string memberSignature);
+        public DynamicDependencyAttribute(string memberSignature, string typeName, string assemblyName);
+        public DynamicDependencyAttribute(string memberSignature, Type type);
+        public string AssemblyName { get; }
+        public string Condition { get; set; }
+        public string MemberSignature { get; }
+        public DynamicallyAccessedMemberTypes MemberTypes { get; }
+        public Type Type { get; }
+        public string TypeName { get; }
+    }
     public sealed class ExcludeFromCodeCoverageAttribute : Attribute {
+        public string Justification { get; set; }
     }
+    public sealed class MemberNotNullAttribute : Attribute {
+        public MemberNotNullAttribute(string member);
+        public MemberNotNullAttribute(params string[] members);
+        public string[] Members { get; }
+    }
+    public sealed class MemberNotNullWhenAttribute : Attribute {
+        public MemberNotNullWhenAttribute(bool returnValue, string member);
+        public MemberNotNullWhenAttribute(bool returnValue, params string[] members);
+        public string[] Members { get; }
+        public bool ReturnValue { get; }
+    }
+    public sealed class RequiresUnreferencedCodeAttribute : Attribute {
+        public RequiresUnreferencedCodeAttribute(string message);
+        public string Message { get; }
+        public string Url { get; set; }
+    }
+    public sealed class UnconditionalSuppressMessageAttribute : Attribute {
+        public UnconditionalSuppressMessageAttribute(string category, string checkId);
+        public string Category { get; }
+        public string CheckId { get; }
+        public string Justification { get; set; }
+        public string MessageId { get; set; }
+        public string Scope { get; set; }
+        public string Target { get; set; }
+    }
 }
```

