# System.Threading

``` diff
 namespace System.Threading {
     public readonly struct CancellationToken {
+        public CancellationTokenRegistration UnsafeRegister(Action<object> callback, object state);
     }
     public readonly struct CancellationTokenRegistration : IAsyncDisposable, IDisposable, IEquatable<CancellationTokenRegistration> {
+        public bool Unregister();
     }
     public class CancellationTokenSource : IDisposable {
+        public static CancellationTokenSource CreateLinkedTokenSource(CancellationToken token);
     }
     public sealed class ExecutionContext : IDisposable, ISerializable {
+        public static void Restore(ExecutionContext executionContext);
     }
     public static class Interlocked {
+        public static uint Add(ref uint location1, uint value);
+        public static ulong Add(ref ulong location1, ulong value);
+        public static int And(ref int location1, int value);
+        public static long And(ref long location1, long value);
+        public static uint And(ref uint location1, uint value);
+        public static ulong And(ref ulong location1, ulong value);
+        public static uint CompareExchange(ref uint location1, uint value, uint comparand);
+        public static ulong CompareExchange(ref ulong location1, ulong value, ulong comparand);
+        public static uint Decrement(ref uint location);
+        public static ulong Decrement(ref ulong location);
+        public static uint Exchange(ref uint location1, uint value);
+        public static ulong Exchange(ref ulong location1, ulong value);
+        public static uint Increment(ref uint location);
+        public static ulong Increment(ref ulong location);
+        public static int Or(ref int location1, int value);
+        public static long Or(ref long location1, long value);
+        public static uint Or(ref uint location1, uint value);
+        public static ulong Or(ref ulong location1, ulong value);
+        public static ulong Read(ref ulong location);
     }
+    public interface IThreadPoolWorkItem {
+        void Execute();
+    }
     public static class Monitor {
+        public static long LockContentionCount { get; }
     }
     public sealed class PreAllocatedOverlapped : IDisposable {
+        ~PreAllocatedOverlapped();
     }
     public struct SpinWait {
+        public void SpinOnce(int sleep1Threshold);
     }
     public sealed class Thread : CriticalFinalizerObject {
+        ~Thread();
     }
     public static class ThreadPool {
+        public static long CompletedWorkItemCount { get; }
+        public static long PendingWorkItemCount { get; }
+        public static int ThreadCount { get; }
+        public static bool UnsafeQueueUserWorkItem(IThreadPoolWorkItem callBack, bool preferLocal);
+        public static bool UnsafeQueueUserWorkItem<TState>(Action<TState> callBack, TState state, bool preferLocal);
     }
     public sealed class Timer : MarshalByRefObject, IAsyncDisposable, IDisposable {
+        public static long ActiveCount { get; }
     }
 }
```

