# System.Xml

``` diff
 namespace System.Xml {
+    public interface IApplicationResourceStreamResolver {
+        Stream GetApplicationResourceStream(Uri relativeUri);
+    }
+    public class XmlDataDocument : XmlDocument {
+        public XmlDataDocument();
+        public XmlDataDocument(DataSet dataset);
+        public DataSet DataSet { get; }
+        public override XmlNode CloneNode(bool deep);
+        public override XmlElement CreateElement(string prefix, string localName, string namespaceURI);
+        public override XmlEntityReference CreateEntityReference(string name);
+        protected override XPathNavigator CreateNavigator(XmlNode node);
+        public override XmlElement GetElementById(string elemId);
+        public XmlElement GetElementFromRow(DataRow r);
+        public override XmlNodeList GetElementsByTagName(string name);
+        public DataRow GetRowFromElement(XmlElement e);
+        public override void Load(Stream inStream);
+        public override void Load(TextReader txtReader);
+        public override void Load(string filename);
+        public override void Load(XmlReader reader);
+    }
-    public abstract class XmlWriter : IDisposable {
+    public abstract class XmlWriter : IAsyncDisposable, IDisposable {
+        public ValueTask DisposeAsync();
+        protected virtual ValueTask DisposeAsyncCore();
     }
 }
```

