# .NET 5.0.0 Preview 1

.NET 5.0.0 Preview 1 comprises:

* .NET Runtime 5.0.0-preview.1.20120.5
* ASP.NET Core 5.0.0-preview.1.20124.5
* .NET SDK 5.0.100-preview.1.20155.7

See the [Release Notes][release-notes] for details about what is included in this update.

## Docker

The [.NET Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Install .NET on Linux

### Install using Snap

Because of the isolated environment, using Snap is the preferred way to install and try .NET Previews on [Linux distributions that support Snap](https://docs.snapcraft.io/installing-snapd/6735).

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel=5.0/beta --classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distributions require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [.NET for Linux Distributions](../../../linux.md) for a possible resolution.

### Install using deb/rpm packages

Preview release installers are not available from the Microsoft package repositories. The steps below provide an easy way to install .NET 5 Preview 1 using your Distro package manager.

**Note:** `curl` must be available on the system before running the following steps. Once you have confirmed that `curl` is available, complete the steps to download and install the .NET 5 Preview 1 SDK and Runtime.

1. Create a directory to use for the download location and change into that directory. For example `mkdir $HOME/dotnet_install && cd $HOME/dotnet_install`
2. Run `curl -L https://aka.ms/install-dotnet-preview -o install-dotnet-preview.sh`
3. Run the script with `sudo bash install-dotnet-preview.sh`

Here's what the script does.

* Detects the distribution and version. If it's in the [5.0 Supported OS](../5.0-supported-os.md) list, the script will continue.
* Determines if additional system dependencies or utilities are needed to successfully complete and install them. For example `tar` is used to unpack that installer packages.
* Downloads the tar.gz containing the .NET preview installer packages for the detected distribution.
* Downloads the system dependency installer, if needed.
* Expands the tar.gz into ./dotnet_pacakges
* Attempts to install the contents of ./dotnet_packages using `rpm` or `dpkg`, as appropriate, for the detected distribution.

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](../linux-packages.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-5.0` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-5.0` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-preview.1.20124.5-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 5.0.0-preview.1.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.0-preview.1-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.0-preview.1-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-core-5-0-preview-1/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-and-blazor-updates-in-net-core-5-0-preview-1/
[ef-blog]: https://devblogs.microsoft.com/dotnet/

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.0-preview1+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.0-preview1+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A5.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A5.0+label%3Aenhancement

[//]: # ( Runtime 5.0.0-preview.1.20120.5)
[dotnet-apphost-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/28d55dfb-e34a-4a70-8a72-9be5e17e975b/8d0313901895bde7a5ffc704021906ca/dotnet-apphost-pack-5.0.0-preview.1.20120.5-x64.deb
[dotnet-apphost-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/db91a035-bb5e-463e-a0a8-2bbbac9caf7e/84df4635a4a4dd2de32028c4cf093795/dotnet-apphost-pack-5.0.0-preview.1.20120.5-x64.rpm
[dotnet-host-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/257b444a-330b-4534-9d10-f26586dda9a4/fc0de30ef3d870367e6c33adc3427fb9/dotnet-host-5.0.0-preview.1.20120.5-x64.deb
[dotnet-host-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/af503f4d-cca5-41e8-bcf7-fb1b6636d11f/a021b589fab4d9f93c2ebe5a18c6c361/dotnet-host-5.0.0-preview.1.20120.5-x64.rpm
[dotnet-hostfxr-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/0aca7fd3-27ac-4491-888d-144d221e26c0/b38c6ab328ebeef3be152e70b0f088fd/dotnet-hostfxr-5.0.0-preview.1.20120.5-x64.deb
[dotnet-hostfxr-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/60a4f518-e26f-4898-aa59-4fb29d06ab13/b56b768b5930fe2d659eda6597bcc3ab/dotnet-hostfxr-5.0.0-preview.1.20120.5-x64.rpm
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/31aee07d-32f7-4efb-9cf1-89106a26212d/a7006126fb7df2d305c7e0bf25299c9e/dotnet-runtime-5.0.0-preview.1.20120.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/84387434-81b7-46a9-8219-185f66a66830/d1087f26ea03ff2ca7751c3813685c0f/dotnet-runtime-5.0.0-preview.1.20120.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/17bfd1fb-9924-4c12-b7cd-0c2a7e43778b/f562456fdd9c94720f4f8e306979b16e/dotnet-runtime-5.0.0-preview.1.20120.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb48e751-cc31-4c5c-9c47-3bfb0ea4fc3b/554bbfb058c4ed507bc7c4f888b317b1/dotnet-runtime-5.0.0-preview.1.20120.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6987c0a0-0f98-454d-92f8-152b4370231f/657b01827c9003378812d80f9d45de8d/dotnet-runtime-5.0.0-preview.1.20120.5-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3d5fb11e-ebec-49ac-ab6f-dbd16d2af3bf/9ee2e4d64ccc528a3ad13787694ea0c1/dotnet-runtime-5.0.0-preview.1.20120.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/53d350d2-dbee-49eb-a5b9-93c2fb1fad2c/94bae932554b373b39067e705fae2c26/dotnet-runtime-5.0.0-preview.1.20120.5-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/421f943b-e151-4215-8cd5-a38577f05fe6/5ed2cfc1e4db2ca1e2f92195eae40437/dotnet-runtime-5.0.0-preview.1.20120.5-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1619a7f2-1bed-4d4a-943c-32bc3a702f5c/8f8fe5d927651a4084792019021cad6d/dotnet-runtime-5.0.0-preview.1.20120.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/87d8839f-c9f4-4e75-9a70-fae73129bede/e898bbfa1af5476d7aad707798fed148/dotnet-runtime-5.0.0-preview.1.20120.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b26425ef-c76b-42f1-b59a-01bb34c1268a/fbd47715f4297fdcbc9f5dc4cd7a5b79/dotnet-runtime-5.0.0-preview.1.20120.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d36d5c8e-6053-47e1-846c-736ddc6fac35/484be0892e1dacec55b5abf7a6ef7ecd/dotnet-runtime-5.0.0-preview.1.20120.5-win-x86.zip
[dotnet-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/caaf95b6-a9f5-4aa0-9516-006f718dddb5/31b849892a71079e3983245dc704f789/dotnet-runtime-5.0.0-preview.1.20120.5-x64.deb
[dotnet-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/30f1a334-438c-4b59-9909-e586f2c4c027/677c7ce2bf758856d96ecd9f723df454/dotnet-runtime-5.0.0-preview.1.20120.5-x64.rpm
[dotnet-runtime-deps-centos.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/1bebb030-7485-4359-8b25-018f4dd36ca5/ef6a4459bdf9a679b51a01a34440f9ad/dotnet-runtime-deps-5.0.0-preview.1.20120.5-centos.7-x64.rpm
[dotnet-runtime-deps-fedora.27-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/d55e8cf7-2575-42d2-89f0-fe13f990a1c3/fe33fc9a9dc34bf6256dd35339a8e765/dotnet-runtime-deps-5.0.0-preview.1.20120.5-fedora.27-x64.rpm
[dotnet-runtime-deps-opensuse.42-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/f87285cf-5a6f-43be-9afe-2ff172143fea/316d73a0fddb3d69f284069c4ec6739a/dotnet-runtime-deps-5.0.0-preview.1.20120.5-opensuse.42-x64.rpm
[dotnet-runtime-deps-oraclelinux.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/4f0b7596-5aed-4e59-936c-2e2206ea40e3/2b4e0f6b45e3871deef5866b32a10b82/dotnet-runtime-deps-5.0.0-preview.1.20120.5-oraclelinux.7-x64.rpm
[dotnet-runtime-deps-rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/74cf028a-e48b-4b43-bdf0-2fe1421cad0e/c0dcaef1445923dab268e1aefd6bf89e/dotnet-runtime-deps-5.0.0-preview.1.20120.5-rhel.7-x64.rpm
[dotnet-runtime-deps-sles.12-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/bcc82c68-1060-4d0b-92a8-8627c94d9348/065b16502d742ea59bf159e4e9210a74/dotnet-runtime-deps-5.0.0-preview.1.20120.5-sles.12-x64.rpm
[dotnet-runtime-deps-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/2c283aee-138b-4d4a-ad63-a299e62655d7/b97d6e120cbbfe16e3481f27610e7972/dotnet-runtime-deps-5.0.0-preview.1.20120.5-x64.deb
[dotnet-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/c68808d4-375f-4845-bc77-99655f6b810b/5a3b53c37d6156679af2df76b66e3b61/dotnet-targeting-pack-5.0.0-preview.1.20120.5-x64.deb
[dotnet-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/195c3d17-7f5d-4416-9b67-955620d52264/d8a0cbd2ae5bc18fd8ed79db4f50b707/dotnet-targeting-pack-5.0.0-preview.1.20120.5-x64.rpm
[netstandard-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/2dae2645-630f-4540-a009-e5f576aeb9b6/25b2d91389688ca3db6a613c20e145f1/netstandard-targeting-pack-2.1.0-preview.1.20120.5-x64.deb
[netstandard-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/65c3f97a-8c17-4004-aa28-63977a36029f/9a273b34e0c62051a5f2693fa173aea5/netstandard-targeting-pack-2.1.0-preview.1.20120.5-x64.rpm

[//]: # ( WindowsDesktop 5.0.0-preview.1.20120.5)
[windowsdesktop-runtime-preview.1.20127.5-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2f55bae1-e4f3-4dfe-8619-875e33d2f600/7645edcc220a59fcb08ac4a7bcbb2478/windowsdesktop-runtime-5.0.0-preview.1.20127.5-win-x64.exe
[windowsdesktop-runtime-preview.1.20127.5-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/064e147d-f45c-44f8-b10c-26bf69057858/45ec44bc95dbf6f427df7f5f814b1afc/windowsdesktop-runtime-5.0.0-preview.1.20127.5-win-x86.exe

[//]: # ( ASP 5.0.0-preview.1.20124.5)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9a20c81d-b745-41ab-84e9-c79a6c1a834a/59eda26304fac6a11cf34ad5020f3730/aspnetcore-runtime-5.0.0-preview.1.20124.5-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/164c04ba-e0f3-47d0-92a7-8e66acc15f4c/f35c8c1aba9e46f1a36d2c5e54e27fd5/aspnetcore-runtime-5.0.0-preview.1.20124.5-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/954abef8-224e-4852-86a6-9d7fc038117c/5c1ab11a52821fa7c7930eaf76804fd7/aspnetcore-runtime-5.0.0-preview.1.20124.5-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b072f80-b9df-4ffa-8b36-3bdc37a9cb05/d188499bbcc1cbeb355504831457f52b/aspnetcore-runtime-5.0.0-preview.1.20124.5-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c88ef7f1-c62a-4ef6-810e-87f5d6152217/96c52963aa875fbcd9131f42075ff5c9/aspnetcore-runtime-5.0.0-preview.1.20124.5-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c181b335-3e57-41c6-b14c-421f42f1ca95/afc7b0f82ece0a8291506d2cbc971bad/aspnetcore-runtime-5.0.0-preview.1.20124.5-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/72c55abd-e606-4a6c-9842-3f9b28f0c1c3/35f6e8843aff939edb17e485911ba4bf/aspnetcore-runtime-5.0.0-preview.1.20124.5-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b22bdbe7-02a4-4511-aa06-2092957fac64/04e6c870f24ecb99207aec320ced30e1/aspnetcore-runtime-5.0.0-preview.1.20124.5-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/00b37d1c-e9f4-41f3-b345-e573c5b56103/86fa2104475b704215069b7cf8a3def9/aspnetcore-runtime-5.0.0-preview.1.20124.5-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2d4e5b00-bab0-4371-895c-4f6b4ba5b522/48e480a50e0384cd9cfe4fa4a8e56311/aspnetcore-runtime-5.0.0-preview.1.20124.5-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a84dde53-e69e-475f-919b-582dd42c189b/05b8ffd4b70561659dbca3b03265936a/aspnetcore-runtime-5.0.0-preview.1.20124.5-win-x86.zip
[aspnetcore-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/d53ad6fb-b757-481b-84a5-2dd400a11d53/9b2d22cad3a9706f27159b64415c21f7/aspnetcore-runtime-5.0.0-preview.1.20124.5-x64.deb
[aspnetcore-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/bd4ed1f2-1966-4fc4-b922-ba0e775aba6d/70a943fbbcf9b97e3fb1c7f6bd84607c/aspnetcore-runtime-5.0.0-preview.1.20124.5-x64.rpm
[aspnetcore-targeting-pack.deb]: https://download.visualstudio.microsoft.com/download/pr/51bfd5c7-b430-45d2-a6cf-3c68fc5b33b3/1b4b80d0247cdac773f638368de30d06/aspnetcore-targeting-pack-5.0.0-preview.1.20124.5.deb
[aspnetcore-targeting-pack.rpm]: https://download.visualstudio.microsoft.com/download/pr/727000b9-7c3e-46de-91f4-619cdada6825/df083ff2a1b24a34c012d46bd5ca8569/aspnetcore-targeting-pack-5.0.0-preview.1.20124.5.rpm
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/98b0a8d8-9eb7-449e-b9bb-d104e46c2e6a/972a2813f230c9eede852cecef20f759/dotnet-hosting-5.0.0-preview.1.20124.5-win.exe

[//]: # ( SDK 5.0.100 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d0ed3148-079b-4003-8490-79e0b4429c86/ccbe5961e8494d374bb3f38bea7f134f/dotnet-sdk-5.0.100-preview.1.20155.7-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7c630d6-c62d-49f6-8efc-24621164e15d/b7fd5253aa76a0c16f9eed5d12ffbff8/dotnet-sdk-5.0.100-preview.1.20155.7-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aa912272-cfe3-4004-a960-61b9133b14e5/2ae4265949516bd8f0dee9b73945110a/dotnet-sdk-5.0.100-preview.1.20155.7-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5b2263be-2e9c-48f4-8bcb-46018b512dd3/664228f47b82f6c530b168c940a9dfa5/dotnet-sdk-5.0.100-preview.1.20155.7-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a6c1bef8-4840-4142-baeb-ff4e727df4c4/59c116135a25bf3f31365a6f7b7e84da/dotnet-sdk-5.0.100-preview.1.20155.7-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d300744f-cb11-4c04-9c7b-c0912c2b2dea/2274f66ff502bd3e65b472f2aa8b6fe4/dotnet-sdk-5.0.100-preview.1.20155.7-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/9dae6cf9-a5b1-4081-b0e0-574eab1d72af/3239f6721e8e8b1667fafb2aa305f50b/dotnet-sdk-5.0.100-preview.1.20155.7-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/de891f82-640f-4f21-8a78-397f851d83bd/7ec1693a74563b572fe81d649e973e3f/dotnet-sdk-5.0.100-preview.1.20155.7-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0dd5a0ce-5b10-4658-8b98-5f4933549b40/18da52cd17126c8738a2e3a6e20f6688/dotnet-sdk-5.0.100-preview.1.20155.7-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0474f339-e798-4b1e-8d6d-7c8c038c784c/f7ae14a31dab3bbb30a02edfdb84c929/dotnet-sdk-5.0.100-preview.1.20155.7-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/90416a23-fc44-44ea-9467-1204652e7a55/202f9e462cd96f0cef2bc333a0534734/dotnet-sdk-5.0.100-preview.1.20155.7-win-x86.zip
[dotnet-sdk-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/36c25a97-a129-462d-8a1d-f71665ae1351/c8e6a12c700506e7cad4e11b519cb797/dotnet-sdk-5.0.100-preview.1.20155.7-x64.deb
[dotnet-sdk-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/f49edc67-fc0f-4c10-a39d-d9638001a53d/44aa8ea149d0864429a6bbbc1333104c/dotnet-sdk-5.0.100-preview.1.20155.7-x64.rpm

[//]: # ( Symbols )
