# .NET 5.0.0 RC 2 - October 13, 2020

.NET 5.0.0 RC 2 is available for download and usage in your environment. This release includes .NET 5.0.0 Runtime RC 2 and .NET SDK 5.0.100 RC 2.

* [Downloads](https://dotnet.microsoft.com/download/dotnet/5.0)
* [.NET 5.0 RC 2 Blog][dotnet-blog]
* [ASP.NET Core Blog][aspnet-blog]
* [EF Core Blog][ef-blog]
* [Changes in this release](#notable-changes-in-500-rc-2)
* [Known issues](../5.0-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

The .NET SDK 5.0.100 RC 2 includes .NET 5.0.0 preview Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET SDK 5.0.100 preview, the following command will show that you're running version `5.0.100-rc.2.20479.15` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5345](https://github.com/dotnet/core/issues/5345) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [ARM64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [ARM64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [ARM64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [Snap and Package Manager](5.0.0-rc.2-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

## Visual Studio Compatibility

.NET 5 RC 2 requires Visual Studio 2019 16.8 Preview 4 to take full advantage of all its features. .NET 5 RC 2 won't work properly in earlier versions of Visual Studio. Visit [Visual Studio Preview](https://visualstudio.microsoft.com/vs/preview/) to learn about VS previews.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

## Notable Changes in 5.0.0 RC 2

Here is list of some of the additions and updates we're excited to bring in RC 2. See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.

* ASP.NET Core: [bugs][aspnet_bugs] | [features][aspnet_features]
* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

For a roadmap and reference to ongoing efforts for .NET 5, see [.NET 5.0 Runtime Epics](https://github.com/dotnet/runtime/issues/37269) on GitHub.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 5.0.0-rc.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.0-rc.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.0-rc.2-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-5-0-rc-2/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-5-release-candidate-2/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-ef-core-5-rc2/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A5.0.0-rc2+is%3Aclosed+label%3Atype-bug+is%3Aclosed
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A5.0.0-rc2+is%3Aclosed+label%3Atype-enhancement+is%3Aclosed

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.0-rc2+label%3ADone+label%3Abug+is%3Aclosed
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.0-rc2+label%3ADone+label%3Aenhancement+is%3Aclosed
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A5.0+label%3Abug+is%3Aclosed
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A5.0+label%3Aenhancement+is%3Aclosed

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.1xx+is%3Aclosed


[//]: # ( Runtime 5.0.0-rc.2.20475.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91f51f33-238d-46bd-9d28-4d07667c49fb/693e99d7e048f96ba1237b19a9c848a9/dotnet-runtime-5.0.0-rc.2.20475.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f765599d-3130-4825-acc5-92c717a06013/22fcf79920ad59b0cce1653a1171a80e/dotnet-runtime-5.0.0-rc.2.20475.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9f24d1a3-44ca-40f4-a129-aa71dc649f87/0eaaade7b6919a1f968e62a1f1cadfbe/dotnet-runtime-5.0.0-rc.2.20475.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ef5fba19-c738-45ba-ac4e-bea399bb1086/ae704db109eec283eee4ecb0cbab491c/dotnet-runtime-5.0.0-rc.2.20475.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3df8caad-2e73-4969-82d1-bd467054c552/06078adfbda938c50ab0dbca01f14ee4/dotnet-runtime-5.0.0-rc.2.20475.5-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6e1df8ce-94d1-4fbf-b1fd-e7128696466f/0c0616999df20b12df4905075b00331c/dotnet-runtime-5.0.0-rc.2.20475.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/71387715-de5a-4cba-851b-77bdcda1b8df/26fce295fd4e8c28e6cf2c50ca3aeb51/dotnet-runtime-5.0.0-rc.2.20475.5-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/123fb0d6-4c3e-4639-8cfd-155e3a6b1710/1b4c779d06b348cb440966c4998a80c9/dotnet-runtime-5.0.0-rc.2.20475.5-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/49591300-4023-4a5f-9cc7-7bf46ec4fdcf/ea4caf85b4c3fb9adda55142ec66f172/dotnet-runtime-5.0.0-rc.2.20475.5-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/054458a0-ecae-4d40-8fab-cac711ab3074/79964cee73907a8a015db5efcb01ac3c/dotnet-runtime-5.0.0-rc.2.20475.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/603925fc-b50c-4657-a5dd-d1652aa39e07/90e27c1418a58bf3226cf6bab7dec5fa/dotnet-runtime-5.0.0-rc.2.20475.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bd93b8cf-5757-49e0-93a0-ab53a377e5ff/728097b8d85670f3f64bddea4338d0aa/dotnet-runtime-5.0.0-rc.2.20475.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a3b8f8fb-6824-4dac-a6be-dd3f51c487a0/e7a0ae5890d7731349acb1a39c730790/dotnet-runtime-5.0.0-rc.2.20475.5-win-x86.zip

[//]: # ( WindowsDesktop 5.0.0-rc.2.20475.6)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a9243817-2e2f-4a9d-999e-41496c7681b2/f27e936a6dab4ab25f38616dbe7369e7/windowsdesktop-runtime-5.0.0-rc.2.20475.6-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/91fb8d46-77fc-4d2b-9762-31584f514470/0c7041dfe359e909743f35e2585af108/windowsdesktop-runtime-5.0.0-rc.2.20475.6-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f125aff4-8055-4ddb-955c-8e65043c33d0/5cc82db36244efb98176d2b4bfed584b/windowsdesktop-runtime-5.0.0-rc.2.20475.6-win-x86.exe

[//]: # ( ASP 5.0.0-rc.2.20475.17)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d28b2c72-92f7-44fd-b673-f7c24275f513/694228a9541d905bda4417156a9617df/aspnetcore-runtime-5.0.0-rc.2.20475.17-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/565b6b58-e67d-4572-b376-574634730f7d/46cd04ba8e137ad20fd0e97814350ff3/aspnetcore-runtime-5.0.0-rc.2.20475.17-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/265f6f53-9338-4b5e-b42f-923ce1bed379/d2959c292c1332765338097fc63cf686/aspnetcore-runtime-5.0.0-rc.2.20475.17-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37b5258c-1758-4e5d-8f53-7431199c1575/f6186fe70e60469e66ca1b1bc9f59ffa/aspnetcore-runtime-5.0.0-rc.2.20475.17-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/76b700c1-f51b-454d-8082-dd0f6db0b5eb/e128bda60e4a72fd2fd38b50b442623e/aspnetcore-runtime-5.0.0-rc.2.20475.17-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4c32af7f-e685-4bd9-8792-e7cdd5f46a20/4bdad80338f3e4e4b65a04c5cd65cceb/aspnetcore-runtime-5.0.0-rc.2.20475.17-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/36abe09b-b2ab-4986-9a45-87aa2391cdb3/07bd88dc9a1fc229faead6cf4eff92fe/aspnetcore-runtime-5.0.0-rc.2.20475.17-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c29737de-627f-44be-ba9e-7292fb0fb97e/3476046d9f030ef6af11bcb7c4c51b7a/aspnetcore-runtime-5.0.0-rc.2.20475.17-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5208bb4a-0704-44c2-b8c1-95871f23f2c9/7c0c1fded168bb35ff4ddd5c3fb85736/aspnetcore-runtime-5.0.0-rc.2.20475.17-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f2306025-c7ad-45de-b351-0f04b30ac115/d75c53920c15dd23fc61d780722636ed/aspnetcore-runtime-5.0.0-rc.2.20475.17-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c79c6f94-e14f-4bc1-bdc3-527efa969faf/7e385dd3f773f925c89a93708d28d309/aspnetcore-runtime-5.0.0-rc.2.20475.17-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/03f2261a-01cc-4a78-8505-88ba0457ef29/1ff22faa58152bec84e636e719c28528/dotnet-hosting-5.0.0-rc.2.20475.17-win.exe

[//]: # ( SDK 5.0.100-rc.2.20479.15 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/068ebc6e-4a1d-45ec-a766-733a142f2839/e0da4c731c943ca2b267c15edb565108/dotnet-sdk-5.0.100-rc.2.20479.15-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b416bc12-1478-4241-bc31-6fe68f8b73b6/582f018a97172f4975973390cf3f58e7/dotnet-sdk-5.0.100-rc.2.20479.15-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1ea8c954-015d-4ded-a221-6bcc27f53d06/c76bcb58b9a1539dcba34c0cb6c5df9b/dotnet-sdk-5.0.100-rc.2.20479.15-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/69cb8922-7bb0-4d3a-aa92-8cb885fdd0a6/2fd4da9e026f661caf8db9c1602e7b2f/dotnet-sdk-5.0.100-rc.2.20479.15-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/414d772d-9d3f-471b-8cc4-3badae3fc6f1/4324fbb212b8801c4b81723535b7e5d5/dotnet-sdk-5.0.100-rc.2.20479.15-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c0cafea0-6f76-407a-8c70-175c25e701d8/de9cc8367c469fa7eaaf5a7fb4aaf08d/dotnet-sdk-5.0.100-rc.2.20479.15-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/0940a90a-35de-40b3-b693-115d0aafb926/f15339d5d33a00fc5801be83e31433b3/dotnet-sdk-5.0.100-rc.2.20479.15-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a5a30a34-0e4b-441d-8a16-4c6c356f418d/7369a30d2a2f04f2dac00f802bde3ae0/dotnet-sdk-5.0.100-rc.2.20479.15-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3121f13a-c4a7-4a93-bf87-f66f6a8b182d/f85dafe84e9d57d9f9c5c4e6a29d04db/dotnet-sdk-5.0.100-rc.2.20479.15-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5fc1edb6-c952-4071-88a7-3ff13c63ab54/71324a7c46138fa35d7f5921207d7142/dotnet-sdk-5.0.100-rc.2.20479.15-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b39635bf-e274-4be0-b35c-a6f92875756c/805a41e904d14b70c3d64a416f5bf12f/dotnet-sdk-5.0.100-rc.2.20479.15-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4503f532-215f-4300-b3b4-eb3ccd3c6ff3/79045e530ca8368c02ba9a2b764be28a/dotnet-sdk-5.0.100-rc.2.20479.15-win-x86.zip
