# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     public abstract class HashAlgorithm : ICryptoTransform, IDisposable {
+        public Task<byte[]> ComputeHashAsync(Stream inputStream, CancellationToken cancellationToken = default(CancellationToken));
     }
     public readonly struct HashAlgorithmName : IEquatable<HashAlgorithmName> {
+        public static HashAlgorithmName FromOid(string oidValue);
+        public static bool TryFromOid(string oidValue, out HashAlgorithmName value);
     }
+    public static class HKDF {
+        public static byte[] DeriveKey(HashAlgorithmName hashAlgorithmName, byte[] ikm, int outputLength, byte[] salt = null, byte[] info = null);
+        public static void DeriveKey(HashAlgorithmName hashAlgorithmName, ReadOnlySpan<byte> ikm, Span<byte> output, ReadOnlySpan<byte> salt, ReadOnlySpan<byte> info);
+        public static byte[] Expand(HashAlgorithmName hashAlgorithmName, byte[] prk, int outputLength, byte[] info = null);
+        public static void Expand(HashAlgorithmName hashAlgorithmName, ReadOnlySpan<byte> prk, Span<byte> output, ReadOnlySpan<byte> info);
+        public static byte[] Extract(HashAlgorithmName hashAlgorithmName, byte[] ikm, byte[] salt = null);
+        public static int Extract(HashAlgorithmName hashAlgorithmName, ReadOnlySpan<byte> ikm, ReadOnlySpan<byte> salt, Span<byte> prk);
+    }
 }
```

