# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
     public readonly struct ElementReference {
+        public ElementReference(string id, ElementReferenceContext context);
+        public ElementReferenceContext Context { get; }
     }
+    public abstract class ElementReferenceContext {
+        protected ElementReferenceContext();
+    }
+    public static class ElementReferenceExtensions {
+        public static ValueTask FocusAsync(this ElementReference elementReference);
+    }
+    public interface IComponentActivator {
+        IComponent CreateInstance(Type componentType);
+    }
+    public class WebElementReferenceContext : ElementReferenceContext {
+        public WebElementReferenceContext(IJSRuntime jsRuntime);
+    }
 }
```

