# .NET 6.0.12 - December 13, 2022

The .NET 6.0.12, [.NET SDK 6.0.112](6.0.112.md), and [.NET SDK 6.0.307](6.0.307.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.404
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```


Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 6.0.12 release carries security fixes.

# Microsoft Security Advisory CVE-2022-41089 | .NET Remote Code Execution Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core 3.1, .NET 6.0., and .NET 7.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A remote code execution vulnerability exists in .NET Core 3.1, .NET 6.0, and .NET 7.0, where a malicious actor could cause a user to run arbitrary code as a result of parsing maliciously crafted xps files.

### Additional fixes in this release
* [Aspnetcore](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A6.0.12+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.12+is%3Aclosed+label%3Aservicing-approved+)
* [Installer](https://github.com/dotnet/installer/issues?q=milestone%3A6.0.12+is%3Aclosed+label%3Aservicing-approved+)


## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8037](https://github.com/dotnet/core/issues/8037) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.12.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.12-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.12-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/december-2022-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86| 6.0.12
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 6.0.12
Microsoft.WindowsDesktop.App.Runtime.win-x64| 6.0.12
Microsoft.WindowsDesktop.App.Ref| 6.0.12
Microsoft.NETCore.App.Host.linux-musl-x64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 6.0.12
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 6.0.12
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 6.0.12
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 6.0.12
Microsoft.NET.Runtime.MonoTargets.Sdk| 6.0.12
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 6.0.12
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Composite| 6.0.12
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 6.0.12
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64| 6.0.12
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86| 6.0.12
Microsoft.NETCore.App.Host.linux-arm| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 6.0.12
Microsoft.NETCore.App.Runtime.linux-arm| 6.0.12
Microsoft.NETCore.App.Runtime.linux-musl-arm| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 6.0.12
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64| 6.0.12
Microsoft.NETCore.DotNetHostPolicy| 6.0.12
Microsoft.NETCore.DotNetHost| 6.0.12
Microsoft.NETCore.DotNetHostResolver| 6.0.12
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 6.0.12
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 6.0.12
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.12
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.12
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.12
runtime.win-x64.Microsoft.NETCore.DotNetHost| 6.0.12
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 6.0.12
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 6.0.12
runtime.win-x86.Microsoft.NETCore.DotNetHost| 6.0.12
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 6.0.12
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 6.0.12
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 6.0.12
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 6.0.12
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100| 6.0.12
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64| 6.0.12
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64| 6.0.12
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 6.0.12
Microsoft.NETCore.App.Crossgen2.win-x64| 6.0.12
Microsoft.NETCore.App.Host.linux-arm64| 6.0.12
Microsoft.NETCore.App.Host.linux-musl-arm| 6.0.12
Microsoft.NETCore.App.Host.osx-x64| 6.0.12
Microsoft.NETCore.App.Host.win-x64| 6.0.12
Microsoft.NETCore.App.Host.win-x86| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.linux-x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.win-arm| 6.0.12
Microsoft.NETCore.App.Runtime.osx-x64| 6.0.12
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.win-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.win-x86| 6.0.12
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.12
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.12
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.12
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.12
runtime.win-arm.Microsoft.NETCore.DotNetHost| 6.0.12
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.12
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.12
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 6.0.12
Microsoft.NETCore.App.Crossgen2.win-x86| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 6.0.12
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm| 6.0.12
Microsoft.NETCore.App.Runtime.linux-musl-x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.win-x64| 6.0.12
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64| 6.0.12
Microsoft.NETCore.DotNetAppHost| 6.0.12
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 6.0.12
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.12
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.12
Microsoft.NET.Runtime.iOS.Sample.Mono| 6.0.12
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 6.0.12
Microsoft.NET.Runtime.WebAssembly.Sdk| 6.0.12
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64| 6.0.12
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86| 6.0.12
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300| 6.0.12
Microsoft.NETCore.App.Crossgen2.linux-arm| 6.0.12
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64| 6.0.12
Microsoft.NETCore.App.Crossgen2.osx-arm64| 6.0.12
Microsoft.NETCore.App.Crossgen2.linux-x64| 6.0.12
Microsoft.NETCore.App.Crossgen2.win-arm| 6.0.12
Microsoft.NETCore.App.Host.osx-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 6.0.12
Microsoft.NETCore.App.Ref| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x86| 6.0.12
Microsoft.NET.Runtime.Android.Sample.Mono| 6.0.12
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 6.0.12
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 6.0.12
Microsoft.NET.Runtime.wasm.Sample.Mono| 6.0.12
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86| 6.0.12
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400| 6.0.12
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64| 6.0.12
Microsoft.NETCore.App.Crossgen2.linux-arm64| 6.0.12
Microsoft.NETCore.App.Crossgen2.osx-x64| 6.0.12
Microsoft.NETCore.App.Host.win-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.osx-arm64| 6.0.12
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 6.0.12
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.12
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.12
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64| 6.0.12
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 6.0.12
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 6.0.12
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.12
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.12
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.12
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.12
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 6.0.12
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.12
Microsoft.NETCore.App.Crossgen2.win-arm64| 6.0.12
Microsoft.NETCore.App.Host.linux-musl-arm64| 6.0.12
Microsoft.NETCore.App.Host.linux-x64| 6.0.12
Microsoft.NETCore.App.Host.win-arm| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 6.0.12
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64| 6.0.12
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86| 6.0.12
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.12
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.12
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 6.0.12
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 6.0.12
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 6.0.12
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.12
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 6.0.12
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.12
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.12
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 6.0.12
Microsoft.NETCore.App.Runtime.linux-arm64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.win-x64| 6.0.12
Microsoft.NETCore.App.Runtime.Mono.win-x86| 6.0.12
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86| 6.0.12
Microsoft.Windows.Compatibility| 6.0.2
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.12
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.12
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 6.0.12
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 6.0.12
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.12
Microsoft.AspNetCore.App.Runtime.linux-arm64| 6.0.12
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 6.0.12
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 6.0.12
Microsoft.AspNetCore.Identity.UI| 6.0.12
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 6.0.12
Microsoft.AspNetCore.SpaServices.Extensions| 6.0.12
Microsoft.AspNetCore.SpaProxy| 6.0.12
Microsoft.Extensions.ApiDescription.Server| 6.0.12
Microsoft.DotNet.Web.ItemTemplates.6.0| 6.0.12
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 6.0.12
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 6.0.12
Microsoft.Extensions.Localization| 6.0.12
Microsoft.Extensions.Identity.Core| 6.0.12
Microsoft.Extensions.Localization.Abstractions| 6.0.12
Microsoft.Extensions.Identity.Stores| 6.0.12
Microsoft.Extensions.Logging.AzureAppServices| 6.0.12
Microsoft.Extensions.ObjectPool| 6.0.12
Microsoft.Extensions.WebEncoders| 6.0.12
Microsoft.JSInterop| 6.0.12
Microsoft.JSInterop.WebAssembly| 6.0.12
Microsoft.AspNetCore.App.Runtime.linux-arm| 6.0.12
AspNetCoreRuntime.6.0.x64| 6.0.12
dotnet-sql-cache| 6.0.12
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 6.0.12
Microsoft.AspNetCore.Components.WebAssembly.Server| 6.0.12
Microsoft.AspNetCore.Components.Web| 6.0.12
Microsoft.AspNetCore.Cryptography.KeyDerivation| 6.0.12
Microsoft.AspNetCore.DataProtection.Abstractions| 6.0.12
Microsoft.AspNetCore.DataProtection.Extensions| 6.0.12
Microsoft.AspNetCore.Http.Connections.Client| 6.0.12
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 6.0.12
Microsoft.AspNetCore.Razor.Language| 6.0.12
Microsoft.Authentication.WebAssembly.Msal| 6.0.12
Microsoft.dotnet-openapi| 6.0.12
Microsoft.CodeAnalysis.Razor| 6.0.12
Microsoft.DotNet.Web.Client.ItemTemplates| 6.0.12
Microsoft.Extensions.ApiDescription.Client| 6.0.12
AspNetCoreRuntime.6.0.x86| 6.0.12
Microsoft.AspNetCore.App.Runtime.win-x64| 6.0.12
Microsoft.AspNetCore.App.Ref| 6.0.12
Microsoft.AspNetCore.Authentication.Certificate| 6.0.12
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 6.0.12
Microsoft.AspNetCore.Authentication.Twitter| 6.0.12
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 6.0.12
Microsoft.AspNetCore.Components| 6.0.12
Microsoft.AspNetCore.Components.Analyzers| 6.0.12
Microsoft.AspNetCore.ConcurrencyLimiter| 6.0.12
Microsoft.AspNetCore.Connections.Abstractions| 6.0.12
Microsoft.AspNetCore.Cryptography.Internal| 6.0.12
Microsoft.AspNetCore.DataProtection| 6.0.12
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 6.0.12
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 6.0.12
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 6.0.12
Microsoft.AspNetCore.HeaderPropagation| 6.0.12
Microsoft.AspNetCore.Hosting.WindowsServices| 6.0.12
Microsoft.AspNetCore.Http.Connections.Common| 6.0.12
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 6.0.12
Microsoft.AspNetCore.JsonPatch| 6.0.12
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 6.0.12
Microsoft.AspNetCore.Metadata| 6.0.12
Microsoft.AspNetCore.Mvc.Testing| 6.0.12
Microsoft.AspNetCore.Mvc.Razor.Extensions| 6.0.12
Microsoft.AspNetCore.Owin| 6.0.12
Microsoft.AspNetCore.SignalR.Client.Core| 6.0.12
Microsoft.AspNetCore.SignalR.Protocols.Json| 6.0.12
Microsoft.AspNetCore.SignalR.Common| 6.0.12
Microsoft.AspNetCore.SignalR.Client| 6.0.12
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 6.0.12
Microsoft.AspNetCore.SignalR.Specification.Tests| 6.0.12
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 6.0.12
Microsoft.AspNetCore.TestHost| 6.0.12
Microsoft.DotNet.Web.ProjectTemplates.6.0| 6.0.12
Microsoft.Extensions.Diagnostics.HealthChecks| 6.0.12
Microsoft.Extensions.Caching.StackExchangeRedis| 6.0.12
Microsoft.Extensions.Configuration.KeyPerFile| 6.0.12
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 6.0.12
Microsoft.Extensions.Http.Polly| 6.0.12
Microsoft.Extensions.Features| 6.0.12
Microsoft.Extensions.FileProviders.Embedded| 6.0.12
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 6.0.12
Microsoft.AspNetCore.App.Runtime.win-arm64| 6.0.12
Microsoft.AspNetCore.Authentication.AzureAD.UI| 6.0.12
Microsoft.AspNetCore.App.Runtime.win-x86| 6.0.12
Microsoft.AspNetCore.Authentication.Facebook| 6.0.12
Microsoft.AspNetCore.Authentication.Google| 6.0.12
Microsoft.AspNetCore.Authentication.JwtBearer| 6.0.12
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 6.0.12
Microsoft.AspNetCore.Authentication.Negotiate| 6.0.12
Microsoft.AspNetCore.Authentication.OpenIdConnect| 6.0.12
Microsoft.AspNetCore.Authentication.WsFederation| 6.0.12
Microsoft.AspNetCore.Authorization| 6.0.12
Microsoft.AspNetCore.Components.Authorization| 6.0.12
Microsoft.AspNetCore.AzureAppServicesIntegration| 6.0.12
Microsoft.AspNetCore.Components.Forms| 6.0.12
Microsoft.AspNetCore.Components.WebView| 6.0.12
Microsoft.AspNetCore.Components.WebAssembly| 6.0.12
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 6.0.12
Microsoft.AspNetCore.MiddlewareAnalysis| 6.0.12
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 6.0.12
Microsoft.Extensions.Caching.SqlServer| 6.0.12
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0| 6.0.12
Microsoft.AspNetCore.App.Runtime.osx-arm64| 6.0.12
Microsoft.AspNetCore.App.Runtime.win-arm| 6.0.12
Microsoft.AspNetCore.App.Runtime.osx-x64| 6.0.12
Microsoft.AspNetCore.App.Runtime.linux-x64| 6.0.12
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 6.0.12
Microsoft.TemplateEngine.Orchestrator.RunnableProjects.| 6.0.112
Microsoft.TemplateEngine.TemplateLocalizer.| 6.0.112
Microsoft.TemplateEngine.Utils.| 6.0.112
Microsoft.TemplateSearch.Common.| 6.0.112
Microsoft.DotNet.Common.ProjectTemplates.6.0.| 6.0.112
Microsoft.TemplateEngine.Abstractions.| 6.0.112
Microsoft.TemplateEngine.Core.Contracts.| 6.0.112
Microsoft.TemplateEngine.Edge.| 6.0.112
Microsoft.TemplateEngine.TemplateLocalizer.Core.| 6.0.112
Microsoft.DotNet.Common.ItemTemplates.| 6.0.112
Microsoft.TemplateEngine.Core.| 6.0.112
Microsoft.TemplateEngine.IDE.| 6.0.112
Microsoft.DotNet.Compatibility| 1.0.0-servicing.22578.6
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64| 6.0.12
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64| 6.0.12
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86| 6.0.12
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64| 6.0.12
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100| 6.0.12
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64| 6.0.12
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64| 6.0.12
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300| 6.0.12
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86| 6.0.12
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64| 6.0.12
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64| 6.0.12
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64| 6.0.12
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64| 6.0.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64| 6.0.12
Microsoft.EntityFrameworkCore| 6.0.12
Microsoft.EntityFrameworkCore.Abstractions| 6.0.12
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 6.0.12
Microsoft.EntityFrameworkCore.Analyzers| 6.0.12
Microsoft.EntityFrameworkCore.Cosmos| 6.0.12
Microsoft.EntityFrameworkCore.Proxies| 6.0.12
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 6.0.12
Microsoft.EntityFrameworkCore.Specification.Tests| 6.0.12
Microsoft.EntityFrameworkCore.Design| 6.0.12
Microsoft.EntityFrameworkCore.InMemory| 6.0.12
Microsoft.EntityFrameworkCore.Relational| 6.0.12
Microsoft.EntityFrameworkCore.Sqlite| 6.0.12
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 6.0.12
Microsoft.EntityFrameworkCore.SqlServer| 6.0.12
dotnet-ef| 6.0.12
Microsoft.Data.Sqlite| 6.0.12
Microsoft.Data.Sqlite.Core| 6.0.12
Microsoft.EntityFrameworkCore.Sqlite.Core| 6.0.12
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 6.0.12
Microsoft.EntityFrameworkCore.Tools| 6.0.12
Microsoft.DotNet.Common.ItemTemplates.| 6.0.307
Microsoft.TemplateEngine.Abstractions.| 6.0.307
Microsoft.TemplateEngine.Core.Contracts.| 6.0.307
Microsoft.TemplateEngine.Edge.| 6.0.307
Microsoft.TemplateEngine.IDE.| 6.0.307
Microsoft.TemplateEngine.Orchestrator.RunnableProjects.| 6.0.307
Microsoft.TemplateEngine.TemplateLocalizer.Core.| 6.0.307
Microsoft.TemplateEngine.Utils.| 6.0.307
Microsoft.TemplateSearch.Common.| 6.0.307
Microsoft.DotNet.Common.ProjectTemplates.6.0.| 6.0.307
Microsoft.TemplateEngine.Core.| 6.0.307
Microsoft.TemplateEngine.TemplateLocalizer.| 6.0.307
FSharp.Compiler.Service| 41.0.5
FSharp.Core| 6.0.5
Microsoft.TemplateEngine.Utils.| 6.0.404
Microsoft.DotNet.Common.ProjectTemplates.1.x.| 6.0.404
Microsoft.TemplateEngine.Orchestrator.RunnableProjects.| 6.0.404
Microsoft.DotNet.Common.ProjectTemplates.2.0.| 6.0.404
Microsoft.DotNet.Common.ItemTemplates.| 6.0.404
Microsoft.DotNet.Common.ProjectTemplates.2.1.| 6.0.404
Microsoft.DotNet.Common.ProjectTemplates.2.2.| 6.0.404
Microsoft.DotNet.Common.ProjectTemplates.3.1.| 6.0.404
Microsoft.DotNet.Common.ProjectTemplates.3.0.| 6.0.404
Microsoft.DotNet.Common.ProjectTemplates.6.0.| 6.0.404
Microsoft.DotNet.Common.ProjectTemplates.5.0.| 6.0.404
Microsoft.TemplateEngine.Abstractions.| 6.0.404
Microsoft.TemplateEngine.Core.| 6.0.404
Microsoft.TemplateEngine.Edge.| 6.0.404
Microsoft.TemplateEngine.TemplateLocalizer.| 6.0.404
Microsoft.TemplateEngine.TemplateLocalizer.Core.| 6.0.404
Microsoft.TemplateEngine.Core.Contracts.| 6.0.404
Microsoft.TemplateEngine.IDE.| 6.0.404
Microsoft.TemplateSearch.Common.| 6.0.404
FSharp.Core| 6.0.7
FSharp.Compiler.Service| 41.0.7


[//]: # ( Runtime 6.0.12)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8cb9b9c2-8eff-4c6c-bc28-f2c5a20b3f2d/1a495fde9c6814ca12e415328298a8c1/dotnet-runtime-6.0.12-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cbcfbaa2-781b-4782-9994-9a9289ca724d/bc2fe2ee1a1842ea6d1151e5e0a410f9/dotnet-runtime-6.0.12-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d2c4250f-d748-4aff-bd0d-59b9834c2d42/6a53987ec268f7947bed69bfc964b2d9/dotnet-runtime-6.0.12-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ee50fa3-5365-4733-802f-20f4e6c63ce9/8999927e45afba236da064eb164ac40e/dotnet-runtime-6.0.12-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bbbb66d6-7325-4758-bf39-c6b87a248a1f/4134186ccfb37cc2556211bf76ce1385/dotnet-runtime-6.0.12-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d543956-0b80-4c08-910e-c8c388f5fab8/01d45a3686e72f70be51b3f98569c6b1/dotnet-runtime-6.0.12-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/815bebc4-e694-46ef-ac6b-1d286275e6b6/df0373c30489e1a724ee7bf3a86214b7/dotnet-runtime-6.0.12-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd80604d-e51e-49fd-afb1-bb8308948f82/3573da78841bc5a685ec4cc90ed7a1c9/dotnet-runtime-6.0.12-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/41eb399c-86fd-4503-b61b-46848cca6fee/d09fb724e749cd7ba0f0bdd4a0705b19/dotnet-runtime-6.0.12-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f3360067-ac4b-4502-bec7-2dfb0c3c556f/2e75f7eaf320f44fd4103fc7ebd969da/dotnet-runtime-6.0.12-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/65268652-23cb-4be4-b57d-e638d90db599/1d7f7da5917e07f4b167cbdbe0613e7d/dotnet-runtime-6.0.12-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/6112ba5a-5a90-4462-a60b-69e95a7acc58/8aa16ce03bbfb7c00d292b16f13d567b/dotnet-runtime-6.0.12-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a7add606-bf46-4e45-b6c8-3761925968db/3a667c5b368ccd8b8de3c26bdeb21a25/dotnet-runtime-6.0.12-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/feac676a-296e-4a71-a6dc-84ab566a5eae/84c4a4a6b51207d7eba92c0f30d4fed8/dotnet-runtime-6.0.12-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/31947856-4c76-4330-a0e9-b36e2f088e38/4a7d322dde9a77c607a99d4c47542a97/dotnet-runtime-6.0.12-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/cc22d67e-64f1-40ad-80a4-4d41a44e3cc8/65ec55a31ea526fb4be94db58164c1f4/dotnet-runtime-6.0.12-win-x86.zip

[//]: # ( WindowsDesktop 6.0.12)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/47562ac8-30a0-4661-9fa3-54964fe97eb8/67916d073e5d04d8aa3058b31c613048/windowsdesktop-runtime-6.0.12-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/064f8acd-4cf7-4816-b80a-86209e95b9b5/8d40551da616b291951d2f172dbd7891/windowsdesktop-runtime-6.0.12-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ba2ece7b-686a-4bda-b7d7-8cc3b8964d66/8eee13e44d90345d40c1b262c78aad6a/windowsdesktop-runtime-6.0.12-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2223c3ab-449e-4260-a28f-0500b4a5150a/784e629eee659307b0cc82e60e5a3abd/windowsdesktop-runtime-6.0.12-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b11d3075-2191-4fe9-be05-e880f58d4577/3199263ba5d86952f5521f5e665e63bb/windowsdesktop-runtime-6.0.12-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ca7d714f-5086-4d5f-856f-f76ff55817d3/605bae0a3e3c9e5d9a1930af7a64719a/windowsdesktop-runtime-6.0.12-win-x86.zip

[//]: # ( ASP 6.0.12)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57b2bdaf-8455-4b1a-b25b-5950c950bd38/471d6de036e6f367f3a4aae5252d885a/aspnetcore-runtime-6.0.12-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8072e219-57e4-48c3-b138-2b4067844ab2/b0712ad06fd0740963bf4ba2eff7f5ea/aspnetcore-runtime-6.0.12-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/862efa8f-1ff3-491f-87b6-d00bf522e994/5f9c18b3c55881fbc238413928d6b4e5/aspnetcore-runtime-6.0.12-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/78fed30b-069b-4225-bae4-c26169ae0617/a162f2d1ebdeb6f3987f050020f4a7e8/aspnetcore-runtime-6.0.12-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/40ff372d-40dc-4023-a67f-7fa4e9727e74/8d7c35f2115e07a0716bab279fd992be/aspnetcore-runtime-6.0.12-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4ba0f30d-0a77-4997-8d8d-1b113d60253b/5caeeb07572b0b6a26f2a82f7a4eb31d/aspnetcore-runtime-6.0.12-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3017c51f-1a99-489a-86cd-c9131e3094d8/9cc88c5635de1699fbdf0ed58fb8e905/aspnetcore-runtime-6.0.12-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/381ec2d0-bcbb-4e2f-8d47-725bbf10f90b/bb582674ac6e1a35760e873358cef8a2/aspnetcore-runtime-6.0.12-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bf9d9263-b287-46ac-bb27-6606a480c1eb/69c554db49792465e04daf37053e2bcc/aspnetcore-runtime-6.0.12-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9e94fe1b-188a-4880-9e40-2cbb1fd98afc/84671c89295704cff726b014a502e188/aspnetcore-runtime-6.0.12-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6f7b904e-0c02-4904-8c2d-42752767f4c8/34b82755e7c93bdbf518363eabdd5029/aspnetcore-runtime-6.0.12-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/81a5aa70-b439-46f3-8eaa-967f25034540/f4819aa6f648c279547406bd672473ed/aspnetcore-runtime-6.0.12-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/bfd8af0d-a0af-4ad8-8c86-861a6841fc57/153709ee9e7f6a620b1765f4ff5541da/aspnetcore-runtime-6.0.12-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/cab723a6-dc1f-4b3a-8675-34dc84a21306/1ee69c32da9ba78d80d65f9c067c4f68/dotnet-hosting-6.0.12-win.exe

[//]: # ( SDK 6.0.404)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58ebc46e-68d7-44db-aaea-5f5cb66a1cb5/44d292c80c0e13c444e6d66d67ca213e/dotnet-sdk-6.0.404-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1055ed3b-6d81-42b8-bfaf-594baf240ec0/37f4c7113ec851f20569bb7435cd527b/dotnet-sdk-6.0.404-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/41f360de-19e1-4ff9-a8fb-fd489217e09d/93b6f40ce406adcf351cd5284930459a/dotnet-sdk-6.0.404-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dcfa8f0b-c9a0-49ff-835f-02713345a699/8db70d41ee915275fe34a8994a4e65da/dotnet-sdk-6.0.404-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/32e09cf3-b5ad-453e-aaa0-2b5c7422141f/6c7f4e895d6aa29471e05367d9880b6c/dotnet-sdk-6.0.404-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/40bc5873-1a39-4a47-9df5-b481869594a6/8455eab2092cc1321ac055f016ef90cf/dotnet-sdk-6.0.404-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2a309cee-38ac-4fb5-877e-e4d0a9dbff1b/01a4ad5d7a0ff5734e0749b3880485fb/dotnet-sdk-6.0.404-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4633191-6deb-4b35-9866-c3c839b8fab4/a66c1c547cfe4fc46a56e66d71153c40/dotnet-sdk-6.0.404-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a93ff2f8-c9f6-41d9-ac15-1b96e77f111e/5296b688fcb69e34eb2c6d05a915ee71/dotnet-sdk-6.0.404-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43189462-e807-4a01-88fe-d348d72130ad/29abc60cb75e8bcb12df60c2930fec25/dotnet-sdk-6.0.404-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a8870388-d200-4ae9-b0dc-117b88e2fdc1/00d77fb127e01d0bf9adcc36e89a7606/dotnet-sdk-6.0.404-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1a74ba96-1e2a-4378-8666-97eaf20c8d63/96b5117cb0b82aaef68e407744f5ebf7/dotnet-sdk-6.0.404-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0a672516-37fb-40de-8bef-725975e0b137/a632cde8d629f9ba9c12196f7e7660db/dotnet-sdk-6.0.404-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6ad651e3-818f-4e00-bb14-e632e1cecdb9/a7228c4ef87b2b856231d0b97f775b4b/dotnet-sdk-6.0.404-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/64139bf6-70a4-4bb2-b053-ef582d4552ce/119883fe60642bb42bac59b25ee98d36/dotnet-sdk-6.0.404-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/882c7878-1519-4bbb-b0eb-223879bce8a9/eaf8b414b3ea4b0d406934b686a6dca9/dotnet-sdk-6.0.404-win-x86.zip
